/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.nio.BufferOverflowException;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WireTcpHandler
implements TcpHandler,
Supplier<WireOutPublisher> {
    private static final int SIZE_OF_SIZE = 4;
    private static final Logger LOG = LoggerFactory.getLogger(WireTcpHandler.class);
    protected WireOutPublisher publisher;
    protected Wire outWire;
    private Wire inWire;
    private boolean recreateWire;
    private WireType wireType;

    public WireTcpHandler(@NotNull NetworkContext nc) {
        this.wireType = nc.wireType();
        this.publisher = nc.wireOutPublisher();
    }

    @Override
    public WireOutPublisher get() {
        return this.publisher;
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out) {
        this.checkWires(in, out, this.wireType());
        this.publisher.applyAction((WireOut)this.outWire, () -> {
            if (in.readRemaining() >= 4L && out.writePosition() < (long)TcpEventHandler.TCP_BUFFER) {
                this.read(in, out);
            }
        });
    }

    @Override
    public void sendHeartBeat(Bytes out, SessionDetailsProvider sessionDetails) {
        if (out.writePosition() == 0L) {
            WireOut outWire = (WireOut)this.wireType.apply((Object)out);
            outWire.writeDocument(true, w -> w.write(() -> "tid").int64(0L));
            outWire.writeDocument(false, w -> w.writeEventName(() -> "heartbeat").int64(Time.currentTimeMillis()));
        }
    }

    @Override
    public void onEndOfConnection(boolean heartbeatTimeOut) {
        this.publisher.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(@NotNull Bytes in, @NotNull Bytes out) {
        long header = in.readInt(in.readPosition());
        long length = Wires.lengthOf((long)header);
        assert (length >= 0L && length < 0x800000L) : "length=" + length + ",in=" + in + ", hex=" + in.toHexString();
        if (length == 0L && Wires.isData((long)header)) {
            in.readSkip(4L);
            return false;
        }
        if (in.readRemaining() < length + 4L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("required length=%d but only got %d bytes, this is short by %d bytes", length, in.readRemaining(), length - in.readRemaining()));
            }
            return false;
        }
        long limit = in.readLimit();
        long end = in.readPosition() + length + 4L;
        assert (end <= limit);
        long outPos = out.writePosition();
        try {
            in.readLimit(end);
            long position = this.inWire.bytes().readPosition();
            try {
                this.process((WireIn)this.inWire, (WireOut)this.outWire);
            }
            finally {
                try {
                    this.inWire.bytes().readPosition(position + length);
                }
                catch (BufferOverflowException e) {
                    throw new IllegalStateException("Unexpected error position: " + position + ", length: " + length + " limit(): " + this.inWire.bytes().readLimit(), e);
                }
            }
            long written = out.writePosition() - outPos;
            if (written > 0L) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable e) {
            LOG.error("", e);
        }
        finally {
            in.readLimit(limit);
            try {
                in.readPosition(end);
            }
            catch (Exception e) {
                throw new IllegalStateException("position: " + end + ", limit:" + limit + ", readLimit: " + in.readLimit() + " " + in.toDebugString(), e);
            }
        }
        return true;
    }

    protected void checkWires(Bytes in, Bytes out, @NotNull WireType wireType) {
        if (this.recreateWire) {
            this.recreateWire = false;
            this.inWire = (Wire)wireType.apply((Object)in);
            this.outWire = (Wire)wireType.apply((Object)out);
            return;
        }
        if (this.inWire == null) {
            this.inWire = (Wire)wireType.apply((Object)in);
            this.recreateWire = false;
        }
        if (this.inWire.bytes() != in) {
            this.inWire = (Wire)wireType.apply((Object)in);
            this.recreateWire = false;
        }
        if (this.outWire == null || this.outWire.bytes() != out) {
            this.outWire = (Wire)wireType.apply((Object)out);
            this.recreateWire = false;
        }
    }

    public WireType wireType() {
        return this.wireType;
    }

    protected abstract void process(@NotNull WireIn var1, @NotNull WireOut var2);
}

