/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;

public class HeaderTcpHandler
implements TcpHandler {
    private final TcpEventHandler handlerManager;
    private final Function<Marshallable, TcpHandler> handlerFunction;
    private final NetworkContext nc;

    public HeaderTcpHandler(@NotNull TcpEventHandler handlerManager, @NotNull Function<Marshallable, TcpHandler> handlerFunction, @NotNull NetworkContext nc) {
        this.handlerManager = handlerManager;
        this.handlerFunction = handlerFunction;
        this.nc = nc;
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out) {
        Wire inWire = (Wire)this.nc.wireType().apply((Object)in);
        try (DocumentContext dc = inWire.readingDocument();){
            Marshallable marshallable;
            if (!dc.isPresent()) {
                return;
            }
            if (dc.isMetaData()) {
                throw new IllegalStateException("expecting a header of type data");
            }
            ValueIn valueIn = inWire.getValueIn();
            if (valueIn.isTyped()) {
                marshallable = (Marshallable)valueIn.typedMarshallable();
            } else {
                marshallable = new VanillaSessionDetails();
                valueIn.marshallable((ReadMarshallable)marshallable);
            }
            TcpHandler handler = this.handlerFunction.apply(marshallable);
            this.handlerManager.tcpHandler(handler);
        }
    }
}

