/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.ConnectionDetails;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.threads.LongPauser;
import net.openhft.chronicle.threads.Pauser;
import org.jetbrains.annotations.NotNull;

public class ConnectorEventHandler
implements EventHandler,
Closeable {
    @NotNull
    private final Function<ConnectionDetails, TcpHandler> tcpHandlerSupplier;
    @NotNull
    private final Supplier<SessionDetailsProvider> sessionDetailsSupplier;
    private final Map<String, SocketChannel> descriptionToChannel = new ConcurrentHashMap<String, SocketChannel>();
    private final Pauser pauser = new LongPauser(0, 0, 5L, 5L, TimeUnit.SECONDS);
    private EventLoop eventLoop;
    private Map<String, ConnectionDetails> nameToConnectionDetails;

    public ConnectorEventHandler(@NotNull Map<String, ConnectionDetails> nameToConnectionDetails, @NotNull Function<ConnectionDetails, TcpHandler> tcpHandlerSupplier, @NotNull Supplier<SessionDetailsProvider> sessionDetailsSupplier) throws IOException {
        this.nameToConnectionDetails = nameToConnectionDetails;
        this.tcpHandlerSupplier = tcpHandlerSupplier;
        this.sessionDetailsSupplier = sessionDetailsSupplier;
    }

    public boolean action() throws InvalidEventHandlerException, InterruptedException {
        this.nameToConnectionDetails.forEach((k, connectionDetails) -> {
            try {
                SocketChannel socketChannel = this.descriptionToChannel.get(k);
                if (socketChannel == null) {
                    if (connectionDetails.isDisable()) {
                        return;
                    }
                    socketChannel = TCPRegistry.createSocketChannel(connectionDetails.getHostNameDescription());
                    this.descriptionToChannel.put((String)k, socketChannel);
                    connectionDetails.setConnected(true);
                    SessionDetailsProvider sessionDetails = this.sessionDetailsSupplier.get();
                    sessionDetails.clientAddress((InetSocketAddress)socketChannel.getRemoteAddress());
                    connectionDetails.socketChannel(socketChannel);
                    TcpEventHandler evntHandler = new TcpEventHandler((NetworkContext)connectionDetails);
                    evntHandler.tcpHandler(this.tcpHandlerSupplier.apply((ConnectionDetails)connectionDetails));
                    this.eventLoop.addHandler((EventHandler)evntHandler);
                } else if (socketChannel.isOpen()) {
                    if (connectionDetails.isDisable()) {
                        socketChannel.close();
                        connectionDetails.setConnected(false);
                        this.descriptionToChannel.remove(k);
                    }
                } else {
                    connectionDetails.setConnected(false);
                    this.descriptionToChannel.remove(k);
                }
            }
            catch (ConnectException e) {
                System.out.println(k + e.getMessage());
            }
            catch (IOException e) {
                System.out.println(k + e.getMessage());
                e.printStackTrace();
            }
        });
        this.pauser.pause();
        return false;
    }

    public void updateConnectionDetails(ConnectionDetails connectionDetails) {
        this.nameToConnectionDetails.put(connectionDetails.getID(), connectionDetails);
        this.forceRescan();
    }

    public void forceRescan() {
        this.pauser.unpause();
    }

    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.BLOCKING;
    }

    @Override
    public void close() throws IOException {
    }
}

