/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.lang.reflect.Constructor;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface WireOutPublisher
extends Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(WireOutPublisher.class);

    public static WireOutPublisher newThrottledWireOutPublisher(int periodMs, @NotNull WireOutPublisher delegate) {
        try {
            Class<?> aClass = Class.forName("software.chronicle.enterprise.throttle.ThrottledWireOutPublisher");
            Constructor<?> constructor = aClass.getConstructors()[0];
            return (WireOutPublisher)constructor.newInstance(periodMs, delegate);
        }
        catch (Exception e) {
            LOG.warn("To use this feature please install Chronicle-Enterprise");
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public void applyAction(@NotNull WireOut var1, @NotNull Runnable var2);

    public void put(@Nullable Object var1, WriteMarshallable var2);

    public boolean isClosed();

    public boolean canTakeMoreData();
}

