/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.nio.ByteBuffer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaWireOutPublisher
implements WireOutPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaWireOutPublisher.class);
    private final Wire wire;
    private volatile boolean closed = false;

    public VanillaWireOutPublisher(@NotNull Function<Bytes, Wire> wireType) {
        this.wire = wireType.apply(Bytes.elasticByteBuffer((int)0x2000000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyAction(@NotNull WireOut out, @NotNull Runnable read) {
        read.run();
        boolean hasReadData = false;
        Bytes bytes = this.wire.bytes();
        Wire wire = this.wire;
        synchronized (wire) {
            if (bytes.readRemaining() < 4L) {
                return;
            }
            do {
                long nextElementSize;
                if ((nextElementSize = (long)bytes.readInt(bytes.readPosition())) == 0L) {
                    return;
                }
                if (out.bytes().writeRemaining() < nextElementSize) break;
                bytes.readSkip(4L);
                out.bytes().write((BytesStore)bytes, bytes.readPosition(), nextElementSize);
                bytes.readSkip(nextElementSize);
                hasReadData = true;
            } while (bytes.readRemaining() >= 4L);
            if (!hasReadData) {
                return;
            }
            if (bytes.readRemaining() == 0L) {
                bytes.clear();
            } else {
                ByteBuffer o = (ByteBuffer)bytes.underlyingObject();
                o.position(0);
                o.limit((int)bytes.readLimit());
                o.position((int)bytes.readPosition());
                o.compact();
                int byteCoppied = o.position();
                bytes.readPosition(0L);
                bytes.writePosition((long)byteCoppied);
            }
            if (YamlLogging.showServerWrites) {
                try {
                    LOG.info("\nServer Publishes (from async publisher ) :\n" + Wires.fromSizePrefixedBlobs((Bytes)out.bytes()));
                }
                catch (Exception e) {
                    LOG.info("\nServer Publishes ( from async publisher - corrupted ) :\n" + out.bytes().toDebugString());
                    LOG.error("", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, WriteMarshallable event) {
        Bytes bytes = this.wire.bytes();
        Wire wire = this.wire;
        synchronized (wire) {
            long sizePosition = bytes.writePosition();
            bytes.writeSkip(4L);
            long start = bytes.writePosition();
            event.writeMarshallable((WireOut)this.wire);
            int size = (int)(bytes.writePosition() - start);
            bytes.writeInt(sizePosition, size);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        this.closed = true;
        Wire wire = this.wire;
        synchronized (wire) {
            this.wire.clear();
        }
    }

    @Override
    public boolean canTakeMoreData() {
        return this.wire.bytes().writePosition() < 0x2000000L;
    }
}

