/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public enum CoreFields implements WireKey
{
    tid,
    csp,
    cid,
    reply,
    exception,
    lastUpdateTime;

    @NotNull
    static final ThreadLocal<StringBuilder> cpsBuilder;

    private static long longEvent(@NotNull WireKey expecting, @NotNull WireIn wire) {
        StringBuilder eventName = Wires.acquireStringBuilder();
        long position = wire.bytes().readPosition();
        ValueIn valueIn = wire.readEventName(eventName);
        if (expecting.contentEquals((CharSequence)eventName)) {
            return valueIn.int64();
        }
        throw new IllegalArgumentException("expecting a " + expecting + " was\n" + wire.bytes().toHexString(position, wire.bytes().readLimit() - position));
    }

    @NotNull
    public static StringBuilder stringEvent(@NotNull WireKey expecting, @NotNull StringBuilder using, @NotNull WireIn wire) {
        StringBuilder eventName = Wires.acquireStringBuilder();
        ValueIn valueIn = wire.readEventName(eventName);
        if (expecting.contentEquals((CharSequence)eventName)) {
            valueIn.textTo(using);
            return using;
        }
        throw new IllegalArgumentException("expecting a " + expecting);
    }

    public static long tid(@NotNull WireIn wire) {
        return CoreFields.longEvent(tid, wire);
    }

    public static long cid(@NotNull WireIn wire) {
        return CoreFields.longEvent(cid, wire);
    }

    @NotNull
    public static StringBuilder csp(@NotNull WireIn wire) {
        return CoreFields.stringEvent(csp, cpsBuilder.get(), wire);
    }

    static {
        cpsBuilder = ThreadLocal.withInitial(StringBuilder::new);
    }
}

