/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.NetworkLog;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.WanSimulator;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpEventHandler
implements EventHandler,
Closeable {
    public static final int TCP_BUFFER = Integer.getInteger("TcpEventHandler.tcpBufferSize", 0x800000);
    private static final Logger LOG = LoggerFactory.getLogger(TcpEventHandler.class);
    private static final int CAPACITY = Integer.getInteger("TcpEventHandler.capacity", 0x800000);
    @NotNull
    private final SocketChannel sc;
    private final TcpHandler handler;
    private final SessionDetailsProvider sessionDetails;
    private final long heartBeatIntervalTicks;
    private final long heartBeatTimeoutTicks;
    @NotNull
    private final WriteEventHandler writeEventHandler;
    @NotNull
    private final NetworkLog readLog;
    @NotNull
    private final NetworkLog writeLog;
    int oneInTen;
    @Nullable
    private ByteBuffer inBB = ByteBuffer.allocateDirect(CAPACITY);
    @Nullable
    private Bytes inBBB;
    @Nullable
    private ByteBuffer outBB = ByteBuffer.allocateDirect(CAPACITY);
    @Nullable
    private Bytes outBBB;
    private long lastTickReadTime = Time.tickTime();
    private long lastHeartBeatTick = this.lastTickReadTime + 1000L;

    public TcpEventHandler(@NotNull SocketChannel sc, @NotNull TcpHandler handler, @NotNull SessionDetailsProvider sessionDetails, boolean unchecked, long heartBeatIntervalTicks, long heartBeatTimeoutTicks) throws IOException {
        this.heartBeatIntervalTicks = heartBeatIntervalTicks;
        this.heartBeatTimeoutTicks = heartBeatTimeoutTicks;
        assert (heartBeatIntervalTicks <= heartBeatTimeoutTicks / 2L);
        this.writeEventHandler = new WriteEventHandler();
        this.sc = sc;
        sc.configureBlocking(false);
        sc.socket().setTcpNoDelay(true);
        sc.socket().setReceiveBufferSize(TCP_BUFFER);
        sc.socket().setSendBufferSize(TCP_BUFFER);
        this.handler = handler;
        this.sessionDetails = sessionDetails;
        assert (this.inBB != null);
        this.inBBB = Bytes.wrapForRead((ByteBuffer)this.inBB.slice()).unchecked(unchecked);
        assert (this.outBB != null);
        this.outBBB = Bytes.wrapForWrite((ByteBuffer)this.outBB.slice()).unchecked(unchecked);
        this.outBB.limit(0);
        this.readLog = new NetworkLog(this.sc, "read");
        this.writeLog = new NetworkLog(this.sc, "write");
    }

    @NotNull
    public HandlerPriority priority() {
        switch (ServerThreadingStrategy.serverThreadingStrategy()) {
            case SINGLE_THREADED: {
                return HandlerPriority.HIGH;
            }
            case MULTI_THREADED_BUSY_WAITING: {
                return HandlerPriority.BLOCKING;
            }
        }
        throw new UnsupportedOperationException("todo");
    }

    public boolean action() throws InvalidEventHandlerException {
        if (!this.sc.isOpen()) {
            this.handler.onEndOfConnection(false);
            this.outBB = null;
            this.inBB = null;
            this.outBBB = null;
            this.inBBB = null;
            throw new InvalidEventHandlerException();
        }
        if (this.oneInTen++ == 10) {
            this.oneInTen = 0;
            try {
                this.writeEventHandler.action();
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
        try {
            int read;
            assert (this.inBB != null);
            int start = this.inBB.position();
            int n = read = this.inBB.remaining() > 0 ? this.sc.read(this.inBB) : Integer.MAX_VALUE;
            if (read < 0) {
                this.closeSC();
                throw new InvalidEventHandlerException();
            }
            if (read > 0) {
                WanSimulator.dataRead(read);
                this.readLog.log(this.inBB, start, this.inBB.position());
                this.lastTickReadTime = Time.tickTime();
                return this.invokeHandler();
            }
            this.readLog.idle();
            if (this.heartBeatIntervalTicks == 0L) {
                return false;
            }
            long tickTime = Time.tickTime();
            if (tickTime > this.lastTickReadTime + this.heartBeatTimeoutTicks) {
                this.closeSC();
                throw new InvalidEventHandlerException();
            }
            if (tickTime > this.lastHeartBeatTick + this.heartBeatIntervalTicks) {
                this.lastHeartBeatTick = tickTime;
                this.sendHeartBeat();
            }
        }
        catch (ClosedChannelException e) {
            this.closeSC();
        }
        catch (IOException e) {
            this.handleIOE(e, this.handler.hasClientClosed());
        }
        return false;
    }

    private void sendHeartBeat() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendHeartbeat - " + this.sc.getRemoteAddress());
        }
        assert (this.outBB != null);
        assert (this.outBBB != null);
        this.outBBB.writePosition((long)this.outBB.limit());
        this.handler.sendHeartBeat(this.outBBB, this.sessionDetails);
        if (this.outBBB.writePosition() > (long)this.outBB.limit() || this.outBBB.writePosition() >= 4L) {
            this.outBB.limit(Maths.toInt32((long)this.outBBB.writePosition()));
            this.tryWrite();
        } else {
            this.writeLog.idle();
        }
    }

    private boolean invokeHandler() throws IOException {
        long lastInBBBReadPosition;
        boolean busy = false;
        assert (this.inBB != null);
        assert (this.inBBB != null);
        this.inBBB.readLimit((long)this.inBB.position());
        assert (this.outBB != null);
        assert (this.outBBB != null);
        this.outBBB.writePosition((long)this.outBB.limit());
        do {
            lastInBBBReadPosition = this.inBBB.readPosition();
            this.handler.process(this.inBBB, this.outBBB, this.sessionDetails);
            if (this.outBBB.writePosition() <= (long)this.outBB.limit() && this.outBBB.writePosition() < 4L) continue;
            this.outBB.limit(Maths.toInt32((long)this.outBBB.writePosition()));
            busy |= this.tryWrite();
            break;
        } while (lastInBBBReadPosition != this.inBBB.readPosition());
        if (this.inBBB.readPosition() > 0L) {
            this.inBB.position((int)this.inBBB.readPosition());
            this.inBB.limit((int)this.inBBB.readLimit());
            this.inBB.compact();
            this.inBBB.readPosition(0L);
            this.inBBB.readLimit((long)this.inBB.position());
            busy = true;
        }
        return busy;
    }

    private void handleIOE(@NotNull IOException e, boolean clientIntentionallyClosed) {
        try {
            if (clientIntentionallyClosed) {
                return;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("An existing connection was forcibly closed")) {
                LOG.warn(e.getMessage());
            } else if (!(e instanceof ClosedByInterruptException)) {
                LOG.error("", (Throwable)e);
            }
        }
        finally {
            this.closeSC();
        }
    }

    public void close() {
        this.closeSC();
    }

    private void closeSC() {
        try {
            this.handler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean tryWrite() throws IOException {
        assert (this.outBB != null);
        if (this.outBB.remaining() <= 0) {
            return false;
        }
        int start = this.outBB.position();
        int wrote = this.sc.write(this.outBB);
        this.writeLog.log(this.outBB, start, this.outBB.position());
        if (wrote < 0) {
            this.closeSC();
        } else if (wrote > 0) {
            this.lastTickReadTime = Time.tickTime();
            this.outBB.compact().flip();
            assert (this.outBBB != null);
            this.outBBB.writeLimit((long)this.outBB.capacity());
            this.outBBB.writePosition((long)this.outBB.limit());
            return true;
        }
        return false;
    }

    private class WriteEventHandler
    implements EventHandler {
        private WriteEventHandler() {
        }

        public boolean action() throws InvalidEventHandlerException {
            if (!TcpEventHandler.this.sc.isOpen()) {
                throw new InvalidEventHandlerException();
            }
            boolean busy = false;
            try {
                assert (TcpEventHandler.this.outBB != null);
                int remaining = TcpEventHandler.this.outBB.remaining();
                boolean bl = busy = remaining > 0;
                if (busy) {
                    TcpEventHandler.this.tryWrite();
                }
                if (TcpEventHandler.this.outBB.remaining() == remaining) {
                    TcpEventHandler.this.invokeHandler();
                    if (!busy) {
                        busy |= TcpEventHandler.this.tryWrite();
                    }
                }
            }
            catch (ClosedChannelException cce) {
                TcpEventHandler.this.closeSC();
            }
            catch (IOException e) {
                TcpEventHandler.this.handleIOE(e, TcpEventHandler.this.handler.hasClientClosed());
            }
            return busy;
        }
    }
}

