/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.event.EventHandler;
import net.openhft.chronicle.network.event.EventLoop;
import net.openhft.chronicle.network.event.HandlerPriority;
import net.openhft.chronicle.network.event.HotMethod;
import net.openhft.chronicle.network.event.References;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;

public class VanillaEventLoop
implements EventLoop,
Runnable {
    private final EventLoop parent;
    private final ExecutorService service;
    private final List<EventHandler> highHandlers = new ArrayList<EventHandler>();
    private final List<EventHandler> mediumHandlers = new ArrayList<EventHandler>();
    private final List<EventHandler> timerHandlers = new ArrayList<EventHandler>();
    private final List<EventHandler> daemonHandlers = new ArrayList<EventHandler>();
    private final AtomicReference<EventHandler> newHandler = new AtomicReference();
    private final Pauser pauser;
    private final long timerIntervalNS;
    private final String name;
    private long loopStartNS;
    private long lastTimerNS;
    private volatile boolean running = true;
    private volatile Thread thread = null;

    public VanillaEventLoop(EventLoop parent, String name, Pauser pauser, long timerIntervalNS) {
        this.parent = parent;
        this.name = name;
        this.pauser = pauser;
        this.timerIntervalNS = timerIntervalNS;
        this.service = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(name, Boolean.valueOf(true)));
    }

    @Override
    public void start() {
        this.running = true;
        this.service.submit(this);
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public void addHandler(EventHandler handler) {
        if (this.thread == null || this.thread == Thread.currentThread()) {
            this.addNewHandler(handler);
        } else {
            this.pauser.unpause();
            while (!this.newHandler.compareAndSet(null, handler)) {
                Thread.yield();
            }
        }
    }

    public long loopStartNS() {
        return this.loopStartNS;
    }

    @Override
    @HotMethod
    public void run() {
        try {
            this.thread = Thread.currentThread();
            int count = 0;
            while (this.running) {
                boolean busy = false;
                for (int i = 0; i < 10; ++i) {
                    this.loopStartNS = System.nanoTime();
                    busy |= this.runAllHighHandlers();
                    busy |= this.runOneTenthLowHandler(i);
                }
                if (this.lastTimerNS + this.timerIntervalNS < this.loopStartNS) {
                    this.lastTimerNS = this.loopStartNS;
                    this.runTimerHandlers();
                }
                this.acceptNewHandlers();
                if (busy) {
                    System.out.println("b " + count);
                    count = 0;
                    this.pauser.reset();
                    continue;
                }
                ++count;
                this.runDaemonHandlers();
                this.pauser.pause();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @HotMethod
    private boolean runAllHighHandlers() {
        boolean busy = false;
        for (int i = 0; i < this.highHandlers.size(); ++i) {
            EventHandler handler = this.highHandlers.get(i);
            try {
                busy |= handler.runOnce();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!handler.isDead()) continue;
            this.highHandlers.remove(i--);
        }
        return busy;
    }

    @HotMethod
    private boolean runOneTenthLowHandler(int i) {
        boolean busy = false;
        for (int j = i; j < this.mediumHandlers.size(); j += 10) {
            EventHandler handler = this.mediumHandlers.get(i);
            try {
                busy |= handler.runOnce();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!handler.isDead()) continue;
            this.mediumHandlers.remove(i--);
        }
        return busy;
    }

    @HotMethod
    private void runTimerHandlers() {
        for (int i = 0; i < this.timerHandlers.size(); ++i) {
            EventHandler handler = this.timerHandlers.get(i);
            try {
                handler.runOnce();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!handler.isDead()) continue;
            this.timerHandlers.remove(i--);
        }
    }

    @HotMethod
    private void runDaemonHandlers() {
        for (int i = 0; i < this.daemonHandlers.size(); ++i) {
            EventHandler handler = this.daemonHandlers.get(i);
            try {
                handler.runOnce();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!handler.isDead()) continue;
            this.daemonHandlers.remove(i--);
        }
    }

    @HotMethod
    private void acceptNewHandlers() {
        EventHandler handler = this.newHandler.getAndSet(null);
        if (handler != null) {
            this.addNewHandler(handler);
        }
    }

    private void addNewHandler(EventHandler handler) {
        switch (References.or(handler.priority(), HandlerPriority.MEDIUM)) {
            case HIGH: {
                this.highHandlers.add(handler);
                break;
            }
            case MEDIUM: {
                this.mediumHandlers.add(handler);
                break;
            }
            case TIMER: 
            case DAEMON: {
                this.daemonHandlers.add(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot add a " + (Object)((Object)handler.priority()) + " task to a busy waiting thread");
            }
        }
        handler.eventLoop(this.parent);
    }

    public String name() {
        return this.name;
    }

    public void dumpRunningState(String message) {
        Thread thread = this.thread;
        if (thread == null) {
            return;
        }
        StringBuilder out = new StringBuilder(message);
        Jvm.trimStackTrace((StringBuilder)out, (StackTraceElement[])thread.getStackTrace());
        System.out.println(out);
    }

    @Override
    public void close() {
        this.service.shutdown();
        try {
            if (this.service.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                this.service.shutdownNow();
            }
            this.service.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.service.shutdownNow();
        }
    }

    public boolean isAlive() {
        Thread thread = this.thread;
        return thread != null && thread.isAlive();
    }
}

