/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import org.jetbrains.annotations.NotNull;

public class VanillaSessionDetails
implements SessionDetailsProvider {
    private final Map<Class, Object> infoMap = new LinkedHashMap<Class, Object>();
    private String userId = "";
    private String securityToken = "";
    private InetSocketAddress clientAddress;
    private long connectTimeMS;
    private UUID sessionId;

    @NotNull
    public static VanillaSessionDetails of(String userId, String securityToken) {
        VanillaSessionDetails vanillaSessionDetails = new VanillaSessionDetails();
        vanillaSessionDetails.setUserId(userId);
        vanillaSessionDetails.setSecurityToken(securityToken);
        return vanillaSessionDetails;
    }

    @Override
    public UUID sessionId() {
        if (this.sessionId == null) {
            this.sessionId = UUID.randomUUID();
        }
        return this.sessionId;
    }

    @Override
    public String userId() {
        return this.userId;
    }

    @Override
    public String securityToken() {
        return this.securityToken;
    }

    @Override
    public InetSocketAddress clientAddress() {
        return this.clientAddress;
    }

    @Override
    public long connectTimeMS() {
        return this.connectTimeMS;
    }

    @Override
    public <I> void set(Class<I> infoClass, I info) {
        this.infoMap.put(infoClass, info);
    }

    @Override
    @NotNull
    public <I> I get(Class<I> infoClass) {
        return (I)this.infoMap.get(infoClass);
    }

    @Override
    public void setConnectTimeMS(long connectTimeMS) {
        this.connectTimeMS = connectTimeMS;
    }

    @Override
    public void setClientAddress(InetSocketAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    @Override
    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String toString() {
        return "VanillaSessionDetails{infoMap=" + this.infoMap + ", userId='" + this.userId + '\'' + ", securityToken='" + this.securityToken + '\'' + ", clientAddress=" + this.clientAddress + ", connectTimeMS=" + this.connectTimeMS + ", sessionId=" + this.sessionId + '}';
    }
}

