/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlLogging;

public class WireOutPublisher
implements Closeable {
    private static final int WARN_QUEUE_LENGTH = 50;
    private final Queue<Consumer<WireOut>> publisher = new LinkedTransferQueue<Consumer<WireOut>>();
    private WireOut out;
    private volatile boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAction(WireOut out, Runnable runnable) {
        Consumer<WireOut> wireConsumer;
        if (this.publisher.isEmpty()) {
            WireOutPublisher wireOutPublisher = this;
            synchronized (wireOutPublisher) {
                try {
                    this.out = out;
                    runnable.run();
                }
                finally {
                    this.out = null;
                }
            }
        }
        while (out.bytes().writePosition() < out.bytes().realCapacity() / 4L && (wireConsumer = this.publisher.poll()) != null) {
            wireConsumer.accept(out);
            if (!Jvm.IS_DEBUG || !YamlLogging.showServerWrites) continue;
            try {
                System.out.println("\nServer Publishes (from async publisher ) :\n" + Wires.fromSizePrefixedBinaryToText((Bytes)out.bytes()));
            }
            catch (Exception e) {
                System.out.println("\nServer Publishes ( from async publisher - corrupted ) :\n" + out.bytes().toDebugString());
                e.printStackTrace();
            }
        }
    }

    public void add(Consumer<WireOut> outConsumer) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        int size = this.publisher.size();
        if (size > 50) {
            System.out.println("publish length: " + size);
        }
        this.publisher.add(outConsumer);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }
}

