/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.Jvm;

public class NetworkLog {
    private final String desc;
    private long lastOut = System.currentTimeMillis();

    public NetworkLog(SocketChannel channel, String op) throws IOException {
        this.desc = op + " " + ((InetSocketAddress)channel.getLocalAddress()).getPort() + " " + ((InetSocketAddress)channel.getRemoteAddress()).getPort();
    }

    public void idle() {
        if (!Jvm.IS_DEBUG) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastOut > 2000L) {
            this.lastOut = now;
            System.out.println(this.desc + " idle");
        }
    }

    public void log(ByteBuffer bytes, int start, int end) {
        if (!Jvm.IS_DEBUG) {
            return;
        }
        StringBuilder sb = new StringBuilder(this.desc);
        sb.append(" len: ").append(end - start).append(" - ");
        for (int i = start; i < end; ++i) {
            sb.append(RandomDataInput.charToString[bytes.get(i) & 0xFF]);
        }
        System.out.println(sb);
    }
}

