/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.StreamCorruptedException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.TcpHandler;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;

public abstract class WireTcpHandler
implements TcpHandler {
    protected Wire inWire;
    protected Wire outWire;
    private boolean recreateWire;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Bytes in, Bytes out) {
        int length;
        this.checkWires(in, out);
        if (in.remaining() < 2L) {
            long outPos = out.position();
            out.skip(2L);
            this.publish(this.outWire);
            long written = out.position() - outPos - 2L;
            if (written == 0L) {
                out.position(outPos);
                return;
            }
            assert (written < 65536L);
            out.writeUnsignedShort(outPos, (int)written);
            return;
        }
        while ((length = in.readUnsignedShort(in.position())) != 0) {
            if (in.remaining() >= (long)(length + 2)) {
                in.skip(2L);
                long limit = in.limit();
                long end = in.position() + (long)length;
                long outPos = out.position();
                try {
                    out.skip(2L);
                    in.limit(end);
                    long position = this.inWire.bytes().position();
                    try {
                        this.process(this.inWire, this.outWire);
                    }
                    finally {
                        this.inWire.bytes().position(position + (long)length);
                    }
                    long written = out.position() - outPos - 2L;
                    if (written == 0L) {
                        out.position(outPos);
                        return;
                    }
                    out.writeUnsignedShort(outPos, (int)written);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    in.limit(limit);
                    in.position(end);
                }
            }
            if (in.remaining() > 2L && out.remaining() > out.capacity() / 2L) continue;
        }
    }

    protected void recreateWire(boolean recreateWire) {
        this.recreateWire = recreateWire;
    }

    private void checkWires(Bytes in, Bytes out) {
        if (this.recreateWire) {
            this.recreateWire = false;
            this.inWire = this.createWriteFor(in);
            this.outWire = this.createWriteFor(out);
            return;
        }
        if (this.inWire == null || this.inWire.bytes() != in) {
            this.inWire = this.createWriteFor(in);
            this.recreateWire = false;
        }
        if (this.outWire == null || this.outWire.bytes() != out) {
            this.outWire = this.createWriteFor(out);
            this.recreateWire = false;
        }
    }

    protected Wire createWriteFor(Bytes bytes) {
        return new TextWire(bytes);
    }

    protected abstract void process(Wire var1, Wire var2) throws StreamCorruptedException;

    protected void publish(Wire out) {
    }
}

