/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.io.Externalizable;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.hash.serialization.impl.BooleanMarshaller;
import net.openhft.chronicle.hash.serialization.impl.ByteArrayDataAccess;
import net.openhft.chronicle.hash.serialization.impl.ByteArraySizedReader;
import net.openhft.chronicle.hash.serialization.impl.ByteBufferDataAccess;
import net.openhft.chronicle.hash.serialization.impl.ByteBufferSizedReader;
import net.openhft.chronicle.hash.serialization.impl.ByteableDataAccess;
import net.openhft.chronicle.hash.serialization.impl.ByteableSizedReader;
import net.openhft.chronicle.hash.serialization.impl.BytesAsSizedReader;
import net.openhft.chronicle.hash.serialization.impl.BytesMarshallableDataAccess;
import net.openhft.chronicle.hash.serialization.impl.BytesMarshallableReader;
import net.openhft.chronicle.hash.serialization.impl.CharSequenceSizedReader;
import net.openhft.chronicle.hash.serialization.impl.CharSequenceUtf8DataAccess;
import net.openhft.chronicle.hash.serialization.impl.DoubleDataAccess;
import net.openhft.chronicle.hash.serialization.impl.DoubleMarshaller;
import net.openhft.chronicle.hash.serialization.impl.ExternalBytesMarshallableDataAccess;
import net.openhft.chronicle.hash.serialization.impl.ExternalizableDataAccess;
import net.openhft.chronicle.hash.serialization.impl.ExternalizableReader;
import net.openhft.chronicle.hash.serialization.impl.IntegerDataAccess;
import net.openhft.chronicle.hash.serialization.impl.IntegerMarshaller;
import net.openhft.chronicle.hash.serialization.impl.LongDataAccess;
import net.openhft.chronicle.hash.serialization.impl.LongMarshaller;
import net.openhft.chronicle.hash.serialization.impl.NotReusingSizedMarshallableDataAccess;
import net.openhft.chronicle.hash.serialization.impl.SerializableDataAccess;
import net.openhft.chronicle.hash.serialization.impl.SerializableReader;
import net.openhft.chronicle.hash.serialization.impl.SizedMarshallableDataAccess;
import net.openhft.chronicle.hash.serialization.impl.StringBuilderSizedReader;
import net.openhft.chronicle.hash.serialization.impl.StringBuilderUtf8DataAccess;
import net.openhft.chronicle.hash.serialization.impl.StringSizedReader;
import net.openhft.chronicle.hash.serialization.impl.StringUtf8DataAccess;
import net.openhft.chronicle.hash.serialization.impl.ValueDataAccess;
import net.openhft.chronicle.hash.serialization.impl.ValueReader;
import net.openhft.chronicle.values.ValueModel;
import net.openhft.chronicle.values.Values;

public final class SerializationBuilder<T>
implements Cloneable {
    public final Class<T> tClass;
    private SizeMarshaller sizeMarshaller = SizeMarshaller.stopBit();
    private SizedReader<T> reader;
    private DataAccess<T> dataAccess;
    public final boolean sizeIsStaticallyKnown;
    boolean serializesGeneratedClasses = false;

    private static boolean concreteClass(Class c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }

    public SerializationBuilder(Class<T> tClass) {
        this.tClass = tClass;
        this.configureByDefault(tClass);
        this.sizeIsStaticallyKnown = this.constantSizeMarshaller();
    }

    private void configureByDefault(Class<T> tClass) {
        if (tClass.isInterface() && Values.isValueInterfaceOrImplClass(tClass)) {
            try {
                ValueModel valueModel = ValueModel.acquire(tClass);
                this.reader(new ValueReader(tClass));
                this.dataAccess(new ValueDataAccess(tClass));
                this.sizeMarshaller(SizeMarshaller.constant(valueModel.sizeInBytes()));
                this.serializesGeneratedClasses = true;
                return;
            }
            catch (Exception e) {
                try {
                    tClass = Values.nativeClassFor(tClass);
                    this.serializesGeneratedClasses = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (SerializationBuilder.concreteClass(tClass) && Byteable.class.isAssignableFrom(tClass)) {
            this.reader(new ByteableSizedReader(tClass));
            this.dataAccess(new ByteableDataAccess(tClass));
            this.sizeMarshaller(SizeMarshaller.constant(((Byteable)OS.memory().allocateInstance(tClass)).maxSize()));
        } else if (tClass == CharSequence.class) {
            this.reader(CharSequenceSizedReader.INSTANCE);
            this.dataAccess(new CharSequenceUtf8DataAccess());
        } else if (tClass == StringBuilder.class) {
            this.reader(StringBuilderSizedReader.INSTANCE);
            this.dataAccess(new StringBuilderUtf8DataAccess());
        } else if (tClass == String.class) {
            this.reader(new StringSizedReader());
            this.dataAccess(new StringUtf8DataAccess());
        } else if (tClass == Boolean.class) {
            this.reader(BooleanMarshaller.INSTANCE);
            this.notReusingWriter(BooleanMarshaller.INSTANCE);
            this.sizeMarshaller(SizeMarshaller.constant(1L));
        } else if (tClass == Long.class) {
            this.reader(LongMarshaller.INSTANCE);
            this.dataAccess(new LongDataAccess());
            this.sizeMarshaller(SizeMarshaller.constant(8L));
        } else if (tClass == Double.class) {
            this.reader(DoubleMarshaller.INSTANCE);
            this.dataAccess(new DoubleDataAccess());
            this.sizeMarshaller(SizeMarshaller.constant(8L));
        } else if (tClass == Integer.class) {
            this.reader(IntegerMarshaller.INSTANCE);
            this.dataAccess(new IntegerDataAccess());
            this.sizeMarshaller(SizeMarshaller.constant(4L));
        } else if (tClass == byte[].class) {
            this.reader(ByteArraySizedReader.INSTANCE);
            this.dataAccess(new ByteArrayDataAccess());
        } else if (tClass == ByteBuffer.class) {
            this.reader(ByteBufferSizedReader.INSTANCE);
            this.dataAccess(new ByteBufferDataAccess());
        } else if (SerializationBuilder.concreteClass(tClass) && BytesMarshallable.class.isAssignableFrom(tClass)) {
            this.reader(new BytesMarshallableReader(tClass));
            this.dataAccess(new BytesMarshallableDataAccess(tClass));
        } else if (SerializationBuilder.concreteClass(tClass) && Externalizable.class.isAssignableFrom(tClass)) {
            this.reader(new ExternalizableReader(tClass));
            this.dataAccess(new ExternalizableDataAccess(tClass));
        } else {
            this.reader(new SerializableReader());
            this.dataAccess(new SerializableDataAccess());
        }
    }

    public void reader(SizedReader<T> reader) {
        this.reader = reader;
    }

    public void reader(BytesReader<T> reader) {
        this.reader = new BytesAsSizedReader<T>(reader);
    }

    public SizedReader<T> reader() {
        return StatefulCopyable.copyIfNeeded(this.reader);
    }

    public void dataAccess(DataAccess<T> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public DataAccess<T> dataAccess() {
        return (DataAccess)this.dataAccess.copy();
    }

    public void writer(SizedWriter<? super T> writer) {
        this.dataAccess(new SizedMarshallableDataAccess<T>(this.tClass, this.reader, writer));
    }

    private void notReusingWriter(SizedWriter<? super T> writer) {
        this.dataAccess(new NotReusingSizedMarshallableDataAccess<T>(this.tClass, this.reader, writer));
    }

    public void writer(BytesWriter<? super T> writer) {
        this.dataAccess(new ExternalBytesMarshallableDataAccess<T>(this.tClass, this.reader, writer));
    }

    public long serializationSize(T sampleObject) {
        return this.dataAccess().getData(sampleObject).size();
    }

    public long constantSizeBySample(T sampleObject) {
        long expectedConstantSize;
        long constantSize = this.serializationSize(sampleObject);
        if (this.constantSizeMarshaller() && constantSize != (expectedConstantSize = this.constantSize())) {
            throw new IllegalStateException("Although configuring constant size by sample is not forbidden for types which size we already know statically, they should be the same. For " + this.tClass + " we know constant size is " + expectedConstantSize + " statically, configured sample is " + sampleObject + " which size in serialized form is " + constantSize);
        }
        this.sizeMarshaller(SizeMarshaller.constant(constantSize));
        return constantSize;
    }

    public SizeMarshaller sizeMarshaller() {
        return this.sizeMarshaller;
    }

    public boolean constantSizeMarshaller() {
        boolean feature2;
        SizeMarshaller marshaller = this.sizeMarshaller();
        boolean feature1 = marshaller.storingLength(marshaller.maxStorableSize()) == 0;
        boolean bl = feature2 = marshaller.minStorableSize() == marshaller.maxStorableSize();
        if (feature1 && feature2) {
            return true;
        }
        if (!feature1 && !feature2) {
            return false;
        }
        throw new IllegalStateException("SizeMarshaller " + marshaller + " has only 1 of 2 " + "constant features: storingLength == 0 and minStorableSize == maxStorableSize." + " Should have both");
    }

    public boolean constantStoringLengthSizeMarshaller() {
        long maxStorableSize;
        long minStorableSize;
        SizeMarshaller marshaller = this.sizeMarshaller();
        return marshaller.minStoringLengthOfSizesInRange(minStorableSize = marshaller.minStorableSize(), maxStorableSize = marshaller.maxStorableSize()) == marshaller.maxStoringLengthOfSizesInRange(minStorableSize, maxStorableSize);
    }

    public long constantSize() {
        if (this.sizeMarshaller().minStorableSize() != this.sizeMarshaller().maxStorableSize()) {
            throw new AssertionError();
        }
        return this.sizeMarshaller().minStorableSize();
    }

    public SerializationBuilder<T> sizeMarshaller(SizeMarshaller sizeMarshaller) {
        this.sizeMarshaller = sizeMarshaller;
        return this;
    }

    public SerializationBuilder<T> clone() {
        try {
            return (SerializationBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

