/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util;

import org.jetbrains.annotations.NotNull;

public final class CharSequences {
    public static boolean equivalent(@NotNull CharSequence a, @NotNull CharSequence b) {
        if (a.equals(b)) {
            return true;
        }
        if (a instanceof String) {
            return ((String)a).contentEquals(b);
        }
        if (b instanceof String) {
            return ((String)b).contentEquals(a);
        }
        int len = a.length();
        if (len != b.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int hash(@NotNull CharSequence cs) {
        if (cs instanceof String) {
            return cs.hashCode();
        }
        int h = 0;
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            h = 31 * h + cs.charAt(i);
        }
        return h;
    }

    private CharSequences() {
    }
}

