/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.hash.serialization.impl.EnumMarshallable;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public interface HashSplitting
extends Marshallable {
    public static HashSplitting forSegments(int segments) {
        if (!1.$assertionsDisabled && segments <= 0) {
            throw new AssertionError();
        }
        if (segments == 1) {
            return ForSingleSegment.INSTANCE;
        }
        if (Maths.isPowerOf2((long)segments)) {
            return new ForPowerOf2Segments(segments);
        }
        return new ForNonPowerOf2Segments(segments);
    }

    public int segmentIndex(long var1);

    public long segmentHash(long var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class ForNonPowerOf2Segments
    implements HashSplitting {
        private static final int MASK = Integer.MAX_VALUE;
        private static final int BITS = 31;
        private int segments;

        public ForNonPowerOf2Segments(int segments) {
            this.segments = segments;
        }

        @Override
        public int segmentIndex(long hash) {
            return ((int)hash & Integer.MAX_VALUE) % this.segments;
        }

        @Override
        public long segmentHash(long hash) {
            return hash >>> 31;
        }

        public void readMarshallable(@NotNull WireIn wire) {
            this.segments = wire.read(() -> "segments").int32();
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write(() -> "segments").int32(this.segments);
        }
    }

    public static class ForPowerOf2Segments
    implements HashSplitting {
        private int bits;
        private transient int mask;

        ForPowerOf2Segments(int segments) {
            assert (Maths.isPowerOf2((long)segments));
            this.bits = Integer.numberOfTrailingZeros(segments);
            this.mask = segments - 1;
        }

        @Override
        public int segmentIndex(long hash) {
            return (int)hash & this.mask;
        }

        @Override
        public long segmentHash(long hash) {
            return hash >>> this.bits;
        }

        public void readMarshallable(@NotNull WireIn wire) {
            this.bits = wire.read(() -> "bits").int32();
            this.mask = (1 << this.bits) - 1;
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write(() -> "bits").int32(this.bits);
        }
    }

    public static enum ForSingleSegment implements HashSplitting,
    EnumMarshallable<ForSingleSegment>
    {
        INSTANCE;


        @Override
        public int segmentIndex(long hash) {
            return 0;
        }

        @Override
        public long segmentHash(long hash) {
            return hash;
        }

        public ForSingleSegment readResolve() {
            return INSTANCE;
        }
    }
}

