/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharSequenceSizedReader
implements SizedReader<CharSequence>,
StatefulCopyable<CharSequenceSizedReader> {
    private transient StringBuilder sb;

    public CharSequenceSizedReader() {
        this.initTransients();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    private void initTransients() {
        this.sb = new StringBuilder();
    }

    @Override
    @NotNull
    public CharSequence read(@NotNull Bytes in, long size, @Nullable CharSequence using) {
        if (0L > size || size > Integer.MAX_VALUE) {
            throw new IllegalStateException("positive int size expected, " + size + " given");
        }
        int csLen = (int)size;
        if (!(using instanceof StringBuilder)) {
            this.sb.setLength(0);
            this.sb.ensureCapacity(csLen);
            BytesUtil.parseUtf8((StreamingDataInput)in, (Appendable)this.sb, (int)csLen);
            return this.sb.toString();
        }
        StringBuilder usingSB = (StringBuilder)using;
        usingSB.setLength(0);
        usingSB.ensureCapacity(csLen);
        BytesUtil.parseUtf8((StreamingDataInput)in, (Appendable)usingSB, (int)csLen);
        return usingSB;
    }

    @Override
    public CharSequenceSizedReader copy() {
        return new CharSequenceSizedReader();
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
    }
}

