/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;

public final class LongCompactOffHeapLinearHashTable
extends CompactOffHeapLinearHashTable {
    private static final long SCALE = 8L;

    LongCompactOffHeapLinearHashTable(VanillaChronicleHash h) {
        super(h);
    }

    @Override
    long indexToPos(long index) {
        return index * 8L;
    }

    @Override
    public long step(long pos) {
        return pos + 8L & this.capacityMask2;
    }

    @Override
    public long stepBack(long pos) {
        return pos - 8L & this.capacityMask2;
    }

    @Override
    public long readEntry(long address, long pos) {
        return OS.memory().readLong(address + pos);
    }

    @Override
    public long readEntryVolatile(long address, long pos) {
        return OS.memory().readVolatileLong(address + pos);
    }

    @Override
    public void writeEntryVolatile(long address, long pos, long key, long value) {
        OS.memory().writeVolatileLong(address + pos, this.entry(key, value));
    }

    @Override
    public void writeEntry(long address, long pos, long newEntry) {
        OS.memory().writeLong(address + pos, newEntry);
    }

    @Override
    public void clearEntry(long address, long pos) {
        OS.memory().writeLong(address + pos, 0L);
    }
}

