/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import net.openhft.chronicle.core.Jvm;

public final class TimeProvider {
    private static final AtomicLong lastTimeHolder = new AtomicLong();
    private static LongSupplier millisecondSupplier = System::currentTimeMillis;

    private TimeProvider() {
    }

    public static long currentTime() {
        long now = TimeUnit.MILLISECONDS.toNanos(millisecondSupplier.getAsLong());
        long lastTime;
        while (now > (lastTime = lastTimeHolder.get())) {
            if (lastTimeHolder.compareAndSet(lastTime, now)) {
                return now;
            }
            Jvm.nanoPause();
        }
        return lastTime;
    }

    public static long systemTimeIntervalBetween(long earlierTime, long laterTime, TimeUnit systemTimeIntervalUnit) {
        long intervalNanos = laterTime - earlierTime;
        return systemTimeIntervalUnit.convert(intervalNanos, TimeUnit.NANOSECONDS);
    }

    static void overrideMillisecondSupplier(LongSupplier millisecondSupplier) {
        TimeProvider.millisecondSupplier = millisecondSupplier;
    }
}

