/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.ChronicleFileLockException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileLockUtil {
    private static final String DISABLE_LOCKING = "chronicle.map.disable.locking";
    private static final ConcurrentHashMap<File, FileLockReference> FILE_LOCKS = new ConcurrentHashMap();
    private static final boolean USE_EXCLUSIVE_LOCKING = !OS.isWindows() && !Jvm.getBoolean((String)"chronicle.map.disable.locking");
    private static final boolean USE_SHARED_LOCKING = !OS.isWindows() && !Jvm.getBoolean((String)"chronicle.map.disable.locking") && !"shared".equalsIgnoreCase(System.getProperty("chronicle.map.disable.locking"));
    private static final AtomicBoolean LOCK_WARNING_PRINTED = new AtomicBoolean();

    private FileLockUtil() {
    }

    public static void acquireSharedFileLock(@NotNull File canonicalFile, @NotNull FileChannel channel) {
        if (USE_SHARED_LOCKING) {
            FILE_LOCKS.compute(canonicalFile, (f, flr) -> {
                try {
                    if (flr == null) {
                        return new FileLockReference(channel.lock(0L, Long.MAX_VALUE, true));
                    }
                    if (!((FileLockReference)flr).fileLock.isShared()) {
                        throw FileLockUtil.newUnableToAcquireSharedFileLockException(canonicalFile, null);
                    }
                    flr.reserve();
                    return flr;
                }
                catch (IOException e) {
                    throw FileLockUtil.newUnableToAcquireSharedFileLockException(canonicalFile, e);
                }
            });
        } else {
            FileLockUtil.printWarningTheFirstTime();
        }
    }

    public static void acquireExclusiveFileLock(@NotNull File canonicalFile, @NotNull FileChannel channel) {
        if (USE_EXCLUSIVE_LOCKING) {
            FILE_LOCKS.compute(canonicalFile, (f, flr) -> {
                if (flr == null) {
                    try {
                        FileLock fileLock = channel.lock(0L, Long.MAX_VALUE, false);
                        return new FileLockReference(fileLock);
                    }
                    catch (IOException e) {
                        throw FileLockUtil.newUnableToAcquireExclusiveFileLockException(canonicalFile, e);
                    }
                }
                throw FileLockUtil.newUnableToAcquireExclusiveFileLockException(canonicalFile, null);
            });
        } else {
            FileLockUtil.printWarningTheFirstTime();
        }
    }

    public static void releaseSharedFileLock(@NotNull File canonicalFile) {
        if (USE_SHARED_LOCKING) {
            FileLockUtil.releaseFileLock0(canonicalFile);
        } else {
            FileLockUtil.printWarningTheFirstTime();
        }
    }

    public static void releaseExclusiveFileLock(@NotNull File canonicalFile) {
        if (USE_EXCLUSIVE_LOCKING) {
            FileLockUtil.releaseFileLock0(canonicalFile);
        } else {
            FileLockUtil.printWarningTheFirstTime();
        }
    }

    @Deprecated
    public static void releaseFileLock(@NotNull File canonicalFile) {
        FileLockUtil.releaseExclusiveFileLock(canonicalFile);
    }

    private static void releaseFileLock0(@NotNull File canonicalFile) {
        FILE_LOCKS.compute(canonicalFile, (f, flr) -> {
            if (flr == null) {
                throw new ChronicleFileLockException("Trying to release lock on file " + canonicalFile + " that did not exist");
            }
            int cnt = flr.release();
            if (cnt == 0) {
                return null;
            }
            return flr;
        });
    }

    public static boolean tryRunExclusively(@NotNull File canonicalFile, @NotNull FileChannel fileChannel, @NotNull FileIOAction fileIOAction) {
        AtomicBoolean locked = new AtomicBoolean(false);
        FILE_LOCKS.compute(canonicalFile, (f, flr) -> {
            if (flr != null) {
                return flr;
            }
            try {
                if (!USE_EXCLUSIVE_LOCKING) {
                    fileIOAction.fileIOAction();
                    locked.set(true);
                    return null;
                }
                try (FileLock ignored2 = fileChannel.tryLock();){
                    if (ignored2 == null) {
                        FileLockReference fileLockReference = null;
                        return fileLockReference;
                    }
                    fileIOAction.fileIOAction();
                    locked.set(true);
                    return null;
                }
                catch (OverlappingFileLockException ignored2) {
                    return null;
                }
            }
            catch (Exception e) {
                throw Jvm.rethrow((Throwable)e);
            }
        });
        return locked.get();
    }

    public static void runExclusively(@NotNull File canonicalFile, @NotNull FileChannel fileChannel, @NotNull FileIOAction fileIOAction) {
        FILE_LOCKS.compute(canonicalFile, (f, flr) -> {
            if (flr != null) {
                throw new ChronicleFileLockException("A file lock instance already exists for the file " + canonicalFile);
            }
            try {
                if (USE_EXCLUSIVE_LOCKING) {
                    try (FileLock ignored = fileChannel.lock();){
                        fileIOAction.fileIOAction();
                    }
                } else {
                    fileIOAction.fileIOAction();
                }
                return null;
            }
            catch (Exception e) {
                throw Jvm.rethrow((Throwable)e);
            }
        });
    }

    static void dump() {
        System.out.println(FILE_LOCKS);
    }

    private static ChronicleFileLockException newUnableToAcquireSharedFileLockException(@NotNull File canonicalFile, @Nullable Exception e) {
        return new ChronicleFileLockException("Unable to acquire a shared file lock for " + canonicalFile + ". Make sure another process is not recovering the map.", e);
    }

    private static ChronicleFileLockException newUnableToAcquireExclusiveFileLockException(@NotNull File canonicalFile, @Nullable Exception e) {
        return new ChronicleFileLockException("Unable to acquire an exclusive file lock for " + canonicalFile + ". Make sure no other process is using the map.", e);
    }

    private static void printWarningTheFirstTime() {
        if (LOCK_WARNING_PRINTED.compareAndSet(false, true)) {
            Jvm.warn().on(FileLockUtil.class, "File locking is disabled or not supported on this platform (" + System.getProperty("os.name") + "). Make sure you are not running ChronicleMapBuilder::*recover* methods when other processes or threads have the mapped file open!");
        }
    }

    @FunctionalInterface
    static interface FileIOAction {
        public void fileIOAction() throws IOException;
    }

    private static final class FileLockReference {
        private final FileLock fileLock;
        private int refCount;

        FileLockReference(@NotNull FileLock fileLock) {
            this.fileLock = fileLock;
            this.refCount = 1;
        }

        int reserve() {
            if (this.refCount == 0) {
                throw new IllegalStateException("Ref counter previously released");
            }
            return ++this.refCount;
        }

        int release() {
            int cnt;
            if ((cnt = --this.refCount) == 0) {
                try {
                    this.fileLock.release();
                }
                catch (IOException e) {
                    throw new ChronicleFileLockException(e);
                }
            }
            if (cnt < 0) {
                throw new IllegalStateException("Ref counter was " + cnt);
            }
            return cnt;
        }

        public String toString() {
            return "FileLockReference{fileLock=" + this.fileLock + ", refCount=" + this.refCount + '}';
        }
    }
}

