/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.values.Copyable;
import net.openhft.chronicle.values.Values;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueReader<T>
implements SizedReader<T>,
BytesReader<T>,
StatefulCopyable<ValueReader<T>> {
    private Class<T> valueType;
    private transient Class<? extends T> nativeClass;
    private transient Class<? extends T> heapClass;
    private transient Byteable nativeReference;

    public ValueReader(Class<T> valueType) {
        this.valueType = valueType;
        this.initTransients();
    }

    protected Class<T> valueType() {
        return this.valueType;
    }

    protected Class<? extends T> nativeClass() {
        return this.nativeClass;
    }

    protected Class<? extends T> heapClass() {
        return this.heapClass;
    }

    private void initTransients() {
        this.nativeClass = Values.nativeClassFor(this.valueType);
        this.heapClass = Values.heapClassFor(this.valueType);
        this.nativeReference = (Byteable)Values.newNativeReference(this.valueType);
    }

    protected T createInstance() {
        try {
            return this.heapClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public T read(@NotNull Bytes in, long size, @Nullable T using) {
        if (size != this.nativeReference.maxSize()) {
            throw new IllegalArgumentException();
        }
        return this.read(in, using);
    }

    @Override
    @NotNull
    public T read(Bytes in, @Nullable T using) {
        if (using != null && using.getClass() == this.nativeClass) {
            ((Byteable)using).bytesStore(in.bytesStore(), in.readPosition(), this.nativeReference.maxSize());
            return using;
        }
        if (using == null) {
            using = this.createInstance();
        }
        this.nativeReference.bytesStore(in.bytesStore(), in.readPosition(), this.nativeReference.maxSize());
        ((Copyable)using).copyFrom((Object)this.nativeReference);
        return using;
    }

    @Override
    public ValueReader<T> copy() {
        return new ValueReader<T>(this.valueType);
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.valueType = wireIn.read(() -> "valueType").typeLiteral();
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "valueType").typeLiteral(this.valueType);
    }
}

