/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.set;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashBuilderPrivateAPI;
import net.openhft.chronicle.hash.ChronicleHashCorruption;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapEntryOperations;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.ChronicleSetBuilderPrivateAPI;
import net.openhft.chronicle.set.DummyValue;
import net.openhft.chronicle.set.DummyValueMarshaller;
import net.openhft.chronicle.set.SetAbsentEntry;
import net.openhft.chronicle.set.SetEntryOperations;
import net.openhft.chronicle.set.SetFromMap;
import org.jetbrains.annotations.NotNull;

public final class ChronicleSetBuilder<K>
implements ChronicleHashBuilder<K, ChronicleSet<K>, ChronicleSetBuilder<K>> {
    private static final ChronicleHashCorruption.Listener defaultChronicleSetCorruptionListener = corruption -> Jvm.error().on(ChronicleSetBuilder.class, corruption.message(), corruption.exception());
    private ChronicleMapBuilder<K, DummyValue> chronicleMapBuilder;
    private final ChronicleSetBuilderPrivateAPI<K> privateAPI;

    ChronicleSetBuilder(Class<K> keyClass) {
        this.chronicleMapBuilder = ChronicleMapBuilder.of(keyClass, DummyValue.class).valueReaderAndDataAccess(DummyValueMarshaller.INSTANCE, DummyValueMarshaller.INSTANCE).valueSizeMarshaller(SizeMarshaller.constant(0L));
        this.privateAPI = new ChronicleSetBuilderPrivateAPI((ChronicleHashBuilderPrivateAPI)this.chronicleMapBuilder.privateAPI());
    }

    public static <K> ChronicleSetBuilder<K> of(Class<K> keyClass) {
        return new ChronicleSetBuilder<K>(keyClass);
    }

    @Override
    public ChronicleSetBuilder<K> clone() {
        try {
            ChronicleSetBuilder result = (ChronicleSetBuilder)super.clone();
            result.chronicleMapBuilder = this.chronicleMapBuilder.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ChronicleSetBuilder<K> name(String name) {
        this.chronicleMapBuilder.name(name);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> actualSegments(int actualSegments) {
        this.chronicleMapBuilder.actualSegments(actualSegments);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> minSegments(int minSegments) {
        this.chronicleMapBuilder.minSegments(minSegments);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> entriesPerSegment(long entriesPerSegment) {
        this.chronicleMapBuilder.entriesPerSegment(entriesPerSegment);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> actualChunksPerSegmentTier(long actualChunksPerSegmentTier) {
        this.chronicleMapBuilder.actualChunksPerSegmentTier(actualChunksPerSegmentTier);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> averageKeySize(double averageKeySize) {
        this.chronicleMapBuilder.averageKeySize(averageKeySize);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> averageKey(K averageKey) {
        this.chronicleMapBuilder.averageKey((Object)averageKey);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> constantKeySizeBySample(K sampleKey) {
        this.chronicleMapBuilder.constantKeySizeBySample((Object)sampleKey);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> actualChunkSize(int actualChunkSize) {
        this.chronicleMapBuilder.actualChunkSize(actualChunkSize);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> maxChunksPerEntry(int maxChunksPerEntry) {
        this.chronicleMapBuilder.maxChunksPerEntry(maxChunksPerEntry);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> entries(long entries) {
        this.chronicleMapBuilder.entries(entries);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> maxBloatFactor(double maxBloatFactor) {
        this.chronicleMapBuilder.maxBloatFactor(maxBloatFactor);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> allowSegmentTiering(boolean allowSegmentTiering) {
        this.chronicleMapBuilder.allowSegmentTiering(allowSegmentTiering);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> nonTieredSegmentsPercentile(double nonTieredSegmentsPercentile) {
        this.chronicleMapBuilder.nonTieredSegmentsPercentile(nonTieredSegmentsPercentile);
        return this;
    }

    public String toString() {
        return " ChronicleSetBuilder{chronicleMapBuilder=" + this.chronicleMapBuilder + '}';
    }

    public boolean equals(Object o) {
        return o instanceof ChronicleSetBuilder && this.chronicleMapBuilder.equals(((ChronicleSetBuilder)o).chronicleMapBuilder);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public ChronicleSetBuilder<K> keyReaderAndDataAccess(SizedReader<K> keyReader, @NotNull DataAccess<K> keyDataAccess) {
        this.chronicleMapBuilder.keyReaderAndDataAccess((SizedReader)keyReader, (DataAccess)keyDataAccess);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> keyMarshallers(@NotNull BytesReader<K> keyReader, @NotNull BytesWriter<? super K> keyWriter) {
        this.chronicleMapBuilder.keyMarshallers((BytesReader)keyReader, keyWriter);
        return this;
    }

    @Override
    public <M extends BytesReader<K> & BytesWriter<? super K>> ChronicleSetBuilder<K> keyMarshaller(@NotNull M marshaller) {
        this.chronicleMapBuilder.keyMarshaller(marshaller);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> keyMarshallers(@NotNull SizedReader<K> keyReader, @NotNull SizedWriter<? super K> keyWriter) {
        this.chronicleMapBuilder.keyMarshallers((SizedReader)keyReader, keyWriter);
        return this;
    }

    @Override
    public <M extends SizedReader<K> & SizedWriter<? super K>> ChronicleSetBuilder<K> keyMarshaller(@NotNull M sizedMarshaller) {
        this.chronicleMapBuilder.keyMarshaller(sizedMarshaller);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> keySizeMarshaller(@NotNull SizeMarshaller keySizeMarshaller) {
        this.chronicleMapBuilder.keySizeMarshaller(keySizeMarshaller);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> aligned64BitMemoryOperationsAtomic(boolean aligned64BitMemoryOperationsAtomic) {
        this.chronicleMapBuilder.aligned64BitMemoryOperationsAtomic(aligned64BitMemoryOperationsAtomic);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> checksumEntries(boolean checksumEntries) {
        this.chronicleMapBuilder.checksumEntries(checksumEntries);
        return this;
    }

    public ChronicleSetBuilder<K> entryOperations(final SetEntryOperations<K, ?> entryOperations) {
        this.chronicleMapBuilder.entryOperations(new MapEntryOperations<K, DummyValue, Object>(){

            @Override
            public Object remove(@NotNull MapEntry<K, DummyValue> entry) {
                return entryOperations.remove(entry);
            }

            @Override
            public Object insert(@NotNull MapAbsentEntry<K, DummyValue> absentEntry, Data<DummyValue> value) {
                return entryOperations.insert((SetAbsentEntry)((Object)absentEntry));
            }
        });
        return this;
    }

    @Override
    public ChronicleSet<K> create() {
        ChronicleHash map = this.chronicleMapBuilder.create();
        return new SetFromMap((VanillaChronicleMap)map);
    }

    @Override
    public ChronicleSet<K> createPersistedTo(File file) throws IOException {
        ChronicleHash map = this.chronicleMapBuilder.createPersistedTo(file);
        return new SetFromMap((VanillaChronicleMap)map);
    }

    @Override
    public ChronicleSet<K> createOrRecoverPersistedTo(File file) throws IOException {
        return this.createOrRecoverPersistedTo(file, true);
    }

    @Override
    public ChronicleSet<K> createOrRecoverPersistedTo(File file, boolean sameLibraryVersion) throws IOException {
        return this.createOrRecoverPersistedTo(file, sameLibraryVersion, defaultChronicleSetCorruptionListener);
    }

    @Override
    public ChronicleSet<K> createOrRecoverPersistedTo(File file, boolean sameLibraryVersion, ChronicleHashCorruption.Listener corruptionListener) throws IOException {
        ChronicleHash map = this.chronicleMapBuilder.createOrRecoverPersistedTo(file, sameLibraryVersion, corruptionListener);
        return new SetFromMap((VanillaChronicleMap)map);
    }

    @Override
    public ChronicleSet<K> recoverPersistedTo(File file, boolean sameBuilderConfigAndLibraryVersion) throws IOException {
        return this.recoverPersistedTo(file, sameBuilderConfigAndLibraryVersion, defaultChronicleSetCorruptionListener);
    }

    @Override
    public ChronicleSet<K> recoverPersistedTo(File file, boolean sameBuilderConfigAndLibraryVersion, ChronicleHashCorruption.Listener corruptionListener) throws IOException {
        ChronicleHash map = this.chronicleMapBuilder.recoverPersistedTo(file, sameBuilderConfigAndLibraryVersion, corruptionListener);
        return new SetFromMap((VanillaChronicleMap)map);
    }

    @Override
    public ChronicleSetBuilder<K> setPreShutdownAction(Runnable preShutdownAction) {
        this.chronicleMapBuilder.setPreShutdownAction(preShutdownAction);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> skipCloseOnExitHook(boolean skipCloseOnExitHook) {
        this.chronicleMapBuilder.skipCloseOnExitHook(skipCloseOnExitHook);
        return this;
    }

    @Override
    @Deprecated
    public Object privateAPI() {
        return this.privateAPI;
    }
}

