/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.map.MapQueryContext;
import net.openhft.chronicle.map.ReturnValue;

final class MapMethodsSupport {
    private MapMethodsSupport() {
    }

    static <V> void returnCurrentValueIfPresent(MapQueryContext<?, V, ?> q, ReturnValue<V> returnValue) {
        HashEntry entry = q.entry();
        if (entry != null) {
            returnValue.returnValue(entry.value());
        }
    }

    static <V> boolean tryReturnCurrentValueIfPresent(MapQueryContext<?, V, ?> q, ReturnValue<V> returnValue) {
        HashEntry entry;
        if (q.readLock().tryLock()) {
            entry = q.entry();
            if (entry != null) {
                returnValue.returnValue(entry.value());
                return true;
            }
            q.readLock().unlock();
        }
        q.updateLock().lock();
        entry = q.entry();
        if (entry != null) {
            returnValue.returnValue(entry.value());
            return true;
        }
        return false;
    }
}

