/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharSequenceSizedReader
implements SizedReader<CharSequence>,
StatefulCopyable<CharSequenceSizedReader>,
ReadResolvable<CharSequenceSizedReader> {
    public static final CharSequenceSizedReader INSTANCE = new CharSequenceSizedReader();

    @Deprecated
    public CharSequenceSizedReader() {
    }

    @Override
    @NotNull
    public CharSequence read(@NotNull Bytes in, long size, @Nullable CharSequence using) {
        StringBuilder usingSB;
        if (0L > size || size > Integer.MAX_VALUE) {
            throw new IllegalStateException("positive int size expected, " + size + " given");
        }
        int csLen = (int)size;
        if (using instanceof StringBuilder) {
            usingSB = (StringBuilder)using;
            usingSB.setLength(0);
            usingSB.ensureCapacity(csLen);
        } else {
            usingSB = new StringBuilder(csLen);
        }
        BytesUtil.parseUtf8((StreamingDataInput)in, (Appendable)usingSB, (int)csLen);
        return usingSB;
    }

    @Override
    public CharSequenceSizedReader copy() {
        return INSTANCE;
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
    }

    public CharSequenceSizedReader readResolve() {
        return INSTANCE;
    }
}

