/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.query;

import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.impl.stage.data.DummyValueZeroData;
import net.openhft.chronicle.map.impl.stage.entry.ReplicatedMapEntryStages;
import net.openhft.chronicle.map.impl.stage.query.MapQuery;
import net.openhft.chronicle.map.impl.stage.query.ReplicatedMapAbsentDelegating;
import net.openhft.chronicle.map.impl.stage.replication.ReplicationUpdate;
import net.openhft.chronicle.map.replication.MapRemoteQueryContext;
import net.openhft.chronicle.map.replication.MapReplicableEntry;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.Nullable;

@Staged
public abstract class ReplicatedMapQuery<K, V, R>
extends MapQuery<K, V, R>
implements MapRemoteQueryContext<K, V, R>,
ReplicableEntry {
    @StageRef
    ReplicatedMapEntryStages<K, V> e;
    @StageRef
    ReplicationUpdate ru;
    @StageRef
    ReplicatedMapAbsentDelegating<K, V> absentDelegating;
    @StageRef
    DummyValueZeroData<V> dummyValue;

    @Override
    @Nullable
    public MapAbsentEntry<K, V> absentEntry() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        if (this.entryPresent()) {
            return null;
        }
        if (!this.ks.searchStatePresent()) {
            return this.absentDelegating;
        }
        assert (this.e.entryDeleted());
        return this.absent.absent();
    }

    @Override
    public boolean entryPresent() {
        return super.entryPresent() && !this.e.entryDeleted();
    }

    @Override
    public MapReplicableEntry<K, V> entry() {
        return (MapReplicableEntry)super.entry();
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.s.innerUpdateLock.lock();
        if (this.entryPresent()) {
            if (this.e.valueSize > this.dummyValue.size()) {
                this.e.innerDefaultReplaceValue(this.dummyValue);
            }
        } else {
            throw new IllegalStateException("Entry is absent in the map when doRemove() is called");
        }
        this.e.updatedReplicationStateOnPresentEntry();
        this.e.writeEntryDeleted();
        this.ru.updateChange();
        this.e.checksumStrategy.computeAndStoreChecksum();
        this.s.deleted(this.s.deleted() + 1L);
    }

    @Override
    public void doRemoveCompletely() {
        boolean wasDeleted = this.e.entryDeleted();
        super.doRemove();
        if (wasDeleted) {
            this.s.deleted(this.s.deleted() - 1L);
        }
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.doReplaceValueWithoutChecksum(newValue);
        this.ru.updateChange();
        this.e.updatedReplicationStateOnPresentEntry();
        this.e.checksumStrategy.computeAndStoreChecksum();
    }
}

