/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.query;

import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupSearch;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.stage.entry.MapEntryStages;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class QueryMapEntryStages<K, V>
extends MapEntryStages<K, V> {
    @StageRef
    HashLookupSearch hls;

    @Override
    public void putValueDeletedEntry(Data<V> newValue) {
        int newSizeInChunks;
        boolean newValueSizeIsDifferent;
        assert (this.s.innerUpdateLock.isHeldByCurrentThread());
        long entryStartOffset = this.keySizeOffset;
        long newSizeOfEverythingBeforeValue = -1L;
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize;
        if (newValueSizeIsDifferent) {
            newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long newValueOffset = VanillaChronicleMap.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue, this.mh.m().alignment);
            long newEntrySize = this.newEntrySize(newValue, entryStartOffset, newValueOffset);
            newSizeInChunks = this.mh.m().inChunks(newEntrySize);
        } else {
            newSizeInChunks = this.entrySizeInChunks;
        }
        if (this.pos + (long)newSizeInChunks < this.s.freeList.logicalSize() && this.s.freeList.isRangeClear(this.pos, this.pos + (long)newSizeInChunks)) {
            this.s.freeList.setRange(this.pos, this.pos + (long)newSizeInChunks);
            this.s.innerWriteLock.lock();
            this.allocatedChunks.incrementSegmentEntriesIfNeeded();
            if (newValueSizeIsDifferent) {
                this.initValue(newValue);
            } else {
                this.writeValue(newValue);
            }
        } else {
            if (newValueSizeIsDifferent) {
                assert (newSizeOfEverythingBeforeValue >= 0L);
            } else {
                newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            }
            long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
            if (newValueSizeIsDifferent) {
                this.allocatedChunks.initEntryAndKeyCopying(entrySize, this.valueSizeOffset - entryStartOffset, -1L, 0);
                this.initValue(newValue);
            } else {
                long oldValueSizeOffset = this.valueSizeOffset;
                long oldValueSize = this.valueSize;
                long oldValueOffset = this.valueOffset;
                this.allocatedChunks.initEntryAndKeyCopying(entrySize, this.valueOffset - entryStartOffset, -1L, 0);
                this.initValue_WithoutSize(newValue, oldValueSizeOffset, oldValueSize, oldValueOffset);
            }
            this.freeExtraAllocatedChunks();
        }
        this.hls.putNewVolatile(this.pos);
    }
}

