/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.iter;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.ReplicatedHashSegmentContext;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.replication.ReplicableEntryDelegating;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.impl.ReplicatedIterationContext;
import net.openhft.chronicle.map.impl.stage.data.DummyValueZeroData;
import net.openhft.chronicle.map.impl.stage.entry.ReplicatedMapEntryStages;
import net.openhft.chronicle.map.impl.stage.iter.MapSegmentIteration;
import net.openhft.chronicle.map.impl.stage.iter.ReplicatedMapAbsentDelegatingForIteration;
import net.openhft.chronicle.map.impl.stage.iter.ReplicatedMapEntryDelegating;
import net.openhft.chronicle.map.impl.stage.replication.ReplicationUpdate;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class ReplicatedMapSegmentIteration<K, V, R>
extends MapSegmentIteration<K, V, R>
implements ReplicatedIterationContext<K, V, R>,
ReplicableEntry,
ReplicatedHashSegmentContext<K, MapEntry<K, V>>,
MapAbsentEntry<K, V> {
    @StageRef
    VanillaChronicleHashHolder<?> hh;
    @StageRef
    ReplicatedMapEntryStages<K, V> e;
    @StageRef
    ReplicationUpdate<K> ru;
    @StageRef
    DummyValueZeroData<V> dummyValue;
    @StageRef
    ReplicatedMapAbsentDelegatingForIteration<K, V> absentEntryDelegating;
    @StageRef
    ReplicatedMapEntryDelegating<K, V> entryDelegating;

    @Override
    public boolean entryIsPresent() {
        return !this.e.entryDeleted();
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        try {
            this.entry.innerDefaultReplaceValue(newValue);
            this.ru.updateChange();
            this.e.updatedReplicationStateOnPresentEntry();
            this.e.checksumStrategy.computeAndStoreChecksum();
        }
        finally {
            this.s.innerWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forEachSegmentReplicableEntryWhile(Predicate<? super ReplicableEntry> predicate) {
        this.s.innerUpdateLock.lock();
        try {
            long entries = this.s.entries();
            if (entries == 0L) {
                boolean bl = true;
                return bl;
            }
            boolean interrupted = false;
            long startPos = 0L;
            CompactOffHeapLinearHashTable hashLookup = this.hh.h().hashLookup;
            while (!hashLookup.empty(hashLookup.readEntry(this.s.tierBaseAddr, startPos))) {
                startPos = hashLookup.step(startPos);
            }
            this.hlp.initHashLookupPos(startPos);
            do {
                this.hlp.setHashLookupPos(hashLookup.step(this.hlp.hashLookupPos));
                long entry = hashLookup.readEntry(this.s.tierBaseAddr, this.hlp.hashLookupPos);
                if (hashLookup.empty(entry)) continue;
                this.e.readExistingEntry(hashLookup.value(entry));
                ReplicableEntryDelegating e = !this.e.entryDeleted() ? this.entryDelegating : this.absentEntryDelegating;
                this.initEntryRemovedOnThisIteration(false);
                if (!predicate.test(e)) {
                    interrupted = true;
                    break;
                }
                if (--entries == 0L) break;
            } while (this.hlp.hashLookupPos != startPos);
            boolean bl = !interrupted;
            return bl;
        }
        finally {
            this.s.innerReadLock.unlock();
            this.initEntryRemovedOnThisIteration(false);
        }
    }

    @Override
    public void forEachSegmentReplicableEntry(Consumer<? super ReplicableEntry> action) {
        this.forEachSegmentReplicableEntryWhile(e -> {
            action.accept((ReplicableEntry)e);
            return true;
        });
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        try {
            if (this.e.valueSize > this.dummyValue.size()) {
                this.e.innerDefaultReplaceValue(this.dummyValue);
            }
            this.e.updatedReplicationStateOnPresentEntry();
            this.e.writeEntryDeleted();
            this.ru.updateChange();
            this.e.checksumStrategy.computeAndStoreChecksum();
            this.s.deleted(this.s.deleted() + 1L);
        }
        finally {
            this.s.innerWriteLock.unlock();
        }
        this.initEntryRemovedOnThisIteration(true);
    }

    @Override
    public void doRemoveCompletely() {
        boolean wasDeleted = this.e.entryDeleted();
        super.doRemove();
        if (wasDeleted) {
            this.s.deleted(this.s.deleted() - 1L);
        }
    }

    @Override
    public void doInsert(Data<V> value) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        if (this.e.entryDeleted()) {
            try {
                this.e.innerDefaultReplaceValue(value);
                this.s.deleted(this.s.deleted() - 1L);
                this.s.incrementModCount();
                this.e.writeEntryPresent();
                this.ru.updateChange();
                this.e.updatedReplicationStateOnPresentEntry();
                this.e.checksumStrategy.computeAndStoreChecksum();
            }
            finally {
                this.s.innerWriteLock.unlock();
            }
        } else {
            throw new IllegalStateException("Entry is present in the map when doInsert() is called");
        }
    }
}

