/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.impl.InstanceCreatingMarshaller;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytesMarshallableDataAccess<T extends BytesMarshallable>
extends InstanceCreatingMarshaller<T>
implements DataAccess<T>,
Data<T> {
    private transient Bytes bytes;
    private transient T instance;

    public BytesMarshallableDataAccess(Class<T> tClass) {
        super(tClass);
        this.initTransients();
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) throws IORuntimeException {
        super.readMarshallable(wireIn);
        this.initTransients();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    private void initTransients() {
        this.bytes = Bytes.allocateElasticDirect((long)1L);
    }

    @Override
    public RandomDataInput bytes() {
        return this.bytes.bytesStore();
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        return this.bytes.readRemaining();
    }

    @Override
    public T get() {
        return this.instance;
    }

    @Override
    public T getUsing(@Nullable T using) {
        if (using == null) {
            using = (BytesMarshallable)this.createInstance();
        }
        using.readMarshallable(this.bytes);
        this.bytes.readPosition(0L);
        return using;
    }

    public int hashCode() {
        return this.dataHashCode();
    }

    public boolean equals(Object obj) {
        return this.dataEquals(obj);
    }

    public String toString() {
        return this.get().toString();
    }

    @Override
    public Data<T> getData(@NotNull T instance) {
        this.instance = instance;
        this.bytes.clear();
        instance.writeMarshallable(this.bytes);
        return this;
    }

    @Override
    public void uninit() {
        this.instance = null;
    }

    @Override
    public DataAccess<T> copy() {
        return new BytesMarshallableDataAccess(this.tClass());
    }
}

