/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.nio.ch.DirectBuffer;

public class ByteBufferDataAccess
extends AbstractData<ByteBuffer>
implements DataAccess<ByteBuffer> {
    private transient HeapBytesStore heapBytesStore;
    private transient NativeBytesStore nativeBytesStore;
    private transient VanillaBytes<Void> bytes;
    private transient ByteBuffer bb;
    private transient BytesStore bytesStore;

    public ByteBufferDataAccess() {
        this.initTransients();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    private void initTransients() {
        this.heapBytesStore = HeapBytesStore.uninitialized();
        this.nativeBytesStore = NativeBytesStore.uninitialized();
        this.bytes = VanillaBytes.vanillaBytes();
    }

    @Override
    public RandomDataInput bytes() {
        return this.bytesStore;
    }

    @Override
    public long offset() {
        return this.bb.position();
    }

    @Override
    public long size() {
        return this.bb.remaining();
    }

    @Override
    public ByteBuffer get() {
        return this.bb;
    }

    @Override
    public ByteBuffer getUsing(@Nullable ByteBuffer using) {
        if (using == null || using.capacity() < this.bb.remaining()) {
            using = ByteBuffer.allocate(this.bb.remaining());
        } else {
            using.position(0);
            using.limit(this.bb.capacity());
        }
        this.bytes.bytesStore(this.bytesStore, (long)this.bb.position(), (long)this.bb.remaining());
        this.bytes.read(using);
        using.flip();
        return using;
    }

    @Override
    public Data<ByteBuffer> getData(@NotNull ByteBuffer instance) {
        this.bb = instance;
        if (instance instanceof DirectBuffer) {
            this.nativeBytesStore.init(instance, false);
            this.bytesStore = this.nativeBytesStore;
        } else {
            this.heapBytesStore.init(instance);
            this.bytesStore = this.heapBytesStore;
        }
        return this;
    }

    @Override
    public void uninit() {
        this.bb = null;
        if (this.bytesStore == this.nativeBytesStore) {
            this.nativeBytesStore.uninit();
        } else {
            this.heapBytesStore.uninit();
        }
    }

    @Override
    public DataAccess<ByteBuffer> copy() {
        return new ByteBufferDataAccess();
    }

    public void readMarshallable(@NotNull WireIn wireIn) throws IORuntimeException {
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
    }
}

