/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.replication.TcpInetSocketAddress;
import net.openhft.chronicle.hash.replication.ThrottlingConfig;

public final class TcpTransportAndNetworkConfig
implements Serializable {
    private static final int DEFAULT_TCP_BUFFER_SIZE = 65536;
    private static final long DEFAULT_HEART_BEAT_INTERVAL = 20L;
    private static final TimeUnit DEFAULT_HEART_BEAT_INTERVAL_UNIT = TimeUnit.SECONDS;
    private final int serverPort;
    private final Set<InetSocketAddress> endpoints;
    private final int tcpBufferSize;
    private final boolean autoReconnectedUponDroppedConnection;
    private final ThrottlingConfig throttlingConfig;
    private final long heartBeatInterval;
    private final TimeUnit heartBeatIntervalUnit;

    private TcpTransportAndNetworkConfig(int serverPort, Set<InetSocketAddress> endpoints, int tcpBufferSize, boolean autoReconnectedUponDroppedConnection, ThrottlingConfig throttlingConfig, long heartBeatInterval, TimeUnit heartBeatIntervalUnit) {
        this.serverPort = serverPort;
        this.endpoints = endpoints;
        this.tcpBufferSize = tcpBufferSize;
        this.autoReconnectedUponDroppedConnection = autoReconnectedUponDroppedConnection;
        this.throttlingConfig = throttlingConfig;
        this.heartBeatInterval = heartBeatInterval;
        this.heartBeatIntervalUnit = heartBeatIntervalUnit;
    }

    public static TcpTransportAndNetworkConfig of(int serverPort, InetSocketAddress ... endpoints) {
        return TcpTransportAndNetworkConfig.of(serverPort, Arrays.asList(endpoints));
    }

    public static TcpTransportAndNetworkConfig of(int serverPort, Collection<InetSocketAddress> endpoints) {
        for (InetSocketAddress endpoint : endpoints) {
            if (endpoint.getPort() != serverPort || !"localhost".equals(endpoint.getHostName())) continue;
            throw new IllegalArgumentException("endpoint=" + endpoint + " can not point to the same port as the server");
        }
        HashSet<TcpInetSocketAddress> s = new HashSet<TcpInetSocketAddress>();
        for (InetSocketAddress endpoint : endpoints) {
            s.add(new TcpInetSocketAddress(endpoint.getHostName(), endpoint.getPort()));
        }
        return new TcpTransportAndNetworkConfig(serverPort, Collections.unmodifiableSet(s), 65536, true, ThrottlingConfig.noThrottling(), 20L, DEFAULT_HEART_BEAT_INTERVAL_UNIT);
    }

    public boolean autoReconnectedUponDroppedConnection() {
        return this.autoReconnectedUponDroppedConnection;
    }

    public TcpTransportAndNetworkConfig autoReconnectedUponDroppedConnection(boolean autoReconnectedUponDroppedConnection) {
        return new TcpTransportAndNetworkConfig(this.serverPort, this.endpoints, this.tcpBufferSize, autoReconnectedUponDroppedConnection, this.throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit);
    }

    public ThrottlingConfig throttlingConfig() {
        return this.throttlingConfig;
    }

    public TcpTransportAndNetworkConfig throttlingConfig(ThrottlingConfig throttlingConfig) {
        ThrottlingConfig.checkMillisecondBucketInterval(throttlingConfig, "TCP");
        return new TcpTransportAndNetworkConfig(this.serverPort, this.endpoints, this.tcpBufferSize, this.autoReconnectedUponDroppedConnection, throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit);
    }

    public long heartBeatInterval(TimeUnit unit) {
        return unit.convert(this.heartBeatInterval, this.heartBeatIntervalUnit);
    }

    public int serverPort() {
        return this.serverPort;
    }

    public TcpTransportAndNetworkConfig serverPort(int serverPort) {
        return new TcpTransportAndNetworkConfig(serverPort, this.endpoints, this.tcpBufferSize, this.autoReconnectedUponDroppedConnection, this.throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit);
    }

    public Set<InetSocketAddress> endpoints() {
        return this.endpoints;
    }

    public TcpTransportAndNetworkConfig endpoints(Set<InetSocketAddress> endpoints) {
        for (InetSocketAddress endpoint : endpoints) {
            if (endpoint.getPort() != this.serverPort || !"localhost".equals(endpoint.getHostName())) continue;
            throw new IllegalArgumentException("endpoint=" + endpoint + " can not point to the same port as the server");
        }
        return new TcpTransportAndNetworkConfig(this.serverPort, endpoints, this.tcpBufferSize, this.autoReconnectedUponDroppedConnection, this.throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit);
    }

    public int tcpBufferSize() {
        return this.tcpBufferSize;
    }

    public TcpTransportAndNetworkConfig tcpBufferSize(int tcpBufferSize) {
        if (tcpBufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        return new TcpTransportAndNetworkConfig(this.serverPort, this.endpoints, tcpBufferSize, this.autoReconnectedUponDroppedConnection, this.throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit);
    }

    public TcpTransportAndNetworkConfig heartBeatInterval(long heartBeatInterval, TimeUnit heartBeatIntervalUnit) {
        return new TcpTransportAndNetworkConfig(this.serverPort, this.endpoints, this.tcpBufferSize, this.autoReconnectedUponDroppedConnection, this.throttlingConfig, heartBeatInterval, heartBeatIntervalUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpTransportAndNetworkConfig that = (TcpTransportAndNetworkConfig)o;
        if (this.autoReconnectedUponDroppedConnection != that.autoReconnectedUponDroppedConnection) {
            return false;
        }
        if (this.heartBeatInterval != that.heartBeatInterval) {
            return false;
        }
        if (this.tcpBufferSize != that.tcpBufferSize) {
            return false;
        }
        if (this.serverPort != that.serverPort) {
            return false;
        }
        if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) {
            return false;
        }
        if (this.heartBeatIntervalUnit != that.heartBeatIntervalUnit) {
            return false;
        }
        return !(this.throttlingConfig != null ? !this.throttlingConfig.equals(that.throttlingConfig) : that.throttlingConfig != null);
    }

    public int hashCode() {
        int result = this.serverPort;
        result = 31 * result + (this.endpoints != null ? this.endpoints.hashCode() : 0);
        result = 31 * result + this.tcpBufferSize;
        result = 31 * result + (this.autoReconnectedUponDroppedConnection ? 1 : 0);
        result = 31 * result + (this.throttlingConfig != null ? this.throttlingConfig.hashCode() : 0);
        result = 31 * result + (int)(this.heartBeatInterval ^ this.heartBeatInterval >>> 32);
        result = 31 * result + (this.heartBeatIntervalUnit != null ? this.heartBeatIntervalUnit.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TcpReplicationConfig{serverPort=" + this.serverPort + ", endpoints=" + this.endpoints + ", tcpBufferSize=" + this.tcpBufferSize + ", autoReconnectedUponDroppedConnection=" + this.autoReconnectedUponDroppedConnection + ", throttlingConfig=" + this.throttlingConfig + ", heartBeatInterval=" + this.heartBeatInterval + ", heartBeatIntervalUnit=" + (Object)((Object)this.heartBeatIntervalUnit) + '}';
    }
}

