/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.Crc32;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public class HashKeyCrc32PayloadChecksumStrategy
implements ChecksumStrategy {
    @StageRef
    CheckOnEachPublicOperation checkOnEachPublicOperation;
    @StageRef
    SegmentStages s;
    @StageRef
    HashEntryStages<?> e;
    @StageRef
    KeyHashCode h;

    @Override
    public void computeAndStoreChecksum() {
        int crc = this.computeChecksum();
        this.s.segmentBS.writeInt(this.e.entryEnd(), crc);
    }

    private int computeChecksum() {
        long checksum;
        long keyHashCode = this.h.keyHashCode();
        long keyEnd = this.e.keyEnd();
        long len = this.e.entryEnd() - keyEnd;
        if (len > 0L) {
            long addr = this.s.tierBaseAddr + keyEnd;
            int payloadCrc = Crc32.compute(addr, len);
            checksum = ChecksumHashing.hash8To16Bytes(this.e.keySize, keyHashCode, payloadCrc);
        } else {
            checksum = ChecksumHashing.hash8To16Bytes(this.e.keySize, keyHashCode, keyHashCode);
        }
        return (int)(checksum >>> 32 ^ checksum);
    }

    @Override
    public void updateChecksum() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.computeAndStoreChecksum();
    }

    @Override
    public boolean innerCheckSum() {
        int crc;
        int oldChecksum = this.s.segmentBS.readInt(this.e.entryEnd());
        return oldChecksum == (crc = this.computeChecksum());
    }

    @Override
    public boolean checkSum() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerCheckSum();
    }

    @Override
    public long extraEntryBytes() {
        return 4L;
    }
}

