/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.hash.ChronicleHashClosedException;
import net.openhft.chronicle.hash.impl.ContextHolder;
import net.openhft.chronicle.hash.impl.MemoryResource;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.impl.util.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChronicleHashResources
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ChronicleHashResources.class);
    private static final int OPEN = 0;
    private static final int PARTIALLY_CLOSED = 1;
    private static final int COMPLETELY_CLOSED = 2;
    private volatile int state = 0;
    private List<MemoryResource> memoryResources = new ArrayList<MemoryResource>();
    private List<Closeable> closeables = new ArrayList<Closeable>(1);
    private List<WeakReference<ContextHolder>> contexts = new ArrayList<WeakReference<ContextHolder>>();
    private String chronicleHashIdentityString;

    List<WeakReference<ContextHolder>> contexts() {
        return this.contexts;
    }

    final synchronized long totalMemory() {
        if (this.closed()) {
            return 0L;
        }
        long totalMemory = 0L;
        for (int i = 0; i < this.memoryResources.size(); ++i) {
            totalMemory += this.memoryResources.get((int)i).size;
        }
        return totalMemory;
    }

    final boolean closed() {
        return this.state != 0;
    }

    private void checkOpen() {
        if (this.closed()) {
            throw new ChronicleHashClosedException(this.chronicleHashIdentityString);
        }
    }

    public final synchronized void setChronicleHashIdentityString(String chronicleHashIdentityString) {
        this.checkOpen();
        this.chronicleHashIdentityString = chronicleHashIdentityString;
    }

    final synchronized void addMemoryResource(long address, long size) {
        this.checkOpen();
        this.memoryResources.add(new MemoryResource(address, size));
    }

    final synchronized void addCloseable(Closeable closeable) {
        this.checkOpen();
        this.closeables.add(closeable);
    }

    final synchronized void addContext(ContextHolder contextHolder) {
        this.checkOpen();
        this.expungeStateContexts();
        this.contexts.add(new WeakReference<ContextHolder>(contextHolder));
    }

    private void expungeStateContexts() {
        this.contexts.removeIf(ref -> {
            ContextHolder contextHolder = (ContextHolder)ref.get();
            return contextHolder == null || !contextHolder.get().owner().isAlive();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable thrown = null;
        try {
            if (this.state == 2) {
                return;
            }
            try {
                LOG.error("{} is not closed manually, cleaned up from Cleaner", (Object)this.chronicleHashIdentityString);
            }
            catch (Throwable t) {
                thrown = t;
            }
            finally {
                ChronicleHashResources chronicleHashResources = this;
                synchronized (chronicleHashResources) {
                    if (this.state == 2) {
                        LOG.error("Somebody closed {} while it is processed by Cleaner, this should be impossible", (Object)this.chronicleHashIdentityString);
                    } else {
                        thrown = Throwables.returnOrSuppress(thrown, this.releaseEverything(true));
                    }
                }
                if (thrown != null) {
                    try {
                        LOG.error("Error on releasing resources of " + this.chronicleHashIdentityString, thrown);
                    }
                    catch (Throwable t) {
                        thrown.addSuppressed(t);
                        thrown.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    abstract void releaseMemoryResource(MemoryResource var1) throws IOException;

    Throwable releaseExtraSystemResources() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean releaseManually() {
        if (this.state == 2) {
            return false;
        }
        ChronicleHashResources chronicleHashResources = this;
        synchronized (chronicleHashResources) {
            if (this.state == 2) {
                return false;
            }
            Throwable thrown = this.releaseEverything(false);
            if (thrown != null) {
                throw Throwables.propagate(thrown);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Throwable releaseEverything(boolean releaseFromCleaner) {
        Throwable thrown;
        block24: {
            block23: {
                this.state = 1;
                thrown = null;
                if (this.contexts == null) break block23;
                thrown = this.closeContexts();
            }
            try {
                if (this.closeables != null) {
                    thrown = Throwables.returnOrSuppress(thrown, this.closeCloseables());
                }
                break block24;
            }
            catch (Throwable t) {
                try {
                    thrown = Throwables.returnOrSuppress(thrown, t);
                    break block24;
                }
                catch (Throwable stackOverflowError) {
                    thrown = thrown != null ? thrown : t;
                }
            }
            break block24;
            catch (Throwable t) {
                try {
                    thrown = t;
                }
                catch (Throwable throwable) {
                    try {
                        if (this.closeables != null) {
                            thrown = Throwables.returnOrSuppress(thrown, this.closeCloseables());
                        }
                    }
                    catch (Throwable t2) {
                        try {
                            thrown = Throwables.returnOrSuppress(thrown, t2);
                        }
                        catch (Throwable stackOverflowError) {
                            thrown = thrown != null ? thrown : t2;
                        }
                    }
                    throw throwable;
                }
                try {
                    if (this.closeables != null) {
                        thrown = Throwables.returnOrSuppress(thrown, this.closeCloseables());
                    }
                }
                catch (Throwable t3) {
                    try {
                        thrown = Throwables.returnOrSuppress(thrown, t3);
                    }
                    catch (Throwable stackOverflowError) {
                        thrown = thrown != null ? thrown : t3;
                    }
                }
            }
        }
        if (thrown == null || releaseFromCleaner) {
            try {
                thrown = this.releaseSystemResources(thrown);
            }
            catch (Throwable stackOverflowError) {
                Throwable throwable = thrown = thrown != null ? thrown : stackOverflowError;
            }
        }
        if (thrown == null) {
            this.state = 2;
        }
        return thrown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Throwable releaseSystemResources(Throwable thrown) {
        block17: {
            block16: {
                if (this.memoryResources == null) break block16;
                thrown = Throwables.returnOrSuppress(thrown, this.releaseMemoryResources());
            }
            try {
                thrown = Throwables.returnOrSuppress(thrown, this.releaseExtraSystemResources());
            }
            catch (Throwable t) {
                try {
                    thrown = Throwables.returnOrSuppress(thrown, t);
                    break block17;
                }
                catch (Throwable stackOverflowError) {
                    thrown = thrown != null ? thrown : t;
                }
            }
            break block17;
            catch (Throwable t) {
                try {
                    thrown = Throwables.returnOrSuppress(thrown, t);
                }
                catch (Throwable throwable) {
                    try {
                        thrown = Throwables.returnOrSuppress(thrown, this.releaseExtraSystemResources());
                    }
                    catch (Throwable t2) {
                        try {
                            thrown = Throwables.returnOrSuppress(thrown, t2);
                        }
                        catch (Throwable stackOverflowError) {
                            thrown = thrown != null ? thrown : t2;
                        }
                    }
                    throw throwable;
                }
                try {
                    thrown = Throwables.returnOrSuppress(thrown, this.releaseExtraSystemResources());
                }
                catch (Throwable t3) {
                    try {
                        thrown = Throwables.returnOrSuppress(thrown, t3);
                    }
                    catch (Throwable stackOverflowError) {
                        thrown = thrown != null ? thrown : t3;
                    }
                }
            }
        }
        return thrown;
    }

    private Throwable closeContexts() {
        Throwable thrown = null;
        List<WeakReference<ContextHolder>> contexts = this.contexts;
        for (int i = 0; i < contexts.size(); ++i) {
            WeakReference<ContextHolder> contextHolderRef = contexts.get(i);
            if (contextHolderRef == null) continue;
            try {
                ContextHolder contextHolder = (ContextHolder)contextHolderRef.get();
                if (contextHolder != null) {
                    this.closeContext(contextHolder);
                }
                contexts.set(i, null);
                continue;
            }
            catch (Throwable t) {
                thrown = Throwables.returnOrSuppress(thrown, t);
            }
        }
        if (thrown == null) {
            this.contexts = null;
        }
        return thrown;
    }

    private void closeContext(ContextHolder contextHolder) {
        ChainingInterface context = contextHolder.get();
        if (context != null) {
            if (context.owner().isAlive()) {
                context.closeContext(this.chronicleHashIdentityString);
            }
            contextHolder.clear();
        }
    }

    private Throwable closeCloseables() {
        Throwable thrown = null;
        List<Closeable> closeables = this.closeables;
        for (int i = 0; i < closeables.size(); ++i) {
            Closeable closeable = closeables.get(i);
            if (closeable == null) continue;
            try {
                closeable.close();
                closeables.set(i, null);
                continue;
            }
            catch (Throwable t) {
                thrown = Throwables.returnOrSuppress(thrown, t);
            }
        }
        if (thrown == null) {
            this.closeables = null;
        }
        return thrown;
    }

    private Throwable releaseMemoryResources() {
        Throwable thrown = null;
        List<MemoryResource> memoryResources = this.memoryResources;
        for (int i = 0; i < memoryResources.size(); ++i) {
            MemoryResource memoryResource = memoryResources.get(i);
            if (memoryResource == null) continue;
            try {
                this.releaseMemoryResource(memoryResource);
                memoryResources.set(i, null);
                continue;
            }
            catch (Throwable t) {
                thrown = Throwables.returnOrSuppress(thrown, t);
            }
        }
        if (thrown == null) {
            this.memoryResources = null;
        }
        return thrown;
    }
}

