/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.impl.InstanceCreatingMarshaller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalizableReader<T extends Externalizable>
extends InstanceCreatingMarshaller<T>
implements SizedReader<T>,
BytesReader<T> {
    public ExternalizableReader(Class<T> tClass) {
        super(tClass);
    }

    @Override
    @NotNull
    public T read(@NotNull Bytes in, long size, @Nullable T using) {
        return this.read(in, using);
    }

    @Override
    @NotNull
    public T read(Bytes in, @Nullable T using) {
        if (using == null) {
            using = (Externalizable)this.createInstance();
        }
        try {
            using.readExternal(new ObjectInputStream(in.inputStream()));
            return using;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

