/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.impl.DefaultElasticBytes;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableDataAccess<T extends Serializable>
extends AbstractData<T>
implements DataAccess<T> {
    transient Bytes bytes;
    transient OutputStream out;
    transient InputStream in;
    transient T instance;

    public SerializableDataAccess() {
        this(32L);
    }

    SerializableDataAccess(long bytesCapacity) {
        this.initTransients(bytesCapacity);
    }

    void initTransients(long bytesCapacity) {
        this.bytes = DefaultElasticBytes.allocateDefaultElasticBytes(bytesCapacity);
        this.out = this.bytes.outputStream();
        this.in = this.bytes.inputStream();
    }

    @Override
    public RandomDataInput bytes() {
        return this.bytes.bytesStore();
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        return this.bytes.readRemaining();
    }

    @Override
    public T get() {
        return this.instance;
    }

    @Override
    public T getUsing(@Nullable T using) {
        try {
            Serializable result = (Serializable)new ObjectInputStream(this.in).readObject();
            this.bytes.readPosition(0L);
            return (T)result;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Data<T> getData(@NotNull T instance) {
        this.instance = instance;
        this.bytes.clear();
        try {
            ObjectOutputStream out = new ObjectOutputStream(this.out);
            out.writeObject(instance);
            out.flush();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void uninit() {
        this.instance = null;
    }

    @Override
    public DataAccess<T> copy() {
        return new SerializableDataAccess<T>(this.bytes.realCapacity());
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients(32L);
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
    }
}

