/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public final class ConstantSizeMarshaller
implements SizeMarshaller {
    private long constantSize;

    public ConstantSizeMarshaller(long constantSize) {
        this.constantSize = constantSize;
    }

    @Override
    public int storingLength(long size) {
        return 0;
    }

    @Override
    public long minStorableSize() {
        return this.constantSize;
    }

    @Override
    public long maxStorableSize() {
        return this.constantSize;
    }

    @Override
    public int minStoringLengthOfSizesInRange(long minSize, long maxSize) {
        return 0;
    }

    @Override
    public int maxStoringLengthOfSizesInRange(long minSize, long maxSize) {
        return 0;
    }

    @Override
    public void writeSize(Bytes out, long sizeToWrite) {
        if (sizeToWrite != this.constantSize) {
            throw new IllegalArgumentException("sizeToWrite: " + sizeToWrite + ", constant size should be: " + this.constantSize);
        }
    }

    @Override
    public long readSize(Bytes in) {
        return this.constantSize;
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.constantSize = wireIn.read(() -> "constantSize").int64();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "constantSize").int64(this.constantSize);
    }
}

