/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.impl.DefaultElasticBytes;
import net.openhft.chronicle.hash.serialization.impl.InstanceCreatingMarshaller;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytesMarshallableDataAccess<T extends BytesMarshallable>
extends InstanceCreatingMarshaller<T>
implements DataAccess<T>,
Data<T> {
    private transient boolean bytesInit;
    private transient Bytes bytes;
    private transient VanillaBytes targetBytes;
    private transient T instance;

    public BytesMarshallableDataAccess(Class<T> tClass) {
        this(tClass, 32L);
    }

    private BytesMarshallableDataAccess(Class<T> tClass, long bytesCapacity) {
        super(tClass);
        this.initTransients(bytesCapacity);
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) {
        super.readMarshallable(wireIn);
        this.initTransients(32L);
    }

    private void initTransients(long bytesCapacity) {
        this.bytes = DefaultElasticBytes.allocateDefaultElasticBytes(bytesCapacity);
        this.targetBytes = VanillaBytes.vanillaBytes();
    }

    @Override
    public RandomDataInput bytes() {
        this.initBytes();
        return this.bytes.bytesStore();
    }

    private void initBytes() {
        if (!this.bytesInit) {
            this.bytes.clear();
            this.instance.writeMarshallable((BytesOut)this.bytes);
            this.bytesInit = true;
        }
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        this.initBytes();
        return this.bytes.readRemaining();
    }

    @Override
    public void writeTo(RandomDataOutput target, long targetOffset) {
        if (this.bytesInit) {
            target.write(targetOffset, this.bytes(), this.offset(), this.size());
        } else {
            this.targetBytes.bytesStore((BytesStore)target, targetOffset, target.capacity() - targetOffset);
            this.targetBytes.writePosition(targetOffset);
            this.instance.writeMarshallable((BytesOut)this.targetBytes);
            this.targetBytes.bytesStore((BytesStore)NoBytesStore.NO_BYTES_STORE, 0L, 0L);
        }
    }

    @Override
    public T get() {
        return this.instance;
    }

    @Override
    public T getUsing(@Nullable T using) {
        if (using == null) {
            using = (BytesMarshallable)this.createInstance();
        }
        this.initBytes();
        using.readMarshallable((BytesIn)this.bytes);
        this.bytes.readPosition(0L);
        return using;
    }

    public int hashCode() {
        return this.dataHashCode();
    }

    public boolean equals(Object obj) {
        return this.dataEquals(obj);
    }

    public String toString() {
        return this.get().toString();
    }

    @Override
    public Data<T> getData(@NotNull T instance) {
        this.instance = instance;
        this.bytesInit = false;
        return this;
    }

    @Override
    public void uninit() {
        this.instance = null;
    }

    @Override
    public DataAccess<T> copy() {
        return new BytesMarshallableDataAccess(this.tClass(), this.bytes.realCapacity());
    }
}

