/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.hash.serialization.impl.DefaultElasticBytes;
import net.openhft.chronicle.hash.serialization.impl.InstanceCreatingMarshaller;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalBytesMarshallableDataAccess<T>
extends InstanceCreatingMarshaller<T>
implements DataAccess<T>,
Data<T> {
    private SizedReader<T> reader;
    private BytesWriter<? super T> writer;
    private transient Bytes bytes;
    private transient T instance;

    public ExternalBytesMarshallableDataAccess(Class<T> tClass, SizedReader<T> reader, BytesWriter<? super T> writer) {
        this(tClass, reader, writer, 32L);
    }

    private ExternalBytesMarshallableDataAccess(Class<T> tClass, SizedReader<T> reader, BytesWriter<? super T> writer, long bytesCapacity) {
        super(tClass);
        this.writer = writer;
        this.reader = reader;
        this.initTransients(bytesCapacity);
    }

    private void initTransients(long bytesCapacity) {
        this.bytes = DefaultElasticBytes.allocateDefaultElasticBytes(bytesCapacity);
    }

    @Override
    public RandomDataInput bytes() {
        return this.bytes.bytesStore();
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        return this.bytes.readRemaining();
    }

    @Override
    public T get() {
        return this.instance;
    }

    @Override
    public T getUsing(@Nullable T using) {
        if (using == null) {
            using = this.createInstance();
        }
        T result = this.reader.read(this.bytes, this.size(), using);
        this.bytes.readPosition(0L);
        return result;
    }

    public int hashCode() {
        return this.dataHashCode();
    }

    public boolean equals(Object obj) {
        return this.dataEquals(obj);
    }

    public String toString() {
        return this.get().toString();
    }

    @Override
    public Data<T> getData(@NotNull T instance) {
        this.instance = instance;
        this.bytes.clear();
        this.writer.write(this.bytes, instance);
        return this;
    }

    @Override
    public void uninit() {
        this.instance = null;
    }

    @Override
    public DataAccess<T> copy() {
        return new ExternalBytesMarshallableDataAccess<T>(this.tClass(), StatefulCopyable.copyIfNeeded(this.reader), StatefulCopyable.copyIfNeeded(this.writer), this.bytes.realCapacity());
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) {
        super.readMarshallable(wireIn);
        this.reader = (SizedReader)wireIn.read(() -> "reader").typedMarshallable();
        this.writer = (BytesWriter)wireIn.read(() -> "writer").typedMarshallable();
        this.initTransients(32L);
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
        super.writeMarshallable(wireOut);
        wireOut.write(() -> "reader").typedMarshallable(this.reader);
        wireOut.write(() -> "writer").typedMarshallable(this.writer);
    }
}

