/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.query;

import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupSearch;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.impl.stage.query.HashQuery;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.entry.MapEntryStages;
import net.openhft.chronicle.map.impl.stage.query.Absent;
import net.openhft.chronicle.map.impl.stage.query.MapQuery;
import net.openhft.chronicle.set.DummyValueData;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public abstract class MapAbsent<K, V>
implements Absent<K, V> {
    @StageRef
    public KeySearch<K> ks;
    @StageRef
    MapQuery<K, V, ?> q;
    @StageRef
    MapEntryStages<K, V> e;
    @StageRef
    public HashLookupSearch hashLookupSearch;
    @StageRef
    public CheckOnEachPublicOperation checkOnEachPublicOperation;
    @StageRef
    public SegmentStages s;
    @StageRef
    VanillaChronicleMapHolder<K, V, ?> mh;

    void putEntry(Data<V> value) {
        assert (this.ks.searchStateAbsent());
        long entrySize = this.e.entrySize(this.ks.inputKey.size(), value.size());
        this.q.allocatedChunks.initEntryAndKey(entrySize);
        this.e.initValue(value);
        this.e.freeExtraAllocatedChunks();
        this.hashLookupSearch.putNewVolatile(this.e.pos);
    }

    @Override
    @NotNull
    public MapQuery<K, V, ?> context() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.q;
    }

    @Override
    @NotNull
    public Data<K> absentKey() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.ks.inputKey;
    }

    @Override
    public void doInsert(Data<V> value) {
        this.q.putPrefix();
        if (this.q.entryPresent()) {
            throw new IllegalStateException(this.mh.h().toIdentityString() + ": Entry is present in the map when doInsert() is called");
        }
        this.putEntry(value);
        this.s.incrementModCount();
        this.ks.setSearchState(KeySearch.SearchState.PRESENT);
        this.q.initPresenceOfEntry(HashQuery.EntryPresence.PRESENT);
    }

    @Override
    public void doInsert() {
        if (this.mh.set() == null) {
            throw new IllegalStateException(this.mh.h().toIdentityString() + ": Called SetAbsentEntry.doInsert() from Map context");
        }
        this.doInsert(DummyValueData.INSTANCE);
    }
}

