/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.bytes.WriteAccess;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.data.bytes.EntryKeyBytesData;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupPos;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public abstract class HashEntryStages<K>
implements HashEntry<K>,
ChecksumEntry {
    @StageRef
    public VanillaChronicleHashHolder<?> hh;
    @StageRef
    public SegmentStages s;
    @StageRef
    public CheckOnEachPublicOperation checkOnEachPublicOperation;
    @StageRef
    public HashLookupPos hlp;
    public long pos = -1L;
    @Stage(value="EntryOffset")
    public long keySizeOffset = -1L;
    public long keySize = -1L;
    public long keyOffset = -1L;
    @StageRef
    HashEntryChecksumStrategy hashEntryChecksumStrategy;
    public final ChecksumStrategy checksumStrategy;
    public boolean delayedUpdateChecksum;
    @StageRef
    public EntryKeyBytesData<K> entryKey;
    @Stage(value="EntrySizeInChunks")
    public int entrySizeInChunks;

    public HashEntryStages() {
        this.checksumStrategy = this.hh.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.delayedUpdateChecksum = false;
        this.entrySizeInChunks = 0;
    }

    public void initPos(long pos) {
        this.pos = pos;
    }

    public abstract void closePos();

    public abstract boolean entryOffsetInit();

    public void initEntryOffset(long keySizeOffset) {
        this.keySizeOffset = keySizeOffset;
    }

    public void initEntryOffset() {
        this.keySizeOffset = this.s.entrySpaceOffset + this.pos * this.hh.h().chunkSize;
    }

    public abstract void closeEntryOffset();

    public void initKeySize(long keySize) {
        this.keySize = keySize;
    }

    public abstract void closeKeySize();

    public void initKeyOffset(long keyOffset) {
        this.keyOffset = keyOffset;
    }

    public abstract void closeKeyOffset();

    public void readExistingEntry(long pos) {
        this.initPos(pos);
        Bytes segmentBytes = this.s.segmentBytesForRead();
        segmentBytes.readPosition(this.keySizeOffset);
        this.initKeySize(this.hh.h().keySizeMarshaller.readSize(segmentBytes));
        this.initKeyOffset(segmentBytes.readPosition());
    }

    public void readFoundEntry(long pos, long keySizeOffset, long keySize, long keyOffset) {
        this.initPos(pos);
        this.initEntryOffset(keySizeOffset);
        this.initKeySize(keySize);
        this.initKeyOffset(keyOffset);
    }

    public void closeEntry() {
        this.closePos();
        this.closeEntryOffset();
        this.closeKeySize();
        this.closeKeyOffset();
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        Bytes segmentBytes = this.s.segmentBytesForWrite();
        segmentBytes.writePosition(this.keySizeOffset);
        this.hh.h().keySizeMarshaller.writeSize(segmentBytes, this.keySize);
        this.initKeyOffset(segmentBytes.writePosition());
        key.writeTo((RandomDataOutput)this.s.segmentBS, this.keyOffset);
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset + (oldKeyAddr - oldKeySizeAddr));
        Access.copy((ReadAccess)Access.nativeAccess(), null, (long)oldKeySizeAddr, (WriteAccess)Access.checkedBytesStoreAccess(), (Object)this.s.segmentBS, (long)this.keySizeOffset, (long)bytesToCopy);
    }

    public long keyEnd() {
        return this.keyOffset + this.keySize;
    }

    public long entryEnd() {
        return this.keyEnd();
    }

    public void initDelayedUpdateChecksum(boolean delayedUpdateChecksum) {
        assert (this.entryOffsetInit() && this.keySizeOffset >= 0L);
        assert (this.s.locksInit() && this.s.localLockState != LocalLockState.UNLOCKED);
        assert (delayedUpdateChecksum);
        this.delayedUpdateChecksum = true;
    }

    abstract boolean delayedUpdateChecksumInit();

    public void closeDelayedUpdateChecksum() {
        if (this.hh.h().checksumEntries) {
            this.hashEntryChecksumStrategy.computeAndStoreChecksum();
        }
        this.delayedUpdateChecksum = false;
    }

    @Override
    public void updateChecksum() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        if (!this.hh.h().checksumEntries) {
            throw new UnsupportedOperationException(this.hh.h().toIdentityString() + ": Checksum is not stored in this Chronicle Hash");
        }
        this.s.innerUpdateLock.lock();
        this.initDelayedUpdateChecksum(true);
    }

    @Override
    public boolean checkSum() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        if (!this.hh.h().checksumEntries) {
            throw new UnsupportedOperationException(this.hh.h().toIdentityString() + ": Checksum is not stored in this Chronicle Hash");
        }
        this.s.innerUpdateLock.lock();
        return this.delayedUpdateChecksumInit() || this.checksumStrategy.innerCheckSum();
    }

    long entrySize() {
        return this.checksumStrategy.extraEntryBytes() + this.entryEnd() - this.keySizeOffset;
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.entryKey;
    }

    void initEntrySizeInChunks() {
        this.entrySizeInChunks = this.hh.h().inChunks(this.entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.s.free(this.pos, this.entrySizeInChunks);
        this.s.incrementModCount();
    }
}

