/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import java.util.Objects;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.entry.ReadLock;
import net.openhft.chronicle.hash.impl.stage.entry.UpdateLock;
import net.openhft.chronicle.hash.impl.stage.entry.WriteLock;
import net.openhft.chronicle.hash.impl.stage.hash.Chaining;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.impl.stage.hash.LogHolder;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.chronicle.hash.locks.InterProcessDeadLockException;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public abstract class SegmentStages
implements SegmentLock,
LocksInterface {
    @StageRef
    LogHolder log;
    @StageRef
    Chaining chaining;
    @StageRef
    public VanillaChronicleHashHolder<?> hh;
    @StageRef
    public CheckOnEachPublicOperation checkOnEachPublicOperation;
    public int segmentIndex = -1;
    @Stage(value="SegmentHeader")
    public long segmentHeaderAddress;
    @Stage(value="SegmentHeader")
    public SegmentHeader segmentHeader = null;
    @Stage(value="Locks")
    public LocksInterface rootContextLockedOnThisSegment = null;
    @Stage(value="Locks")
    public boolean nestedContextsLockedOnSameSegment;
    @Stage(value="Locks")
    public int latestSameThreadSegmentModCount;
    @Stage(value="Locks")
    public int contextModCount;
    @Stage(value="Locks")
    LocksInterface nextNode;
    @Stage(value="Locks")
    LocalLockState localLockState;
    @Stage(value="Locks")
    int totalReadLockCount;
    @Stage(value="Locks")
    int totalUpdateLockCount;
    @Stage(value="Locks")
    int totalWriteLockCount;
    @StageRef
    public ReadLock innerReadLock;
    @StageRef
    public UpdateLock innerUpdateLock;
    @StageRef
    public WriteLock innerWriteLock;
    @Stage(value="SegmentTier")
    public int tier = -1;
    @Stage(value="SegmentTier")
    public long tierIndex;
    @Stage(value="SegmentTier")
    public long tierBaseAddr;
    @Stage(value="Segment")
    public final PointerBytesStore segmentBS = new PointerBytesStore();
    @Stage(value="Segment")
    public final Bytes segmentBytes = new VanillaBytes((BytesStore)this.segmentBS);
    @Stage(value="Segment")
    public final ReusableBitSet freeList;
    @Stage(value="Segment")
    public long entrySpaceOffset;

    public SegmentStages() {
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.hh.h().actualChunksPerSegmentTier, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
        this.entrySpaceOffset = 0L;
    }

    public void initSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
    }

    public abstract boolean segmentIndexInit();

    private void initSegmentHeader() {
        this.segmentHeaderAddress = this.hh.h().segmentHeaderAddress(this.segmentIndex);
        this.segmentHeader = BigSegmentHeader.INSTANCE;
    }

    public long tierEntries() {
        if (this.tier == 0) {
            return this.segmentHeader.entries(this.segmentHeaderAddress);
        }
        return TierCountersArea.entries(this.tierCountersAreaAddr());
    }

    public void tierEntries(long tierEntries) {
        if (this.tier == 0) {
            this.segmentHeader.entries(this.segmentHeaderAddress, tierEntries);
        } else {
            TierCountersArea.entries(this.tierCountersAreaAddr(), tierEntries);
        }
    }

    public long lowestPossiblyFreeChunk() {
        if (this.tier == 0) {
            return this.segmentHeader.lowestPossiblyFreeChunk(this.segmentHeaderAddress);
        }
        return TierCountersArea.lowestPossiblyFreeChunkTiered(this.tierCountersAreaAddr());
    }

    public void lowestPossiblyFreeChunk(long lowestPossiblyFreeChunk) {
        if (this.tier == 0) {
            this.segmentHeader.lowestPossiblyFreeChunk(this.segmentHeaderAddress, lowestPossiblyFreeChunk);
        } else {
            TierCountersArea.lowestPossiblyFreeChunkTiered(this.tierCountersAreaAddr(), lowestPossiblyFreeChunk);
        }
    }

    public long tierDeleted() {
        if (this.tier == 0) {
            return this.segmentHeader.deleted(this.segmentHeaderAddress);
        }
        return TierCountersArea.deleted(this.tierCountersAreaAddr());
    }

    public void tierDeleted(long tierDeleted) {
        if (this.tier == 0) {
            this.segmentHeader.deleted(this.segmentHeaderAddress, tierDeleted);
        } else {
            TierCountersArea.deleted(this.tierCountersAreaAddr(), tierDeleted);
        }
    }

    public long nextTierIndex() {
        if (this.tier == 0) {
            return this.segmentHeader.nextTierIndex(this.segmentHeaderAddress);
        }
        return TierCountersArea.nextTierIndex(this.tierCountersAreaAddr());
    }

    public void nextTierIndex(long nextTierIndex) {
        if (this.tier == 0) {
            this.segmentHeader.nextTierIndex(this.segmentHeaderAddress, nextTierIndex);
        } else {
            TierCountersArea.nextTierIndex(this.tierCountersAreaAddr(), nextTierIndex);
        }
    }

    public long size() {
        this.goToFirstTier();
        long size = this.tierEntries() - this.tierDeleted();
        while (this.hasNextTier()) {
            this.nextTier();
            size += this.tierEntries() - this.tierDeleted();
        }
        return size;
    }

    @Override
    @Stage(value="Locks")
    public void setNestedContextsLockedOnSameSegment(boolean nestedContextsLockedOnSameSegment) {
        this.nestedContextsLockedOnSameSegment = nestedContextsLockedOnSameSegment;
    }

    @Override
    @Stage(value="Locks")
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Stage(value="Locks")
    public void incrementModCount() {
        this.contextModCount = this.rootContextLockedOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    @Override
    @Stage(value="Locks")
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    @Stage(value="Locks")
    public boolean readZero() {
        return this.rootContextLockedOnThisSegment.totalReadLockCount() == 0;
    }

    @Override
    @Stage(value="Locks")
    public int changeAndGetTotalReadLockCount(int change) {
        assert (this.totalReadLockCount + change >= 0) : "read underflow";
        return this.totalReadLockCount += change;
    }

    @Stage(value="Locks")
    public boolean updateZero() {
        return this.rootContextLockedOnThisSegment.totalUpdateLockCount() == 0;
    }

    @Override
    @Stage(value="Locks")
    public int changeAndGetTotalUpdateLockCount(int change) {
        assert (this.totalUpdateLockCount + change >= 0) : "update underflow";
        return this.totalUpdateLockCount += change;
    }

    @Stage(value="Locks")
    public boolean writeZero() {
        return this.rootContextLockedOnThisSegment.totalWriteLockCount() == 0;
    }

    @Override
    @Stage(value="Locks")
    public int changeAndGetTotalWriteLockCount(int change) {
        assert (this.totalWriteLockCount + change >= 0) : "write underflow";
        return this.totalWriteLockCount += change;
    }

    @Stage(value="Locks")
    public int decrementRead() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    @Stage(value="Locks")
    public int decrementUpdate() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    @Stage(value="Locks")
    public int decrementWrite() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    @Stage(value="Locks")
    public void incrementRead() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    @Stage(value="Locks")
    public void incrementUpdate() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    @Stage(value="Locks")
    public void incrementWrite() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    @Override
    public abstract boolean locksInit();

    void initLocks() {
        int i;
        assert (this.chaining.used);
        if (this.segmentHeader == null) {
            throw new AssertionError();
        }
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.chaining.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        int size = this.chaining.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        this.rootContextLockedOnThisSegment = this;
        this.nestedContextsLockedOnSameSegment = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
    }

    @Stage(value="Locks")
    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = (LocksInterface)this.chaining.contextAtIndexInChain(index);
        if (c.segmentHeaderInit() && c.segmentHeaderAddress() == this.segmentHeaderAddress && c.locksInit()) {
            LocksInterface root;
            this.rootContextLockedOnThisSegment = root = c.rootContextLockedOnThisSegment();
            root.setNestedContextsLockedOnSameSegment(true);
            this.nestedContextsLockedOnSameSegment = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            this.linkToSegmentContextsChain();
            return true;
        }
        return false;
    }

    void closeLocks() {
        if (this.rootContextLockedOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.deregisterIterationContextLockedInThisThread();
        this.localLockState = null;
        this.rootContextLockedOnThisSegment = null;
    }

    @Stage(value="Locks")
    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        this.readUnlockAndDecrementCount();
    }

    @Stage(value="Locks")
    public void readUnlockAndDecrementCount() {
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                if (this.decrementRead() == 0 && this.updateZero() && this.writeZero()) {
                    this.segmentHeader.readUnlock(this.segmentHeaderAddress);
                }
                return;
            }
            case UPDATE_LOCKED: {
                if (this.decrementUpdate() == 0 && this.writeZero()) {
                    if (this.readZero()) {
                        this.segmentHeader.updateUnlock(this.segmentHeaderAddress);
                    } else {
                        this.segmentHeader.downgradeUpdateToReadLock(this.segmentHeaderAddress);
                    }
                }
                return;
            }
            case WRITE_LOCKED: {
                if (this.decrementWrite() != 0) break;
                if (!this.updateZero()) {
                    this.segmentHeader.downgradeWriteToUpdateLock(this.segmentHeaderAddress);
                    break;
                }
                if (!this.readZero()) {
                    this.segmentHeader.downgradeWriteToReadLock(this.segmentHeaderAddress);
                    break;
                }
                this.segmentHeader.writeUnlock(this.segmentHeaderAddress);
            }
        }
    }

    @Stage(value="Locks")
    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = this.rootContextLockedOnThisSegment;
        while (true) {
            this.checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if (innermostContextOnThisSegment.nextNode() == null) break;
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        Data key;
        if (innermostContextOnThisSegment.getClass() == this.getClass() && Objects.equals(key = ((KeySearch)((Object)innermostContextOnThisSegment)).inputKey, ((KeySearch)((Object)this)).inputKey)) {
            throw new IllegalStateException(this.hh.h().toIdentityString() + ": Nested same-thread contexts cannot access the same key " + key);
        }
    }

    @Stage(value="Locks")
    private void unlinkFromSegmentContextsChain() {
        LocksInterface nextNode;
        LocksInterface prevContext = this.rootContextLockedOnThisSegment;
        while ((nextNode = prevContext.nextNode()) != this && nextNode != null) {
            prevContext = nextNode;
        }
        this.verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    @Stage(value="Locks")
    private void verifyInnermostContext() {
        if (this.nextNode != null) {
            throw new IllegalStateException(this.hh.h().toIdentityString() + ": Attempt to close contexts not structurally");
        }
    }

    @Stage(value="Locks")
    private void closeRootLocks() {
        this.verifyInnermostContext();
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader.readUnlock(this.segmentHeaderAddress);
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader.updateUnlock(this.segmentHeaderAddress);
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader.writeUnlock(this.segmentHeaderAddress);
            }
        }
    }

    @Stage(value="Locks")
    public void setLocalLockState(LocalLockState newState) {
        boolean goingToLock;
        boolean isLocked = this.localLockState != LocalLockState.UNLOCKED && this.localLockState != null;
        boolean bl = goingToLock = newState != LocalLockState.UNLOCKED && newState != null;
        if (isLocked) {
            if (!goingToLock) {
                this.deregisterIterationContextLockedInThisThread();
            }
        } else if (goingToLock) {
            this.registerIterationContextLockedInThisThread();
        }
        this.localLockState = newState;
    }

    public void checkIterationContextNotLockedInThisThread() {
        if (this.chaining.rootContextInThisThread.iterationContextLockedInThisThread) {
            throw new IllegalStateException(this.hh.h().toIdentityString() + ": Update or Write " + "locking is forbidden in the context of locked iteration context");
        }
    }

    private void registerIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.chaining.rootContextInThisThread.iterationContextLockedInThisThread = true;
        }
    }

    private void deregisterIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.chaining.rootContextInThisThread.iterationContextLockedInThisThread = false;
        }
    }

    @Stage(value="Locks")
    public RuntimeException debugContextsAndLocks(InterProcessDeadLockException e) {
        String message = this.hh.h().toIdentityString() + ":\n";
        message = message + "Contexts locked on this segment:\n";
        for (LocksInterface cxt = this.rootContextLockedOnThisSegment; cxt != null; cxt = cxt.nextNode()) {
            message = message + cxt.debugLocksState() + "\n";
        }
        message = message + "Current thread contexts:\n";
        int size = this.chaining.contextChain.size();
        for (int i = 0; i < size; ++i) {
            LocksInterface cxt = (LocksInterface)this.chaining.contextAtIndexInChain(i);
            message = message + cxt.debugLocksState() + "\n";
        }
        throw new InterProcessDeadLockException(message, e);
    }

    @Override
    public String debugLocksState() {
        String s = this + ": ";
        if (!this.chaining.usedInit()) {
            s = s + "unused";
            return s;
        }
        s = s + "used, ";
        if (!this.segmentIndexInit()) {
            s = s + "segment uninitialized";
            return s;
        }
        s = s + "segment " + this.segmentIndex() + ", ";
        if (!this.locksInit()) {
            s = s + "locks uninitialized";
            return s;
        }
        s = s + "local state: " + (Object)((Object)this.localLockState) + ", ";
        s = s + "read lock count: " + this.rootContextLockedOnThisSegment.totalReadLockCount() + ", ";
        s = s + "update lock count: " + this.rootContextLockedOnThisSegment.totalUpdateLockCount() + ", ";
        s = s + "write lock count: " + this.rootContextLockedOnThisSegment.totalWriteLockCount();
        return s;
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    public abstract boolean segmentTierInit();

    public void initSegmentTier() {
        this.tierIndex = this.segmentIndex + 1;
        this.tierBaseAddr = this.hh.h().segmentBaseAddr(this.segmentIndex);
        this.tier = 0;
    }

    public void initSegmentTier(int tier, long tierIndex) {
        this.tier = tier;
        this.tierIndex = tierIndex;
        assert (tierIndex > 0L);
        this.tierBaseAddr = this.hh.h().tierIndexToBaseAddr(tierIndex);
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
    }

    public long tierCountersAreaAddr() {
        return this.tierBaseAddr + this.hh.h().tierHashLookupOuterSize;
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(this.tierCountersAreaAddr());
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(this.tierCountersAreaAddr(), prevTierIndex);
    }

    public void nextTier() {
        VanillaChronicleHash<?, ?, ?, ?> h = this.hh.h();
        long nextTierIndex = this.nextTierIndex();
        if (nextTierIndex == 0L) {
            LogHolder.LOG.debug("Allocate tier for segment # {}, tier {}", (Object)this.segmentIndex, (Object)(this.tier + 1));
            nextTierIndex = h.allocateTier();
            this.nextTierIndex(nextTierIndex);
            long prevTierIndex = this.tierIndex;
            this.initSegmentTier(this.tier + 1, nextTierIndex);
            TierCountersArea.segmentIndex(this.tierCountersAreaAddr(), this.segmentIndex);
            TierCountersArea.tier(this.tierCountersAreaAddr(), this.tier);
            this.nextTierIndex(0L);
            this.prevTierIndex(prevTierIndex);
        } else {
            this.initSegmentTier(this.tier + 1, nextTierIndex);
        }
    }

    public boolean hasNextTier() {
        return this.nextTierIndex() != 0L;
    }

    public void prevTier() {
        if (this.tier == 0) {
            throw new IllegalStateException(this.hh.h().toIdentityString() + ": first tier doesn't have previous");
        }
        this.initSegmentTier(this.tier - 1, this.prevTierIndex());
    }

    public void goToLastTier() {
        while (this.hasNextTier()) {
            this.nextTier();
        }
    }

    public void goToFirstTier() {
        while (this.tier != 0) {
            this.prevTier();
        }
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        VanillaChronicleHash<?, ?, ?, ?> h = this.hh.h();
        long segmentBaseAddr = this.tierBaseAddr;
        this.segmentBS.set(segmentBaseAddr, h.tierSize);
        this.segmentBytes.clear();
        long freeListOffset = h.tierHashLookupOuterSize + 64L;
        this.freeList.setOffset(segmentBaseAddr + freeListOffset);
        this.entrySpaceOffset = freeListOffset + h.tierFreeListOuterSize + (long)h.tierEntrySpaceInnerOffset;
    }

    @Stage(value="Segment")
    public Bytes segmentBytesForRead() {
        this.segmentBytes.readLimit(this.segmentBytes.capacity());
        return this.segmentBytes;
    }

    @Stage(value="Segment")
    public Bytes segmentBytesForWrite() {
        this.segmentBytes.readPosition(0L);
        return this.segmentBytes;
    }

    void closeSegment() {
        this.entrySpaceOffset = 0L;
    }

    @Stage(value="Segment")
    public long allocReturnCode(int chunks) {
        VanillaChronicleHash<?, ?, ?, ?> h = this.hh.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException(this.hh.h().toIdentityString() + ": Entry is too large: requires " + chunks + " chunks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long lowestPossiblyFreeChunk = this.lowestPossiblyFreeChunk();
        if (lowestPossiblyFreeChunk + (long)chunks > h.actualChunksPerSegmentTier) {
            return -1L;
        }
        if (this.tierEntries() >= h.maxEntriesPerHashLookup) {
            return -1L;
        }
        assert (lowestPossiblyFreeChunk < h.actualChunksPerSegmentTier);
        long ret = this.freeList.setNextNContinuousClearBits(lowestPossiblyFreeChunk, chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegmentTier) {
            if (ret + (long)chunks > h.actualChunksPerSegmentTier) {
                assert (ret != -1L);
                this.freeList.clearRange(ret, ret + (long)chunks);
            }
            return -1L;
        }
        this.tierEntries(this.tierEntries() + 1L);
        if (chunks == 1 || this.freeList.isSet(lowestPossiblyFreeChunk)) {
            this.lowestPossiblyFreeChunk(ret + (long)chunks);
        }
        return ret;
    }

    @Stage(value="Segment")
    public boolean realloc(long fromPos, int oldChunks, int newChunks) {
        if (fromPos + (long)newChunks < this.hh.h().actualChunksPerSegmentTier && this.freeList.isRangeClear(fromPos + (long)oldChunks, fromPos + (long)newChunks)) {
            this.freeList.setRange(fromPos + (long)oldChunks, fromPos + (long)newChunks);
            return true;
        }
        return false;
    }

    @Stage(value="Segment")
    public void free(long fromPos, int chunks) {
        this.tierEntries(this.tierEntries() - 1L);
        this.freeList.clearRange(fromPos, fromPos + (long)chunks);
        if (fromPos < this.lowestPossiblyFreeChunk()) {
            this.lowestPossiblyFreeChunk(fromPos);
        }
    }

    @Stage(value="Segment")
    public void freeExtra(long pos, int oldChunks, int newChunks) {
        long from = pos + (long)newChunks;
        this.freeList.clearRange(from, pos + (long)oldChunks);
        if (from < this.lowestPossiblyFreeChunk()) {
            this.lowestPossiblyFreeChunk(from);
        }
    }

    public void verifyTierCountersAreaData() {
        block2: {
            long currentTierIndex;
            this.goToFirstTier();
            do {
                int tierSegmentIndex;
                if ((tierSegmentIndex = TierCountersArea.segmentIndex(this.tierCountersAreaAddr())) != this.segmentIndex) {
                    throw new AssertionError((Object)("segmentIndex: " + this.segmentIndex + ", tier: " + this.tier + ", tierIndex: " + this.tierIndex + ", tierBaseAddr: " + this.tierBaseAddr + " reports it belongs to segmentIndex " + tierSegmentIndex));
                }
                if (!this.hasNextTier()) break block2;
                currentTierIndex = this.tierIndex;
                this.nextTier();
            } while (this.prevTierIndex() == currentTierIndex);
            throw new AssertionError((Object)("segmentIndex: " + this.segmentIndex + ", tier: " + this.tier + ", tierIndex: " + this.tierIndex + ", tierBaseAddr: " + this.tierBaseAddr + " reports the previous tierIndex is " + this.prevTierIndex() + " while actually it is " + currentTierIndex));
        }
    }
}

