/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.ret;

import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.JavaLangBytesReusableBytesStore;
import net.openhft.chronicle.map.ReturnValue;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.lang.io.Bytes;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public class BytesReturnValue<V>
implements ReturnValue<V>,
AutoCloseable {
    @StageRef
    VanillaChronicleMapHolder<?, ?, ?, V, ?, ?, ?> mh;
    private final JavaLangBytesReusableBytesStore outputStore = new JavaLangBytesReusableBytesStore();
    @Stage(value="Output")
    TcpReplicator.TcpSocketChannelEntryWriter output = null;
    @Stage(value="Output")
    long startOutputPos;

    public void initOutput(TcpReplicator.TcpSocketChannelEntryWriter output) {
        this.output = output;
        this.startOutputPos = output.in().position();
    }

    @Override
    public void returnValue(@NotNull Data<V> value) {
        long valueSize = value.size();
        long totalSize = 1L + (long)this.mh.m().valueSizeMarshaller.sizeEncodingSize(valueSize) + valueSize;
        this.output.ensureBufferSize(totalSize);
        Bytes out = this.output.in();
        out.writeBoolean(false);
        this.mh.m().valueSizeMarshaller.writeSize(out, valueSize);
        long outPosition = out.position();
        out.skip(valueSize);
        this.outputStore.setBytes(out);
        value.writeTo((RandomDataOutput)this.outputStore, outPosition);
    }

    @Override
    public void close() {
        if (this.output.in().position() == this.startOutputPos) {
            this.output.ensureBufferSize(1L);
            this.output.in().writeBoolean(true);
        }
    }
}

