/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashBuilderPrivateAPI;
import net.openhft.chronicle.hash.ChronicleHashInstanceBuilder;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.hash.impl.util.math.PoissonDistribution;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.ReplicationHub;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.hash.serialization.internal.SerializationBuilder;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChannelProvider;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilderPrivateAPI;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.DefaultSpi;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.MapEntryOperations;
import net.openhft.chronicle.map.MapInstanceBuilder;
import net.openhft.chronicle.map.MapMethods;
import net.openhft.chronicle.map.MicrosecondPrecisionSystemTimeProvider;
import net.openhft.chronicle.map.OldDeletedEntriesCleanup;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.Replicators;
import net.openhft.chronicle.map.UdpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.replication.MapRemoteOperations;
import net.openhft.lang.Maths;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.model.DataValueGenerator;
import net.openhft.lang.thread.NamedThreadFactory;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChronicleMapBuilder<K, V>
implements ChronicleHashBuilder<K, ChronicleMap<K, V>, ChronicleMapBuilder<K, V>> {
    static final byte UDP_REPLICATION_MODIFICATION_ITERATOR_ID = 127;
    private static final int DEFAULT_KEY_OR_VALUE_SIZE = 120;
    private static final long DEFAULT_ENTRIES = 0x100000L;
    private static final int MAX_SEGMENTS = 0x40000000;
    private static final Logger LOG = LoggerFactory.getLogger((String)ChronicleMapBuilder.class.getName());
    private static final StringBuilder EMPTY_STRING_BUILDER = new StringBuilder();
    private static final double UNDEFINED_DOUBLE_CONFIG = Double.NaN;
    private static final int XML_SERIALIZATION = 1;
    private static final int BINARY_SERIALIZATION = 2;
    static final long RUNTIME_PAGE_SIZE = NativeBytes.UNSAFE.pageSize();
    private ChronicleMapBuilderPrivateAPI<K> privateAPI = new ChronicleMapBuilderPrivateAPI(this);
    SerializationBuilder<K> keyBuilder;
    SerializationBuilder<V> valueBuilder;
    private int minSegments = -1;
    private int actualSegments = -1;
    private long entriesPerSegment = -1L;
    private long actualChunksPerSegment = -1L;
    private double averageKeySize = Double.NaN;
    private K averageKey;
    private K sampleKey;
    private double averageValueSize = Double.NaN;
    private V averageValue;
    private V sampleValue;
    private int actualChunkSize = 0;
    private int worstAlignment = -1;
    private int maxChunksPerEntry = -1;
    private Alignment alignment = null;
    private long entries = -1L;
    private long lockTimeOut = 20000L;
    private TimeUnit lockTimeOutUnit = TimeUnit.MILLISECONDS;
    private double maxBloatFactor = 1.0;
    private boolean allowSegmentTiering = true;
    private double nonTieredSegmentsPercentile = 0.99999;
    private boolean aligned64BitMemoryOperationsAtomic = OS.is64Bit();
    private ChecksumEntries checksumEntries = ChecksumEntries.IF_PERSISTED;
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    private TimeProvider timeProvider = MicrosecondPrecisionSystemTimeProvider.instance();
    long cleanupTimeout = 1L;
    TimeUnit cleanupTimeoutUnit = TimeUnit.MINUTES;
    private boolean cleanupRemovedEntries = true;
    private BytesMarshallerFactory bytesMarshallerFactory;
    private ObjectSerializer objectSerializer;
    private V defaultValue = null;
    private ConstantValueProvider<V> constantValueProvider = null;
    DefaultValueProvider<K, V> defaultValueProvider = DefaultSpi.defaultValueProvider();
    private SingleChronicleHashReplication singleHashReplication = null;
    MapMethods<K, V, ?> methods = DefaultSpi.mapMethods();
    MapEntryOperations<K, V, ?> entryOperations = DefaultSpi.mapEntryOperations();
    MapRemoteOperations<K, V, ?> remoteOperations = DefaultSpi.mapRemoteOperations();
    private boolean replicated;
    private boolean persisted;

    private static boolean isDefined(double config) {
        return !Double.isNaN(config);
    }

    ChronicleMapBuilder(Class<K> keyClass, Class<V> valueClass) {
        this.keyBuilder = new SerializationBuilder<K>(keyClass, SerializationBuilder.Role.KEY);
        this.valueBuilder = new SerializationBuilder<V>(valueClass, SerializationBuilder.Role.VALUE);
        if (CharSequence.class == valueClass) {
            this.defaultValue = "";
        }
        if (StringBuilder.class == valueClass) {
            this.defaultValue = EMPTY_STRING_BUILDER;
        }
    }

    public static <K, V> ChronicleMapBuilder<K, V> of(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        return new ChronicleMapBuilder<K, V>(keyClass, valueClass);
    }

    private static void checkSegments(long segments) {
        if (segments <= 0L) {
            throw new IllegalArgumentException("segments should be positive, " + segments + " given");
        }
        if (segments > 0x40000000L) {
            throw new IllegalArgumentException("Max segments is 1073741824, " + segments + " given");
        }
    }

    private static long divideUpper(long dividend, long divisor) {
        return (dividend - 1L) / divisor + 1L;
    }

    private static String pretty(int value) {
        return value > 0 ? value + "" : "not configured";
    }

    private static String pretty(Object obj) {
        return obj != null ? obj + "" : "not configured";
    }

    @Override
    public ChronicleMapBuilder<K, V> clone() {
        try {
            ChronicleMapBuilder result = (ChronicleMapBuilder)super.clone();
            result.keyBuilder = this.keyBuilder.clone();
            result.valueBuilder = this.valueBuilder.clone();
            result.privateAPI = new ChronicleMapBuilderPrivateAPI(result);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ChronicleHashBuilderPrivateAPI<K> privateAPI() {
        return this.privateAPI;
    }

    @Override
    public ChronicleMapBuilder<K, V> averageKeySize(double averageKeySize) {
        ChronicleMapBuilder.checkSizeIsNotStaticallyKnown(this.keyBuilder);
        ChronicleMapBuilder.checkAverageSize(averageKeySize, "key");
        this.averageKeySize = averageKeySize;
        this.averageKey = null;
        this.sampleKey = null;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> averageKey(K averageKey) {
        ChronicleMapBuilder.checkSizeIsNotStaticallyKnown(this.keyBuilder);
        this.averageKey = averageKey;
        this.sampleKey = null;
        this.averageKeySize = Double.NaN;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> constantKeySizeBySample(K sampleKey) {
        this.sampleKey = sampleKey;
        this.averageKey = null;
        this.averageKeySize = Double.NaN;
        return this;
    }

    private double averageKeySize() {
        if (!ChronicleMapBuilder.isDefined(this.averageKeySize)) {
            throw new AssertionError();
        }
        return this.averageKeySize;
    }

    public ChronicleMapBuilder<K, V> averageValueSize(double averageValueSize) {
        ChronicleMapBuilder.checkSizeIsNotStaticallyKnown(this.valueBuilder);
        ChronicleMapBuilder.checkAverageSize(averageValueSize, "value");
        this.averageValueSize = averageValueSize;
        this.averageValue = null;
        this.sampleValue = null;
        return this;
    }

    public ChronicleMapBuilder<K, V> averageValue(V averageValue) {
        java.util.Objects.requireNonNull(averageValue);
        ChronicleMapBuilder.checkSizeIsNotStaticallyKnown(this.valueBuilder);
        this.averageValue = averageValue;
        this.sampleValue = null;
        this.averageValueSize = Double.NaN;
        return this;
    }

    private static void checkAverageSize(double averageSize, String role) {
        if (averageSize <= 0.0 || Double.isNaN(averageSize) || Double.isInfinite(averageSize)) {
            throw new IllegalArgumentException("Average " + role + " size must be a positive, " + "finite number");
        }
    }

    private static void checkSizeIsNotStaticallyKnown(SerializationBuilder builder) {
        if (builder.sizeIsStaticallyKnown) {
            throw new IllegalStateException("Size of type " + builder.eClass + " is statically known and shouldn't be specified manually");
        }
    }

    public ChronicleMapBuilder<K, V> constantValueSizeBySample(V sampleValue) {
        this.sampleValue = sampleValue;
        this.averageValue = null;
        this.averageValueSize = Double.NaN;
        return this;
    }

    double averageValueSize() {
        if (!ChronicleMapBuilder.isDefined(this.averageValueSize)) {
            throw new AssertionError();
        }
        return this.averageValueSize;
    }

    private <E> double averageKeyOrValueSize(double configuredSize, SerializationBuilder<E> builder, E average) {
        if (ChronicleMapBuilder.isDefined(configuredSize)) {
            return configuredSize;
        }
        if (builder.constantSizeMarshaller()) {
            return builder.pseudoReadConstantSize();
        }
        if (average != null) {
            builder.maxSize(120L);
            return builder.serializationSize(average);
        }
        return Double.NaN;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualChunkSize(int actualChunkSize) {
        if (this.constantlySizedEntries()) {
            throw new IllegalStateException("Sizes of key type: " + this.keyBuilder.eClass + " and " + "value type: " + this.valueBuilder.eClass + " are both constant, " + "so chunk size shouldn't be specified manually");
        }
        if (actualChunkSize <= 0) {
            throw new IllegalArgumentException("Chunk size must be positive");
        }
        this.actualChunkSize = actualChunkSize;
        return this;
    }

    SerializationBuilder<K> keyBuilder() {
        return this.keyBuilder;
    }

    private EntrySizeInfo entrySizeInfo() {
        int worstAlignment;
        double size = 0.0;
        double keySize = this.averageKeySize();
        size += ChronicleMapBuilder.averageSizeEncodingSize(this.keyBuilder, keySize);
        size += keySize;
        if (this.replicated) {
            size += 10.0;
        }
        if (this.checksumEntries()) {
            size += 4.0;
        }
        double valueSize = this.averageValueSize();
        size += ChronicleMapBuilder.averageSizeEncodingSize(this.valueBuilder, valueSize);
        Alignment alignment = this.valueAlignment();
        if (this.worstAlignmentComputationRequiresValueSize(alignment)) {
            long constantSizeBeforeAlignment = Math.round(size);
            if (this.constantlySizedValues()) {
                long totalDataSize = constantSizeBeforeAlignment + this.constantValueSize();
                worstAlignment = (int)(alignment.alignAddr(totalDataSize) - totalDataSize);
            } else if (this.actualChunkSize > 0) {
                worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, this.actualChunkSize);
            } else {
                int chunkSize = 8;
                worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, chunkSize);
                if (!(size + (double)worstAlignment + valueSize >= (double)(ChronicleMapBuilder.maxDefaultChunksPerAverageEntry(this.replicated) * chunkSize))) {
                    chunkSize = 4;
                    worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, chunkSize);
                }
            }
        } else {
            worstAlignment = this.worstAlignmentWithoutValueSize(alignment);
        }
        size += (double)worstAlignment;
        return new EntrySizeInfo(size += valueSize, worstAlignment);
    }

    private boolean worstAlignmentComputationRequiresValueSize(Alignment alignment) {
        return alignment != Alignment.NO_ALIGNMENT && this.constantlySizedKeys() && this.valueBuilder.constantSizeEncodingSizeMarshaller();
    }

    private int worstAlignmentWithoutValueSize(Alignment alignment) {
        return alignment.alignment() - 1;
    }

    int segmentEntrySpaceInnerOffset() {
        if (!this.constantlySizedEntries()) {
            return 0;
        }
        return (int)(this.constantValueSize() % (long)this.valueAlignment().alignment());
    }

    private long constantValueSize() {
        return this.valueBuilder.pseudoReadConstantSize();
    }

    boolean constantlySizedKeys() {
        return this.keyBuilder.constantSizeMarshaller() || this.sampleKey != null;
    }

    private static double averageSizeEncodingSize(SerializationBuilder builder, double averageSize) {
        int upperEncodingSize;
        SizeMarshaller sizeMarshaller = builder.sizeMarshaller();
        if (averageSize == (double)Math.round(averageSize)) {
            return sizeMarshaller.sizeEncodingSize(Math.round(averageSize));
        }
        long lower = (long)averageSize;
        long upper = lower + 1L;
        int lowerEncodingSize = sizeMarshaller.sizeEncodingSize(lower);
        if (lowerEncodingSize == (upperEncodingSize = sizeMarshaller.sizeEncodingSize(upper))) {
            return lowerEncodingSize;
        }
        return (double)lower * ((double)upper - averageSize) + (double)upper * (averageSize - (double)lower);
    }

    private int worstAlignmentAssumingChunkSize(long constantSizeBeforeAlignment, int chunkSize) {
        Alignment valueAlignment = this.valueAlignment();
        long firstAlignment = valueAlignment.alignAddr(constantSizeBeforeAlignment) - constantSizeBeforeAlignment;
        int alignment = valueAlignment.alignment();
        int gcdOfAlignmentAndChunkSize = ChronicleMapBuilder.greatestCommonDivisor(alignment, chunkSize);
        if (gcdOfAlignmentAndChunkSize == alignment) {
            return (int)firstAlignment;
        }
        long worstAlignment = firstAlignment;
        while (worstAlignment + (long)gcdOfAlignmentAndChunkSize < (long)alignment) {
            worstAlignment += (long)gcdOfAlignmentAndChunkSize;
        }
        return (int)worstAlignment;
    }

    int worstAlignment() {
        if (this.worstAlignment >= 0) {
            return this.worstAlignment;
        }
        Alignment alignment = this.valueAlignment();
        if (!this.worstAlignmentComputationRequiresValueSize(alignment)) {
            this.worstAlignment = this.worstAlignmentWithoutValueSize(alignment);
            return this.worstAlignment;
        }
        this.worstAlignment = this.entrySizeInfo().worstAlignment;
        return this.worstAlignment;
    }

    void worstAlignment(int worstAlignment) {
        assert (worstAlignment >= 0);
        this.worstAlignment = worstAlignment;
    }

    static int greatestCommonDivisor(int a, int b) {
        if (b == 0) {
            return a;
        }
        return ChronicleMapBuilder.greatestCommonDivisor(b, a % b);
    }

    long chunkSize() {
        if (this.actualChunkSize > 0) {
            return this.actualChunkSize;
        }
        double averageEntrySize = this.entrySizeInfo().averageEntrySize;
        if (this.constantlySizedEntries()) {
            return Math.round(averageEntrySize);
        }
        int maxChunkSize = 0x40000000;
        for (long chunkSize = 4L; chunkSize <= (long)maxChunkSize; chunkSize *= 2L) {
            if (!((double)((long)ChronicleMapBuilder.maxDefaultChunksPerAverageEntry(this.replicated) * chunkSize) > averageEntrySize)) continue;
            return chunkSize;
        }
        return maxChunkSize;
    }

    boolean constantlySizedEntries() {
        return this.constantlySizedKeys() && this.constantlySizedValues();
    }

    double averageChunksPerEntry() {
        if (this.constantlySizedEntries()) {
            return 1.0;
        }
        long chunkSize = this.chunkSize();
        return (this.entrySizeInfo().averageEntrySize + (double)chunkSize - 1.0) / (double)chunkSize;
    }

    private static int maxDefaultChunksPerAverageEntry(boolean replicated) {
        return replicated ? 4 : 8;
    }

    @Override
    public ChronicleMapBuilder<K, V> maxChunksPerEntry(int maxChunksPerEntry) {
        if (maxChunksPerEntry < 1) {
            throw new IllegalArgumentException("maxChunksPerEntry should be >= 1, " + maxChunksPerEntry + " given");
        }
        this.maxChunksPerEntry = maxChunksPerEntry;
        return this;
    }

    int maxChunksPerEntry() {
        if (this.constantlySizedEntries()) {
            return 1;
        }
        long actualChunksPerSegment = this.actualChunksPerSegment();
        int result = (int)Math.min(actualChunksPerSegment, Integer.MAX_VALUE);
        if (this.maxChunksPerEntry > 0) {
            result = Math.min(this.maxChunksPerEntry, result);
        }
        return result;
    }

    boolean constantlySizedValues() {
        return this.valueBuilder.constantSizeMarshaller() || this.sampleValue != null;
    }

    public ChronicleMapBuilder<K, V> entryAndValueAlignment(Alignment alignment) {
        this.alignment = alignment;
        this.checkAlignmentOnlyIfValuesPossiblyReferenceOffHeap();
        return this;
    }

    private void checkAlignmentOnlyIfValuesPossiblyReferenceOffHeap() {
        if (!(this.valueBuilder.possibleOffHeapReferences() || this.alignment != Alignment.OF_4_BYTES && this.alignment != Alignment.OF_8_BYTES)) {
            throw new IllegalStateException("Entry and value alignment should be configured only if values might point to off-heap memory");
        }
    }

    Alignment valueAlignment() {
        if (this.alignment != null) {
            return this.alignment;
        }
        Class firstPrimitiveFieldType = DataValueGenerator.firstPrimitiveFieldType(this.valueBuilder.eClass);
        if (firstPrimitiveFieldType == Long.TYPE || firstPrimitiveFieldType == Double.TYPE) {
            return Alignment.OF_8_BYTES;
        }
        if (firstPrimitiveFieldType == Integer.TYPE || firstPrimitiveFieldType == Float.TYPE) {
            return Alignment.OF_4_BYTES;
        }
        return Alignment.NO_ALIGNMENT;
    }

    @Override
    public ChronicleMapBuilder<K, V> entries(long entries) {
        if (entries <= 0L) {
            throw new IllegalArgumentException("Entries should be positive, " + entries + " given");
        }
        this.entries = entries;
        return this;
    }

    long entries() {
        if (this.entries < 0L) {
            return 0x100000L;
        }
        return this.entries;
    }

    @Override
    public ChronicleMapBuilder<K, V> entriesPerSegment(long entriesPerSegment) {
        if (entriesPerSegment <= 0L) {
            throw new IllegalArgumentException("Entries per segment should be positive, " + entriesPerSegment + " given");
        }
        this.entriesPerSegment = entriesPerSegment;
        return this;
    }

    long entriesPerSegment() {
        double averageChunksPerEntry;
        boolean actualChunksDefined;
        long entriesPerSegment;
        if (this.entriesPerSegment > 0L) {
            entriesPerSegment = this.entriesPerSegment;
        } else {
            int actualSegments = this.actualSegments();
            double averageEntriesPerSegment = (double)this.entries() * 1.0 / (double)actualSegments;
            entriesPerSegment = PoissonDistribution.inverseCumulativeProbability(averageEntriesPerSegment, this.nonTieredSegmentsPercentile);
        }
        boolean bl = actualChunksDefined = this.actualChunksPerSegment > 0L;
        if (!actualChunksDefined && (double)entriesPerSegment * (averageChunksPerEntry = this.averageChunksPerEntry()) > 1.073741824E9) {
            throw new IllegalStateException("Max chunks per segment is 1073741824 configured entries() and actualSegments() so that there should be " + entriesPerSegment + " entries per segment, while average chunks per entry is " + averageChunksPerEntry);
        }
        if (entriesPerSegment > 0x20000000L) {
            throw new IllegalStateException("shouldn't be more than 536870912 entries per segment");
        }
        return entriesPerSegment;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualChunksPerSegment(long actualChunksPerSegment) {
        if (actualChunksPerSegment <= 0L) {
            throw new IllegalArgumentException("Actual chunks per segment should be positive, " + actualChunksPerSegment + " given");
        }
        this.actualChunksPerSegment = actualChunksPerSegment;
        return this;
    }

    private void checkActualChunksPerSegmentIsConfiguredOnlyIfOtherLowLevelConfigsAreManual() {
        if (this.actualChunksPerSegment > 0L && (this.entriesPerSegment <= 0L || this.actualChunkSize <= 0 && !this.constantlySizedEntries() || this.actualSegments <= 0)) {
            throw new IllegalStateException("Actual chunks per segment could be configured only if other three low level configs are manual: entriesPerSegment(), actualSegments() and actualChunkSize(), unless both keys and value sizes are constant");
        }
    }

    private void checkActualChunksPerSegmentGreaterOrEqualToEntries() {
        if (this.actualChunksPerSegment > 0L && this.entriesPerSegment > 0L && this.entriesPerSegment > this.actualChunksPerSegment) {
            throw new IllegalStateException("Entries per segment couldn't be greater than actual chunks per segment. Entries: " + this.entriesPerSegment + ", " + "chunks: " + this.actualChunksPerSegment + " is configured");
        }
    }

    long actualChunksPerSegment() {
        if (this.actualChunksPerSegment > 0L) {
            return this.actualChunksPerSegment;
        }
        return this.chunksPerSegment(this.entriesPerSegment());
    }

    private long chunksPerSegment(long entriesPerSegment) {
        return Math.round((double)entriesPerSegment * this.averageChunksPerEntry());
    }

    @Override
    public ChronicleMapBuilder<K, V> minSegments(int minSegments) {
        ChronicleMapBuilder.checkSegments(minSegments);
        this.minSegments = minSegments;
        return this;
    }

    int minSegments() {
        return Math.max(this.estimateSegments(), this.minSegments);
    }

    private int estimateSegments() {
        return (int)Math.min(Maths.nextPower2((long)(this.entries() / 32L), (long)1L), (long)this.estimateSegmentsBasedOnSize());
    }

    private int estimateSegmentsBasedOnSize() {
        int segmentsForEntries = ChronicleMapBuilder.estimateSegmentsForEntries(this.entries());
        double averageValueSize = this.averageValueSize();
        return averageValueSize >= 1000000.0 ? segmentsForEntries * 16 : (averageValueSize >= 100000.0 ? segmentsForEntries * 8 : (averageValueSize >= 10000.0 ? segmentsForEntries * 4 : (averageValueSize >= 1000.0 ? segmentsForEntries * 2 : segmentsForEntries)));
    }

    private static int estimateSegmentsForEntries(long size) {
        if (size > 0xC800000L) {
            return 256;
        }
        if (size >= 0x100000L) {
            return 128;
        }
        if (size >= 131072L) {
            return 64;
        }
        if (size >= 16384L) {
            return 32;
        }
        if (size >= 4096L) {
            return 16;
        }
        if (size >= 1024L) {
            return 8;
        }
        return 1;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualSegments(int actualSegments) {
        ChronicleMapBuilder.checkSegments(actualSegments);
        this.actualSegments = actualSegments;
        return this;
    }

    int actualSegments() {
        if (this.actualSegments > 0) {
            return this.actualSegments;
        }
        if (this.entriesPerSegment > 0L) {
            return (int)this.segmentsGivenEntriesPerSegmentFixed(this.entriesPerSegment);
        }
        long segments = this.tryHashLookupSlotSize(4);
        if (segments > 0L) {
            return (int)segments;
        }
        int maxHashLookupEntrySize = this.aligned64BitMemoryOperationsAtomic() ? 8 : 4;
        long maxEntriesPerSegment = this.findMaxEntriesPerSegmentToFitHashLookupSlotSize(maxHashLookupEntrySize);
        long maxSegments = this.trySegments(maxEntriesPerSegment, 0x40000000);
        if (maxSegments > 0L) {
            return (int)maxSegments;
        }
        throw new IllegalStateException("Max segments is 1073741824, configured so much entries (" + this.entries() + ") or average chunks per entry is too high (" + this.averageChunksPerEntry() + ") that builder automatically decided to use " + -maxSegments + " segments");
    }

    private long tryHashLookupSlotSize(int hashLookupSlotSize) {
        long entriesPerSegment = this.findMaxEntriesPerSegmentToFitHashLookupSlotSize(hashLookupSlotSize);
        long entrySpaceSize = Math.round((double)entriesPerSegment * this.entrySizeInfo().averageEntrySize);
        if (entrySpaceSize < RUNTIME_PAGE_SIZE * 5L) {
            return -1L;
        }
        return this.trySegments(entriesPerSegment, 0x40000000);
    }

    private long findMaxEntriesPerSegmentToFitHashLookupSlotSize(int targetHashLookupSlotSize) {
        long entriesPerSegment = 0x4000000000000000L;
        for (long step = entriesPerSegment / 2L; step > 0L; step /= 2L) {
            if (this.hashLookupSlotBytes(entriesPerSegment) <= targetHashLookupSlotSize) continue;
            entriesPerSegment -= step;
        }
        return entriesPerSegment - 1L;
    }

    private int hashLookupSlotBytes(long entriesPerSegment) {
        int valueBits = CompactOffHeapLinearHashTable.valueBits(this.chunksPerSegment(entriesPerSegment));
        int keyBits = CompactOffHeapLinearHashTable.keyBits(entriesPerSegment, valueBits);
        return CompactOffHeapLinearHashTable.entrySize(keyBits, valueBits);
    }

    private long trySegments(long entriesPerSegment, int maxSegments) {
        long segments = this.segmentsGivenEntriesPerSegmentFixed(entriesPerSegment);
        return (segments = Maths.nextPower2((long)Math.max(segments, (long)this.minSegments()), (long)1L)) <= (long)maxSegments ? segments : -segments;
    }

    private long segmentsGivenEntriesPerSegmentFixed(long entriesPerSegment) {
        double precision = 1.0 / this.averageChunksPerEntry();
        double entriesPerSegmentShouldBe = PoissonDistribution.meanByCumulativeProbabilityAndValue(this.nonTieredSegmentsPercentile, entriesPerSegment, precision);
        long segments = (long)((double)this.entries() / entriesPerSegmentShouldBe) + 1L;
        ChronicleMapBuilder.checkSegments(segments);
        if (this.minSegments > 0) {
            segments = Math.max((long)this.minSegments, segments);
        }
        return segments;
    }

    int segmentHeaderSize() {
        long pageSize;
        int segments = this.actualSegments();
        if ((long)(segments * 192) < 2L * (pageSize = 4096L)) {
            return 192;
        }
        if ((long)(segments * 128) < 3L * pageSize) {
            return 128;
        }
        return segments <= 16384 ? 64 : 32;
    }

    public ChronicleMapBuilder<K, V> putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this;
    }

    boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    public ChronicleMapBuilder<K, V> removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this;
    }

    boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    @Override
    public ChronicleMapBuilder<K, V> maxBloatFactor(double maxBloatFactor) {
        if (Double.isNaN(maxBloatFactor) || maxBloatFactor < 1.0 || maxBloatFactor > 1000.0) {
            throw new IllegalArgumentException("maxBloatFactor should be in [1.0, 1_000.0] bounds, " + maxBloatFactor + " given");
        }
        this.maxBloatFactor = maxBloatFactor;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> allowSegmentTiering(boolean allowSegmentTiering) {
        this.allowSegmentTiering = allowSegmentTiering;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> nonTieredSegmentsPercentile(double nonTieredSegmentsPercentile) {
        if (Double.isNaN(nonTieredSegmentsPercentile) || 0.5 <= nonTieredSegmentsPercentile || nonTieredSegmentsPercentile >= 1.0) {
            throw new IllegalArgumentException("nonTieredSegmentsPercentile should be in (0.5, 1.0) range, " + nonTieredSegmentsPercentile + " is given");
        }
        this.nonTieredSegmentsPercentile = nonTieredSegmentsPercentile;
        return this;
    }

    long maxExtraTiers() {
        if (!this.allowSegmentTiering) {
            return 0L;
        }
        int actualSegments = this.actualSegments();
        return (long)(this.maxBloatFactor - 1.0) * (long)actualSegments + (long)actualSegments;
    }

    public String toString() {
        return "ChronicleMapBuilder{, actualSegments=" + ChronicleMapBuilder.pretty(this.actualSegments) + ", minSegments=" + ChronicleMapBuilder.pretty(this.minSegments) + ", entriesPerSegment=" + ChronicleMapBuilder.pretty(this.entriesPerSegment) + ", actualChunksPerSegment=" + ChronicleMapBuilder.pretty(this.actualChunksPerSegment) + ", averageKeySize=" + ChronicleMapBuilder.pretty(this.averageKeySize) + ", sampleKeyForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleKey) + ", averageValueSize=" + ChronicleMapBuilder.pretty(this.averageValueSize) + ", sampleValueForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleValue) + ", actualChunkSize=" + ChronicleMapBuilder.pretty(this.actualChunkSize) + ", valueAlignment=" + (Object)((Object)this.valueAlignment()) + ", entries=" + this.entries() + ", lockTimeOut=" + this.lockTimeOut + " " + (Object)((Object)this.lockTimeOutUnit) + ", putReturnsNull=" + this.putReturnsNull() + ", removeReturnsNull=" + this.removeReturnsNull() + ", timeProvider=" + this.timeProvider() + ", bytesMarshallerFactory=" + ChronicleMapBuilder.pretty(this.bytesMarshallerFactory) + ", objectSerializer=" + ChronicleMapBuilder.pretty(this.objectSerializer) + ", keyBuilder=" + this.keyBuilder + ", valueBuilder=" + this.valueBuilder + ", defaultValue=" + this.defaultValue + '}';
    }

    public boolean equals(Object o) {
        return Objects.builderEquals(this, o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public ChronicleMapBuilder<K, V> timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> removedEntryCleanupTimeout(long removedEntryCleanupTimeout, TimeUnit unit) {
        if (unit.toMillis(removedEntryCleanupTimeout) < 1L) {
            throw new IllegalArgumentException("timeout should be >= 1 millisecond, " + removedEntryCleanupTimeout + " " + (Object)((Object)unit) + " is given");
        }
        this.cleanupTimeout = removedEntryCleanupTimeout;
        this.cleanupTimeoutUnit = unit;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> cleanupRemovedEntries(boolean cleanupRemovedEntries) {
        this.cleanupRemovedEntries = cleanupRemovedEntries;
        return this;
    }

    TimeProvider timeProvider() {
        return this.timeProvider;
    }

    BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory == null ? (this.bytesMarshallerFactory = new VanillaBytesMarshallerFactory()) : this.bytesMarshallerFactory;
    }

    @Override
    public ChronicleMapBuilder<K, V> bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        return this;
    }

    ObjectSerializer acquireObjectSerializer(ObjectSerializer defaultSerializer) {
        return this.objectSerializer == null ? BytesMarshallableSerializer.create((BytesMarshallerFactory)this.bytesMarshallerFactory(), (ObjectSerializer)defaultSerializer) : this.objectSerializer;
    }

    @Override
    public ChronicleMapBuilder<K, V> objectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshaller(@NotNull BytesMarshaller<? super K> keyMarshaller) {
        this.keyBuilder.marshaller(keyMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshallers(@NotNull BytesWriter<? super K> keyWriter, @NotNull BytesReader<K> keyReader) {
        this.keyBuilder.writer(keyWriter);
        this.keyBuilder.reader(keyReader);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keySizeMarshaller(@NotNull SizeMarshaller keySizeMarshaller) {
        this.keyBuilder.sizeMarshaller(keySizeMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyDeserializationFactory(@NotNull ObjectFactory<? extends K> keyDeserializationFactory) {
        this.keyBuilder.factory(keyDeserializationFactory);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> immutableKeys() {
        this.keyBuilder.instancesAreMutable(false);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> aligned64BitMemoryOperationsAtomic(boolean aligned64BitMemoryOperationsAtomic) {
        this.aligned64BitMemoryOperationsAtomic = aligned64BitMemoryOperationsAtomic;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> checksumEntries(boolean checksumEntries) {
        this.checksumEntries = checksumEntries ? ChecksumEntries.YES : ChecksumEntries.NO;
        return this;
    }

    boolean checksumEntries() {
        switch (this.checksumEntries) {
            case NO: {
                return false;
            }
            case YES: {
                return true;
            }
            case IF_PERSISTED: {
                return this.persisted;
            }
        }
        throw new AssertionError();
    }

    boolean aligned64BitMemoryOperationsAtomic() {
        return this.aligned64BitMemoryOperationsAtomic;
    }

    public ChronicleMapBuilder<K, V> valueMarshaller(@NotNull BytesMarshaller<? super V> valueMarshaller) {
        this.valueBuilder.marshaller(valueMarshaller);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueMarshallers(@NotNull BytesWriter<V> valueWriter, @NotNull BytesReader<V> valueReader) {
        this.valueBuilder.writer(valueWriter);
        this.valueBuilder.reader(valueReader);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueSizeMarshaller(@NotNull SizeMarshaller valueSizeMarshaller) {
        this.valueBuilder.sizeMarshaller(valueSizeMarshaller);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueDeserializationFactory(@NotNull ObjectFactory<V> valueDeserializationFactory) {
        this.valueBuilder.factory(valueDeserializationFactory);
        return this;
    }

    public ChronicleMapBuilder<K, V> defaultValue(V defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("default ChronicleMap value couldn't be null");
        }
        this.defaultValue = defaultValue;
        this.constantValueProvider = null;
        return this;
    }

    public ChronicleMapBuilder<K, V> defaultValueProvider(@NotNull DefaultValueProvider<K, V> defaultValueProvider) {
        java.util.Objects.requireNonNull(defaultValueProvider);
        this.defaultValueProvider = defaultValueProvider;
        return this;
    }

    ConstantValueProvider<V> constantValueProvider() {
        if (this.constantValueProvider != null) {
            return this.constantValueProvider;
        }
        V defaultValue = this.defaultValue;
        if (defaultValue == null) {
            defaultValue = this.zeroValue();
        }
        if (defaultValue == null) {
            return null;
        }
        Object originalValueWriter = this.valueBuilder.interop();
        Provider writerProvider = Provider.of(originalValueWriter.getClass());
        ThreadLocalCopies copies = writerProvider.getCopies(null);
        Object valueWriter = writerProvider.get(copies, originalValueWriter);
        MetaProvider<V, ?, MetaBytesInterop<V, ?>> metaWriterProvider = this.valueBuilder.metaInteropProvider();
        copies = metaWriterProvider.getCopies(copies);
        MetaBytesInterop<V, ?> metaValueWriter = metaWriterProvider.get(copies, this.valueBuilder.metaInterop(), valueWriter, defaultValue, true);
        return new ConstantValueProvider<V>(defaultValue, metaValueWriter, valueWriter);
    }

    private V zeroValue() {
        if (Byteable.class.isAssignableFrom(this.valueBuilder.eClass)) {
            try {
                Object v = NativeBytes.UNSAFE.allocateInstance(this.valueBuilder.eClass);
                Byteable defaultValue = (Byteable)v;
                defaultValue.bytes((Bytes)DirectStore.allocate((long)defaultValue.maxSize()).bytes(), 0L);
                return (V)v;
            }
            catch (InstantiationException e) {
                return null;
            }
        }
        try {
            return (V)DataValueClasses.newDirectInstance(this.valueBuilder.eClass);
        }
        catch (Exception e) {
            if (this.valueBuilder.eClass == Long.class) {
                return (V)Long.valueOf(0L);
            }
            if (this.valueBuilder.eClass == Integer.class) {
                return (V)Integer.valueOf(0);
            }
            if (this.valueBuilder.eClass == Short.class) {
                return (V)Short.valueOf((short)0);
            }
            if (this.valueBuilder.eClass == Character.class) {
                return (V)Character.valueOf('\u0000');
            }
            if (this.valueBuilder.eClass == Byte.class) {
                return (V)Byte.valueOf((byte)0);
            }
            if (this.valueBuilder.eClass == Float.class) {
                return (V)Float.valueOf(0.0f);
            }
            if (this.valueBuilder.eClass == Double.class) {
                return (V)Double.valueOf(0.0);
            }
            return null;
        }
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(SingleChronicleHashReplication replication) {
        this.singleHashReplication = replication;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(byte identifier) {
        return this.replication(SingleChronicleHashReplication.builder().createWithId(identifier));
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        return this.replication(((SingleChronicleHashReplication.Builder)SingleChronicleHashReplication.builder().tcpTransportAndNetwork(tcpTransportAndNetwork)).createWithId(identifier));
    }

    @Override
    public ChronicleHashInstanceBuilder<ChronicleMap<K, V>> instance() {
        return new MapInstanceBuilder(this.clone(), this.singleHashReplication, null, null, null, new AtomicBoolean(false));
    }

    @Override
    public ChronicleMap<K, V> createPersistedTo(File file) throws IOException {
        return ((ChronicleMapBuilder)this.clone()).createWithFile(file, this.singleHashReplication, null);
    }

    @Override
    public ChronicleMap<K, V> create() {
        return ((ChronicleMapBuilder)this.clone()).createWithoutFile(this.singleHashReplication, null);
    }

    ChronicleMap<K, V> create(MapInstanceBuilder<K, V> ib) throws IOException {
        if (ib.file != null) {
            return this.createWithFile(ib.file, ib.singleHashReplication, ib.channel);
        }
        return this.createWithoutFile(ib.singleHashReplication, ib.channel);
    }

    /*
     * Exception decompiling
     */
    ChronicleMap<K, V> createWithFile(File file, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void initTransientsFromReplication(VanillaChronicleMap<?, ?, ?, ?, ?, ?, ?> map, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) {
        AbstractReplication replication;
        if (map instanceof ReplicatedChronicleMap && (replication = singleHashReplication != null ? singleHashReplication : (channel != null ? channel.hub() : null)) != null) {
            ((ReplicatedChronicleMap)map).initTransientsFromReplication(replication);
        }
    }

    private static <K, V> boolean trySerializeHeaderViaXStream(VanillaChronicleMap<K, ?, ?, V, ?, ?, ?> map, ObjectOutputStream oos) throws IOException {
        Class<?> xStreamClass;
        try {
            xStreamClass = Class.forName("net.openhft.xstream.MapHeaderSerializationXStream");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            xStreamClass = null;
        }
        if (xStreamClass == null) {
            LOG.info("xStream not found, use binary ChronicleMap header serialization");
            return false;
        }
        try {
            oos.writeByte(1);
            Method toXML = xStreamClass.getMethod("toXML", Object.class, OutputStream.class);
            toXML.invoke(xStreamClass.newInstance(), map, oos);
            return true;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Object deserializeHeaderViaXStream(ObjectInputStream ois) {
        try {
            Class<?> xStreamClass = Class.forName("net.openhft.xstream.MapHeaderSerializationXStream");
            Method fromXML = xStreamClass.getMethod("fromXML", InputStream.class);
            return fromXML.invoke(xStreamClass.newInstance(), ois);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    ChronicleMap<K, V> createWithoutFile(SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) {
        this.replicated = singleHashReplication != null || channel != null;
        this.persisted = false;
        try {
            VanillaChronicleMap<K, ?, ?, V, ?, ?, ?> map = this.newMap(singleHashReplication, channel);
            DirectStore bytesStore = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, map.sizeInBytesWithoutTiers(), false);
            map.createMappedStoreAndSegments((BytesStore)bytesStore);
            return this.establishReplication(map, singleHashReplication, channel);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private VanillaChronicleMap<K, ?, ?, V, ?, ?, ?> newMap(SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        this.preMapConstruction();
        if (this.replicated) {
            AbstractReplication replication = singleHashReplication != null ? singleHashReplication : channel.hub();
            return new ReplicatedChronicleMap(this, replication);
        }
        return new VanillaChronicleMap(this);
    }

    void preMapConstruction() {
        this.averageKeySize = this.preMapConstruction(this.keyBuilder, this.averageKeySize, this.averageKey, this.sampleKey, "Key");
        this.averageValueSize = this.preMapConstruction(this.valueBuilder, this.averageValueSize, this.averageValue, this.sampleValue, "Value");
        if (this.sampleKey == null) {
            this.keyBuilder.maxSize(this.bufferSize(this.keyBuilder, this.averageSizeIfDefined(this.averageKeySize)));
        }
        if (this.sampleValue == null) {
            this.valueBuilder.maxSize(this.bufferSize(this.valueBuilder, this.averageSizeIfDefined(this.averageValueSize)));
        }
        this.stateChecks();
    }

    private double averageSizeIfDefined(double averageKeyOrValueSize) {
        if (ChronicleMapBuilder.isDefined(averageKeyOrValueSize)) {
            return averageKeyOrValueSize;
        }
        assert (this.actualChunksPerSegment > 0L && this.entriesPerSegment > 0L) : "average key or value size could be not defined here, only if allLowLevelConfigurationsAreManual() returns true in preMapConstruction()";
        return (double)this.actualChunksPerSegment * 1.0 / (double)this.entriesPerSegment * (double)this.actualChunkSize;
    }

    private <E> double preMapConstruction(SerializationBuilder<E> builder, double configuredAverageSize, E average, E sample, String dim) {
        builder.objectSerializer(this.acquireObjectSerializer((ObjectSerializer)JDKObjectSerializer.INSTANCE));
        if (sample != null) {
            builder.maxSize(120L);
            builder.constantSizeBySample(sample);
            return builder.maxSize();
        }
        double result = this.averageKeyOrValueSize(configuredAverageSize, builder, average);
        if (!Double.isNaN(result) || this.allLowLevelConfigurationsAreManual()) {
            return result;
        }
        throw new IllegalStateException(dim + " size in serialized form must " + "be configured in ChronicleMap, at least approximately.\nUse builder" + ".average" + dim + "()/.constant" + dim + "SizeBySample()/" + ".average" + dim + "Size() methods to configure the size");
    }

    private void stateChecks() {
        this.checkAlignmentOnlyIfValuesPossiblyReferenceOffHeap();
        this.checkActualChunksPerSegmentIsConfiguredOnlyIfOtherLowLevelConfigsAreManual();
        this.checkActualChunksPerSegmentGreaterOrEqualToEntries();
    }

    private boolean allLowLevelConfigurationsAreManual() {
        return this.actualSegments > 0 && this.entriesPerSegment > 0L && this.actualChunksPerSegment > 0L && this.actualChunkSize > 0;
    }

    private ChronicleMap<K, V> establishReplication(VanillaChronicleMap<K, ?, ?, V, ?, ?, ?> map, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        if (map instanceof ReplicatedChronicleMap) {
            if (singleHashReplication != null && channel != null) {
                throw new AssertionError((Object)"Only one non-null replication should be passed");
            }
            ReplicatedChronicleMap result = (ReplicatedChronicleMap)map;
            if (this.cleanupRemovedEntries) {
                this.establishCleanupThread(result);
            }
            ArrayList<Replicator> replicators = new ArrayList<Replicator>(2);
            if (singleHashReplication != null) {
                if (singleHashReplication.tcpTransportAndNetwork() != null) {
                    replicators.add(Replicators.tcp(singleHashReplication));
                }
                if (singleHashReplication.udpTransport() != null) {
                    replicators.add(Replicators.udp(singleHashReplication.udpTransport()));
                }
            } else if (channel != null) {
                ReplicationHub hub = channel.hub();
                ChannelProvider provider = ChannelProvider.getProvider(hub);
                ChannelProvider.ChronicleChannel ch = provider.createChannel(channel.channelId());
                replicators.add(ch);
            } else assert (this.persisted && !((ReplicatedChronicleMap)map).createdOrInMemory) : "No Replicators for replicated ChronicleMap could be only on deserialization/access of existing replicated ChronicleMap, when replication in not needed in this JVM/run";
            for (Replicator replicator : replicators) {
                Closeable token = replicator.applyTo(this, result, result, (ReplicatedChronicleMap)map);
                if (replicators.size() == 1 && token.getClass() == UdpReplicator.class) {
                    LOG.warn("MISSING TCP REPLICATION : The UdpReplicator only attempts to read data (it does not enforce or guarantee delivery), you should usethe UdpReplicator if you have a large number of nodes, and you wishto receive the data before it becomes available on TCP/IP. Since datadelivery is not guaranteed, it is recommended that you only usethe UDP Replicator in conjunction with a TCP Replicator");
                }
                result.addCloseable(token);
            }
        }
        return map;
    }

    private void establishCleanupThread(ReplicatedChronicleMap map) {
        OldDeletedEntriesCleanup cleanup = new OldDeletedEntriesCleanup(map);
        NamedThreadFactory threadFactory = new NamedThreadFactory("cleanup thread for map persisted at " + map.file());
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
        executor.submit(cleanup);
        map.addCloseable((Closeable)((Object)cleanup));
        map.addCloseable(() -> {
            executor.shutdown();
            try {
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.error("", (Throwable)e);
            }
        });
    }

    private long bufferSize(SerializationBuilder builder, double averageSize) {
        if (builder.constantSizeMarshaller()) {
            return Math.round(Math.ceil(averageSize));
        }
        int maxChunksPerEntry = this.maxChunksPerEntry();
        int limitedMaxChunksPerEntry = Math.min(64, maxChunksPerEntry);
        long limitedMaxEntrySize = (long)limitedMaxChunksPerEntry * this.chunkSize();
        long limitFactor = Math.max(2L, this.entries() >> 10);
        return Math.min(Math.round(Math.ceil((double)limitFactor * averageSize)), limitedMaxEntrySize);
    }

    public ChronicleMapBuilder<K, V> entryOperations(MapEntryOperations<K, V, ?> entryOperations) {
        java.util.Objects.requireNonNull(entryOperations);
        this.entryOperations = entryOperations;
        return this;
    }

    public ChronicleMapBuilder<K, V> mapMethods(MapMethods<K, V, ?> mapMethods) {
        java.util.Objects.requireNonNull(mapMethods);
        this.methods = mapMethods;
        return this;
    }

    public ChronicleMapBuilder<K, V> remoteOperations(MapRemoteOperations<K, V, ?> remoteOperations) {
        java.util.Objects.requireNonNull(remoteOperations);
        this.remoteOperations = remoteOperations;
        return this;
    }

    static class EntrySizeInfo {
        final double averageEntrySize;
        final int worstAlignment;

        public EntrySizeInfo(double averageEntrySize, int worstAlignment) {
            this.averageEntrySize = averageEntrySize;
            this.worstAlignment = worstAlignment;
        }
    }

    static enum ChecksumEntries {
        YES,
        NO,
        IF_PERSISTED;

    }
}

