/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.query;

import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.data.bytes.InputKeyBytesData;
import net.openhft.chronicle.hash.impl.stage.data.instance.InputKeyInstanceData;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupPos;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupSearch;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class HashQuery<K>
implements HashEntry<K> {
    @StageRef
    public VanillaChronicleHashHolder<K, ?, ?> hh;
    @StageRef
    public SegmentStages s;
    @StageRef
    public HashEntryStages<K> entry;
    @StageRef
    public HashLookupSearch hashLookupSearch;
    @StageRef
    public CheckOnEachPublicOperation checkOnEachPublicOperation;
    @StageRef
    public HashLookupPos hlp;
    @StageRef
    public KeySearch ks;
    @StageRef
    public InputKeyInstanceData<K, ?, ?> inputKeyInstanceValue;
    @StageRef
    public InputKeyBytesData<K> inputKeyBytesValue;
    @Stage(value="PresenceOfEntry")
    private EntryPresence entryPresence = null;

    public void dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed() {
        if (this.s.locksInit() && this.s.nestedContextsLockedOnSameSegment && this.s.rootContextLockedOnThisSegment.latestSameThreadSegmentModCount() != this.s.contextModCount && this.ks.keySearchInit() && this.ks.searchState == KeySearch.SearchState.PRESENT && !this.hashLookupSearch.checkSlotContainsExpectedKeyAndValue(this.entry.pos)) {
            this.hlp.closeHashLookupPos();
        }
    }

    public Data<K> queriedKey() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.ks.inputKey;
    }

    private void initPresenceOfEntry() {
        this.entryPresence = this.ks.searchStatePresent() || this.tieredEntryPresent() ? EntryPresence.PRESENT : EntryPresence.ABSENT;
    }

    public void initPresenceOfEntry(EntryPresence entryPresence) {
        this.entryPresence = entryPresence;
    }

    private boolean tieredEntryPresent() {
        int firstTier;
        block5: {
            firstTier = this.s.segmentTier;
            long firstTierBaseAddr = this.s.segmentBaseAddr;
            do {
                if (this.s.hasNextTier()) {
                    this.s.nextTier();
                } else if (this.s.segmentTier != 0) {
                    this.s.initSegmentTier();
                }
                if (this.s.segmentBaseAddr == firstTierBaseAddr) break block5;
            } while (!this.ks.searchStatePresent());
            return true;
        }
        if (firstTier != 0) {
            this.s.initSegmentTier();
        }
        return false;
    }

    public boolean entryPresent() {
        return this.entryPresence == EntryPresence.PRESENT;
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.s.innerUpdateLock.lock();
        if (!this.ks.searchStatePresent()) {
            throw new IllegalStateException("Entry is absent when doRemove() is called");
        }
        this.s.innerWriteLock.lock();
        this.hashLookupSearch.remove();
        this.entry.innerRemoveEntryExceptHashLookupUpdate();
        this.ks.setSearchState(KeySearch.SearchState.DELETED);
        this.initPresenceOfEntry(EntryPresence.ABSENT);
    }

    public static enum EntryPresence {
        PRESENT,
        ABSENT;

    }
}

