/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.bytes.WriteAccess;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.data.bytes.EntryKeyBytesData;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.HashKeyCrc32PayloadChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupPos;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.lang.io.Bytes;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public abstract class HashEntryStages<K>
implements HashEntry<K>,
ChecksumEntry {
    @StageRef
    public VanillaChronicleHashHolder<?, ?, ?> hh;
    @StageRef
    public SegmentStages s;
    @StageRef
    public CheckOnEachPublicOperation checkOnEachPublicOperation;
    @StageRef
    public HashLookupPos hlp;
    public long pos = -1L;
    @Stage(value="EntryOffset")
    public long keySizeOffset = -1L;
    public long keySize = -1L;
    public long keyOffset = -1L;
    @StageRef
    HashKeyCrc32PayloadChecksumStrategy hashKeyCrc32PayloadChecksumStrategy;
    public final ChecksumStrategy checksumStrategy;
    @StageRef
    EntryKeyBytesData<K> entryKey;
    @Stage(value="EntrySizeInChunks")
    public int entrySizeInChunks;

    public HashEntryStages() {
        this.checksumStrategy = this.hh.h().checksumEntries ? this.hashKeyCrc32PayloadChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.entrySizeInChunks = 0;
    }

    public void initPos(long pos) {
        this.pos = pos;
    }

    public abstract void closePos();

    public void initEntryOffset() {
        this.keySizeOffset = this.s.entrySpaceOffset + this.pos * this.hh.h().chunkSize;
        this.s.segmentBytes.limit(this.s.segmentBytes.capacity());
    }

    public void initKeySize(long keySize) {
        this.keySize = keySize;
    }

    public void initKeyOffset(long keyOffset) {
        this.keyOffset = keyOffset;
    }

    public void readExistingEntry(long pos) {
        this.initPos(pos);
        this.s.segmentBytes.position(this.keySizeOffset);
        this.initKeySize(this.hh.h().keySizeMarshaller.readSize((Bytes)this.s.segmentBytes));
        this.initKeyOffset(this.s.segmentBytes.position());
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        this.s.segmentBytes.position(this.keySizeOffset);
        this.hh.h().keySizeMarshaller.writeSize((Bytes)this.s.segmentBytes, this.keySize);
        this.initKeyOffset(this.s.segmentBytes.position());
        key.writeTo((RandomDataOutput)this.s.segmentBS, this.keyOffset);
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset + (oldKeyAddr - oldKeySizeAddr));
        Access.copy((ReadAccess)Access.nativeAccess(), null, (long)oldKeySizeAddr, (WriteAccess)Access.checkedBytesStoreAccess(), (Object)this.s.segmentBS, (long)this.keySizeOffset, (long)bytesToCopy);
    }

    public long keyEnd() {
        return this.keyOffset + this.keySize;
    }

    protected long entryEnd() {
        return this.keyEnd();
    }

    @Override
    public void updateChecksum() {
        this.checksumStrategy.updateChecksum();
    }

    @Override
    public boolean checkSum() {
        return this.checksumStrategy.checkSum();
    }

    long entrySize() {
        return this.checksumStrategy.extraEntryBytes() + this.entryEnd() - this.keySizeOffset;
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.entryKey;
    }

    void initEntrySizeInChunks() {
        this.entrySizeInChunks = this.hh.h().inChunks(this.entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.s.free(this.pos, this.entrySizeInChunks);
        this.s.entries(this.s.entries() - 1L);
        this.s.incrementModCount();
    }
}

