/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.bytes.WriteAccess;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.ReplicatedHashSegmentContext;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.CopyingInstanceData;
import net.openhft.chronicle.hash.impl.JavaLangBytesReusableBytesStore;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.PublicMultiStoreBytes;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.Alloc;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.Crc32;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.impl.value.instance.KeyInitableData;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.replication.RemoteOperationContext;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.ReturnValue;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.MapAbsentEntryHolder;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.impl.ReplicatedChronicleMapHolder;
import net.openhft.chronicle.map.impl.data.instance.ValueInitializableData;
import net.openhft.chronicle.map.impl.ret.InstanceReturnValue;
import net.openhft.chronicle.map.impl.ret.UsableReturnValue;
import net.openhft.chronicle.map.impl.stage.data.ZeroRandomDataInput;
import net.openhft.chronicle.map.replication.MapRemoteQueryContext;
import net.openhft.chronicle.map.replication.MapReplicableEntry;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledReplicatedMapQueryContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R>
implements AutoCloseable,
ChecksumEntry,
HashEntry<K>,
SegmentLock,
Alloc,
KeyHashCode,
LocksInterface,
ChainingInterface,
RemoteOperationContext<K>,
ReplicableEntry,
ExternalMapQueryContext<K, V, R>,
MapAbsentEntry<K, V>,
MapContext<K, V, R>,
MapEntry<K, V>,
MapAbsentEntryHolder<K, V>,
QueryContextInterface<K, V, R>,
ReplicatedChronicleMapHolder<K, KI, MKI, V, VI, MVI, R>,
MapRemoteQueryContext<K, V, R>,
MapReplicableEntry<K, V> {
    final Thread owner;
    public final int indexInContextChain;
    final CleanupAction cleanupAction;
    public final ReadLock innerReadLock;
    public static final Logger LOG = LoggerFactory.getLogger(CompiledReplicatedMapQueryContext.class);
    public final WriteLock innerWriteLock;
    public final UpdateLock innerUpdateLock;
    final BytesReturnValue bytesReturnValue;
    public final ThreadLocalCopies copies;
    final EntryKeyBytesData entryKey;
    final DummyValueZeroData dummyValue;
    public final List<ChainingInterface> contextChain;
    public final AcquireHandle acquireHandle;
    public final UsingReturnValue usingReturnValue;
    public final InputKeyBytesData inputKeyBytesValue;
    public final DefaultReturnValue defaultReturnValue;
    public final EntryValueBytesData entryValue;
    final ReplicatedInputKeyBytesData replicatedInputKeyBytesValue;
    final ReplicatedInputValueBytesData replicatedInputValueBytesValue;
    final WrappedValueInstanceData wrappedValueInstanceValue;
    public final InputFirstValueBytesData inputFirstValueBytesValue;
    public final JavaLangBytesReusableBytesStore replicatedInputStore;
    public final JavaLangBytesReusableBytesStore inputStore;
    public final ReusableBitSet freeList;
    final HashKeyCrc32PayloadChecksumStrategy hashKeyCrc32PayloadChecksumStrategy;
    final ReplicatedMapAbsentDelegating absentDelegating;
    public final InputSecondValueBytesData inputSecondValueBytesValue;
    public final InputKeyInstanceData inputKeyInstanceValue;
    public final PointerBytesStore segmentBS;
    public final InputValueInstanceData inputValueInstanceValue;
    public final PublicMultiStoreBytes segmentBytes;
    private final ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m;
    public final VI valueInterop;
    public final ChecksumStrategy checksumStrategy;
    public final BytesReader<V> valueReader;
    public final KI keyInterop;
    public final BytesReader<K> keyReader;
    long searchKey = 0L;
    public long searchStartPos;
    public long keySize = -1L;
    public int segmentIndex = -1;
    long segmentHeaderAddress;
    SegmentHeader segmentHeader = null;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    public boolean concurrentSameThreadContexts;
    LocksInterface nextNode;
    LocalLockState localLockState;
    public LocksInterface rootContextOnThisSegment = null;
    public int segmentTier = -1;
    public long tierIndex;
    public long segmentBaseAddr;
    public long hashLookupPos = -1L;
    long entrySpaceOffset = 0L;
    boolean used;
    public Bytes replicatedInputBytes = null;
    public Data<K> inputKey = null;
    public long keyHash = 0L;
    public long pos = -1L;
    public long keySizeOffset = -1L;
    public long keyOffset = -1L;
    public long valueSizeOffset = -1L;
    public long valueSize = -1L;
    public long valueOffset;
    long replicationBytesOffset = -1L;
    public int entrySizeInChunks = 0;
    protected SearchState searchState = null;
    private EntryPresence entryPresence = null;
    public int allocatedChunks = 0;
    public long innerRemoteTimestamp;
    public byte innerRemoteIdentifier = 0;
    public long bootstrapTimestamp;
    public long riKeySize = -1L;
    public long riValueSize;
    public long riKeyOffset;
    public long riValueOffset;
    public long riTimestamp;
    public byte riId;
    public boolean isDeleted;
    public Bytes inputBytes = null;
    public long inputKeySize = -1L;
    public long inputKeyOffset;
    public long firstInputValueSize = -1L;
    public long firstInputValueOffset;
    public long secondInputValueSize = -1L;
    public long secondInputValueOffset;

    public boolean readZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.readZero();
    }

    public boolean updateZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.updateZero();
    }

    public boolean writeZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.writeZero();
    }

    public int decrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementUpdate();
    }

    public int decrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementWrite();
    }

    public String debugContextsAndLocksGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.debugContextsAndLocks();
    }

    @Override
    public void close() {
        this.closeInputBytes();
        this.closeReplicationInput();
        this.closeReplicationUpdate();
        this.usingReturnValue.closeUsingReturnValue();
        this.bytesReturnValue.closeOutput();
        this.defaultReturnValue.closeDefaultReturnedValue();
        this.closeAllocatedChunks();
        this.closeKeyOffset();
        this.inputKeyInstanceValue.closeKey();
        this.closePos();
        this.wrappedValueInstanceValue.closeNext();
        this.closeInputKey();
        this.closeReplicatedInputBytes();
        this.closeUsed();
        this.closeSegmentIndex();
        this.wrappedValueInstanceValue.closeValue();
        this.inputValueInstanceValue.closeValue();
        this.closeKeySize();
        this.closeQueryHashLookupSearchHlDependants();
        this.closeKeyBytesInteropKeyMetaInteropDependants();
        this.closeQuerySegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeValueBytesInteropValueMetaInteropDependants();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeReplicatedChronicleMapHolderImplContextAtIndexInChainDependants();
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void incrementReadGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementRead();
    }

    public void incrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementUpdate();
    }

    public void incrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementWrite();
    }

    public void readUnlockAndDecrementCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.readUnlockAndDecrementCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    public void setSearchStateGuarded(SearchState newSearchState) {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        this.setSearchState(newSearchState);
    }

    private long _MapEntryStages_countValueSizeOffset() {
        return this.keyEnd();
    }

    private long _MapEntryStages_sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)(((ReplicatedChronicleMap)this.m()).metaDataBytes + ((ReplicatedChronicleMap)this.m()).keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + (long)((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.sizeEncodingSize(valueSize);
    }

    void keyFound() {
        this.searchState = SearchState.PRESENT;
    }

    public CompiledReplicatedMapQueryContext(ChainingInterface c, ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m) {
        this.contextChain = c.getContextChain();
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.m = m;
        this.absentDelegating = new ReplicatedMapAbsentDelegating();
        this.dummyValue = new DummyValueZeroData();
        this.inputSecondValueBytesValue = new InputSecondValueBytesData();
        this.replicatedInputKeyBytesValue = new ReplicatedInputKeyBytesData();
        this.wrappedValueInstanceValue = new WrappedValueInstanceData();
        this.inputValueInstanceValue = new InputValueInstanceData();
        this.defaultReturnValue = new DefaultReturnValue();
        this.inputStore = new JavaLangBytesReusableBytesStore();
        this.inputFirstValueBytesValue = new InputFirstValueBytesData();
        this.replicatedInputStore = new JavaLangBytesReusableBytesStore();
        this.owner = Thread.currentThread();
        this.entryKey = new EntryKeyBytesData();
        this.bytesReturnValue = new BytesReturnValue();
        this.usingReturnValue = new UsingReturnValue();
        this.acquireHandle = new AcquireHandle();
        this.entryValue = new EntryValueBytesData();
        this.hashKeyCrc32PayloadChecksumStrategy = new HashKeyCrc32PayloadChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashKeyCrc32PayloadChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerReadLock = new ReadLock();
        this.inputKeyInstanceValue = new InputKeyInstanceData();
        this.innerWriteLock = new WriteLock();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = ((ReplicatedChronicleMap)this.m()).valueInteropProvider.get(this.copies, ((ReplicatedChronicleMap)this.m()).originalValueInterop);
        this.valueReader = (BytesReader)((ReplicatedChronicleMap)this.m()).valueReaderProvider.get(this.copies, (Object)((ReplicatedChronicleMap)this.m()).originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.replicatedInputValueBytesValue = new ReplicatedInputValueBytesData();
        this.inputKeyBytesValue = new InputKeyBytesData();
        this.cleanupAction = new CleanupAction();
        this.segmentBytes = new PublicMultiStoreBytes();
        this.segmentBS = new PointerBytesStore();
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegment, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
        this.innerUpdateLock = new UpdateLock();
    }

    public CompiledReplicatedMapQueryContext(ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m) {
        this.contextChain = new ArrayList<ChainingInterface>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.m = m;
        this.absentDelegating = new ReplicatedMapAbsentDelegating();
        this.dummyValue = new DummyValueZeroData();
        this.inputSecondValueBytesValue = new InputSecondValueBytesData();
        this.replicatedInputKeyBytesValue = new ReplicatedInputKeyBytesData();
        this.wrappedValueInstanceValue = new WrappedValueInstanceData();
        this.inputValueInstanceValue = new InputValueInstanceData();
        this.defaultReturnValue = new DefaultReturnValue();
        this.inputStore = new JavaLangBytesReusableBytesStore();
        this.inputFirstValueBytesValue = new InputFirstValueBytesData();
        this.replicatedInputStore = new JavaLangBytesReusableBytesStore();
        this.owner = Thread.currentThread();
        this.entryKey = new EntryKeyBytesData();
        this.bytesReturnValue = new BytesReturnValue();
        this.usingReturnValue = new UsingReturnValue();
        this.acquireHandle = new AcquireHandle();
        this.entryValue = new EntryValueBytesData();
        this.hashKeyCrc32PayloadChecksumStrategy = new HashKeyCrc32PayloadChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashKeyCrc32PayloadChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerReadLock = new ReadLock();
        this.inputKeyInstanceValue = new InputKeyInstanceData();
        this.innerWriteLock = new WriteLock();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = ((ReplicatedChronicleMap)this.m()).valueInteropProvider.get(this.copies, ((ReplicatedChronicleMap)this.m()).originalValueInterop);
        this.valueReader = (BytesReader)((ReplicatedChronicleMap)this.m()).valueReaderProvider.get(this.copies, (Object)((ReplicatedChronicleMap)this.m()).originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.replicatedInputValueBytesValue = new ReplicatedInputValueBytesData();
        this.inputKeyBytesValue = new InputKeyBytesData();
        this.cleanupAction = new CleanupAction();
        this.segmentBytes = new PublicMultiStoreBytes();
        this.segmentBS = new PointerBytesStore();
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegment, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
        this.innerUpdateLock = new UpdateLock();
    }

    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = (LocksInterface)this.contextAtIndexInChain(index);
        if (c.segmentHeaderInit() && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.locksInit()) {
            LocksInterface root;
            this.rootContextOnThisSegment = root = c.rootContextOnThisSegment();
            root.setConcurrentSameThreadContexts(true);
            this.concurrentSameThreadContexts = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            this.linkToSegmentContextsChain();
            return true;
        }
        return false;
    }

    @Override
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Override
    public int changeAndGetTotalReadLockCount(int change) {
        return this.totalReadLockCount += change;
    }

    @Override
    public int changeAndGetTotalUpdateLockCount(int change) {
        return this.totalUpdateLockCount += change;
    }

    @Override
    public int changeAndGetTotalWriteLockCount(int change) {
        return this.totalWriteLockCount += change;
    }

    public int decrementRead() {
        return this.rootContextOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    public int decrementUpdate() {
        return this.rootContextOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    public int decrementWrite() {
        return this.rootContextOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    private long _QueryAlloc_alloc(int chunks) {
        long ret = this.allocReturnCode(chunks);
        if (ret >= 0L) {
            return ret;
        }
        int alreadyAttemptedTier = this.segmentTier();
        this.goToFirstTier();
        while (this.segmentTier() == alreadyAttemptedTier || (ret = this.allocReturnCode(chunks)) < 0L) {
            this.nextTier();
        }
        return ret;
    }

    private void _AllocatedChunks_incrementSegmentEntriesIfNeeded() {
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkAccessingFromOwnerThread();
        if (!this.h().isOpen()) {
            throw new IllegalStateException("Access to Chronicle Hash after close()");
        }
    }

    private void _MapAbsent_doInsert(Data<V> value) {
        this.putPrefix();
        if (!this.entryPresent()) {
            if (this.searchStateDeleted()) {
                this.putValueDeletedEntry(value);
            } else {
                this.putEntry(value);
            }
        } else {
            throw new IllegalStateException("Entry is present in the map when doInsert() is called");
        }
        this.incrementModCountGuarded();
        this.setSearchStateGuarded(SearchState.PRESENT);
        this.initPresenceOfEntry(EntryPresence.PRESENT);
        this.checksumStrategy.computeAndStoreChecksum();
    }

    private void _MapQuery_doRemove() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        if (!this.searchStatePresent()) {
            throw new IllegalStateException("Entry is absent when doRemove() is called");
        }
        this.innerWriteLock.lock();
        this.remove();
        this.innerRemoveEntryExceptHashLookupUpdate();
        this.setSearchStateGuarded(SearchState.DELETED);
        this.initPresenceOfEntry(EntryPresence.ABSENT);
    }

    private void _MapQuery_doReplaceValue(Data<V> newValue) {
        this.doReplaceValueWithoutChecksum(newValue);
        this.checksumStrategy.computeAndStoreChecksum();
    }

    public void incrementModCount() {
        this.contextModCount = this.rootContextOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    public void incrementRead() {
        this.rootContextOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    public void incrementUpdate() {
        this.rootContextOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    public void incrementWrite() {
        this.rootContextOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    public void readUnlockAndDecrementCount() {
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                int newTotalReadLockCount = this.decrementRead();
                if (newTotalReadLockCount == 0) {
                    if (this.updateZero() && this.writeZero()) {
                        this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                    }
                } else assert (newTotalReadLockCount > 0) : "read underflow";
                return;
            }
            case UPDATE_LOCKED: {
                int newTotalUpdateLockCount = this.decrementUpdate();
                if (newTotalUpdateLockCount == 0) {
                    if (this.writeZero()) {
                        if (this.readZero()) {
                            this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                        } else {
                            this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                        }
                    }
                } else assert (newTotalUpdateLockCount > 0) : "update underflow";
                return;
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = this.decrementWrite();
                if (newTotalWriteLockCount == 0) {
                    if (!this.updateZero()) {
                        this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                        break;
                    }
                    if (!this.readZero()) {
                        this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                        break;
                    }
                    this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
                    break;
                }
                assert (newTotalWriteLockCount > 0) : "write underflow";
                break;
            }
        }
    }

    @Override
    public void setConcurrentSameThreadContexts(boolean concurrentSameThreadContexts) {
        this.concurrentSameThreadContexts = concurrentSameThreadContexts;
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        this.localLockState = newState;
    }

    @Override
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    public Thread owner() {
        return this.owner;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        this.readUnlockAndDecrementCount();
    }

    private void closeRootLocks() {
        this.verifyInnermostContext();
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void countValueOffset() {
        ((ReplicatedChronicleMap)this.m()).alignment.alignPositionAddr((Bytes)this.segmentBytes());
        this.valueOffset = this.segmentBytes().position();
    }

    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = this.rootContextOnThisSegment;
        while (true) {
            this.checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if (innermostContextOnThisSegment.nextNode() == null) break;
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    private void unlinkFromSegmentContextsChain() {
        LocksInterface prevContext = this.rootContextOnThisSegment;
        while (true) {
            assert (prevContext.nextNode() != null);
            if (prevContext.nextNode() == this) break;
            prevContext = prevContext.nextNode();
        }
        this.verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    private void verifyInnermostContext() {
        if (this.nextNode != null) {
            throw new IllegalStateException("Attempt to close contexts not structurally");
        }
    }

    public String debugContextsAndLocks() {
        String message = "";
        message = message + "Contexts locked on this segment:\n";
        for (LocksInterface cxt = this.rootContextOnThisSegment; cxt != null; cxt = cxt.nextNode()) {
            message = message + cxt.debugLocksState() + "\n";
        }
        message = message + "Current thread contexts:\n";
        int size = this.contextChain.size();
        for (int i = 0; i < size; ++i) {
            LocksInterface cxt = (LocksInterface)this.contextAtIndexInChain(i);
            message = message + cxt.debugLocksState() + "\n";
        }
        return message;
    }

    private boolean _MapQuery_entryPresent() {
        return this.entryPresence() == EntryPresence.PRESENT;
    }

    public boolean readZero() {
        return this.rootContextOnThisSegment.totalReadLockCount() == 0;
    }

    public boolean updateZero() {
        return this.rootContextOnThisSegment.totalUpdateLockCount() == 0;
    }

    public boolean writeZero() {
        return this.rootContextOnThisSegment.totalWriteLockCount() == 0;
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    private void _MapEntryStages_relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        this.innerWriteLock.lock();
        this.free(this.pos(), this.entrySizeInChunks());
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        long oldHashLookupPos = this.hashLookupPos();
        long oldHashLookupAddr = this.segmentBaseAddr();
        boolean tierHasChanged = this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - this.keySizeOffset());
        if (tierHasChanged && !this.searchStateAbsent()) {
            throw new AssertionError();
        }
        this.initValue(newValue);
        this.freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.h().hashLookup;
        long oldEntry = hl.readEntry(oldHashLookupAddr, oldHashLookupPos);
        hl.checkValueForPut(this.pos());
        hl.writeEntryVolatile(this.segmentBaseAddr(), this.hashLookupPos(), oldEntry, hl.key(oldEntry), this.pos());
        if (tierHasChanged) {
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        }
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public CleanupAction cleanupAction() {
        return this.cleanupAction;
    }

    private MapEntry<K, V> _MapQuery_entry() {
        this.checkOnEachPublicOperation();
        return this.entryPresent() ? this : null;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public Logger LOG() {
        return LOG;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    @Nullable
    private MapAbsentEntry<K, V> _MapQuery_absentEntry() {
        this.checkOnEachPublicOperation();
        return this.entryPresent() ? null : this.absent();
    }

    public BytesReturnValue bytesReturnValue() {
        return this.bytesReturnValue;
    }

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public ThreadLocalCopies copies() {
        return this.copies;
    }

    public DummyValueZeroData dummyValue() {
        return this.dummyValue;
    }

    public UsingReturnValue usingReturnValue() {
        return this.usingReturnValue;
    }

    @Override
    public AcquireHandle acquireHandle() {
        return this.acquireHandle;
    }

    public List<ChainingInterface> contextChain() {
        return this.contextChain;
    }

    public InputKeyBytesData inputKeyBytesValue() {
        return this.inputKeyBytesValue;
    }

    public DefaultReturnValue defaultReturnValue() {
        return this.defaultReturnValue;
    }

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    public ReplicatedInputKeyBytesData replicatedInputKeyBytesValue() {
        return this.replicatedInputKeyBytesValue;
    }

    public ReplicatedInputValueBytesData replicatedInputValueBytesValue() {
        return this.replicatedInputValueBytesValue;
    }

    public WrappedValueInstanceData wrappedValueInstanceValue() {
        return this.wrappedValueInstanceValue;
    }

    public JavaLangBytesReusableBytesStore inputStore() {
        return this.inputStore;
    }

    public JavaLangBytesReusableBytesStore replicatedInputStore() {
        return this.replicatedInputStore;
    }

    public InputFirstValueBytesData inputFirstValueBytesValue() {
        return this.inputFirstValueBytesValue;
    }

    public InputSecondValueBytesData inputSecondValueBytesValue() {
        return this.inputSecondValueBytesValue;
    }

    public ReplicatedMapAbsentDelegating absentDelegating() {
        return this.absentDelegating;
    }

    public HashKeyCrc32PayloadChecksumStrategy hashKeyCrc32PayloadChecksumStrategy() {
        return this.hashKeyCrc32PayloadChecksumStrategy;
    }

    public InputKeyInstanceData inputKeyInstanceValue() {
        return this.inputKeyInstanceValue;
    }

    public InputValueInstanceData inputValueInstanceValue() {
        return this.inputValueInstanceValue;
    }

    public VI valueInterop() {
        return this.valueInterop;
    }

    public ChecksumStrategy checksumStrategy() {
        return this.checksumStrategy;
    }

    public BytesReader<V> valueReader() {
        return this.valueReader;
    }

    public KI keyInterop() {
        return this.keyInterop;
    }

    public BytesReader<K> keyReader() {
        return this.keyReader;
    }

    @Override
    public boolean checkSum() {
        return this.checksumStrategy.checkSum();
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeReplicatedChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeLocks();
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException("Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    @Override
    public MapAbsentEntry<K, V> absent() {
        return this;
    }

    @Override
    public ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m() {
        return this.m;
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    public MVI valueMetaInterop(V value) {
        return (MVI)((ReplicatedChronicleMap)this.m()).metaValueInteropProvider.get(this.copies, ((ReplicatedChronicleMap)this.m()).originalMetaValueInterop, this.valueInterop, value, false);
    }

    public void closeValueBytesInteropValueMetaInteropDependants() {
        this.wrappedValueInstanceValue.closeBuffer();
        this.inputValueInstanceValue.closeBuffer();
    }

    @Override
    public <T extends ChainingInterface> T getContext(Class<? extends T> contextClass, Function<ChainingInterface, T> createChaining) {
        ChainingInterface context2;
        for (ChainingInterface context2 : this.contextChain) {
            if (context2.getClass() != contextClass || context2.usedInit()) continue;
            context2.initUsed(true);
            return (T)context2;
        }
        int maxNestedContexts = 1024;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        context2 = (ChainingInterface)createChaining.apply(this);
        context2.initUsed(true);
        return (T)context2;
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        Data<K> key;
        if (innermostContextOnThisSegment.getClass() == this.getClass() && Objects.equals(key = ((CompiledReplicatedMapQueryContext)innermostContextOnThisSegment).inputKey(), this.inputKey())) {
            throw new IllegalStateException("Nested same-thread contexts cannot access the same key " + key);
        }
    }

    public void closeQuerySegmentStagesCheckNestedContextsQueryDifferentKeysDependants() {
        this.closeLocks();
    }

    public MKI keyMetaInterop(K key) {
        return (MKI)((MetaBytesInterop)this.h().metaKeyInteropProvider.get(this.copies, this.h().originalMetaKeyInterop, this.keyInterop, key, false));
    }

    public void closeKeyBytesInteropKeyMetaInteropDependants() {
        this.inputKeyInstanceValue.closeBuffer();
    }

    public CompactOffHeapLinearHashTable hl() {
        return this.h().hashLookup;
    }

    public void closeQueryHashLookupSearchHlDependants() {
        this.closeSearchKey();
        this.closeQueryHashLookupSearchFoundDependants();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public boolean searchKeyInit() {
        return this.searchKey != 0L;
    }

    void initSearchKey() {
        this.initSearchKey(this.hl().maskUnsetKey(this.h().hashSplitting.segmentHash(this.keyHashCode())));
        this.closeSearchKeyDependants();
    }

    public void initSearchKey(long searchKey) {
        this.searchKey = searchKey;
        this.searchStartPos = this.hl().hlPos(searchKey);
        this.closeSearchKeyDependants();
    }

    public long searchKey() {
        if (!this.searchKeyInit()) {
            this.initSearchKey();
        }
        return this.searchKey;
    }

    public long searchStartPos() {
        if (!this.searchKeyInit()) {
            this.initSearchKey();
        }
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!this.searchKeyInit()) {
            return;
        }
        this.closeSearchKeyDependants();
        this.searchKey = 0L;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return this._MapEntryStages_sizeOfEverythingBeforeValue(keySize, valueSize) + 10L;
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (((ReplicatedChronicleMap)this.m()).constantlySizedEntry) {
            return ((ReplicatedChronicleMap)this.m()).alignment.alignAddr(sizeOfEverythingBeforeValue + valueSize);
        }
        if (((ReplicatedChronicleMap)this.m()).couldNotDetermineAlignmentBeforeAllocation) {
            return sizeOfEverythingBeforeValue + (long)((ReplicatedChronicleMap)this.m()).worstAlignment + valueSize;
        }
        return ((ReplicatedChronicleMap)this.m()).alignment.alignAddr(sizeOfEverythingBeforeValue) + valueSize;
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    public void putValueDeletedEntry(Data<V> newValue) {
        throw new AssertionError((Object)"putValueDeletedEntry() might be called only from non-Replicated Map query context");
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return this.contextChain;
    }

    @Override
    public Data<V> dummyZeroValue() {
        return this.dummyValue;
    }

    @Override
    public void updateChecksum() {
        this.checksumStrategy.updateChecksum();
    }

    public boolean keySizeInit() {
        return this.keySize != -1L;
    }

    public void initKeySize(long keySize) {
        this.keySize = keySize;
        this.closeKeySizeDependants();
    }

    public long keySize() {
        assert (this.keySizeInit()) : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!this.keySizeInit()) {
            return;
        }
        this.closeKeySizeDependants();
        this.keySize = -1L;
    }

    public void closeKeySizeDependants() {
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    public boolean segmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    void initSegmentIndex() {
        this.segmentIndex = this.h().hashSplitting.segmentIndex(this.keyHashCode());
        this.closeSegmentIndexDependants();
    }

    @Override
    public void initSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
        this.closeSegmentIndexDependants();
    }

    @Override
    public int segmentIndex() {
        if (!this.segmentIndexInit()) {
            this.initSegmentIndex();
        }
        return this.segmentIndex;
    }

    public void closeSegmentIndex() {
        if (!this.segmentIndexInit()) {
            return;
        }
        this.closeSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeSegmentIndexDependants() {
        this.closeSegmentHeader();
        this.closeSegmentTier();
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public boolean forcedOldDeletedEntriesCleanup() {
        VanillaChronicleMap map = this.m();
        try (HashSegmentContext sc = map.segmentContext(this.segmentIndex());){
            this.cleanupAction.removedCompletely = 0;
            ((ReplicatedHashSegmentContext)sc).forEachSegmentReplicableEntry(this.cleanupAction);
            boolean bl = this.cleanupAction.removedCompletely > 0;
            return bl;
        }
    }

    @Override
    public boolean segmentHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegmentHeader() {
        this.segmentHeaderAddress = this.h().segmentHeaderAddress(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        this.closeSegmentHeaderDependants();
    }

    @Override
    public long segmentHeaderAddress() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegmentHeader() {
        if (!this.segmentHeaderInit()) {
            return;
        }
        this.closeSegmentHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegmentHeaderDependants() {
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
    }

    public void entries(long size) {
        this.segmentHeader().size(this.segmentHeaderAddress(), size);
    }

    public long entries() {
        return this.segmentHeader().size(this.segmentHeaderAddress());
    }

    public void deleted(long deleted) {
        this.segmentHeader().deleted(this.segmentHeaderAddress(), deleted);
    }

    public long deleted() {
        return this.segmentHeader().deleted(this.segmentHeaderAddress());
    }

    public long size() {
        return this.entries() - this.deleted();
    }

    @Override
    public boolean locksInit() {
        return this.rootContextOnThisSegment != null;
    }

    void initLocks() {
        int i;
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        this.rootContextOnThisSegment = this;
        this.concurrentSameThreadContexts = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
        this.closeLocksDependants();
    }

    public boolean concurrentSameThreadContexts() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.concurrentSameThreadContexts;
    }

    public int contextModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.contextModCount;
    }

    @Override
    public int latestSameThreadSegmentModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.latestSameThreadSegmentModCount;
    }

    @Override
    public int totalReadLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalReadLockCount;
    }

    @Override
    public int totalUpdateLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalUpdateLockCount;
    }

    @Override
    public int totalWriteLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalWriteLockCount;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    @Override
    public LocksInterface nextNode() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nextNode;
    }

    @Override
    public LocksInterface rootContextOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        this.closeLocksDependants();
        if (this.rootContextOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.localLockState = null;
        this.rootContextOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeReplicatedMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    @Override
    public String debugLocksState() {
        String s = this + ": ";
        if (!this.usedInit()) {
            s = s + "unused";
            return s;
        }
        s = s + "used, ";
        if (!this.segmentIndexInit()) {
            s = s + "segment uninitialized";
            return s;
        }
        s = s + "segment " + this.segmentIndex() + ", ";
        if (!this.locksInit()) {
            s = s + "locks uninitialized";
            return s;
        }
        s = s + "local state: " + (Object)((Object)this.localLockState()) + ", ";
        s = s + "read lock count: " + this.rootContextOnThisSegment().totalReadLockCount() + ", ";
        s = s + "update lock count: " + this.rootContextOnThisSegment().totalUpdateLockCount() + ", ";
        s = s + "write lock count: " + this.rootContextOnThisSegment().totalWriteLockCount();
        return s;
    }

    public boolean segmentTierInit() {
        return this.segmentTier >= 0;
    }

    public void initSegmentTier() {
        this.tierIndex = this.segmentIndex() + 1;
        this.segmentBaseAddr = this.h().segmentBaseAddr(this.segmentIndex());
        this.segmentTier = 0;
        this.closeSegmentTierDependants();
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        this.segmentTier = tier;
        this.tierIndex = tierIndex;
        this.segmentBaseAddr = tierBaseAddr;
        this.closeSegmentTierDependants();
    }

    private void initSegmentTier(int tier, long tierIndex) {
        this.segmentTier = tier;
        this.tierIndex = tierIndex;
        assert (tierIndex > 0L);
        this.segmentBaseAddr = this.h().tierIndexToBaseAddr(tierIndex);
        this.closeSegmentTierDependants();
    }

    public int segmentTier() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.segmentTier;
    }

    public long segmentBaseAddr() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.segmentBaseAddr;
    }

    public long tierIndex() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierIndex;
    }

    public void closeSegmentTier() {
        if (!this.segmentTierInit()) {
            return;
        }
        this.closeSegmentTierDependants();
        this.segmentTier = -1;
    }

    public void closeSegmentTierDependants() {
        this.closeQueryHashLookupSearchAddrDependants();
        this.closeQuerySegmentStagesTierCountersAreaAddrDependants();
        this.closeQuerySegmentStagesNextTierDependants();
        this.closeHashLookupPos();
        this.closeSegment();
        this.closeReplicatedMapQueryTieredEntryPresentDependants();
    }

    private long addr() {
        return this.segmentBaseAddr();
    }

    public void closeQueryHashLookupSearchAddrDependants() {
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public long tierCountersAreaAddr() {
        return this.segmentBaseAddr() + this.h().segmentHashLookupOuterSize;
    }

    public void closeQuerySegmentStagesTierCountersAreaAddrDependants() {
        this.closeQuerySegmentStagesPrevTierIndexDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(this.tierCountersAreaAddr(), prevTierIndex);
    }

    public void closeQuerySegmentStagesPrevTierIndexDependants() {
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(this.tierCountersAreaAddr());
    }

    public void nextPosToSearchFromTiered(long nextPosToSearchFrom) {
        TierCountersArea.nextPosToSearchFromTiered(this.tierCountersAreaAddr(), nextPosToSearchFrom);
    }

    public void nextPosToSearchFrom(long nextPosToSearchFrom) {
        if (this.segmentTier() == 0) {
            this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress(), nextPosToSearchFrom);
        } else {
            this.nextPosToSearchFromTiered(nextPosToSearchFrom);
        }
    }

    public void updateNextPosToSearchFrom(long allocated, int chunks) {
        long nextPosToSearchFrom = allocated + (long)chunks;
        if (nextPosToSearchFrom >= this.h().actualChunksPerSegment) {
            nextPosToSearchFrom = 0L;
        }
        this.nextPosToSearchFrom(nextPosToSearchFrom);
    }

    public long nextPosToSearchFromTiered() {
        return TierCountersArea.nextPosToSearchFromTiered(this.tierCountersAreaAddr());
    }

    long nextPosToSearchFrom() {
        if (this.segmentTier() == 0) {
            return this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress());
        }
        return this.nextPosToSearchFromTiered();
    }

    public void nextTierIndex(long nextTierIndex) {
        TierCountersArea.nextTierIndex(this.tierCountersAreaAddr(), nextTierIndex);
    }

    public void closeQuerySegmentStagesNextTierIndexDependants() {
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public long nextTierIndex() {
        return TierCountersArea.nextTierIndex(this.tierCountersAreaAddr());
    }

    public boolean hasNextTier() {
        return this.nextTierIndex() != 0L;
    }

    public void closeQuerySegmentStagesHasNextTierDependants() {
        this.closeReplicatedMapQueryTieredEntryPresentDependants();
    }

    public void nextTier() {
        VanillaChronicleHash h = this.h();
        long nextTierIndex = this.nextTierIndex();
        if (nextTierIndex == 0L) {
            nextTierIndex = h.allocateTier(this.segmentIndex(), this.segmentTier() + 1);
            this.nextTierIndex(nextTierIndex);
            long currentTierIndex = this.tierIndex();
            this.initSegmentTier(this.segmentTier() + 1, nextTierIndex);
            this.prevTierIndex(currentTierIndex);
        } else {
            this.initSegmentTier(this.segmentTier() + 1, nextTierIndex);
        }
    }

    public void closeQuerySegmentStagesNextTierDependants() {
        this.closeReplicatedMapQueryTieredEntryPresentDependants();
    }

    public void goToLastTier() {
        while (this.hasNextTier()) {
            this.nextTier();
        }
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos != -1L;
    }

    public void initHashLookupPos() {
        assert (this.segmentTier() >= 0);
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        this.closeHashLookupPosDependants();
    }

    public void initHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
        this.closeHashLookupPosDependants();
    }

    public long hashLookupPos() {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1L;
    }

    public void closeHashLookupPosDependants() {
        this.closeQueryHashLookupSearchFoundDependants();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public void found() {
        this.setHashLookupPosGuarded(this.hl().stepBack(this.hashLookupPos()));
    }

    public void closeQueryHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hashLookupPos();
            do {
                entry = this.hl().readEntry(this.addr(), pos);
                if (this.hl().empty(entry)) {
                    this.setHashLookupPosGuarded(pos);
                    return -1L;
                }
                pos = this.hl().step(pos);
                if (pos == this.searchStartPos()) break block2;
            } while (this.hl().key(entry) != this.searchKey());
            this.setHashLookupPosGuarded(pos);
            return this.hl().value(entry);
        }
        throw new IllegalStateException("MultiMap is full, that most likely means you misconfigured entrySize/chunkSize, and entries tend to take less chunks than expected");
    }

    public void closeQueryHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        return this.hl().key(entry) == this.searchKey() && this.hl().value(entry) == value;
    }

    public void closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants() {
        this.closeReplicatedMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void putValueVolatile(long newValue) {
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        hashLookup.checkValueForPut(newValue);
        hashLookup.putValueVolatile(this.segmentBaseAddr(), this.hashLookupPos(), newValue);
    }

    public void remove() {
        this.setHashLookupPosGuarded(this.hl().remove(this.addr(), this.hashLookupPos()));
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        VanillaChronicleHash h = this.h();
        PublicMultiStoreBytes segmentBytes = this.segmentBytes;
        segmentBytes.setBytesOffset(h.tierBytes(this.tierIndex()), h.tierBytesOffset(this.tierIndex()));
        long segmentBaseAddr = this.segmentBaseAddr();
        this.segmentBS.set(segmentBaseAddr, h.segmentSize);
        long freeListOffset = h.segmentHashLookupOuterSize + 64L;
        this.freeList.setOffset(segmentBaseAddr + freeListOffset);
        this.entrySpaceOffset = freeListOffset + h.segmentFreeListOuterSize + (long)h.segmentEntrySpaceInnerOffset;
        this.closeSegmentDependants();
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public ReusableBitSet freeList() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.freeList;
    }

    public PointerBytesStore segmentBS() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBS;
    }

    public PublicMultiStoreBytes segmentBytes() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytes;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeValueSize();
        this.closeKeySearchKeyEqualsDependants();
        this.closeEntryOffset();
        this.closeReplicatedMapEntryStagesReadExistingEntryDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public void free(long fromPos, int chunks) {
        this.freeList().clearRange(fromPos, fromPos + (long)chunks);
        if (fromPos < this.nextPosToSearchFrom()) {
            this.nextPosToSearchFrom(fromPos);
        }
    }

    public long allocReturnCode(int chunks) {
        VanillaChronicleHash h = this.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " entry size chucks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long ret = this.freeList().setNextNContinuousClearBits(this.nextPosToSearchFrom(), chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
            if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                this.freeList().clearRange(ret, h.actualChunksPerSegment);
            }
            if ((ret = this.freeList().setNextNContinuousClearBits(0L, chunks)) == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
                if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                    this.freeList().clearRange(ret, h.actualChunksPerSegment);
                }
                return -1L;
            }
            this.updateNextPosToSearchFrom(ret, chunks);
        } else if (chunks == 1 || this.freeList().isSet(this.nextPosToSearchFrom())) {
            this.updateNextPosToSearchFrom(ret, chunks);
        }
        return ret;
    }

    public void prevTier() {
        if (this.segmentTier() == 0) {
            throw new IllegalStateException("first tier doesn't have previous");
        }
        this.initSegmentTier(this.segmentTier() - 1, this.prevTierIndex());
    }

    public void goToFirstTier() {
        while (this.segmentTier() != 0) {
            this.prevTier();
        }
    }

    @Override
    public long alloc(int chunks) {
        long ret = this.allocReturnCode(chunks);
        if (ret >= 0L) {
            return ret;
        }
        int alreadyAttemptedTier = !this.forcedOldDeletedEntriesCleanup() ? this.segmentTier() : -1;
        this.goToFirstTier();
        while (this.segmentTier() == alreadyAttemptedTier || (ret = this.allocReturnCode(chunks)) < 0L) {
            this.nextTier();
        }
        return ret;
    }

    @Override
    public boolean usedInit() {
        return this.used;
    }

    @Override
    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
    }

    public boolean replicatedInputBytesInit() {
        return this.replicatedInputBytes != null;
    }

    public void initReplicatedInputBytes(Bytes replicatedInputBytes) {
        this.replicatedInputBytes = replicatedInputBytes;
        this.replicatedInputStore.setBytes(replicatedInputBytes);
        this.closeReplicatedInputBytesDependants();
    }

    public Bytes replicatedInputBytes() {
        assert (this.replicatedInputBytesInit()) : "ReplicatedInputBytes should be init";
        return this.replicatedInputBytes;
    }

    public void closeReplicatedInputBytes() {
        if (!this.replicatedInputBytesInit()) {
            return;
        }
        this.closeReplicatedInputBytesDependants();
        this.replicatedInputBytes = null;
    }

    public void closeReplicatedInputBytesDependants() {
        this.replicatedInputKeyBytesValue.closeReplicatedInputKeyBytesDataGetUsingDependants();
        this.replicatedInputValueBytesValue.closeReplicatedInputValueBytesDataGetUsingDependants();
    }

    boolean inputKeyInit() {
        return this.inputKey != null;
    }

    @Override
    public void initInputKey(Data<K> inputKey) {
        this.inputKey = inputKey;
        this.closeInputKeyDependants();
    }

    public Data<K> inputKey() {
        assert (this.inputKeyInit()) : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!this.inputKeyInit()) {
            return;
        }
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
    }

    public boolean keyHashInit() {
        return this.keyHash != 0L;
    }

    void initKeyHash() {
        this.keyHash = this.inputKey().hash(LongHashFunction.city_1_1());
    }

    public long keyHash() {
        if (!this.keyHashInit()) {
            this.initKeyHash();
        }
        return this.keyHash;
    }

    public void closeKeyHash() {
        if (!this.keyHashInit()) {
            return;
        }
        this.keyHash = 0L;
    }

    @Override
    public long keyHashCode() {
        return this.keyHash();
    }

    public boolean posInit() {
        return this.pos != -1L;
    }

    public void initPos(long pos) {
        this.pos = pos;
        this.closePosDependants();
    }

    public long pos() {
        assert (this.posInit()) : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!this.posInit()) {
            return;
        }
        this.closePosDependants();
        this.pos = -1L;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
        this.closeReplicatedMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void dropChange() {
        ((ReplicatedChronicleMap)this.m()).dropChange(this.tierIndex(), this.pos());
    }

    public boolean changed() {
        return ((ReplicatedChronicleMap)this.m()).isChanged(this.tierIndex(), this.pos());
    }

    public boolean entryOffsetInit() {
        return this.keySizeOffset != -1L;
    }

    public void initEntryOffset() {
        this.keySizeOffset = this.entrySpaceOffset() + this.pos() * this.h().chunkSize;
        this.segmentBytes().limit(this.segmentBytes().capacity());
        this.closeEntryOffsetDependants();
    }

    public long keySizeOffset() {
        if (!this.entryOffsetInit()) {
            this.initEntryOffset();
        }
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!this.entryOffsetInit()) {
            return;
        }
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1L;
    }

    public void closeEntryOffsetDependants() {
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
        this.closeReplicatedMapEntryStagesReadExistingEntryDependants();
    }

    public void readExistingEntry(long pos) {
        this.initPos(pos);
        this.segmentBytes().position(this.keySizeOffset());
        this.initKeySize(this.h().keySizeMarshaller.readSize((Bytes)this.segmentBytes()));
        this.initKeyOffset(this.segmentBytes().position());
    }

    public void closeReplicatedMapEntryStagesReadExistingEntryDependants() {
        this.closeKeySearch();
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset() + (oldKeyAddr - oldKeySizeAddr));
        Access.copy((ReadAccess)Access.nativeAccess(), null, (long)oldKeySizeAddr, (WriteAccess)Access.checkedBytesStoreAccess(), (Object)this.segmentBS(), (long)this.keySizeOffset(), (long)bytesToCopy);
    }

    public boolean keyOffsetInit() {
        return this.keyOffset != -1L;
    }

    public void initKeyOffset(long keyOffset) {
        this.keyOffset = keyOffset;
        this.closeKeyOffsetDependants();
    }

    public long keyOffset() {
        assert (this.keyOffsetInit()) : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!this.keyOffsetInit()) {
            return;
        }
        this.closeKeyOffsetDependants();
        this.keyOffset = -1L;
    }

    public void closeKeyOffsetDependants() {
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeReplicatedMapEntryStagesKeyEndDependants() {
        this.closeReplicatedMapEntryStagesCountValueSizeOffsetDependants();
        this.closeReplicationState();
        this.closeReplicatedMapEntryStagesEntryEndDependants();
    }

    long countValueSizeOffset() {
        return this._MapEntryStages_countValueSizeOffset() + 10L;
    }

    public void closeReplicatedMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public boolean valueSizeOffsetInit() {
        return this.valueSizeOffset != -1L;
    }

    void initValueSizeOffset() {
        this.valueSizeOffset = this.countValueSizeOffset();
        this.closeValueSizeOffsetDependants();
    }

    public long valueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            this.initValueSizeOffset();
        }
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            return;
        }
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1L;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValueSize();
    }

    public boolean valueSizeInit() {
        return this.valueSize != -1L;
    }

    void initValueSize() {
        this.segmentBytes().position(this.valueSizeOffset());
        this.valueSize = this.m().readValueSize((Bytes)this.segmentBytes());
        this.countValueOffset();
        this.closeValueSizeDependants();
    }

    void initValueSize(long valueSize) {
        this.valueSize = valueSize;
        this.segmentBytes().position(this.valueSizeOffset());
        ((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.writeSize((Bytes)this.segmentBytes(), valueSize);
        this.countValueOffset();
        this.closeValueSizeDependants();
    }

    void initValueSize_EqualToOld(long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        this.valueSize = oldValueSize;
        this.valueOffset = this.valueSizeOffset() + (oldValueOffset - oldValueSizeOffset);
        this.closeValueSizeDependants();
    }

    public long valueOffset() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueSize;
    }

    public void closeValueSize() {
        if (!this.valueSizeInit()) {
            return;
        }
        this.closeValueSizeDependants();
        this.valueSize = -1L;
    }

    public void closeValueSizeDependants() {
        this.closeReplicatedMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    public void writeValue(Data<?> value) {
        value.writeTo((RandomDataOutput)this.segmentBS(), this.valueOffset());
    }

    public void initValue_WithoutSize(Data<?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        assert (oldValueSize == value.size());
        this.initValueSize_EqualToOld(oldValueSizeOffset, oldValueSize, oldValueOffset);
        this.writeValue(value);
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset() + (long)((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.sizeEncodingSize(newValue.size()) - this.keySizeOffset();
    }

    public void initValue(Data<?> value) {
        this.segmentBytes().position(this.valueSizeOffset());
        this.initValueSize(value.size());
        this.writeValue(value);
    }

    public boolean replicationStateInit() {
        return this.replicationBytesOffset != -1L;
    }

    void initReplicationState() {
        this.replicationBytesOffset = this.keyEnd();
    }

    public long replicationBytesOffset() {
        if (!this.replicationStateInit()) {
            this.initReplicationState();
        }
        return this.replicationBytesOffset;
    }

    public void closeReplicationState() {
        if (!this.replicationStateInit()) {
            return;
        }
        this.replicationBytesOffset = -1L;
    }

    void updateReplicationState(long timestamp, byte identifier) {
        this.segmentBytes().position(this.replicationBytesOffset());
        this.segmentBytes().writeLong(timestamp);
        this.segmentBytes().writeByte(identifier);
    }

    public void updatedReplicationStateOnAbsentEntry() {
        if (!this.replicationUpdateInit()) {
            this.innerWriteLock.lock();
            this.updateReplicationState(((ReplicatedChronicleMap)this.m()).timeProvider.currentTime(), ((ReplicatedChronicleMap)this.m()).identifier());
        }
    }

    public long timestamp() {
        return this.segmentBS().readLong(this.replicationBytesOffset());
    }

    public void raiseChange() {
        ((ReplicatedChronicleMap)this.m()).raiseChange(this.tierIndex(), this.pos(), this.timestamp());
    }

    public void updateChange() {
        if (!this.replicationUpdateInit()) {
            this.raiseChange();
        }
    }

    public void moveChange(long oldTierIndex, long oldPos, long newPos) {
        ((ReplicatedChronicleMap)this.m()).moveChange(oldTierIndex, oldPos, this.tierIndex(), newPos, this.timestamp());
    }

    private long entryDeletedOffset() {
        return this.replicationBytesOffset() + 9L;
    }

    public void writeEntryDeleted() {
        this.segmentBS().writeBoolean(this.entryDeletedOffset(), true);
    }

    public void writeEntryPresent() {
        this.segmentBS().writeBoolean(this.entryDeletedOffset(), false);
    }

    public boolean entryDeleted() {
        return this.segmentBS().readBoolean(this.entryDeletedOffset());
    }

    @Override
    public void doRemoveCompletely() {
        boolean wasDeleted = this.entryDeleted();
        this._MapQuery_doRemove();
        if (wasDeleted) {
            this.deleted(this.deleted() - 1L);
        }
    }

    private long timestampOffset() {
        return this.replicationBytesOffset();
    }

    private long identifierOffset() {
        return this.replicationBytesOffset() + 8L;
    }

    byte identifier() {
        return this.segmentBS().readByte(this.identifierOffset());
    }

    public void updatedReplicationStateOnPresentEntry() {
        if (!this.replicationUpdateInit()) {
            this.innerWriteLock.lock();
            long timestamp = this.identifier() != ((ReplicatedChronicleMap)this.m()).identifier() ? Math.max(this.timestamp() + 1L, ((ReplicatedChronicleMap)this.m()).timeProvider.currentTime()) : ((ReplicatedChronicleMap)this.m()).timeProvider.currentTime();
            this.updateReplicationState(timestamp, ((ReplicatedChronicleMap)this.m()).identifier());
        }
    }

    protected long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeReplicatedMapEntryStagesEntryEndDependants() {
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
    }

    long entrySize() {
        return this.checksumStrategy.extraEntryBytes() + this.entryEnd() - this.keySizeOffset();
    }

    public void closeReplicatedMapEntryStagesEntrySizeDependants() {
        this.closeEntrySizeInChunks();
    }

    public boolean entrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            this.initEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeEntrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            return;
        }
        this.entrySizeInChunks = 0;
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.free(this.pos(), this.entrySizeInChunks());
        this.entries(this.entries() - 1L);
        this.incrementModCountGuarded();
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        this.segmentBytes().position(this.keySizeOffset());
        this.h().keySizeMarshaller.writeSize((Bytes)this.segmentBytes(), this.keySize());
        this.initKeyOffset(this.segmentBytes().position());
        key.writeTo((RandomDataOutput)this.segmentBS(), this.keyOffset());
    }

    boolean keyEquals() {
        return this.inputKey().size() == this.keySize() && BytesUtil.bytesEqual((RandomDataInput)this.segmentBS(), (long)this.keyOffset(), (RandomDataInput)this.inputKey().bytes(), (long)this.inputKey().offset(), (long)this.keySize());
    }

    public void closeKeySearchKeyEqualsDependants() {
        this.closeKeySearch();
    }

    boolean keySearchInit() {
        return this.searchState != null;
    }

    public void initKeySearch() {
        long pos;
        while ((pos = this.nextPos()) >= 0L) {
            if (!this.inputKeyInit()) continue;
            this.readExistingEntry(pos);
            if (!this.keyEquals()) continue;
            this.found();
            this.keyFound();
            return;
        }
        this.searchState = SearchState.ABSENT;
        this.closeKeySearchDependants();
    }

    public SearchState searchState() {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        return this.searchState;
    }

    void closeKeySearch() {
        if (!this.keySearchInit()) {
            return;
        }
        this.closeKeySearchDependants();
        this.searchState = null;
    }

    public void closeKeySearchDependants() {
        this.closeReplicatedMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
        this.closeKeySearchSearchStatePresentDependants();
    }

    public void incrementSegmentEntriesIfNeeded() {
        if (this.searchState() != SearchState.PRESENT) {
            this.entries(this.entries() + 1L);
        }
    }

    public void dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed() {
        if (this.locksInit() && this.concurrentSameThreadContexts() && this.rootContextOnThisSegment().latestSameThreadSegmentModCount() != this.contextModCount() && this.keySearchInit() && this.searchState() == SearchState.PRESENT && !this.checkSlotContainsExpectedKeyAndValue(this.pos())) {
            this.closeHashLookupPos();
        }
    }

    public void closeReplicatedMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed();
    }

    public void closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    public void dropChanged() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.dropChange();
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.replaceValue(entry, newValue);
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    public Data<K> queriedKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    public Data<V> wrapValueAsData(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceData wrapped = this.wrappedValueInstanceValue;
        wrapped = wrapped.getUnusedWrappedValueGuarded();
        wrapped.initValue(value);
        return wrapped;
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    public void raiseChanged() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.raiseChange();
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @Override
    public boolean isChanged() {
        this.checkOnEachPublicOperation();
        this.innerReadLock.lock();
        return this.changed();
    }

    @Override
    @NotNull
    public MapContext<K, V, ?> context() {
        this.checkOnEachPublicOperation();
        return this;
    }

    @Override
    public Data<V> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).defaultValueProvider.defaultValue(absentEntry);
    }

    @Override
    public long originTimestamp() {
        this.checkOnEachPublicOperation();
        return this.timestamp();
    }

    @Override
    public byte originIdentifier() {
        this.checkOnEachPublicOperation();
        return this.identifier();
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.remove(entry);
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @Override
    @NotNull
    public Data<K> absentKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    public void updateOrigin(byte newIdentifier, long newTimestamp) {
        this.checkOnEachPublicOperation();
        this.innerWriteLock.lock();
        this.updateReplicationState(newTimestamp, newIdentifier);
    }

    @Override
    @NotNull
    public Data<V> defaultValue() {
        this.checkOnEachPublicOperation();
        if (((ReplicatedChronicleMap)this.m()).constantValueProvider == null) {
            throw new IllegalStateException("to call acquireUsing(), or defaultValue() on AbsentEntry, you should configure ChronicleMapBuilder.defaultValue(), or use one of the 'known' value types: boxed primitives, or so-called data-value-generated interface as a value");
        }
        return this.context().wrapValueAsData(((ReplicatedChronicleMap)this.m()).constantValueProvider.defaultValue());
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.insert(absentEntry, value);
    }

    public boolean searchStateDeleted() {
        return this.searchState() == SearchState.DELETED && !this.concurrentSameThreadContexts() && this.innerUpdateLock.isHeldByCurrentThread();
    }

    public boolean searchStatePresent() {
        return this.searchState() == SearchState.PRESENT;
    }

    public void closeKeySearchSearchStatePresentDependants() {
        this.closeReplicatedMapQueryTieredEntryPresentDependants();
        this.closePresenceOfEntry();
    }

    private boolean tieredEntryPresent() {
        int firstTier;
        block5: {
            firstTier = this.segmentTier();
            long firstTierBaseAddr = this.segmentBaseAddr();
            do {
                if (this.hasNextTier()) {
                    this.nextTier();
                } else if (this.segmentTier() != 0) {
                    this.initSegmentTier();
                }
                if (this.segmentBaseAddr() == firstTierBaseAddr) break block5;
            } while (!this.searchStatePresent());
            return true;
        }
        if (firstTier != 0) {
            this.initSegmentTier();
        }
        return false;
    }

    public void closeReplicatedMapQueryTieredEntryPresentDependants() {
        this.closePresenceOfEntry();
    }

    public boolean searchStateAbsent() {
        return !this.searchStatePresent() && !this.searchStateDeleted();
    }

    protected void putPrefix() {
        boolean searchResultsNotTrusted;
        boolean underUpdatedLockIsHeld;
        this.checkOnEachPublicOperation();
        boolean bl = underUpdatedLockIsHeld = !this.innerUpdateLock.isHeldByCurrentThread();
        if (underUpdatedLockIsHeld) {
            this.innerUpdateLock.lock();
        }
        boolean bl2 = searchResultsNotTrusted = underUpdatedLockIsHeld || this.concurrentSameThreadContexts();
        if (this.hashLookupPosInit() && this.searchStateAbsent() && searchResultsNotTrusted) {
            this.closeHashLookupPos();
        }
    }

    public void putNewVolatile(long value) {
        assert (!this.searchStatePresent());
        this.hl().checkValueForPut(value);
        long currentEntry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        this.hl().writeEntryVolatile(this.addr(), this.hashLookupPos(), currentEntry, this.searchKey(), value);
    }

    public boolean presenceOfEntryInit() {
        return this.entryPresence != null;
    }

    public void initPresenceOfEntry(EntryPresence entryPresence) {
        this.entryPresence = entryPresence;
    }

    private void initPresenceOfEntry() {
        this.entryPresence = this.searchStatePresent() || this.tieredEntryPresent() ? EntryPresence.PRESENT : EntryPresence.ABSENT;
    }

    public EntryPresence entryPresence() {
        if (!this.presenceOfEntryInit()) {
            this.initPresenceOfEntry();
        }
        return this.entryPresence;
    }

    public void closePresenceOfEntry() {
        if (!this.presenceOfEntryInit()) {
            return;
        }
        this.entryPresence = null;
    }

    public boolean entryPresent() {
        return this._MapQuery_entryPresent() && !this.entryDeleted();
    }

    @Override
    @Nullable
    public MapAbsentEntry<K, V> absentEntry() {
        this.checkOnEachPublicOperation();
        if (this.entryPresent()) {
            return null;
        }
        if (!this.searchStatePresent()) {
            return this.absentDelegating;
        }
        assert (this.entryDeleted());
        return this.absent();
    }

    @Override
    public MapReplicableEntry<K, V> entry() {
        return (MapReplicableEntry)this._MapQuery_entry();
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!this.allocatedChunksInit()) {
            return;
        }
        this.allocatedChunks = 0;
    }

    public boolean initEntryAndKeyCopying(long entrySize, long bytesToCopy) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.incrementSegmentEntriesIfNeeded();
        long oldSegmentTierBaseAddr = this.segmentBaseAddr();
        long oldKeySizeAddr = oldSegmentTierBaseAddr + this.keySizeOffset();
        long oldKeyAddr = oldSegmentTierBaseAddr + this.keyOffset();
        int tierBeforeAllocation = this.segmentTier();
        long pos = this.alloc(this.allocatedChunks());
        this.copyExistingEntry(pos, bytesToCopy, oldKeyAddr, oldKeySizeAddr);
        return this.segmentTier() != tierBeforeAllocation;
    }

    public final void freeExtraAllocatedChunks() {
        if (!((ReplicatedChronicleMap)this.m()).constantlySizedEntry && ((ReplicatedChronicleMap)this.m()).couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.free(this.pos() + (long)this.entrySizeInChunks(), this.allocatedChunks() - this.entrySizeInChunks());
        } else {
            this.initEntrySizeInChunks(this.allocatedChunks());
        }
    }

    public void writeValueAndPutPos(Data<V> value) {
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putValueVolatile(this.pos());
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        long oldPos = this.pos();
        long oldTierIndex = this.tierIndex();
        this._MapEntryStages_relocation(newValue, newSizeOfEverythingBeforeValue);
        this.moveChange(oldTierIndex, oldPos, this.pos());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap m = this.m();
            int newSizeInChunks = m.inChunks(newEntrySize = (newValueOffset = m.alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue)) + newValue.size() - entryStartOffset);
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.freeList().isRangeClear(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
                this.freeList().setRange(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks);
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeList().clearRange(this.pos() + (long)newSizeInChunks, this.pos() + (long)this.entrySizeInChunks());
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
            return;
        }
        this.writeValue(newValue);
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        if (this.entryPresent()) {
            if (this.valueSize() > this.dummyValue.size()) {
                this.innerDefaultReplaceValue(this.dummyValue);
            }
        } else {
            throw new IllegalStateException("Entry is absent in the map when doRemove() is called");
        }
        this.updatedReplicationStateOnPresentEntry();
        this.writeEntryDeleted();
        this.updateChange();
        this.checksumStrategy.computeAndStoreChecksum();
        this.deleted(this.deleted() + 1L);
    }

    public void doReplaceValueWithoutChecksum(Data<V> newValue) {
        this.putPrefix();
        if (!this.entryPresent()) {
            throw new IllegalStateException("Entry is absent in the map when doReplaceValue() is called");
        }
        this.innerDefaultReplaceValue(newValue);
        this.incrementModCountGuarded();
        this.setSearchStateGuarded(SearchState.PRESENT);
        this.initPresenceOfEntry(EntryPresence.PRESENT);
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.doReplaceValueWithoutChecksum(newValue);
        this.updateChange();
        this.updatedReplicationStateOnPresentEntry();
        this.checksumStrategy.computeAndStoreChecksum();
    }

    public boolean initEntryAndKey(long entrySize) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.incrementSegmentEntriesIfNeeded();
        int tierBeforeAllocation = this.segmentTier();
        long pos = this.alloc(this.allocatedChunks());
        this.writeNewEntry(pos, this.inputKey());
        return this.segmentTier() != tierBeforeAllocation;
    }

    void putEntry(Data<V> value) {
        assert (this.searchStateAbsent());
        long entrySize = this.entrySize(this.inputKey().size(), value.size());
        this.initEntryAndKey(entrySize);
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putNewVolatile(this.pos());
    }

    @Override
    public void doInsert(Data<V> value) {
        this.putPrefix();
        if (!this.entryPresent()) {
            if (!this.searchStatePresent()) {
                this.putEntry(value);
                this.setSearchStateGuarded(SearchState.PRESENT);
                this.initPresenceOfEntry(EntryPresence.PRESENT);
            } else {
                this.innerDefaultReplaceValue(value);
                this.deleted(this.deleted() - 1L);
            }
        } else {
            throw new IllegalStateException("Entry is absent in the map when doInsert() is called");
        }
        this.incrementModCountGuarded();
        this.writeEntryPresent();
        this.updateChange();
        this.updatedReplicationStateOnAbsentEntry();
        this.checksumStrategy.computeAndStoreChecksum();
    }

    public boolean replicationUpdateInit() {
        return this.innerRemoteIdentifier != 0;
    }

    public void initReplicationUpdate(long timestamp, byte identifier) {
        this.innerRemoteTimestamp = timestamp;
        if (identifier == 0) {
            throw new IllegalStateException("identifier can't be 0");
        }
        this.innerRemoteIdentifier = identifier;
    }

    public byte innerRemoteIdentifier() {
        assert (this.replicationUpdateInit()) : "ReplicationUpdate should be init";
        return this.innerRemoteIdentifier;
    }

    public long innerRemoteTimestamp() {
        assert (this.replicationUpdateInit()) : "ReplicationUpdate should be init";
        return this.innerRemoteTimestamp;
    }

    public void closeReplicationUpdate() {
        if (!this.replicationUpdateInit()) {
            return;
        }
        this.innerRemoteIdentifier = 0;
    }

    @Override
    public long remoteTimestamp() {
        this.checkOnEachPublicOperation();
        return this.innerRemoteTimestamp();
    }

    @Override
    public byte remoteIdentifier() {
        this.checkOnEachPublicOperation();
        return this.innerRemoteIdentifier();
    }

    public boolean replicationInputInit() {
        return this.riKeySize != -1L;
    }

    public void initReplicationInput(Bytes replicatedInputBytes) {
        this.initReplicatedInputBytes(replicatedInputBytes);
        this.bootstrapTimestamp = replicatedInputBytes.readLong();
        this.riKeySize = ((ReplicatedChronicleMap)this.m()).keySizeMarshaller.readSize(replicatedInputBytes);
        this.riValueSize = ((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.readSize(replicatedInputBytes);
        this.riTimestamp = replicatedInputBytes.readStopBit();
        this.riId = replicatedInputBytes.readByte();
        this.initReplicationUpdate(this.riTimestamp, this.riId);
        this.isDeleted = replicatedInputBytes.readBoolean();
        this.riKeyOffset = replicatedInputBytes.position();
        this.riValueOffset = this.riKeyOffset + this.riKeySize;
        this.closeReplicationInputDependants();
    }

    public boolean isDeleted() {
        assert (this.replicationInputInit()) : "ReplicationInput should be init";
        return this.isDeleted;
    }

    public byte riId() {
        assert (this.replicationInputInit()) : "ReplicationInput should be init";
        return this.riId;
    }

    public long bootstrapTimestamp() {
        assert (this.replicationInputInit()) : "ReplicationInput should be init";
        return this.bootstrapTimestamp;
    }

    public long riKeyOffset() {
        assert (this.replicationInputInit()) : "ReplicationInput should be init";
        return this.riKeyOffset;
    }

    public long riKeySize() {
        assert (this.replicationInputInit()) : "ReplicationInput should be init";
        return this.riKeySize;
    }

    public long riValueOffset() {
        assert (this.replicationInputInit()) : "ReplicationInput should be init";
        return this.riValueOffset;
    }

    public long riValueSize() {
        assert (this.replicationInputInit()) : "ReplicationInput should be init";
        return this.riValueSize;
    }

    public void closeReplicationInput() {
        if (!this.replicationInputInit()) {
            return;
        }
        this.closeReplicationInputDependants();
        this.riKeySize = -1L;
    }

    public void closeReplicationInputDependants() {
        this.replicatedInputKeyBytesValue.closeReplicatedInputKeyBytesDataSizeDependants();
        this.replicatedInputValueBytesValue.closeReplicatedInputValueBytesDataSizeDependants();
        this.replicatedInputKeyBytesValue.closeReplicatedInputKeyBytesDataGetUsingDependants();
        this.replicatedInputValueBytesValue.closeReplicatedInputValueBytesDataGetUsingDependants();
    }

    public void processReplicatedEvent() {
        if (this.riId() == ((ReplicatedChronicleMap)this.m()).identifier()) {
            return;
        }
        ((ReplicatedChronicleMap)this.m()).setLastModificationTime(this.riId(), this.bootstrapTimestamp());
        this.initInputKey(this.replicatedInputKeyBytesValue);
        boolean debugEnabled = LOG.isDebugEnabled();
        this.innerUpdateLock.lock();
        if (this.isDeleted()) {
            if (debugEnabled) {
                LOG.debug("READING FROM SOURCE -  into local-id={}, remote={}, remove(key={})", new Object[]{((ReplicatedChronicleMap)this.m()).identifier(), this.riId(), this.inputKey()});
            }
            ((ReplicatedChronicleMap)this.m()).remoteOperations.remove(this);
            return;
        }
        String message = null;
        if (debugEnabled) {
            message = String.format("READING FROM SOURCE -  into local-id=%d, remote-id=%d, put(key=%s,", ((ReplicatedChronicleMap)this.m()).identifier(), this.riId(), this.inputKey());
        }
        ((ReplicatedChronicleMap)this.m()).remoteOperations.put(this, this.replicatedInputValueBytesValue);
        if (debugEnabled) {
            LOG.debug(message + "value=" + this.replicatedInputValueBytesValue + ")");
        }
    }

    public boolean inputBytesInit() {
        return this.inputBytes != null;
    }

    public void initInputBytes(Bytes inputBytes) {
        this.inputBytes = inputBytes;
        this.inputStore.setBytes(inputBytes);
        this.closeInputBytesDependants();
    }

    public Bytes inputBytes() {
        assert (this.inputBytesInit()) : "InputBytes should be init";
        return this.inputBytes;
    }

    public void closeInputBytes() {
        if (!this.inputBytesInit()) {
            return;
        }
        this.closeInputBytesDependants();
        this.inputBytes = null;
    }

    public void closeInputBytesDependants() {
        this.closeInputKeyOffsets();
        this.closeFirstInputValueOffsets();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesDataGetUsingDependants();
        this.inputKeyBytesValue.closeInputKeyBytesDataGetUsingDependants();
        this.closeSecondInputValueOffsets();
        this.inputSecondValueBytesValue.closeInputSecondValueBytesDataGetUsingDependants();
    }

    public boolean inputKeyOffsetsInit() {
        return this.inputKeySize != -1L;
    }

    private void initInputKeyOffsets() {
        this.inputKeySize = this.h().keySizeMarshaller.readSize(this.inputBytes());
        this.inputKeyOffset = this.inputBytes().position();
        this.closeInputKeyOffsetsDependants();
    }

    public long inputKeyOffset() {
        if (!this.inputKeyOffsetsInit()) {
            this.initInputKeyOffsets();
        }
        return this.inputKeyOffset;
    }

    public long inputKeySize() {
        if (!this.inputKeyOffsetsInit()) {
            this.initInputKeyOffsets();
        }
        return this.inputKeySize;
    }

    public void closeInputKeyOffsets() {
        if (!this.inputKeyOffsetsInit()) {
            return;
        }
        this.closeInputKeyOffsetsDependants();
        this.inputKeySize = -1L;
    }

    public void closeInputKeyOffsetsDependants() {
        this.closeFirstInputValueOffsets();
        this.inputKeyBytesValue.closeInputKeyBytesDataSizeDependants();
        this.inputKeyBytesValue.closeInputKeyBytesDataGetUsingDependants();
    }

    public boolean firstInputValueOffsetsInit() {
        return this.firstInputValueSize != -1L;
    }

    private void initFirstInputValueOffsets() {
        this.inputBytes().position(this.inputKeyOffset() + this.inputKeySize());
        this.firstInputValueSize = ((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.readSize(this.inputBytes());
        this.firstInputValueOffset = this.inputBytes().position();
        this.closeFirstInputValueOffsetsDependants();
    }

    public long firstInputValueOffset() {
        if (!this.firstInputValueOffsetsInit()) {
            this.initFirstInputValueOffsets();
        }
        return this.firstInputValueOffset;
    }

    public long firstInputValueSize() {
        if (!this.firstInputValueOffsetsInit()) {
            this.initFirstInputValueOffsets();
        }
        return this.firstInputValueSize;
    }

    public void closeFirstInputValueOffsets() {
        if (!this.firstInputValueOffsetsInit()) {
            return;
        }
        this.closeFirstInputValueOffsetsDependants();
        this.firstInputValueSize = -1L;
    }

    public void closeFirstInputValueOffsetsDependants() {
        this.closeSecondInputValueOffsets();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesDataSizeDependants();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesDataGetUsingDependants();
    }

    public boolean secondInputValueOffsetsInit() {
        return this.secondInputValueSize != -1L;
    }

    private void initSecondInputValueOffsets() {
        this.inputBytes().position(this.firstInputValueOffset() + this.firstInputValueSize());
        this.secondInputValueSize = ((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.readSize(this.inputBytes());
        this.secondInputValueOffset = this.inputBytes().position();
        this.closeSecondInputValueOffsetsDependants();
    }

    public long secondInputValueOffset() {
        if (!this.secondInputValueOffsetsInit()) {
            this.initSecondInputValueOffsets();
        }
        return this.secondInputValueOffset;
    }

    public long secondInputValueSize() {
        if (!this.secondInputValueOffsetsInit()) {
            this.initSecondInputValueOffsets();
        }
        return this.secondInputValueSize;
    }

    public void closeSecondInputValueOffsets() {
        if (!this.secondInputValueOffsetsInit()) {
            return;
        }
        this.closeSecondInputValueOffsetsDependants();
        this.secondInputValueSize = -1L;
    }

    public void closeSecondInputValueOffsetsDependants() {
        this.inputSecondValueBytesValue.closeInputSecondValueBytesDataSizeDependants();
        this.inputSecondValueBytesValue.closeInputSecondValueBytesDataGetUsingDependants();
    }

    public class UsingReturnValue
    implements UsableReturnValue<V> {
        private V usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINT;
        private V returnedValue = null;

        @Override
        public void returnValue(@NotNull Data<V> value) {
            this.initReturnedValue(value);
        }

        public boolean usingReturnValueInit() {
            return this.usingReturnValue != UsableReturnValue.USING_RETURN_VALUE_UNINT;
        }

        @Override
        public void initUsingReturnValue(V usingReturnValue) {
            this.usingReturnValue = usingReturnValue;
            this.closeUsingReturnValueDependants();
        }

        public V usingReturnValue() {
            assert (this.usingReturnValueInit()) : "UsingReturnValue should be init";
            return this.usingReturnValue;
        }

        public void closeUsingReturnValue() {
            if (!this.usingReturnValueInit()) {
                return;
            }
            this.closeUsingReturnValueDependants();
            this.usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINT;
        }

        public void closeUsingReturnValueDependants() {
            this.closeReturnedValue();
        }

        boolean returnedValueInit() {
            return this.returnedValue != null;
        }

        private void initReturnedValue(@NotNull Data<V> value) {
            this.returnedValue = value.getUsing(this.usingReturnValue());
        }

        public V returnedValue() {
            assert (this.returnedValueInit()) : "ReturnedValue should be init";
            return this.returnedValue;
        }

        public void closeReturnedValue() {
            if (!this.returnedValueInit()) {
                return;
            }
            this.returnedValue = null;
        }

        @Override
        public V returnValue() {
            if (this.returnedValueInit()) {
                return this.returnedValue();
            }
            return null;
        }
    }

    public class InputValueInstanceData
    extends CopyingInstanceData<V>
    implements ValueInitializableData<V> {
        private V value = null;
        private boolean marshalled = false;
        private DirectBytes buffer;

        public boolean valueInit() {
            return this.value != null;
        }

        @Override
        public void initValue(V value) {
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        @Override
        public V instance() {
            return this.value();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mvi = CompiledReplicatedMapQueryContext.this.valueMetaInterop(this.value());
            long size = mvi.size(CompiledReplicatedMapQueryContext.this.valueInterop, this.value());
            this.buffer = this.getBuffer(this.buffer, size);
            mvi.write(CompiledReplicatedMapQueryContext.this.valueInterop, (Bytes)this.buffer, this.value());
            this.buffer.flip();
            this.marshalled = true;
        }

        @Override
        public DirectBytes buffer() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buffer;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public V getUsing(V usingValue) {
            this.buffer().position(0L);
            return CompiledReplicatedMapQueryContext.this.valueReader.read((Bytes)this.buffer(), this.buffer().limit(), usingValue);
        }
    }

    public class InputKeyInstanceData
    extends CopyingInstanceData<K>
    implements KeyInitableData<K> {
        private K key = null;
        private boolean marshalled = false;
        private DirectBytes buffer;

        public boolean keyInit() {
            return this.key != null;
        }

        @Override
        public void initKey(K key) {
            this.key = key;
            this.closeKeyDependants();
        }

        public K key() {
            assert (this.keyInit()) : "Key should be init";
            return this.key;
        }

        public void closeKey() {
            if (!this.keyInit()) {
                return;
            }
            this.closeKeyDependants();
            this.key = null;
        }

        public void closeKeyDependants() {
            this.closeBuffer();
        }

        @Override
        public K instance() {
            return this.key();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mki = CompiledReplicatedMapQueryContext.this.keyMetaInterop(this.key());
            long size = mki.size(CompiledReplicatedMapQueryContext.this.keyInterop, this.key());
            this.buffer = this.getBuffer(this.buffer, size);
            mki.write(CompiledReplicatedMapQueryContext.this.keyInterop, (Bytes)this.buffer, this.key());
            this.buffer.flip();
            this.marshalled = true;
        }

        @Override
        public DirectBytes buffer() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buffer;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public K getUsing(K usingKey) {
            this.buffer().position(0L);
            return CompiledReplicatedMapQueryContext.this.keyReader.read((Bytes)this.buffer(), this.buffer().limit(), usingKey);
        }
    }

    public class DefaultReturnValue
    implements InstanceReturnValue<V> {
        private V defaultReturnedValue = null;

        @Override
        public void returnValue(@NotNull Data<V> value) {
            this.initDefaultReturnedValue(value);
        }

        boolean defaultReturnedValueInit() {
            return this.defaultReturnedValue != null;
        }

        private void initDefaultReturnedValue(@NotNull Data<V> value) {
            this.defaultReturnedValue = value.getUsing(null);
        }

        public V defaultReturnedValue() {
            assert (this.defaultReturnedValueInit()) : "DefaultReturnedValue should be init";
            return this.defaultReturnedValue;
        }

        public void closeDefaultReturnedValue() {
            if (!this.defaultReturnedValueInit()) {
                return;
            }
            this.defaultReturnedValue = null;
        }

        @Override
        public V returnValue() {
            if (this.defaultReturnedValueInit()) {
                return this.defaultReturnedValue();
            }
            return null;
        }
    }

    private class CleanupAction
    implements Consumer<ReplicableEntry> {
        int removedCompletely;

        private CleanupAction() {
        }

        @Override
        public void accept(ReplicableEntry e) {
            VanillaChronicleMap map = CompiledReplicatedMapQueryContext.this.m();
            if (e instanceof MapAbsentEntry) {
                long deleteTimeout = ((ReplicatedChronicleMap)map).timeProvider.currentTime() - e.originTimestamp();
                ((ReplicatedChronicleMap)map).timeProvider.systemTimeIntervalBetween(e.originTimestamp(), ((ReplicatedChronicleMap)map).timeProvider.currentTime(), ((ReplicatedChronicleMap)map).cleanupTimeoutUnit);
                if (deleteTimeout > ((ReplicatedChronicleMap)map).cleanupTimeout && !e.isChanged()) {
                    e.doRemoveCompletely();
                    ++this.removedCompletely;
                }
            }
        }
    }

    public static enum SearchState {
        PRESENT,
        DELETED,
        ABSENT;

    }

    public static enum EntryPresence {
        PRESENT,
        ABSENT;

    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @NotNull
        private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
            return new IllegalStateException("Cannot acquire write lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public boolean tryLock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapQueryContext.this.updateZeroGuarded()) {
                            if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress())) {
                                CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                                CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledReplicatedMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapQueryContext.this.updateZeroGuarded());
                        if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                            CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapQueryContext.this.updateZeroGuarded()) {
                            if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                                CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledReplicatedMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapQueryContext.this.updateZeroGuarded());
                        if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                            CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapQueryContext.this.localLockState().write;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapQueryContext.this.updateZeroGuarded()) {
                            CompiledReplicatedMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledReplicatedMapQueryContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            CompiledReplicatedMapQueryContext.this.segmentHeader().writeLockInterruptibly(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        }
                    }
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapQueryContext.this.updateZeroGuarded());
                        CompiledReplicatedMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                    }
                    CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    int newTotalWriteLockCount = CompiledReplicatedMapQueryContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        CompiledReplicatedMapQueryContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalWriteLockCount > 0) : "write underflow";
                    break;
                }
            }
            CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapQueryContext.this.updateZeroGuarded()) {
                            CompiledReplicatedMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledReplicatedMapQueryContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            CompiledReplicatedMapQueryContext.this.segmentHeader().writeLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        }
                    }
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapQueryContext.this.updateZeroGuarded());
                        CompiledReplicatedMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                    }
                    CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }
    }

    public class WrappedValueInstanceData
    extends CopyingInstanceData<V> {
        private V value;
        private boolean marshalled = false;
        private DirectBytes buf;
        private WrappedValueInstanceData next;

        public WrappedValueInstanceData getUnusedWrappedValueGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValue();
        }

        public WrappedValueInstanceData getUnusedWrappedValue() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceData();
            }
            return this.next.getUnusedWrappedValue();
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            CompiledReplicatedMapQueryContext.this.m().checkValue(value);
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next != null) {
                this.next.closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        @Override
        public V instance() {
            return this.value();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mvi = CompiledReplicatedMapQueryContext.this.valueMetaInterop(this.value());
            long size = mvi.size(CompiledReplicatedMapQueryContext.this.valueInterop, this.value());
            this.buf = this.getBuffer(this.buf, size);
            mvi.write(CompiledReplicatedMapQueryContext.this.valueInterop, (Bytes)this.buf, this.value());
            this.buf.flip();
            this.marshalled = true;
        }

        public DirectBytes buf() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buf;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public V getUsing(V usingValue) {
            this.buf().position(0L);
            return CompiledReplicatedMapQueryContext.this.valueReader.read((Bytes)this.buf(), this.buf().limit(), usingValue);
        }

        @Override
        public DirectBytes buffer() {
            return this.buf();
        }

        boolean nextInit() {
            return true;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @NotNull
        private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
            return new IllegalStateException("Cannot acquire update lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapQueryContext.this.localLockState().update;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.updateZeroGuarded() && CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.updateZeroGuarded() && CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.updateZeroGuarded() && CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        CompiledReplicatedMapQueryContext.this.segmentHeader().updateLockInterruptibly(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                    }
                    CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    int newTotalUpdateLockCount = CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                    if (newTotalUpdateLockCount == 0) {
                        if (!CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) break;
                        CompiledReplicatedMapQueryContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalUpdateLockCount > 0) : "update underflow";
                    break;
                }
                case WRITE_LOCKED: {
                    int newTotalWriteLockCount = CompiledReplicatedMapQueryContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        if (!CompiledReplicatedMapQueryContext.this.updateZeroGuarded()) {
                            CompiledReplicatedMapQueryContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                            break;
                        }
                        CompiledReplicatedMapQueryContext.this.segmentHeader().downgradeWriteToReadLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalWriteLockCount > 0) : "write underflow";
                    break;
                }
            }
            CompiledReplicatedMapQueryContext.this.incrementReadGuarded();
            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapQueryContext.this.updateZeroGuarded() && CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        try {
                            CompiledReplicatedMapQueryContext.this.segmentHeader().updateLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        }
                        catch (RuntimeException e) {
                            LOG.error(CompiledReplicatedMapQueryContext.this.debugContextsAndLocksGuarded());
                            throw e;
                        }
                    }
                    CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }
    }

    public class ReplicatedMapAbsentDelegating
    implements MapAbsentEntry<K, V> {
        @Override
        @NotNull
        public Data<V> defaultValue() {
            return CompiledReplicatedMapQueryContext.this.defaultValue();
        }

        @Override
        @NotNull
        public Data<K> absentKey() {
            return CompiledReplicatedMapQueryContext.this.absentKey();
        }

        @Override
        @NotNull
        public MapContext<K, V, ?> context() {
            return CompiledReplicatedMapQueryContext.this.context();
        }

        @Override
        public void doInsert(Data<V> value) {
            CompiledReplicatedMapQueryContext.this.doInsert(value);
        }
    }

    public class ReplicatedInputValueBytesData
    extends AbstractData<V> {
        private V cachedBytesReplicatedInputValue;
        private boolean cachedBytesReplicatedInputValueRead = false;

        @Override
        public RandomDataInput bytes() {
            return CompiledReplicatedMapQueryContext.this.replicatedInputStore;
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.riValueSize();
        }

        public void closeReplicatedInputValueBytesDataSizeDependants() {
            this.closeReplicatedInputValueBytesDataGetUsingDependants();
        }

        @Override
        public V getUsing(V usingValue) {
            Bytes inputBytes = CompiledReplicatedMapQueryContext.this.replicatedInputBytes();
            inputBytes.position(CompiledReplicatedMapQueryContext.this.riValueOffset());
            return CompiledReplicatedMapQueryContext.this.valueReader.read(inputBytes, this.size(), usingValue);
        }

        public void closeReplicatedInputValueBytesDataGetUsingDependants() {
            this.closeCachedBytesReplicatedInputValue();
        }

        public boolean cachedBytesReplicatedInputValueInit() {
            return this.cachedBytesReplicatedInputValueRead;
        }

        private void initCachedBytesReplicatedInputValue() {
            this.cachedBytesReplicatedInputValue = this.getUsing(this.cachedBytesReplicatedInputValue);
            this.cachedBytesReplicatedInputValueRead = true;
        }

        public V cachedBytesReplicatedInputValue() {
            if (!this.cachedBytesReplicatedInputValueInit()) {
                this.initCachedBytesReplicatedInputValue();
            }
            return this.cachedBytesReplicatedInputValue;
        }

        public void closeCachedBytesReplicatedInputValue() {
            if (!this.cachedBytesReplicatedInputValueInit()) {
                return;
            }
            this.cachedBytesReplicatedInputValueRead = false;
        }

        @Override
        public V get() {
            return this.cachedBytesReplicatedInputValue();
        }

        @Override
        public long offset() {
            return CompiledReplicatedMapQueryContext.this.riValueOffset();
        }
    }

    public class ReplicatedInputKeyBytesData
    extends AbstractData<K> {
        private K cachedBytesReplicatedInputKey;
        private boolean cachedBytesReplicatedInputKeyRead = false;

        @Override
        public RandomDataInput bytes() {
            return CompiledReplicatedMapQueryContext.this.replicatedInputStore;
        }

        @Override
        public long offset() {
            return CompiledReplicatedMapQueryContext.this.riKeyOffset();
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.riKeySize();
        }

        public void closeReplicatedInputKeyBytesDataSizeDependants() {
            this.closeReplicatedInputKeyBytesDataGetUsingDependants();
        }

        @Override
        public K getUsing(K usingKey) {
            Bytes inputBytes = CompiledReplicatedMapQueryContext.this.replicatedInputBytes();
            inputBytes.position(CompiledReplicatedMapQueryContext.this.riKeyOffset());
            return CompiledReplicatedMapQueryContext.this.keyReader.read(inputBytes, this.size(), usingKey);
        }

        public void closeReplicatedInputKeyBytesDataGetUsingDependants() {
            this.closeCachedBytesReplicatedInputKey();
        }

        public boolean cachedBytesReplicatedInputKeyInit() {
            return this.cachedBytesReplicatedInputKeyRead;
        }

        private void initCachedBytesReplicatedInputKey() {
            this.cachedBytesReplicatedInputKey = this.getUsing((K)this.cachedBytesReplicatedInputKey);
            this.cachedBytesReplicatedInputKeyRead = true;
        }

        public K cachedBytesReplicatedInputKey() {
            if (!this.cachedBytesReplicatedInputKeyInit()) {
                this.initCachedBytesReplicatedInputKey();
            }
            return this.cachedBytesReplicatedInputKey;
        }

        public void closeCachedBytesReplicatedInputKey() {
            if (!this.cachedBytesReplicatedInputKeyInit()) {
                return;
            }
            this.cachedBytesReplicatedInputKeyRead = false;
        }

        @Override
        public K get() {
            return this.cachedBytesReplicatedInputKey();
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapQueryContext.this.localLockState().read;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (CompiledReplicatedMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledReplicatedMapQueryContext.this.readZeroGuarded() && CompiledReplicatedMapQueryContext.this.updateZeroGuarded() && CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                    CompiledReplicatedMapQueryContext.this.segmentHeader().readLockInterruptibly(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                }
                CompiledReplicatedMapQueryContext.this.incrementReadGuarded();
                CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public void lock() {
            if (CompiledReplicatedMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledReplicatedMapQueryContext.this.readZeroGuarded() && CompiledReplicatedMapQueryContext.this.updateZeroGuarded() && CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                    CompiledReplicatedMapQueryContext.this.segmentHeader().readLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                }
                CompiledReplicatedMapQueryContext.this.incrementReadGuarded();
                CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        public void closeReadLockLockDependants() {
            CompiledReplicatedMapQueryContext.this.closeHashLookupPos();
        }

        @Override
        public void unlock() {
            CompiledReplicatedMapQueryContext.this.readUnlockAndDecrementCountGuarded();
            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
            CompiledReplicatedMapQueryContext.this.closeHashLookupPos();
            CompiledReplicatedMapQueryContext.this.closePos();
        }

        @Override
        public boolean tryLock() {
            if (CompiledReplicatedMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledReplicatedMapQueryContext.this.readZeroGuarded() || !CompiledReplicatedMapQueryContext.this.updateZeroGuarded() || !CompiledReplicatedMapQueryContext.this.writeZeroGuarded() || CompiledReplicatedMapQueryContext.this.segmentHeader().tryReadLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress())) {
                    CompiledReplicatedMapQueryContext.this.incrementReadGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (CompiledReplicatedMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledReplicatedMapQueryContext.this.readZeroGuarded() || !CompiledReplicatedMapQueryContext.this.updateZeroGuarded() || !CompiledReplicatedMapQueryContext.this.writeZeroGuarded() || CompiledReplicatedMapQueryContext.this.segmentHeader().tryReadLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledReplicatedMapQueryContext.this.incrementReadGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public class InputSecondValueBytesData
    extends AbstractData<V> {
        private V cachedBytesInputSecondValue;
        private boolean cachedBytesInputSecondValueRead = false;

        @Override
        public RandomDataInput bytes() {
            return CompiledReplicatedMapQueryContext.this.inputStore;
        }

        @Override
        public long offset() {
            return CompiledReplicatedMapQueryContext.this.secondInputValueOffset();
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.secondInputValueSize();
        }

        public void closeInputSecondValueBytesDataSizeDependants() {
            this.closeInputSecondValueBytesDataGetUsingDependants();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledReplicatedMapQueryContext.this.inputBytes().position(CompiledReplicatedMapQueryContext.this.secondInputValueOffset());
            return CompiledReplicatedMapQueryContext.this.valueReader.read(CompiledReplicatedMapQueryContext.this.inputBytes(), this.size(), usingValue);
        }

        public void closeInputSecondValueBytesDataGetUsingDependants() {
            this.closeCachedBytesInputSecondValue();
        }

        public boolean cachedBytesInputSecondValueInit() {
            return this.cachedBytesInputSecondValueRead;
        }

        private void initCachedBytesInputSecondValue() {
            this.cachedBytesInputSecondValue = this.getUsing(this.cachedBytesInputSecondValue);
            this.cachedBytesInputSecondValueRead = true;
        }

        public V cachedBytesInputSecondValue() {
            if (!this.cachedBytesInputSecondValueInit()) {
                this.initCachedBytesInputSecondValue();
            }
            return this.cachedBytesInputSecondValue;
        }

        public void closeCachedBytesInputSecondValue() {
            if (!this.cachedBytesInputSecondValueInit()) {
                return;
            }
            this.cachedBytesInputSecondValueRead = false;
        }

        @Override
        public V get() {
            return this.cachedBytesInputSecondValue();
        }
    }

    public class InputKeyBytesData
    extends AbstractData<K> {
        private K cachedBytesInputKey;
        private boolean cachedBytesInputKeyRead = false;

        @Override
        public RandomDataInput bytes() {
            return CompiledReplicatedMapQueryContext.this.inputStore;
        }

        @Override
        public long offset() {
            return CompiledReplicatedMapQueryContext.this.inputKeyOffset();
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.inputKeySize();
        }

        public void closeInputKeyBytesDataSizeDependants() {
            this.closeInputKeyBytesDataGetUsingDependants();
        }

        @Override
        public K getUsing(K usingKey) {
            Bytes inputBytes = CompiledReplicatedMapQueryContext.this.inputBytes();
            inputBytes.position(CompiledReplicatedMapQueryContext.this.inputKeyOffset());
            return CompiledReplicatedMapQueryContext.this.keyReader.read(inputBytes, this.size(), usingKey);
        }

        public void closeInputKeyBytesDataGetUsingDependants() {
            this.closeCachedBytesInputKey();
        }

        public boolean cachedBytesInputKeyInit() {
            return this.cachedBytesInputKeyRead;
        }

        private void initCachedBytesInputKey() {
            this.cachedBytesInputKey = this.getUsing((K)this.cachedBytesInputKey);
            this.cachedBytesInputKeyRead = true;
        }

        public K cachedBytesInputKey() {
            if (!this.cachedBytesInputKeyInit()) {
                this.initCachedBytesInputKey();
            }
            return this.cachedBytesInputKey;
        }

        public void closeCachedBytesInputKey() {
            if (!this.cachedBytesInputKeyInit()) {
                return;
            }
            this.cachedBytesInputKeyRead = false;
        }

        @Override
        public K get() {
            return this.cachedBytesInputKey();
        }
    }

    public class InputFirstValueBytesData
    extends AbstractData<V> {
        private V cachedBytesInputFirstValue;
        private boolean cachedBytesInputFirstValueRead = false;

        @Override
        public RandomDataInput bytes() {
            return CompiledReplicatedMapQueryContext.this.inputStore;
        }

        @Override
        public long offset() {
            return CompiledReplicatedMapQueryContext.this.firstInputValueOffset();
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.firstInputValueSize();
        }

        public void closeInputFirstValueBytesDataSizeDependants() {
            this.closeInputFirstValueBytesDataGetUsingDependants();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledReplicatedMapQueryContext.this.inputBytes().position(CompiledReplicatedMapQueryContext.this.firstInputValueOffset());
            return CompiledReplicatedMapQueryContext.this.valueReader.read(CompiledReplicatedMapQueryContext.this.inputBytes(), this.size(), usingValue);
        }

        public void closeInputFirstValueBytesDataGetUsingDependants() {
            this.closeCachedBytesInputFirstValue();
        }

        public boolean cachedBytesInputFirstValueInit() {
            return this.cachedBytesInputFirstValueRead;
        }

        private void initCachedBytesInputFirstValue() {
            this.cachedBytesInputFirstValue = this.getUsing(this.cachedBytesInputFirstValue);
            this.cachedBytesInputFirstValueRead = true;
        }

        public V cachedBytesInputFirstValue() {
            if (!this.cachedBytesInputFirstValueInit()) {
                this.initCachedBytesInputFirstValue();
            }
            return this.cachedBytesInputFirstValue;
        }

        public void closeCachedBytesInputFirstValue() {
            if (!this.cachedBytesInputFirstValueInit()) {
                return;
            }
            this.cachedBytesInputFirstValueRead = false;
        }

        @Override
        public V get() {
            return this.cachedBytesInputFirstValue();
        }
    }

    public class HashKeyCrc32PayloadChecksumStrategy
    implements ChecksumStrategy {
        @Override
        public long extraEntryBytes() {
            return 4L;
        }

        private int computeChecksum() {
            long checksum;
            long keyHashCode = CompiledReplicatedMapQueryContext.this.keyHashCode();
            long keyEnd = CompiledReplicatedMapQueryContext.this.keyEnd();
            long len = CompiledReplicatedMapQueryContext.this.entryEnd() - keyEnd;
            if (len > 0L) {
                long addr = CompiledReplicatedMapQueryContext.this.segmentBaseAddr() + keyEnd;
                int payloadCrc = Crc32.compute(addr, len);
                checksum = ChecksumHashing.hash8To16Bytes(CompiledReplicatedMapQueryContext.this.keySize(), keyHashCode, payloadCrc);
            } else {
                checksum = ChecksumHashing.hash8To16Bytes(CompiledReplicatedMapQueryContext.this.keySize(), keyHashCode, keyHashCode);
            }
            return (int)(checksum >>> 32 ^ checksum);
        }

        @Override
        public boolean innerCheckSum() {
            int crc;
            int oldChecksum = CompiledReplicatedMapQueryContext.this.segmentBS().readInt(CompiledReplicatedMapQueryContext.this.entryEnd());
            return oldChecksum == (crc = this.computeChecksum());
        }

        @Override
        public void computeAndStoreChecksum() {
            int crc = this.computeChecksum();
            CompiledReplicatedMapQueryContext.this.segmentBS().writeInt(CompiledReplicatedMapQueryContext.this.entryEnd(), crc);
        }

        @Override
        public boolean checkSum() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerCheckSum();
        }

        @Override
        public void updateChecksum() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            this.computeAndStoreChecksum();
        }
    }

    public class EntryValueBytesData
    extends AbstractData<V> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead = false;

        @Override
        public long offset() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            CompiledReplicatedMapQueryContext.this.segmentBytes().position(CompiledReplicatedMapQueryContext.this.valueOffset());
            return CompiledReplicatedMapQueryContext.this.valueReader.read((Bytes)CompiledReplicatedMapQueryContext.this.segmentBytes(), this.size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingValue);
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.segmentBS();
        }
    }

    public class EntryKeyBytesData
    extends AbstractData<K> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        @Override
        public RandomDataInput bytes() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.segmentBS();
        }

        @Override
        public long size() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        private K innerGetUsing(K usingKey) {
            CompiledReplicatedMapQueryContext.this.segmentBytes().position(CompiledReplicatedMapQueryContext.this.keyOffset());
            return CompiledReplicatedMapQueryContext.this.keyReader.read((Bytes)CompiledReplicatedMapQueryContext.this.segmentBytes(), this.size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                return;
            }
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }

        @Override
        public K getUsing(K usingKey) {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingKey);
        }

        @Override
        public long offset() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.keyOffset();
        }
    }

    public class DummyValueZeroData
    extends AbstractData<V> {
        @Override
        public long offset() {
            return 0L;
        }

        @Override
        public V get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getUsing(V usingInstance) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RandomDataInput bytes() {
            return ZeroRandomDataInput.INSTANCE;
        }

        @Override
        public long size() {
            return ((ReplicatedChronicleMap)CompiledReplicatedMapQueryContext.this.m()).valueSizeMarshaller.minEncodableSize();
        }
    }

    public class BytesReturnValue
    implements AutoCloseable,
    ReturnValue<V> {
        private final JavaLangBytesReusableBytesStore outputStore = new JavaLangBytesReusableBytesStore();
        long startOutputPos;
        TcpReplicator.TcpSocketChannelEntryWriter output = null;

        public JavaLangBytesReusableBytesStore outputStore() {
            return this.outputStore;
        }

        public boolean outputInit() {
            return this.output != null;
        }

        public void initOutput(TcpReplicator.TcpSocketChannelEntryWriter output) {
            this.output = output;
            this.startOutputPos = output.in().position();
        }

        public long startOutputPos() {
            assert (this.outputInit()) : "Output should be init";
            return this.startOutputPos;
        }

        public TcpReplicator.TcpSocketChannelEntryWriter output() {
            assert (this.outputInit()) : "Output should be init";
            return this.output;
        }

        public void closeOutput() {
            if (!this.outputInit()) {
                return;
            }
            this.output = null;
        }

        @Override
        public void returnValue(@NotNull Data<V> value) {
            long valueSize = value.size();
            long totalSize = 1L + (long)((ReplicatedChronicleMap)CompiledReplicatedMapQueryContext.this.m()).valueSizeMarshaller.sizeEncodingSize(valueSize) + valueSize;
            this.output().ensureBufferSize(totalSize);
            Bytes out = this.output().in();
            out.writeBoolean(false);
            ((ReplicatedChronicleMap)CompiledReplicatedMapQueryContext.this.m()).valueSizeMarshaller.writeSize(out, valueSize);
            long outPosition = out.position();
            out.skip(valueSize);
            this.outputStore.setBytes(out);
            value.writeTo((RandomDataOutput)this.outputStore, outPosition);
        }

        @Override
        public void close() {
            if (this.output().in().position() == this.startOutputPos()) {
                this.output().ensureBufferSize(1L);
                this.output().in().writeBoolean(true);
            }
        }
    }

    public class AcquireHandle
    implements Closeable {
        public void close() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            CompiledReplicatedMapQueryContext.this.replaceValue(CompiledReplicatedMapQueryContext.this.entry(), CompiledReplicatedMapQueryContext.this.wrapValueAsData(CompiledReplicatedMapQueryContext.this.usingReturnValue.returnValue()));
            CompiledReplicatedMapQueryContext.this.close();
        }
    }
}

