/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CopyingInstanceData;
import net.openhft.chronicle.hash.impl.JavaLangBytesReusableBytesStore;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.hashlookup.EntryConsumer;
import net.openhft.chronicle.hash.impl.value.instance.KeyInitableData;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.locks.InterProcessReadWriteUpdateLock;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapKeyContext;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.MapAbsentEntryHolder;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.data.instance.ValueInitableData;
import net.openhft.chronicle.map.impl.ret.InstanceReturnValue;
import net.openhft.chronicle.map.impl.ret.UsableReturnValue;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompiledMapQueryContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R>
implements AutoCloseable,
HashEntry<K>,
InterProcessReadWriteUpdateLock,
ExternalMapQueryContext<K, V, R>,
MapAbsentEntry<K, V>,
MapContext<K, V, R>,
MapEntry<K, V>,
MapAbsentEntryHolder<K, V>,
QueryContextInterface<K, V, R>,
VanillaChronicleMapHolder<K, KI, MKI, V, VI, MVI, R> {
    final Thread owner;
    public final int indexInContextChain;
    public final Bytes entryBytes;
    public static final int MAX_SEGMENT_CHUNKS = 0x40000000;
    public static final int MAX_SEGMENT_ENTRIES = 0x20000000;
    public static final long UNSET_KEY = 0L;
    public static final long UNSET_ENTRY = 0L;
    public final ReadLock innerReadLock;
    public final WriteLock innerWriteLock;
    public final List<CompiledMapQueryContext> contextChain;
    public final UpdateLock innerUpdateLock;
    public final ThreadLocalCopies copies;
    final EntryKeyBytesData entryKey;
    public final UsingReturnValue usingReturnValue;
    public final InputKeyBytesData inputKeyBytesValue;
    public final DefaultReturnValue defaultReturnValue;
    public final EntryValueBytesData entryValue;
    final WrappedValueInstanceData wrappedValueInstanceValue;
    public final InputFirstValueBytesData inputFirstValueBytesValue;
    public final JavaLangBytesReusableBytesStore inputStore;
    public final InputSecondValueBytesData inputSecondValueBytesValue;
    public final InputKeyInstanceData inputKeyInstanceValue;
    public final InputValueInstanceData inputValueInstanceValue;
    public final DeprecatedMapKeyContextOnQuery deprecatedMapKeyContext;
    public final DeprecatedMapAcquireContextOnQuery deprecatedMapAcquireContext;
    private final VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m;
    public final VI valueInterop;
    public final BytesStore entryBS;
    public final BytesReader<V> valueReader;
    public final KI keyInterop;
    public final BytesReader<K> keyReader;
    public long keyOffset = -1L;
    public int allocatedChunks = 0;
    public Data<K> inputKey = null;
    public long hashOfKey = 0L;
    public int segmentIndex = -1;
    long entrySpaceOffset = 0L;
    MultiStoreBytes freeListBytes = new MultiStoreBytes();
    public SingleThreadedDirectBitSet freeList = new SingleThreadedDirectBitSet();
    int hashLookupEntrySize;
    int keyBits;
    long address = -1L;
    long capacityMask;
    long capacityMask2;
    long keyMask;
    long valueMask;
    long entryMask;
    long segmentHeaderAddress;
    SegmentHeader segmentHeader = null;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    CompiledMapQueryContext nextNode;
    public boolean concurrentSameThreadContexts;
    LocalLockState localLockState;
    public CompiledMapQueryContext rootContextOnThisSegment = null;
    long searchKey = 0L;
    long searchStartPos;
    public long hashLookupPos = -1L;
    public long pos = -1L;
    public long keySizeOffset = -1L;
    public long keySize = -1L;
    public long valueSizeOffset = -1L;
    public long valueSize = -1L;
    public long valueOffset;
    public int entrySizeInChunks = 0;
    protected SearchState searchState = null;
    boolean used;
    public Bytes inputBytes = null;
    public long inputKeySize = -1L;
    public long inputKeyOffset;
    public long firstInputValueSize = -1L;
    public long firstInputValueOffset;
    public long secondInputValueSize = -1L;
    public long secondInputValueOffset;

    @Override
    public void close() {
        this.wrappedValueInstanceValue.closeValue();
        this.inputValueInstanceValue.closeValue();
        this.closeInputBytes();
        this.wrappedValueInstanceValue.closeNext();
        this.usingReturnValue.closeUsingReturnValue();
        this.defaultReturnValue.closeDefaultReturnedValue();
        this.closeUsed();
        this.closeKeySize();
        this.inputKeyInstanceValue.closeKey();
        this.closePos();
        this.closeInputKey();
        this.closeAllocatedChunks();
        this.closeKeyOffset();
        this.closeKeyBytesInteropKeyMetaInteropDependants();
        this.closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeValueBytesInteropValueMetaInteropDependants();
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    public void setSearchStateGuarded(SearchState newSearchState) {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        this.setSearchState(newSearchState);
    }

    void keyFound() {
        this.searchState = SearchState.PRESENT;
    }

    public CompiledMapQueryContext(VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m) {
        this.contextChain = new ArrayList<CompiledMapQueryContext>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.m = m;
        this.inputKeyBytesValue = new InputKeyBytesData();
        this.defaultReturnValue = new DefaultReturnValue();
        this.inputValueInstanceValue = new InputValueInstanceData();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
        this.valueReader = (BytesReader)this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.deprecatedMapAcquireContext = new DeprecatedMapAcquireContextOnQuery();
        this.usingReturnValue = new UsingReturnValue();
        this.entryKey = new EntryKeyBytesData();
        this.innerUpdateLock = new UpdateLock();
        this.innerReadLock = new ReadLock();
        this.inputStore = new JavaLangBytesReusableBytesStore();
        this.deprecatedMapKeyContext = new DeprecatedMapKeyContextOnQuery();
        this.entryValue = new EntryValueBytesData();
        this.innerWriteLock = new WriteLock();
        this.entryBytes = this.h().ms.bytes();
        this.entryBS = new NativeBytesStore(this.entryBytes.address(), this.entryBytes.capacity(), null, false);
        this.owner = Thread.currentThread();
        this.inputFirstValueBytesValue = new InputFirstValueBytesData();
        this.inputKeyInstanceValue = new InputKeyInstanceData();
        this.wrappedValueInstanceValue = new WrappedValueInstanceData();
        this.inputSecondValueBytesValue = new InputSecondValueBytesData();
    }

    public CompiledMapQueryContext(CompiledMapQueryContext c) {
        this.contextChain = c.contextChain;
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.m = c.m;
        this.inputKeyBytesValue = new InputKeyBytesData();
        this.defaultReturnValue = new DefaultReturnValue();
        this.inputValueInstanceValue = new InputValueInstanceData();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
        this.valueReader = (BytesReader)this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.deprecatedMapAcquireContext = new DeprecatedMapAcquireContextOnQuery();
        this.usingReturnValue = new UsingReturnValue();
        this.entryKey = new EntryKeyBytesData();
        this.innerUpdateLock = new UpdateLock();
        this.innerReadLock = new ReadLock();
        this.inputStore = new JavaLangBytesReusableBytesStore();
        this.deprecatedMapKeyContext = new DeprecatedMapKeyContextOnQuery();
        this.entryValue = new EntryValueBytesData();
        this.innerWriteLock = new WriteLock();
        this.entryBytes = this.h().ms.bytes();
        this.entryBS = new NativeBytesStore(this.entryBytes.address(), this.entryBytes.capacity(), null, false);
        this.owner = Thread.currentThread();
        this.inputFirstValueBytesValue = new InputFirstValueBytesData();
        this.inputKeyInstanceValue = new InputKeyInstanceData();
        this.wrappedValueInstanceValue = new WrappedValueInstanceData();
        this.inputSecondValueBytesValue = new InputSecondValueBytesData();
    }

    private void _AllocatedChunks_incrementSegmentEntriesIfNeeded() {
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkAccessingFromOwnerThread();
    }

    public void incrementModCount() {
        this.contextModCount = ++this.rootContextOnThisSegment.latestSameThreadSegmentModCount;
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        this.localLockState = newState;
    }

    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    public Thread owner() {
        return this.owner;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        switch (this.localLockState) {
            case UNLOCKED: {
                break;
            }
            case READ_LOCKED: {
                int newTotalReadLockCount = --this.rootContextOnThisSegment.totalReadLockCount;
                if (newTotalReadLockCount == 0) {
                    if (this.rootContextOnThisSegment.totalUpdateLockCount != 0 || this.rootContextOnThisSegment.totalWriteLockCount != 0) break;
                    this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                    break;
                }
                if (newTotalReadLockCount >= 0) break;
                throw new IllegalStateException("read underflow");
            }
            case UPDATE_LOCKED: {
                int newTotalUpdateLockCount = --this.rootContextOnThisSegment.totalUpdateLockCount;
                if (newTotalUpdateLockCount == 0) {
                    if (this.rootContextOnThisSegment.totalWriteLockCount != 0) break;
                    if (this.rootContextOnThisSegment.totalReadLockCount == 0) {
                        this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                        break;
                    }
                    this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                    break;
                }
                if (newTotalUpdateLockCount >= 0) break;
                throw new IllegalStateException("update underflow");
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = --this.rootContextOnThisSegment.totalWriteLockCount;
                if (newTotalWriteLockCount != 0) break;
                if (this.rootContextOnThisSegment.totalUpdateLockCount > 0) {
                    this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                    break;
                }
                if (this.rootContextOnThisSegment.totalReadLockCount > 0) {
                    this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                    break;
                }
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void closeRootLocks() {
        assert (this.nextNode == null);
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void innerInitSegmentHashLookup(long address, long capacity, int entrySize, int keyBits, int valueBits) {
        this.address = address;
        this.capacityMask = capacity - 1L;
        this.hashLookupEntrySize = entrySize;
        this.capacityMask2 = this.capacityMask * (long)entrySize;
        this.keyBits = keyBits;
        this.keyMask = CompiledMapQueryContext.mask(keyBits);
        this.valueMask = CompiledMapQueryContext.mask(valueBits);
        this.entryMask = CompiledMapQueryContext.mask(keyBits + valueBits);
    }

    private void unlinkFromSegmentContextsChain() {
        CompiledMapQueryContext prevContext = this.rootContextOnThisSegment;
        while (true) {
            assert (prevContext.nextNode != null);
            if (prevContext.nextNode == this) break;
            prevContext = prevContext.nextNode;
        }
        assert (this.nextNode == null);
        prevContext.nextNode = null;
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    private CompiledMapQueryContext _Chaining_createChaining() {
        return new CompiledMapQueryContext<K, KI, MKI, V, VI, MVI, R>(this);
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public static int entrySize(int keyBits, int valueBits) {
        return (int)MemoryUnit.BYTES.alignAndConvert((long)(keyBits + valueBits), MemoryUnit.BITS);
    }

    public static int keyBits(long entriesPerSegment, int valueBits) {
        int minKeyBits = 64 - Long.numberOfLeadingZeros(entriesPerSegment - 1L);
        int actualEntryBits = (int)MemoryUnit.BYTES.align((long)((minKeyBits += 3) + valueBits), MemoryUnit.BITS);
        return actualEntryBits - valueBits;
    }

    public static int valueBits(long actualChunksPerSegment) {
        return 64 - Long.numberOfLeadingZeros(actualChunksPerSegment - 1L);
    }

    public Bytes entryBytes() {
        return this.entryBytes;
    }

    public static long capacityFor(long entriesPerSegment) {
        if (entriesPerSegment < 0L) {
            throw new IllegalArgumentException("entriesPerSegment should be positive");
        }
        long capacity = Maths.nextPower2((long)entriesPerSegment, (long)64L);
        if ((double)entriesPerSegment / (double)capacity > 0.6666666666666666) {
            capacity <<= 1;
        }
        return capacity;
    }

    public static long mask(int bits) {
        return (1L << bits) - 1L;
    }

    public int MAX_SEGMENT_ENTRIES() {
        return 0x20000000;
    }

    public int MAX_SEGMENT_CHUNKS() {
        return 0x40000000;
    }

    public long UNSET_ENTRY() {
        return 0L;
    }

    public long UNSET_KEY() {
        return 0L;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public List<CompiledMapQueryContext> contextChain() {
        return this.contextChain;
    }

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public ThreadLocalCopies copies() {
        return this.copies;
    }

    private void countValueOffset() {
        this.m().alignment.alignPositionAddr(this.entryBytes);
        this.valueOffset = this.entryBytes.position();
    }

    public UsingReturnValue usingReturnValue() {
        return this.usingReturnValue;
    }

    public InputKeyBytesData inputKeyBytesValue() {
        return this.inputKeyBytesValue;
    }

    public DefaultReturnValue defaultReturnValue() {
        return this.defaultReturnValue;
    }

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    public WrappedValueInstanceData wrappedValueInstanceValue() {
        return this.wrappedValueInstanceValue;
    }

    public JavaLangBytesReusableBytesStore inputStore() {
        return this.inputStore;
    }

    public InputFirstValueBytesData inputFirstValueBytesValue() {
        return this.inputFirstValueBytesValue;
    }

    public InputSecondValueBytesData inputSecondValueBytesValue() {
        return this.inputSecondValueBytesValue;
    }

    public InputKeyInstanceData inputKeyInstanceValue() {
        return this.inputKeyInstanceValue;
    }

    public InputValueInstanceData inputValueInstanceValue() {
        return this.inputValueInstanceValue;
    }

    public DeprecatedMapKeyContextOnQuery deprecatedMapKeyContext() {
        return this.deprecatedMapKeyContext;
    }

    public DeprecatedMapAcquireContextOnQuery deprecatedMapAcquireContext() {
        return this.deprecatedMapAcquireContext;
    }

    public VI valueInterop() {
        return this.valueInterop;
    }

    public BytesStore entryBS() {
        return this.entryBS;
    }

    public BytesReader<V> valueReader() {
        return this.valueReader;
    }

    public KI keyInterop() {
        return this.keyInterop;
    }

    public BytesReader<K> keyReader() {
        return this.keyReader;
    }

    @Override
    public MapAbsentEntry<K, V> absent() {
        return this;
    }

    @Override
    public VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m() {
        return this.m;
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)(this.m().metaDataBytes + this.m().keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + (long)this.m().valueSizeMarshaller.sizeEncodingSize(valueSize);
    }

    public MVI valueMetaInterop(V value) {
        return (MVI)((MetaBytesInterop)this.m().metaValueInteropProvider.get(this.copies, this.m().originalMetaValueInterop, this.valueInterop, value));
    }

    public void closeValueBytesInteropValueMetaInteropDependants() {
        this.wrappedValueInstanceValue.closeBuffer();
        this.inputValueInstanceValue.closeBuffer();
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (this.m().constantlySizedEntry) {
            return this.m().alignment.alignAddr(sizeOfEverythingBeforeValue + valueSize);
        }
        if (this.m().couldNotDetermineAlignmentBeforeAllocation) {
            return sizeOfEverythingBeforeValue + (long)this.m().worstAlignment + valueSize;
        }
        return this.m().alignment.alignAddr(sizeOfEverythingBeforeValue) + valueSize;
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException("Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public CompiledMapQueryContext createChaining() {
        return new CompiledMapQueryContext<K, KI, MKI, V, VI, MVI, R>(this);
    }

    public <T> T getContext() {
        for (CompiledMapQueryContext context : this.contextChain) {
            if (context.usedInit()) continue;
            return (T)context;
        }
        int maxNestedContexts = 65536;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        return (T)this.createChaining();
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeQuerySegmentStagesTryFindInitLocksOfThisSegmentDependants();
    }

    public MKI keyMetaInterop(K key) {
        return (MKI)((MetaBytesInterop)this.h().metaKeyInteropProvider.get(this.copies, this.h().originalMetaKeyInterop, this.keyInterop, key));
    }

    public void closeKeyBytesInteropKeyMetaInteropDependants() {
        this.inputKeyInstanceValue.closeBuffer();
    }

    public boolean keyOffsetInit() {
        return this.keyOffset >= 0L;
    }

    public void initKeyOffset(long keyOffset) {
        this.keyOffset = keyOffset;
        this.closeKeyOffsetDependants();
    }

    public long keyOffset() {
        assert (this.keyOffsetInit()) : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!this.keyOffsetInit()) {
            return;
        }
        this.closeKeyOffsetDependants();
        this.keyOffset = -1L;
    }

    public void closeKeyOffsetDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.closeMapQueryKeyEqualsDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!this.allocatedChunksInit()) {
            return;
        }
        this.allocatedChunks = 0;
    }

    public boolean inputKeyInit() {
        return this.inputKey != null;
    }

    @Override
    public void initInputKey(Data<K> inputKey) {
        this.inputKey = inputKey;
        this.closeInputKeyDependants();
    }

    public Data<K> inputKey() {
        assert (this.inputKeyInit()) : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!this.inputKeyInit()) {
            return;
        }
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeHashOfKey();
        this.closeMapQueryKeyEqualsDependants();
    }

    public boolean hashOfKeyInit() {
        return this.hashOfKey != 0L;
    }

    void initHashOfKey() {
        this.hashOfKey = this.inputKey().hash(LongHashFunction.city_1_1());
        this.closeHashOfKeyDependants();
    }

    public long hashOfKey() {
        if (!this.hashOfKeyInit()) {
            this.initHashOfKey();
        }
        return this.hashOfKey;
    }

    public void closeHashOfKey() {
        if (!this.hashOfKeyInit()) {
            return;
        }
        this.closeHashOfKeyDependants();
        this.hashOfKey = 0L;
    }

    public void closeHashOfKeyDependants() {
        this.closeTheSegmentIndex();
        this.closeSearchKey();
    }

    @Override
    public boolean theSegmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    void initTheSegmentIndex() {
        this.segmentIndex = this.h().hashSplitting.segmentIndex(this.hashOfKey());
        this.closeTheSegmentIndexDependants();
    }

    @Override
    public void initTheSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
        this.closeTheSegmentIndexDependants();
    }

    public int segmentIndex() {
        if (!this.theSegmentIndexInit()) {
            this.initTheSegmentIndex();
        }
        return this.segmentIndex;
    }

    public void closeTheSegmentIndex() {
        if (!this.theSegmentIndexInit()) {
            return;
        }
        this.closeTheSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeTheSegmentIndexDependants() {
        this.closeSegment();
        this.closeSegmentHashLookup();
        this.closeSegHeader();
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        VanillaChronicleHash h = this.h();
        long hashLookupOffset = h.segmentOffset(this.segmentIndex());
        long freeListOffset = hashLookupOffset + h.segmentHashLookupOuterSize;
        this.freeListBytes.storePositionAndSize(h.ms, freeListOffset, h.segmentFreeListInnerSize);
        this.freeList.reuse((Bytes)this.freeListBytes);
        this.entrySpaceOffset = freeListOffset + h.segmentFreeListOuterSize + (long)h.segmentEntrySpaceInnerOffset;
        this.closeSegmentDependants();
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public SingleThreadedDirectBitSet freeList() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.freeList;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeEntryOffset();
    }

    public boolean segmentHashLookupInit() {
        return this.address >= 0L;
    }

    public void initSegmentHashLookup() {
        long hashLookupOffset = this.h().segmentOffset(this.segmentIndex());
        this.innerInitSegmentHashLookup(this.h().ms.address() + hashLookupOffset, this.h().segmentHashLookupCapacity, this.h().segmentHashLookupEntrySize, this.h().segmentHashLookupKeyBits, this.h().segmentHashLookupValueBits);
        this.closeSegmentHashLookupDependants();
    }

    public void initSegmentHashLookup(long address, long capacity, int entrySize, int keyBits, int valueBits) {
        this.innerInitSegmentHashLookup(address, capacity, entrySize, keyBits, valueBits);
        this.closeSegmentHashLookupDependants();
    }

    public int hashLookupEntrySize() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.hashLookupEntrySize;
    }

    public int keyBits() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.keyBits;
    }

    public long address() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.address;
    }

    public long capacityMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.capacityMask;
    }

    public long capacityMask2() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.capacityMask2;
    }

    public long entryMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.entryMask;
    }

    public long keyMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.keyMask;
    }

    public long valueMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.valueMask;
    }

    public void closeSegmentHashLookup() {
        if (!this.segmentHashLookupInit()) {
            return;
        }
        this.closeSegmentHashLookupDependants();
        this.address = -1L;
    }

    public void closeSegmentHashLookupDependants() {
        this.closeHashLookupReadEntryDependants();
        this.closeHashLookupStepDependants();
        this.closeHashLookupStepBackDependants();
        this.closeHashLookupIndexToPosDependants();
        this.closeHashLookupMaskUnsetKeyDependants();
        this.closeHashLookupKeyDependants();
        this.closeHashLookupValueDependants();
        this.closeHashLookupHlPosDependants();
        this.closeHashLookupEmptyDependants();
    }

    public long readEntry(long pos) {
        return NativeBytes.UNSAFE.getLong(this.address() + pos);
    }

    public void closeHashLookupReadEntryDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public long step(long pos) {
        return (pos += (long)this.hashLookupEntrySize()) <= this.capacityMask2() ? pos : 0L;
    }

    public void closeHashLookupStepDependants() {
        this.closeHashLookupSearchNextPosDependants();
    }

    public long stepBack(long pos) {
        return (pos -= (long)this.hashLookupEntrySize()) >= 0L ? pos : this.capacityMask2();
    }

    public void closeHashLookupStepBackDependants() {
        this.closeHashLookupSearchFoundDependants();
    }

    long indexToPos(long index) {
        return index * (long)this.hashLookupEntrySize();
    }

    public void closeHashLookupIndexToPosDependants() {
        this.closeHashLookupHlPosDependants();
    }

    public long maskUnsetKey(long key) {
        return (key &= this.keyMask()) != 0L ? key : this.keyMask();
    }

    public void closeHashLookupMaskUnsetKeyDependants() {
        this.closeSearchKey();
    }

    long entry(long key, long value) {
        return key | value << this.keyBits();
    }

    public void writeEntryVolatile(long pos, long prevEntry, long key, long value) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | this.entry(key, value);
        NativeBytes.UNSAFE.putLongVolatile(null, this.address() + pos, entry);
    }

    public void clearHashLookup() {
        NativeBytes.UNSAFE.setMemory(this.address(), this.capacityMask2() + (long)this.hashLookupEntrySize(), (byte)0);
    }

    public long key(long entry) {
        return entry & this.keyMask();
    }

    public void closeHashLookupKeyDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public void writeEntry(long pos, long prevEntry, long key, long value) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | this.entry(key, value);
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    void writeEntry(long pos, long prevEntry, long anotherEntry) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | anotherEntry & this.entryMask();
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    public long value(long entry) {
        return entry >>> this.keyBits() & this.valueMask();
    }

    public void closeHashLookupValueDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public long hlPos(long key) {
        return this.indexToPos(key & this.capacityMask());
    }

    public void closeHashLookupHlPosDependants() {
        this.closeSearchKey();
    }

    public void checkValueForPut(long value) {
        assert ((value & (this.valueMask() ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "Value out of range, was " + value;
    }

    public void putValueVolatile(long pos, long value) {
        this.checkValueForPut(value);
        long currentEntry = this.readEntry(pos);
        this.writeEntryVolatile(pos, currentEntry, this.key(currentEntry), value);
    }

    void clearEntry(long pos, long prevEntry) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL);
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    public boolean empty(long entry) {
        return (entry & this.entryMask()) == 0L;
    }

    public void closeHashLookupEmptyDependants() {
        this.closeHashLookupSearchNextPosDependants();
    }

    public long remove(long posToRemove) {
        long entryToShift;
        long entryToRemove = this.readEntry(posToRemove);
        long posToShift = posToRemove;
        while (!this.empty(entryToShift = this.readEntry(posToShift = this.step(posToShift)))) {
            boolean cond2;
            long insertPos = this.hlPos(this.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.writeEntry(posToRemove, entryToRemove, entryToShift);
            posToRemove = posToShift;
            entryToRemove = entryToShift;
        }
        this.clearEntry(posToRemove, entryToRemove);
        return posToRemove;
    }

    void forEach(EntryConsumer action) {
        for (long pos = 0L; pos <= this.capacityMask2(); pos += (long)this.hashLookupEntrySize()) {
            long entry = this.readEntry(pos);
            if (this.empty(entry)) continue;
            action.accept(this.key(entry), this.value(entry));
        }
    }

    String hashLookupToString() {
        StringBuilder sb = new StringBuilder("{");
        this.forEach((key, value) -> sb.append(key).append('=').append(value).append(','));
        sb.append('}');
        return sb.toString();
    }

    public boolean segHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegHeader() {
        this.segmentHeaderAddress = this.h().ms.address() + this.h().segmentHeaderOffset(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        this.closeSegHeaderDependants();
    }

    public long segmentHeaderAddress() {
        if (!this.segHeaderInit()) {
            this.initSegHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segHeaderInit()) {
            this.initSegHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegHeader() {
        if (!this.segHeaderInit()) {
            return;
        }
        this.closeSegHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegHeaderDependants() {
        this.closeQuerySegmentStagesTryFindInitLocksOfThisSegmentDependants();
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
    }

    public void nextPosToSearchFrom(long nextPosToSearchFrom) {
        this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress(), nextPosToSearchFrom);
    }

    public void updateNextPosToSearchFrom(long allocated, int chunks) {
        long nextPosToSearchFrom = allocated + (long)chunks;
        if (nextPosToSearchFrom >= this.h().actualChunksPerSegment) {
            nextPosToSearchFrom = 0L;
        }
        this.nextPosToSearchFrom(nextPosToSearchFrom);
    }

    long nextPosToSearchFrom() {
        return this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress());
    }

    public long alloc(int chunks) {
        VanillaChronicleHash h = this.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " entry size chucks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long ret = this.freeList().setNextNContinuousClearBits(this.nextPosToSearchFrom(), chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
            if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                this.freeList().clear(ret, h.actualChunksPerSegment);
            }
            if ((ret = this.freeList().setNextNContinuousClearBits(0L, chunks)) == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
                if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                    this.freeList().clear(ret, h.actualChunksPerSegment);
                }
                if (chunks == 1) {
                    throw new IllegalStateException("Segment is full, no free entries found");
                }
                throw new IllegalStateException("Segment is full or has no ranges of " + chunks + " continuous free chunks");
            }
            this.updateNextPosToSearchFrom(ret, chunks);
        } else if (chunks == 1 || this.freeList().isSet(this.nextPosToSearchFrom())) {
            this.updateNextPosToSearchFrom(ret, chunks);
        }
        return ret;
    }

    public void free(long fromPos, int chunks) {
        this.freeList().clear(fromPos, fromPos + (long)chunks);
        if (fromPos < this.nextPosToSearchFrom()) {
            this.nextPosToSearchFrom(fromPos);
        }
    }

    boolean tryFindInitLocksOfThisSegment(Object thisContext, int index) {
        CompiledMapQueryContext c = (CompiledMapQueryContext)this.contextAtIndexInChain(index);
        if (c.segmentHeader() != null && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.rootContextOnThisSegment() != null) {
            throw new IllegalStateException("Nested context not implemented yet");
        }
        return false;
    }

    public void closeQuerySegmentStagesTryFindInitLocksOfThisSegmentDependants() {
        this.closeLocks();
    }

    public void entries(long size) {
        this.segmentHeader().size(this.segmentHeaderAddress(), size);
    }

    public long entries() {
        return this.segmentHeader().size(this.segmentHeaderAddress());
    }

    public void deleted(long deleted) {
        this.segmentHeader().deleted(this.segmentHeaderAddress(), deleted);
    }

    public long deleted() {
        return this.segmentHeader().deleted(this.segmentHeaderAddress());
    }

    public long size() {
        return this.entries() - this.deleted();
    }

    public boolean locksInit() {
        return this.rootContextOnThisSegment != null;
    }

    void initLocks() {
        int i;
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(this, i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(this, i)) continue;
            return;
        }
        this.rootContextOnThisSegment = this;
        this.concurrentSameThreadContexts = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.nextNode = null;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
        this.closeLocksDependants();
    }

    public boolean concurrentSameThreadContexts() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.concurrentSameThreadContexts;
    }

    public int contextModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.contextModCount;
    }

    public int latestSameThreadSegmentModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.latestSameThreadSegmentModCount;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    public CompiledMapQueryContext rootContextOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        this.closeLocksDependants();
        if (this.rootContextOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.localLockState = null;
        this.rootContextOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void clearSegment() {
        this.innerWriteLock.lock();
        this.clearHashLookup();
        this.freeList().clear();
        this.nextPosToSearchFrom(0L);
        this.entries(0L);
    }

    @Override
    public void clear() {
        this.clearSegment();
    }

    public boolean searchKeyInit() {
        return this.searchKey != 0L;
    }

    void initSearchKey() {
        this.searchKey = this.maskUnsetKey(this.h().hashSplitting.segmentHash(this.hashOfKey()));
        this.searchStartPos = this.hlPos(this.searchKey);
        this.closeSearchKeyDependants();
    }

    public long searchKey() {
        if (!this.searchKeyInit()) {
            this.initSearchKey();
        }
        return this.searchKey;
    }

    public long searchStartPos() {
        if (!this.searchKeyInit()) {
            this.initSearchKey();
        }
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!this.searchKeyInit()) {
            return;
        }
        this.closeSearchKeyDependants();
        this.searchKey = 0L;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos >= 0L;
    }

    public void initHashLookupPos() {
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        this.closeHashLookupPosDependants();
    }

    public void initHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
        this.closeHashLookupPosDependants();
    }

    public long hashLookupPos() {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1L;
    }

    public void closeHashLookupPosDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
        this.closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public void putVolatile(long value) {
        this.checkValueForPut(value);
        long currentEntry = this.readEntry(this.hashLookupPos());
        assert (this.key(currentEntry) == this.searchKey());
        this.writeEntryVolatile(this.hashLookupPos(), currentEntry, this.searchKey(), value);
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hashLookupPos();
            do {
                if (this.empty(entry = this.readEntry(pos))) {
                    this.setHashLookupPosGuarded(pos);
                    return -1L;
                }
                if ((pos = this.step(pos)) == this.searchStartPos()) break block2;
            } while (this.key(entry) != this.searchKey());
            this.setHashLookupPosGuarded(pos);
            return this.value(entry);
        }
        throw new IllegalStateException("MultiMap is full, that most likely means you misconfigured entrySize/chunkSize, and entries tend to take less chunks than expected");
    }

    public void closeHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public void putNewVolatile(long value) {
        this.checkValueForPut(value);
        long currentEntry = this.readEntry(this.hashLookupPos());
        this.writeEntryVolatile(this.hashLookupPos(), currentEntry, this.searchKey(), value);
    }

    void put(long value) {
        this.checkValueForPut(value);
        this.writeEntry(this.hashLookupPos(), this.readEntry(this.hashLookupPos()), this.searchKey(), value);
    }

    public void found() {
        this.setHashLookupPosGuarded(this.stepBack(this.hashLookupPos()));
    }

    public void closeHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.readEntry(this.hashLookupPos());
        return this.key(entry) == this.searchKey() && this.value(entry) == value;
    }

    public void closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants() {
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void remove() {
        this.setHashLookupPosGuarded(this.remove(this.hashLookupPos()));
    }

    public boolean checkSlotIsEmpty() {
        return this.empty(this.readEntry(this.hashLookupPos()));
    }

    public boolean posInit() {
        return this.pos >= 0L;
    }

    public void initPos(long pos) {
        this.pos = pos;
        this.closePosDependants();
    }

    public long pos() {
        assert (this.posInit()) : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!this.posInit()) {
            return;
        }
        this.closePosDependants();
        this.pos = -1L;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public boolean entryOffsetInit() {
        return this.keySizeOffset >= 0L;
    }

    public void initEntryOffset() {
        this.keySizeOffset = this.entrySpaceOffset() + this.pos() * this.h().chunkSize;
        this.entryBytes.limit(this.entryBytes.capacity());
        this.closeEntryOffsetDependants();
    }

    public long keySizeOffset() {
        if (!this.entryOffsetInit()) {
            this.initEntryOffset();
        }
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!this.entryOffsetInit()) {
            return;
        }
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1L;
    }

    public void closeEntryOffsetDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
        this.closeMapEntryStagesReadExistingEntryDependants();
    }

    public void copyExistingEntry(long newPos, long bytesToCopy) {
        long oldKeySizeOffset = this.keySizeOffset();
        long oldKeyOffset = this.keyOffset();
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset() + (oldKeyOffset - oldKeySizeOffset));
        this.entryBS.write(this.keySizeOffset(), (RandomDataInput)this.entryBS, oldKeySizeOffset, bytesToCopy);
    }

    public void readExistingEntry(long pos) {
        this.initPos(pos);
        this.entryBytes.position(this.keySizeOffset());
        this.initKeySize(this.h().keySizeMarshaller.readSize(this.entryBytes));
        this.initKeyOffset(this.entryBytes.position());
    }

    public void closeMapEntryStagesReadExistingEntryDependants() {
        this.closeKeySearch();
    }

    public boolean keySizeInit() {
        return this.keySize >= 0L;
    }

    public void initKeySize(long keySize) {
        this.keySize = keySize;
        this.closeKeySizeDependants();
    }

    public long keySize() {
        assert (this.keySizeInit()) : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!this.keySizeInit()) {
            return;
        }
        this.closeKeySizeDependants();
        this.keySize = -1L;
    }

    public void closeKeySizeDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.closeMapQueryKeyEqualsDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        this.entryBytes.position(this.keySizeOffset());
        this.h().keySizeMarshaller.writeSize(this.entryBytes, this.keySize());
        this.initKeyOffset(this.entryBytes.position());
        key.writeTo((RandomDataOutput)this.entryBS, this.keyOffset());
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeMapEntryStagesKeyEndDependants() {
        this.closeMapEntryStagesCountValueSizeOffsetDependants();
        this.closeMapEntryStagesEntryEndDependants();
    }

    long countValueSizeOffset() {
        return this.keyEnd();
    }

    public void closeMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public boolean valueSizeOffsetInit() {
        return this.valueSizeOffset >= 0L;
    }

    void initValueSizeOffset() {
        this.valueSizeOffset = this.countValueSizeOffset();
        this.closeValueSizeOffsetDependants();
    }

    public long valueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            this.initValueSizeOffset();
        }
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            return;
        }
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1L;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValSize();
    }

    public boolean valSizeInit() {
        return this.valueSize >= 0L;
    }

    void initValSize() {
        this.entryBytes.position(this.valueSizeOffset());
        this.valueSize = this.m().readValueSize(this.entryBytes);
        this.countValueOffset();
        this.closeValSizeDependants();
    }

    void initValSize(long valueSize) {
        this.valueSize = valueSize;
        this.entryBytes.position(this.valueSizeOffset());
        this.m().valueSizeMarshaller.writeSize(this.entryBytes, valueSize);
        this.countValueOffset();
        this.closeValSizeDependants();
    }

    void initValSizeEqualToOld(long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        this.valueSize = oldValueSize;
        this.valueOffset = this.valueSizeOffset() + (oldValueOffset - oldValueSizeOffset);
        this.closeValSizeDependants();
    }

    public long valueOffset() {
        if (!this.valSizeInit()) {
            this.initValSize();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valSizeInit()) {
            this.initValSize();
        }
        return this.valueSize;
    }

    public void closeValSize() {
        if (!this.valSizeInit()) {
            return;
        }
        this.closeValSizeDependants();
        this.valueSize = -1L;
    }

    public void closeValSizeDependants() {
        this.closeMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    protected long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeMapEntryStagesEntryEndDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
    }

    long entrySize() {
        return this.entryEnd() - this.keySizeOffset();
    }

    public void closeMapEntryStagesEntrySizeDependants() {
        this.closeTheEntrySizeInChunks();
    }

    public boolean theEntrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initTheEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initTheEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.theEntrySizeInChunksInit()) {
            this.initTheEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeTheEntrySizeInChunks() {
        if (!this.theEntrySizeInChunksInit()) {
            return;
        }
        this.entrySizeInChunks = 0;
    }

    public final void freeExtraAllocatedChunks() {
        if (!this.m().constantlySizedEntry && this.m().couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.free(this.pos() + (long)this.entrySizeInChunks(), this.allocatedChunks() - this.entrySizeInChunks());
        } else {
            this.initTheEntrySizeInChunks(this.allocatedChunks());
        }
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.free(this.pos(), this.entrySizeInChunks());
        this.entries(this.entries() - 1L);
        this.incrementModCountGuarded();
    }

    public void writeValue(Data<?> value) {
        value.writeTo((RandomDataOutput)this.entryBS, this.valueOffset());
    }

    public void initValue(Data<?> value) {
        this.entryBytes.position(this.valueSizeOffset());
        this.initValSize(value.size());
        this.writeValue(value);
    }

    public void writeValueAndPutPos(Data<V> value) {
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    public void initValueWithoutSize(Data<?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        assert (oldValueSize == value.size());
        this.initValSizeEqualToOld(oldValueSizeOffset, oldValueSize, oldValueOffset);
        this.writeValue(value);
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset() + (long)this.m().valueSizeMarshaller.sizeEncodingSize(newValue.size()) - this.keySizeOffset();
    }

    boolean keyEquals() {
        return this.inputKey().size() == this.keySize() && BytesUtil.bytesEqual((RandomDataInput)this.entryBS, (long)this.keyOffset(), (RandomDataInput)this.inputKey().bytes(), (long)this.inputKey().offset(), (long)this.keySize());
    }

    public void closeMapQueryKeyEqualsDependants() {
        this.closeKeySearch();
    }

    boolean keySearchInit() {
        return this.searchState != null;
    }

    void initKeySearch() {
        long pos;
        while ((pos = this.nextPos()) >= 0L) {
            this.readExistingEntry(pos);
            if (!this.keyEquals()) continue;
            this.found();
            this.keyFound();
            return;
        }
        this.searchState = SearchState.ABSENT;
        this.closeKeySearchDependants();
    }

    public SearchState searchState() {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        return this.searchState;
    }

    void closeKeySearch() {
        if (!this.keySearchInit()) {
            return;
        }
        this.closeKeySearchDependants();
        this.searchState = null;
    }

    public void closeKeySearchDependants() {
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void incrementSegmentEntriesIfNeeded() {
        if (this.searchState() != SearchState.PRESENT) {
            this.entries(this.entries() + 1L);
        }
    }

    public void initEntryAndKeyCopying(long entrySize, long bytesToCopy) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.copyExistingEntry(this.alloc(this.allocatedChunks()), bytesToCopy);
        this.incrementSegmentEntriesIfNeeded();
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        this.free(this.pos(), this.entrySizeInChunks());
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - this.keySizeOffset());
        this.writeValueAndPutPos(newValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m = this.m();
            int newSizeInChunks = m.inChunks(newEntrySize = (newValueOffset = m.alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue)) + newValue.size() - entryStartOffset);
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.freeList().allClear(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
                this.freeList().set(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks);
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeList().clear(this.pos() + (long)newSizeInChunks, this.pos() + (long)this.entrySizeInChunks());
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
        } else {
            this.writeValue(newValue);
        }
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    public void putValueDeletedEntry(Data<V> newValue) {
        int newSizeInChunks;
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        long entryStartOffset = this.keySizeOffset();
        long newSizeOfEverythingBeforeValue = -1L;
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long newValueOffset = this.m().alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue);
            long newEntrySize = newValueOffset + newValue.size() - entryStartOffset;
            newSizeInChunks = this.m().inChunks(newEntrySize);
        } else {
            newSizeInChunks = this.entrySizeInChunks();
        }
        if (this.pos() + (long)newSizeInChunks < this.freeList().size() && this.freeList().allClear(this.pos(), this.pos() + (long)newSizeInChunks)) {
            this.freeList().set(this.pos(), this.pos() + (long)newSizeInChunks);
            this.innerWriteLock.lock();
            this.incrementSegmentEntriesIfNeeded();
            if (newValueSizeIsDifferent) {
                this.initValue(newValue);
            } else {
                this.writeValue(newValue);
            }
        } else {
            if (newValueSizeIsDifferent) {
                assert (newSizeOfEverythingBeforeValue >= 0L);
            } else {
                newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            }
            long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
            if (newValueSizeIsDifferent) {
                this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - entryStartOffset);
                this.initValue(newValue);
            } else {
                long oldValueSizeOffset = this.valueSizeOffset();
                long oldValueSize = this.valueSize();
                long oldValueOffset = this.valueOffset();
                this.initEntryAndKeyCopying(entrySize, this.valueOffset() - entryStartOffset);
                this.initValueWithoutSize(newValue, oldValueSizeOffset, oldValueSize, oldValueOffset);
            }
            this.freeExtraAllocatedChunks();
        }
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    public void initEntryAndKey(long entrySize) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.writeNewEntry(this.alloc(this.allocatedChunks()), this.inputKey());
        this.incrementSegmentEntriesIfNeeded();
    }

    public boolean searchStateDeleted() {
        return this.searchState() == SearchState.DELETED && !this.concurrentSameThreadContexts() && this.innerUpdateLock.isHeldByCurrentThread();
    }

    public void dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed() {
        if (this.locksInit() && this.concurrentSameThreadContexts() && this.rootContextOnThisSegment().latestSameThreadSegmentModCount() != this.contextModCount() && this.keySearchInit() && this.searchState() == SearchState.PRESENT && !this.checkSlotContainsExpectedKeyAndValue(this.pos())) {
            this.closeHashLookupPos();
        }
    }

    public void closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed();
    }

    public void closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.replaceValue(entry, newValue);
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.remove(entry);
    }

    @Override
    @NotNull
    public Data<V> defaultValue() {
        this.checkOnEachPublicOperation();
        return this.wrapValueAsValue(this.m().defaultValue(this.deprecatedMapKeyContext));
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @Override
    @NotNull
    public MapContext<K, V, ?> context() {
        this.checkOnEachPublicOperation();
        return this;
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.insert(absentEntry, value);
    }

    @Override
    public Data<V> wrapValueAsValue(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceData wrapped = this.wrappedValueInstanceValue;
        wrapped = wrapped.getUnusedWrappedValueGuarded();
        wrapped.initValue(value);
        return wrapped;
    }

    @Override
    public Data<K> queriedKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    public Data<V> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.defaultValue(absentEntry);
    }

    @Override
    @NotNull
    public Data<K> absentKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    public boolean searchStatePresent() {
        return this.searchState() == SearchState.PRESENT;
    }

    public boolean entryPresent() {
        return this.searchStatePresent();
    }

    @Override
    public MapEntry<K, V> entry() {
        this.checkOnEachPublicOperation();
        return this.entryPresent() ? this : null;
    }

    @Override
    @Nullable
    public MapAbsentEntry<K, V> absentEntry() {
        this.checkOnEachPublicOperation();
        return this.entryPresent() ? null : this.absent();
    }

    public boolean searchStateAbsent() {
        return !this.searchStatePresent() && !this.searchStateDeleted();
    }

    void putEntry(Data<V> value) {
        assert (this.searchStateAbsent());
        long entrySize = this.entrySize(this.inputKey().size(), value.size());
        this.initEntryAndKey(entrySize);
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putNewVolatile(this.pos());
    }

    protected void putPrefix() {
        boolean searchResultsNotTrusted;
        boolean underUpdatedLockIsHeld;
        this.checkOnEachPublicOperation();
        boolean bl = underUpdatedLockIsHeld = !this.innerUpdateLock.isHeldByCurrentThread();
        if (underUpdatedLockIsHeld) {
            this.innerUpdateLock.lock();
        }
        boolean bl2 = searchResultsNotTrusted = underUpdatedLockIsHeld || this.concurrentSameThreadContexts();
        if (this.hashLookupPosInit() && this.searchStateAbsent() && searchResultsNotTrusted) {
            this.closeHashLookupPos();
        }
    }

    @Override
    public void doInsert(Data<V> value) {
        this.putPrefix();
        if (!this.searchStatePresent()) {
            if (this.searchStateDeleted()) {
                this.putValueDeletedEntry(value);
            } else {
                this.putEntry(value);
            }
        } else {
            throw new IllegalStateException("Entry is present in the map when doInsert() is called");
        }
        this.incrementModCountGuarded();
        this.setSearchStateGuarded(SearchState.PRESENT);
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.putPrefix();
        if (!this.searchStatePresent()) {
            throw new IllegalStateException("Entry is absent in the map when doReplaceValue() is called");
        }
        this.innerDefaultReplaceValue(newValue);
        this.incrementModCountGuarded();
        this.setSearchStateGuarded(SearchState.PRESENT);
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        if (!this.searchStatePresent()) {
            throw new IllegalStateException("Entry is absent when doRemove() is called");
        }
        this.innerWriteLock.lock();
        this.remove();
        this.innerRemoveEntryExceptHashLookupUpdate();
        this.setSearchStateGuarded(SearchState.DELETED);
    }

    public boolean usedInit() {
        return this.used;
    }

    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
    }

    public boolean inputBytesInit() {
        return this.inputBytes != null;
    }

    public void initInputBytes(Bytes inputBytes) {
        this.inputBytes = inputBytes;
        this.inputStore.setBytes(inputBytes);
        this.closeInputBytesDependants();
    }

    public Bytes inputBytes() {
        assert (this.inputBytesInit()) : "InputBytes should be init";
        return this.inputBytes;
    }

    public void closeInputBytes() {
        if (!this.inputBytesInit()) {
            return;
        }
        this.closeInputBytesDependants();
        this.inputBytes = null;
    }

    public void closeInputBytesDependants() {
        this.closeInputKeyOffsets();
        this.closeFirstInputValueOffsets();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesDataGetUsingDependants();
        this.inputKeyBytesValue.closeInputKeyBytesDataGetUsingDependants();
        this.closeSecondInputValueOffsets();
        this.inputSecondValueBytesValue.closeInputSecondValueBytesDataGetUsingDependants();
    }

    public boolean inputKeyOffsetsInit() {
        return this.inputKeySize >= 0L;
    }

    private void initInputKeyOffsets() {
        this.inputKeySize = this.h().keySizeMarshaller.readSize(this.inputBytes());
        this.inputKeyOffset = this.inputBytes().position();
        this.closeInputKeyOffsetsDependants();
    }

    public long inputKeyOffset() {
        if (!this.inputKeyOffsetsInit()) {
            this.initInputKeyOffsets();
        }
        return this.inputKeyOffset;
    }

    public long inputKeySize() {
        if (!this.inputKeyOffsetsInit()) {
            this.initInputKeyOffsets();
        }
        return this.inputKeySize;
    }

    public void closeInputKeyOffsets() {
        if (!this.inputKeyOffsetsInit()) {
            return;
        }
        this.closeInputKeyOffsetsDependants();
        this.inputKeySize = -1L;
    }

    public void closeInputKeyOffsetsDependants() {
        this.closeFirstInputValueOffsets();
        this.inputKeyBytesValue.closeInputKeyBytesDataSizeDependants();
        this.inputKeyBytesValue.closeInputKeyBytesDataGetUsingDependants();
    }

    public boolean firstInputValueOffsetsInit() {
        return this.firstInputValueSize >= 0L;
    }

    private void initFirstInputValueOffsets() {
        this.inputBytes().position(this.inputKeyOffset() + this.inputKeySize());
        this.firstInputValueSize = this.m().valueSizeMarshaller.readSize(this.inputBytes());
        this.firstInputValueOffset = this.inputBytes().position();
        this.closeFirstInputValueOffsetsDependants();
    }

    public long firstInputValueOffset() {
        if (!this.firstInputValueOffsetsInit()) {
            this.initFirstInputValueOffsets();
        }
        return this.firstInputValueOffset;
    }

    public long firstInputValueSize() {
        if (!this.firstInputValueOffsetsInit()) {
            this.initFirstInputValueOffsets();
        }
        return this.firstInputValueSize;
    }

    public void closeFirstInputValueOffsets() {
        if (!this.firstInputValueOffsetsInit()) {
            return;
        }
        this.closeFirstInputValueOffsetsDependants();
        this.firstInputValueSize = -1L;
    }

    public void closeFirstInputValueOffsetsDependants() {
        this.closeSecondInputValueOffsets();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesDataSizeDependants();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesDataGetUsingDependants();
    }

    public boolean secondInputValueOffsetsInit() {
        return this.secondInputValueSize >= 0L;
    }

    private void initSecondInputValueOffsets() {
        this.inputBytes().position(this.firstInputValueOffset() + this.firstInputValueSize());
        this.secondInputValueSize = this.m().valueSizeMarshaller.readSize(this.inputBytes());
        this.secondInputValueOffset = this.inputBytes().position();
        this.closeSecondInputValueOffsetsDependants();
    }

    public long secondInputValueOffset() {
        if (!this.secondInputValueOffsetsInit()) {
            this.initSecondInputValueOffsets();
        }
        return this.secondInputValueOffset;
    }

    public long secondInputValueSize() {
        if (!this.secondInputValueOffsetsInit()) {
            this.initSecondInputValueOffsets();
        }
        return this.secondInputValueSize;
    }

    public void closeSecondInputValueOffsets() {
        if (!this.secondInputValueOffsetsInit()) {
            return;
        }
        this.closeSecondInputValueOffsetsDependants();
        this.secondInputValueSize = -1L;
    }

    public void closeSecondInputValueOffsetsDependants() {
        this.inputSecondValueBytesValue.closeInputSecondValueBytesDataSizeDependants();
        this.inputSecondValueBytesValue.closeInputSecondValueBytesDataGetUsingDependants();
    }

    public class UsingReturnValue
    implements UsableReturnValue<V> {
        private V usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINT;
        private V returnedValue = null;

        @Override
        public void returnValue(@NotNull Data<V> value) {
            this.initReturnedValue(value);
        }

        public boolean usingReturnValueInit() {
            return this.usingReturnValue != UsableReturnValue.USING_RETURN_VALUE_UNINT;
        }

        @Override
        public void initUsingReturnValue(V usingReturnValue) {
            this.usingReturnValue = usingReturnValue;
            this.closeUsingReturnValueDependants();
        }

        public V usingReturnValue() {
            assert (this.usingReturnValueInit()) : "UsingReturnValue should be init";
            return this.usingReturnValue;
        }

        public void closeUsingReturnValue() {
            if (!this.usingReturnValueInit()) {
                return;
            }
            this.closeUsingReturnValueDependants();
            this.usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINT;
        }

        public void closeUsingReturnValueDependants() {
            this.closeReturnedValue();
        }

        boolean returnedValueInit() {
            return this.returnedValue != null;
        }

        private void initReturnedValue(@NotNull Data<V> value) {
            this.returnedValue = value.getUsing(this.usingReturnValue());
        }

        public V returnedValue() {
            assert (this.returnedValueInit()) : "ReturnedValue should be init";
            return this.returnedValue;
        }

        public void closeReturnedValue() {
            if (!this.returnedValueInit()) {
                return;
            }
            this.returnedValue = null;
        }

        @Override
        public V returnValue() {
            if (this.returnedValueInit()) {
                return this.returnedValue();
            }
            return null;
        }
    }

    public class InputValueInstanceData
    extends CopyingInstanceData<V>
    implements ValueInitableData<V> {
        private V value = null;
        private boolean marshalled = false;
        private DirectBytes buffer;

        public boolean valueInit() {
            return this.value != null;
        }

        @Override
        public void initValue(V value) {
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        @Override
        public V instance() {
            return this.value();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mvi = CompiledMapQueryContext.this.valueMetaInterop(this.value());
            long size = mvi.size(CompiledMapQueryContext.this.valueInterop, this.value());
            this.buffer = this.getBuffer(this.buffer, size);
            mvi.write(CompiledMapQueryContext.this.valueInterop, (Bytes)this.buffer, this.value());
            this.buffer.flip();
            this.marshalled = true;
        }

        @Override
        public DirectBytes buffer() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buffer;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public V getUsing(V usingValue) {
            this.buffer().position(0L);
            return CompiledMapQueryContext.this.valueReader.read((Bytes)this.buffer(), this.buffer().limit(), usingValue);
        }
    }

    public class InputKeyInstanceData
    extends CopyingInstanceData<K>
    implements KeyInitableData<K> {
        private K key = null;
        private boolean marshalled = false;
        private DirectBytes buffer;

        public boolean keyInit() {
            return this.key != null;
        }

        @Override
        public void initKey(K key) {
            this.key = key;
            this.closeKeyDependants();
        }

        public K key() {
            assert (this.keyInit()) : "Key should be init";
            return this.key;
        }

        public void closeKey() {
            if (!this.keyInit()) {
                return;
            }
            this.closeKeyDependants();
            this.key = null;
        }

        public void closeKeyDependants() {
            this.closeBuffer();
        }

        @Override
        public K instance() {
            return this.key();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mki = CompiledMapQueryContext.this.keyMetaInterop(this.key());
            long size = mki.size(CompiledMapQueryContext.this.keyInterop, this.key());
            this.buffer = this.getBuffer(this.buffer, size);
            mki.write(CompiledMapQueryContext.this.keyInterop, (Bytes)this.buffer, this.key());
            this.buffer.flip();
            this.marshalled = true;
        }

        @Override
        public DirectBytes buffer() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buffer;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public K getUsing(K usingKey) {
            this.buffer().position(0L);
            return CompiledMapQueryContext.this.keyReader.read((Bytes)this.buffer(), this.buffer().limit(), usingKey);
        }
    }

    public class DefaultReturnValue
    implements InstanceReturnValue<V> {
        private V defaultReturnedValue = null;

        @Override
        public void returnValue(@NotNull Data<V> value) {
            this.initDefaultReturnedValue(value);
        }

        boolean defaultReturnedValueInit() {
            return this.defaultReturnedValue != null;
        }

        private void initDefaultReturnedValue(@NotNull Data<V> value) {
            this.defaultReturnedValue = value.getUsing(null);
        }

        public V defaultReturnedValue() {
            assert (this.defaultReturnedValueInit()) : "DefaultReturnedValue should be init";
            return this.defaultReturnedValue;
        }

        public void closeDefaultReturnedValue() {
            if (!this.defaultReturnedValueInit()) {
                return;
            }
            this.defaultReturnedValue = null;
        }

        @Override
        public V returnValue() {
            if (this.defaultReturnedValueInit()) {
                return this.defaultReturnedValue();
            }
            return null;
        }
    }

    public static enum SearchState {
        PRESENT,
        DELETED,
        ABSENT;

    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().writeLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapQueryContext.this.localLockState().write;
        }

        @Override
        public void lock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().writeLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }
    }

    public class WrappedValueInstanceData
    extends CopyingInstanceData<V> {
        private WrappedValueInstanceData next;
        private V value;
        private boolean marshalled = false;
        private DirectBytes buf;

        public WrappedValueInstanceData getUnusedWrappedValueGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValue();
        }

        public WrappedValueInstanceData getUnusedWrappedValue() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceData();
            }
            return this.next.getUnusedWrappedValue();
        }

        boolean nextInit() {
            return true;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            CompiledMapQueryContext.this.m().checkValue(value);
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next != null) {
                this.next.closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        @Override
        public V instance() {
            return this.value();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mvi = CompiledMapQueryContext.this.valueMetaInterop(this.value());
            long size = mvi.size(CompiledMapQueryContext.this.valueInterop, this.value());
            this.buf = this.getBuffer(this.buf, size);
            mvi.write(CompiledMapQueryContext.this.valueInterop, (Bytes)this.buf, this.value());
            this.buf.flip();
            this.marshalled = true;
        }

        public DirectBytes buf() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buf;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public V getUsing(V usingValue) {
            this.buf().position(0L);
            return CompiledMapQueryContext.this.valueReader.read((Bytes)this.buf(), this.buf().limit(), usingValue);
        }

        @Override
        public DirectBytes buffer() {
            return this.buf();
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().updateLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapQueryContext.this.localLockState().update;
        }

        @Override
        public void unlock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().downgradeWriteToReadLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().updateLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                CompiledMapQueryContext.this.segmentHeader().readLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public void lock() {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                CompiledMapQueryContext.this.segmentHeader().readLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        public void closeReadLockLockDependants() {
            CompiledMapQueryContext.this.closeHashLookupPos();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapQueryContext.this.localLockState().read;
        }

        @Override
        public void unlock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    return;
                }
                case READ_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().readUnlock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    break;
                }
                case UPDATE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().updateUnlock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().writeUnlock(CompiledMapQueryContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
            CompiledMapQueryContext.this.closeHashLookupPos();
            CompiledMapQueryContext.this.closePos();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapQueryContext.this.segmentHeader().tryReadLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean tryLock() {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapQueryContext.this.segmentHeader().tryReadLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public class InputSecondValueBytesData
    extends AbstractData<V> {
        private V cachedBytesInputSecondValue;
        private boolean cachedBytesInputSecondValueRead = false;

        @Override
        public RandomDataInput bytes() {
            return CompiledMapQueryContext.this.inputStore;
        }

        @Override
        public long offset() {
            return CompiledMapQueryContext.this.secondInputValueOffset();
        }

        @Override
        public long size() {
            return CompiledMapQueryContext.this.secondInputValueSize();
        }

        public void closeInputSecondValueBytesDataSizeDependants() {
            this.closeInputSecondValueBytesDataGetUsingDependants();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledMapQueryContext.this.inputBytes().position(CompiledMapQueryContext.this.secondInputValueOffset());
            return CompiledMapQueryContext.this.valueReader.read(CompiledMapQueryContext.this.inputBytes(), this.size(), usingValue);
        }

        public void closeInputSecondValueBytesDataGetUsingDependants() {
            this.closeCachedBytesInputSecondValue();
        }

        public boolean cachedBytesInputSecondValueInit() {
            return this.cachedBytesInputSecondValueRead;
        }

        private void initCachedBytesInputSecondValue() {
            this.cachedBytesInputSecondValue = this.getUsing(this.cachedBytesInputSecondValue);
            this.cachedBytesInputSecondValueRead = true;
        }

        public V cachedBytesInputSecondValue() {
            if (!this.cachedBytesInputSecondValueInit()) {
                this.initCachedBytesInputSecondValue();
            }
            return this.cachedBytesInputSecondValue;
        }

        public void closeCachedBytesInputSecondValue() {
            if (!this.cachedBytesInputSecondValueInit()) {
                return;
            }
            this.cachedBytesInputSecondValueRead = false;
        }

        @Override
        public V get() {
            return this.cachedBytesInputSecondValue();
        }
    }

    public class InputKeyBytesData
    extends AbstractData<K> {
        private K cachedBytesInputKey;
        private boolean cachedBytesInputKeyRead = false;

        @Override
        public RandomDataInput bytes() {
            return CompiledMapQueryContext.this.inputStore;
        }

        @Override
        public long offset() {
            return CompiledMapQueryContext.this.inputKeyOffset();
        }

        @Override
        public long size() {
            return CompiledMapQueryContext.this.inputKeySize();
        }

        public void closeInputKeyBytesDataSizeDependants() {
            this.closeInputKeyBytesDataGetUsingDependants();
        }

        @Override
        public K getUsing(K usingKey) {
            Bytes inputBytes = CompiledMapQueryContext.this.inputBytes();
            inputBytes.position(CompiledMapQueryContext.this.inputKeyOffset());
            return CompiledMapQueryContext.this.keyReader.read(inputBytes, this.size(), usingKey);
        }

        public void closeInputKeyBytesDataGetUsingDependants() {
            this.closeCachedBytesInputKey();
        }

        public boolean cachedBytesInputKeyInit() {
            return this.cachedBytesInputKeyRead;
        }

        private void initCachedBytesInputKey() {
            this.cachedBytesInputKey = this.getUsing((K)this.cachedBytesInputKey);
            this.cachedBytesInputKeyRead = true;
        }

        public K cachedBytesInputKey() {
            if (!this.cachedBytesInputKeyInit()) {
                this.initCachedBytesInputKey();
            }
            return this.cachedBytesInputKey;
        }

        public void closeCachedBytesInputKey() {
            if (!this.cachedBytesInputKeyInit()) {
                return;
            }
            this.cachedBytesInputKeyRead = false;
        }

        @Override
        public K get() {
            return this.cachedBytesInputKey();
        }
    }

    public class InputFirstValueBytesData
    extends AbstractData<V> {
        private V cachedBytesInputFirstValue;
        private boolean cachedBytesInputFirstValueRead = false;

        @Override
        public RandomDataInput bytes() {
            return CompiledMapQueryContext.this.inputStore;
        }

        @Override
        public long offset() {
            return CompiledMapQueryContext.this.firstInputValueOffset();
        }

        @Override
        public long size() {
            return CompiledMapQueryContext.this.firstInputValueSize();
        }

        public void closeInputFirstValueBytesDataSizeDependants() {
            this.closeInputFirstValueBytesDataGetUsingDependants();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledMapQueryContext.this.inputBytes().position(CompiledMapQueryContext.this.firstInputValueOffset());
            return CompiledMapQueryContext.this.valueReader.read(CompiledMapQueryContext.this.inputBytes(), this.size(), usingValue);
        }

        public void closeInputFirstValueBytesDataGetUsingDependants() {
            this.closeCachedBytesInputFirstValue();
        }

        public boolean cachedBytesInputFirstValueInit() {
            return this.cachedBytesInputFirstValueRead;
        }

        private void initCachedBytesInputFirstValue() {
            this.cachedBytesInputFirstValue = this.getUsing(this.cachedBytesInputFirstValue);
            this.cachedBytesInputFirstValueRead = true;
        }

        public V cachedBytesInputFirstValue() {
            if (!this.cachedBytesInputFirstValueInit()) {
                this.initCachedBytesInputFirstValue();
            }
            return this.cachedBytesInputFirstValue;
        }

        public void closeCachedBytesInputFirstValue() {
            if (!this.cachedBytesInputFirstValueInit()) {
                return;
            }
            this.cachedBytesInputFirstValueRead = false;
        }

        @Override
        public V get() {
            return this.cachedBytesInputFirstValue();
        }
    }

    public class EntryValueBytesData
    extends AbstractData<V> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead = false;

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            CompiledMapQueryContext.this.entryBytes.position(CompiledMapQueryContext.this.valueOffset());
            return CompiledMapQueryContext.this.valueReader.read(CompiledMapQueryContext.this.entryBytes, this.size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingValue);
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBS;
        }
    }

    public class EntryKeyBytesData
    extends AbstractData<K> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keyOffset();
        }

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        private K innerGetUsing(K usingKey) {
            CompiledMapQueryContext.this.entryBytes.position(CompiledMapQueryContext.this.keyOffset());
            return CompiledMapQueryContext.this.keyReader.read(CompiledMapQueryContext.this.entryBytes, this.size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                return;
            }
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }

        @Override
        public K getUsing(K usingKey) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingKey);
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBS;
        }
    }

    public class DeprecatedMapKeyContextOnQuery
    implements MapKeyContext<K, V> {
        @Override
        @NotNull
        public InterProcessLock writeLock() {
            return CompiledMapQueryContext.this.writeLock();
        }

        @Override
        @NotNull
        public InterProcessLock readLock() {
            return CompiledMapQueryContext.this.readLock();
        }

        @Override
        @NotNull
        public InterProcessLock updateLock() {
            return CompiledMapQueryContext.this.updateLock();
        }

        @Override
        public long keySize() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keySize();
        }

        @Override
        public long valueSize() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueSize();
        }

        @Override
        public void close() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            CompiledMapQueryContext.this.close();
        }

        @Override
        public boolean valueEqualTo(V value) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return Data.bytesEquivalent(CompiledMapQueryContext.this.entryValue, CompiledMapQueryContext.this.wrapValueAsValue(value));
        }

        @Override
        public long valueOffset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueOffset();
        }

        @Override
        @NotNull
        public Bytes entry() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBytes;
        }

        @Override
        public long keyOffset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keyOffset();
        }

        @Override
        @NotNull
        public K key() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.queriedKey().get();
        }

        @Override
        public boolean remove() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.updateLock().lock();
            HashEntry entry = CompiledMapQueryContext.this.entry();
            if (entry != null) {
                CompiledMapQueryContext.this.remove(entry);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsKey() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entry() != null;
        }

        @Override
        public V getUsing(V usingValue) {
            return this.containsKey() ? (Object)CompiledMapQueryContext.this.value().getUsing(usingValue) : null;
        }

        @Override
        public V get() {
            return this.containsKey() ? (Object)CompiledMapQueryContext.this.value().get() : null;
        }

        @Override
        public boolean put(V newValue) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.updateLock().lock();
            HashEntry entry = CompiledMapQueryContext.this.entry();
            if (entry != null) {
                CompiledMapQueryContext.this.replaceValue(entry, CompiledMapQueryContext.this.wrapValueAsValue(newValue));
            } else {
                CompiledMapQueryContext.this.insert(CompiledMapQueryContext.this.absentEntry(), CompiledMapQueryContext.this.wrapValueAsValue(newValue));
            }
            return true;
        }
    }

    public class DeprecatedMapAcquireContextOnQuery
    implements MapKeyContext<K, V> {
        @Override
        @NotNull
        public InterProcessLock writeLock() {
            return CompiledMapQueryContext.this.writeLock();
        }

        @Override
        @NotNull
        public InterProcessLock readLock() {
            return CompiledMapQueryContext.this.readLock();
        }

        @Override
        @NotNull
        public InterProcessLock updateLock() {
            return CompiledMapQueryContext.this.updateLock();
        }

        @Override
        public long valueOffset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueOffset();
        }

        @Override
        public long keyOffset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keyOffset();
        }

        @Override
        @NotNull
        public Bytes entry() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBytes;
        }

        @Override
        public long keySize() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keySize();
        }

        @Override
        @NotNull
        public K key() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.queriedKey().get();
        }

        @Override
        public long valueSize() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueSize();
        }

        @Override
        public boolean valueEqualTo(V value) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return Data.bytesEquivalent(CompiledMapQueryContext.this.entryValue, CompiledMapQueryContext.this.wrapValueAsValue(value));
        }

        @Override
        public boolean remove() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.updateLock().lock();
            HashEntry entry = CompiledMapQueryContext.this.entry();
            if (entry != null) {
                CompiledMapQueryContext.this.remove(entry);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsKey() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entry() != null;
        }

        @Override
        public V getUsing(V usingValue) {
            return this.containsKey() ? (Object)CompiledMapQueryContext.this.value().getUsing(usingValue) : null;
        }

        @Override
        public boolean put(V newValue) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.updateLock().lock();
            HashEntry entry = CompiledMapQueryContext.this.entry();
            if (entry != null) {
                CompiledMapQueryContext.this.replaceValue(entry, CompiledMapQueryContext.this.wrapValueAsValue(newValue));
            } else {
                CompiledMapQueryContext.this.insert(CompiledMapQueryContext.this.absentEntry(), CompiledMapQueryContext.this.wrapValueAsValue(newValue));
            }
            return true;
        }

        @Override
        public V get() {
            assert (this.containsKey());
            return CompiledMapQueryContext.this.usingReturnValue.returnValue();
        }

        @Override
        public void close() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.put(CompiledMapQueryContext.this.usingReturnValue.returnValue());
            CompiledMapQueryContext.this.close();
        }
    }
}

