/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;

public class ServiceDescriptor<K, V>
implements Marshallable {
    public Class<K> keyClass;
    public Class<V> valueClass;
    public short channelID;

    public ServiceDescriptor() {
    }

    public ServiceDescriptor(Class<K> keyClass, Class<V> valueClass, short channelID) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.channelID = channelID;
    }

    public void writeMarshallable(WireOut wire) {
        wire.write(() -> "keyClass").text((CharSequence)this.keyClass.getName());
        wire.write(() -> "valueClass").text((CharSequence)this.valueClass.getName());
        wire.write(() -> "channelID").int16(this.channelID);
    }

    public void readMarshallable(WireIn wire) throws IllegalStateException {
        try {
            this.keyClass = Class.forName(wire.read(() -> "keyClass").text());
            this.valueClass = Class.forName(wire.read(() -> "valueClass").text());
            this.channelID = wire.read(() -> "channelID").int16();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDescriptor serviceDescriptor = (ServiceDescriptor)o;
        if (this.channelID != serviceDescriptor.channelID) {
            return false;
        }
        if (!this.keyClass.equals(serviceDescriptor.keyClass)) {
            return false;
        }
        return this.valueClass.equals(serviceDescriptor.valueClass);
    }

    public int hashCode() {
        int result = this.keyClass.hashCode();
        result = 31 * result + this.valueClass.hashCode();
        result = 31 * result + this.channelID;
        return result;
    }
}

