/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Accessor;
import net.openhft.chronicle.bytes.ReadAccess;
import net.openhft.chronicle.hash.AbstractValue;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.Value;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CopyingInstanceValue;
import net.openhft.chronicle.hash.impl.JavaLangBytesAccessors;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.hashlookup.EntryConsumer;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.locks.InterProcessReadWriteUpdateLock;
import net.openhft.chronicle.hash.replication.RemoteOperationContext;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapKeyContext;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.IterationContextInterface;
import net.openhft.chronicle.map.impl.ReplicatedChronicleMapHolder;
import net.openhft.chronicle.map.replication.MapReplicableEntry;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;

public class CompiledReplicatedMapIterationContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R, T>
implements AutoCloseable,
HashEntry<K>,
InterProcessReadWriteUpdateLock,
RemoteOperationContext<K>,
MapContext<K, V, R>,
MapEntry<K, V>,
IterationContextInterface<K, V>,
ReplicatedChronicleMapHolder<K, KI, MKI, V, VI, MVI, R>,
MapReplicableEntry<K, V> {
    final Thread owner;
    public final int indexInContextChain;
    public final Bytes entryBytes;
    public static final int MAX_SEGMENT_CHUNKS = 0x40000000;
    public static final int MAX_SEGMENT_ENTRIES = 0x20000000;
    public static final long UNSET_KEY = 0L;
    public static final long UNSET_ENTRY = 0L;
    public final ReadLock innerReadLock;
    public final WriteLock innerWriteLock;
    public final List<CompiledReplicatedMapIterationContext> contextChain;
    public final UpdateLock innerUpdateLock;
    public final ThreadLocalCopies copies;
    final EntryKeyBytesValue entryKey;
    public final EntryValueBytesValue entryValue;
    final WrappedValueInstanceValue wrappedValueInstanceValue;
    public final DeprecatedMapKeyContextOnIteration deprecatedMapKeyContextOnIteration;
    private final ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m;
    public final VI valueInterop;
    final Accessor.Full<Bytes, ?> entryBytesAccessor;
    public final T entryBytesAccessHandle;
    public final BytesReader<V> valueReader;
    public final KI keyInterop;
    public final Access<T> entryBytesAccess;
    public final BytesReader<K> keyReader;
    boolean used;
    public boolean entryRemovedOnThisIteration = false;
    public int segmentIndex = -1;
    int hashLookupEntrySize;
    int keyBits;
    long address = -1L;
    long capacityMask;
    long capacityMask2;
    long keyMask;
    long valueMask;
    long entryMask;
    long entrySpaceOffset = 0L;
    MultiStoreBytes freeListBytes = new MultiStoreBytes();
    public SingleThreadedDirectBitSet freeList = new SingleThreadedDirectBitSet();
    public long pos = -1L;
    public long keySizeOffset;
    public long keySize;
    public long keyOffset;
    long replicationBytesOffset = -1L;
    long segmentHeaderAddress;
    SegmentHeader segmentHeader = null;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    CompiledReplicatedMapIterationContext nextNode;
    public boolean concurrentSameThreadContexts;
    LocalLockState localLockState;
    public CompiledReplicatedMapIterationContext rootContextOnThisSegment = null;
    public int allocatedChunks = 0;
    public long hashLookupPos = -1L;
    public long newTimestamp;
    public byte newIdentifier = 0;
    public long valueSizeOffset;
    public long valueSize;
    public long valueOffset = -1L;
    public int entrySizeInChunks = 0;
    private boolean updatedReplicationState = false;

    @Override
    public void close() {
        this.closeReplicationUpdate();
        this.closeHashLookupPos();
        this.wrappedValueInstanceValue.closeValue();
        this.closeAllocatedChunks();
        this.wrappedValueInstanceValue.closeNext();
        this.closeTheSegmentIndex();
        this.closeEntryRemovedOnThisIteration();
        this.closeUsed();
        this.closeReplicatedMapEntryStagesEntryBytesAccessOffsetDependants();
        this.closeMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants();
        this.closeReplicatedChronicleMapHolderImplContextAtIndexInChainDependants();
        this.closeValueBytesInteropValueMetaInteropDependants();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        assert (this.hashLookupPosInit()) : "HashLookupPos should be init";
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    public void writeValueGuarded(Value<?, ?> value) {
        if (!this.valueInit()) {
            this.initValue();
        }
        this.writeValue(value);
    }

    void initKeySizeOffset(long pos) {
        this.keySizeOffset = this.entrySpaceOffset() + pos * this.h().chunkSize;
        this.entryBytes.limit(this.entryBytes.capacity());
    }

    public CompiledReplicatedMapIterationContext(ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m) {
        this.contextChain = new ArrayList<CompiledReplicatedMapIterationContext>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.m = m;
        this.owner = Thread.currentThread();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = ((ReplicatedChronicleMap)this.m()).valueInteropProvider.get(this.copies, ((ReplicatedChronicleMap)this.m()).originalValueInterop);
        this.valueReader = (BytesReader)((ReplicatedChronicleMap)this.m()).valueReaderProvider.get(this.copies, (Object)((ReplicatedChronicleMap)this.m()).originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.innerReadLock = new ReadLock();
        this.entryBytes = this.h().ms.bytes();
        this.entryBytesAccessor = JavaLangBytesAccessors.uncheckedBytesAccessor(this.entryBytes);
        this.entryBytesAccessHandle = this.entryBytesAccessor.handle((Object)this.entryBytes);
        this.entryBytesAccess = (Access)this.entryBytesAccessor.access((Object)this.entryBytes);
        this.wrappedValueInstanceValue = new WrappedValueInstanceValue();
        this.entryValue = new EntryValueBytesValue();
        this.innerUpdateLock = new UpdateLock();
        this.deprecatedMapKeyContextOnIteration = new DeprecatedMapKeyContextOnIteration();
        this.entryKey = new EntryKeyBytesValue();
        this.innerWriteLock = new WriteLock();
    }

    public CompiledReplicatedMapIterationContext(CompiledReplicatedMapIterationContext c) {
        this.contextChain = c.contextChain;
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.m = c.m;
        this.owner = Thread.currentThread();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = ((ReplicatedChronicleMap)this.m()).valueInteropProvider.get(this.copies, ((ReplicatedChronicleMap)this.m()).originalValueInterop);
        this.valueReader = (BytesReader)((ReplicatedChronicleMap)this.m()).valueReaderProvider.get(this.copies, (Object)((ReplicatedChronicleMap)this.m()).originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.innerReadLock = new ReadLock();
        this.entryBytes = this.h().ms.bytes();
        this.entryBytesAccessor = JavaLangBytesAccessors.uncheckedBytesAccessor(this.entryBytes);
        this.entryBytesAccessHandle = this.entryBytesAccessor.handle((Object)this.entryBytes);
        this.entryBytesAccess = (Access)this.entryBytesAccessor.access((Object)this.entryBytes);
        this.wrappedValueInstanceValue = new WrappedValueInstanceValue();
        this.entryValue = new EntryValueBytesValue();
        this.innerUpdateLock = new UpdateLock();
        this.deprecatedMapKeyContextOnIteration = new DeprecatedMapKeyContextOnIteration();
        this.entryKey = new EntryKeyBytesValue();
        this.innerWriteLock = new WriteLock();
    }

    private void _MapEntryStages_writeValue(Value<?, ?> value) {
        value.writeTo(this.entryBytesAccess, this.entryBytesAccessHandle, this.entryBytesAccessOffset(this.valueOffset));
    }

    public void incrementModCount() {
        this.contextModCount = ++this.rootContextOnThisSegment.latestSameThreadSegmentModCount;
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        this.localLockState = newState;
    }

    public void writeValue(Value<?, ?> value) {
        this._MapEntryStages_writeValue(value);
        this.initUpdatedReplicationState();
        this.updateChange();
    }

    public Thread owner() {
        return this.owner;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        switch (this.localLockState) {
            case UNLOCKED: {
                break;
            }
            case READ_LOCKED: {
                int newTotalReadLockCount = --this.rootContextOnThisSegment.totalReadLockCount;
                if (newTotalReadLockCount == 0) {
                    if (this.rootContextOnThisSegment.totalUpdateLockCount != 0 || this.rootContextOnThisSegment.totalWriteLockCount != 0) break;
                    this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                    break;
                }
                if (newTotalReadLockCount >= 0) break;
                throw new IllegalStateException("read underflow");
            }
            case UPDATE_LOCKED: {
                int newTotalUpdateLockCount = --this.rootContextOnThisSegment.totalUpdateLockCount;
                if (newTotalUpdateLockCount == 0) {
                    if (this.rootContextOnThisSegment.totalWriteLockCount != 0) break;
                    if (this.rootContextOnThisSegment.totalReadLockCount == 0) {
                        this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                        break;
                    }
                    this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                    break;
                }
                if (newTotalUpdateLockCount >= 0) break;
                throw new IllegalStateException("update underflow");
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = --this.rootContextOnThisSegment.totalWriteLockCount;
                if (newTotalWriteLockCount != 0) break;
                if (this.rootContextOnThisSegment.totalUpdateLockCount > 0) {
                    this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                    break;
                }
                if (this.rootContextOnThisSegment.totalReadLockCount > 0) {
                    this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                    break;
                }
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void closeRootLocks() {
        assert (this.nextNode == null);
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void innerInitSegmentHashLookup(long address, long capacity, int entrySize, int keyBits, int valueBits) {
        this.address = address;
        this.capacityMask = capacity - 1L;
        this.hashLookupEntrySize = entrySize;
        this.capacityMask2 = this.capacityMask * (long)entrySize;
        this.keyBits = keyBits;
        this.keyMask = CompiledReplicatedMapIterationContext.mask(keyBits);
        this.valueMask = CompiledReplicatedMapIterationContext.mask(valueBits);
        this.entryMask = CompiledReplicatedMapIterationContext.mask(keyBits + valueBits);
    }

    private void innerInitValue(Value<?, ?> value) {
        this.entryBytes.position(this.valueSizeOffset);
        this.valueSize = value.size();
        ((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.writeSize(this.entryBytes, this.valueSize);
        ((ReplicatedChronicleMap)this.m()).alignment.alignPositionAddr(this.entryBytes);
        this.valueOffset = this.entryBytes.position();
        this.writeValue(value);
    }

    private void unlinkFromSegmentContextsChain() {
        CompiledReplicatedMapIterationContext prevContext = this.rootContextOnThisSegment;
        while (true) {
            assert (prevContext.nextNode != null);
            if (prevContext.nextNode == this) break;
            prevContext = prevContext.nextNode;
        }
        assert (this.nextNode == null);
        prevContext.nextNode = null;
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public static int entrySize(int keyBits, int valueBits) {
        return (int)MemoryUnit.BYTES.alignAndConvert((long)(keyBits + valueBits), MemoryUnit.BITS);
    }

    public static int keyBits(long entriesPerSegment, int valueBits) {
        int minKeyBits = 64 - Long.numberOfLeadingZeros(entriesPerSegment - 1L);
        int actualEntryBits = (int)MemoryUnit.BYTES.align((long)((minKeyBits += 3) + valueBits), MemoryUnit.BITS);
        return actualEntryBits - valueBits;
    }

    public static int valueBits(long actualChunksPerSegment) {
        return 64 - Long.numberOfLeadingZeros(actualChunksPerSegment - 1L);
    }

    public Bytes entryBytes() {
        return this.entryBytes;
    }

    public static long capacityFor(long entriesPerSegment) {
        if (entriesPerSegment < 0L) {
            throw new IllegalArgumentException("entriesPerSegment should be positive");
        }
        long capacity = Maths.nextPower2((long)entriesPerSegment, (long)64L);
        if ((double)entriesPerSegment / (double)capacity > 0.6666666666666666) {
            capacity <<= 1;
        }
        return capacity;
    }

    public static long mask(int bits) {
        return (1L << bits) - 1L;
    }

    public int MAX_SEGMENT_ENTRIES() {
        return 0x20000000;
    }

    public int MAX_SEGMENT_CHUNKS() {
        return 0x40000000;
    }

    public long UNSET_ENTRY() {
        return 0L;
    }

    public long UNSET_KEY() {
        return 0L;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public List<CompiledReplicatedMapIterationContext> contextChain() {
        return this.contextChain;
    }

    public ThreadLocalCopies copies() {
        return this.copies;
    }

    public EntryKeyBytesValue entryKey() {
        return this.entryKey;
    }

    public EntryValueBytesValue entryValue() {
        return this.entryValue;
    }

    public WrappedValueInstanceValue wrappedValueInstanceValue() {
        return this.wrappedValueInstanceValue;
    }

    public DeprecatedMapKeyContextOnIteration deprecatedMapKeyContextOnIteration() {
        return this.deprecatedMapKeyContextOnIteration;
    }

    public VI valueInterop() {
        return this.valueInterop;
    }

    public Accessor.Full<Bytes, ?> entryBytesAccessor() {
        return this.entryBytesAccessor;
    }

    public T entryBytesAccessHandle() {
        return this.entryBytesAccessHandle;
    }

    public BytesReader<V> valueReader() {
        return this.valueReader;
    }

    public KI keyInterop() {
        return this.keyInterop;
    }

    public Access<T> entryBytesAccess() {
        return this.entryBytesAccess;
    }

    public BytesReader<K> keyReader() {
        return this.keyReader;
    }

    @Override
    public ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m() {
        return this.m;
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    @Override
    @NotNull
    public MapContext<K, V, ?> context() {
        return this;
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException("Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeInterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public MVI valueMetaInterop(V value) {
        return (MVI)((ReplicatedChronicleMap)this.m()).metaValueInteropProvider.get(this.copies, ((ReplicatedChronicleMap)this.m()).originalMetaValueInterop, this.valueInterop, value);
    }

    public void closeValueBytesInteropValueMetaInteropDependants() {
        this.wrappedValueInstanceValue.closeBuffer();
    }

    private CompiledReplicatedMapIterationContext _Chaining_createChaining() {
        return new CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, T>(this);
    }

    public CompiledReplicatedMapIterationContext createChaining() {
        return new CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, T>(this);
    }

    public <T> T getContext() {
        for (CompiledReplicatedMapIterationContext context : this.contextChain) {
            if (context.usedInit()) continue;
            return (T)context;
        }
        int maxNestedContexts = 65536;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        return (T)this.createChaining();
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (((ReplicatedChronicleMap)this.m()).constantlySizedEntry) {
            return ((ReplicatedChronicleMap)this.m()).alignment.alignAddr(sizeOfEverythingBeforeValue + valueSize);
        }
        if (((ReplicatedChronicleMap)this.m()).couldNotDetermineAlignmentBeforeAllocation) {
            return sizeOfEverythingBeforeValue + (long)((ReplicatedChronicleMap)this.m()).worstAlignment + valueSize;
        }
        return ((ReplicatedChronicleMap)this.m()).alignment.alignAddr(sizeOfEverythingBeforeValue) + valueSize;
    }

    public void incrementSegmentEntriesIfNeeded() {
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeReplicatedChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeSegmentStagesTryFindInitLocksOfThisSegmentDependants();
    }

    public void checkEntryNotRemovedOnThisIteration() {
        if (this.entryRemovedOnThisIterationInit()) {
            throw new IllegalStateException("Entry was already removed on this iteration");
        }
    }

    public void closeMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants() {
        this.closeInterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkAccessingFromOwnerThread();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.checkEntryNotRemovedOnThisIteration();
    }

    public void closeInterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryKey.closeEntryKeyBytesValueSizeDependants();
        this.entryValue.closeEntryValueBytesValueSizeDependants();
    }

    @Override
    public Value<V, ?> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.defaultValue(absentEntry);
    }

    @Override
    public Value<V, ?> wrapValueAsValue(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceValue wrapped = this.wrappedValueInstanceValue;
        wrapped = wrapped.getUnusedWrappedValueGuarded();
        wrapped.initValue(value);
        return wrapped;
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    @NotNull
    public Value<K, ?> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Value<V, ?> newValue) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.replaceValue(entry, newValue);
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.remove(entry);
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Value<V, ?> value) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.insert(absentEntry, value);
    }

    @Override
    @NotNull
    public Value<V, ?> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    public boolean entryIsPresent() {
        return true;
    }

    public long entryBytesAccessOffset(long offset) {
        return this.entryBytesAccessor.offset((Object)this.entryBytes, offset);
    }

    public void closeReplicatedMapEntryStagesEntryBytesAccessOffsetDependants() {
        this.closeEntry();
    }

    private long _MapEntryStages_sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)(((ReplicatedChronicleMap)this.m()).metaDataBytes + ((ReplicatedChronicleMap)this.m()).keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + (long)((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.sizeEncodingSize(valueSize);
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return this._MapEntryStages_sizeOfEverythingBeforeValue(keySize, valueSize) + 10L;
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    public MKI keyMetaInterop(K key) {
        return (MKI)((MetaBytesInterop)this.h().metaKeyInteropProvider.get(this.copies, this.h().originalMetaKeyInterop, this.keyInterop, key));
    }

    public boolean usedInit() {
        return this.used;
    }

    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
    }

    boolean entryRemovedOnThisIterationInit() {
        return this.entryRemovedOnThisIteration;
    }

    private void initEntryRemovedOnThisIteration(boolean entryRemovedOnThisIteration) {
        this.entryRemovedOnThisIteration = entryRemovedOnThisIteration;
    }

    public void closeEntryRemovedOnThisIteration() {
        if (!this.entryRemovedOnThisIterationInit()) {
            return;
        }
        this.entryRemovedOnThisIteration = false;
    }

    public boolean theSegmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    @Override
    public void initTheSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
        this.closeTheSegmentIndexDependants();
    }

    public int segmentIndex() {
        assert (this.theSegmentIndexInit()) : "TheSegmentIndex should be init";
        return this.segmentIndex;
    }

    public void closeTheSegmentIndex() {
        if (!this.theSegmentIndexInit()) {
            return;
        }
        this.closeTheSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeTheSegmentIndexDependants() {
        this.closeSegmentHashLookup();
        this.closeSegment();
        this.closeReplicationUpdateDropChangeDependants();
        this.closeReplicationUpdateUpdateChangeDependants();
        this.closeSegHeader();
    }

    public boolean segmentHashLookupInit() {
        return this.address >= 0L;
    }

    public void initSegmentHashLookup() {
        long hashLookupOffset = this.h().segmentOffset(this.segmentIndex());
        this.innerInitSegmentHashLookup(this.h().ms.address() + hashLookupOffset, this.h().segmentHashLookupCapacity, this.h().segmentHashLookupEntrySize, this.h().segmentHashLookupKeyBits, this.h().segmentHashLookupValueBits);
    }

    public void initSegmentHashLookup(long address, long capacity, int entrySize, int keyBits, int valueBits) {
        this.innerInitSegmentHashLookup(address, capacity, entrySize, keyBits, valueBits);
    }

    public int hashLookupEntrySize() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.hashLookupEntrySize;
    }

    public int keyBits() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.keyBits;
    }

    public long address() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.address;
    }

    public long capacityMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.capacityMask;
    }

    public long capacityMask2() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.capacityMask2;
    }

    public long entryMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.entryMask;
    }

    public long keyMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.keyMask;
    }

    public long valueMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.valueMask;
    }

    public void closeSegmentHashLookup() {
        if (!this.segmentHashLookupInit()) {
            return;
        }
        this.address = -1L;
    }

    public long stepBack(long pos) {
        return (pos -= (long)this.hashLookupEntrySize()) >= 0L ? pos : this.capacityMask2();
    }

    public long step(long pos) {
        return (pos += (long)this.hashLookupEntrySize()) <= this.capacityMask2() ? pos : 0L;
    }

    public long key(long entry) {
        return entry & this.keyMask();
    }

    public boolean empty(long entry) {
        return (entry & this.entryMask()) == 0L;
    }

    long indexToPos(long index) {
        return index * (long)this.hashLookupEntrySize();
    }

    public long maskUnsetKey(long key) {
        return (key &= this.keyMask()) != 0L ? key : this.keyMask();
    }

    long entry(long key, long value) {
        return key | value << this.keyBits();
    }

    public void writeEntryVolatile(long pos, long prevEntry, long key, long value) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | this.entry(key, value);
        NativeBytes.UNSAFE.putLongVolatile(null, this.address() + pos, entry);
    }

    public void writeEntry(long pos, long prevEntry, long key, long value) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | this.entry(key, value);
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    void writeEntry(long pos, long prevEntry, long anotherEntry) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | anotherEntry & this.entryMask();
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    public void clearHashLookup() {
        NativeBytes.UNSAFE.setMemory(this.address(), this.capacityMask2() + (long)this.hashLookupEntrySize(), (byte)0);
    }

    public long hlPos(long key) {
        return this.indexToPos(key & this.capacityMask());
    }

    public void checkValueForPut(long value) {
        assert ((value & (this.valueMask() ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "Value out of range, was " + value;
    }

    public long readEntry(long pos) {
        return NativeBytes.UNSAFE.getLong(this.address() + pos);
    }

    public void putValueVolatile(long pos, long value) {
        this.checkValueForPut(value);
        long currentEntry = this.readEntry(pos);
        this.writeEntryVolatile(pos, currentEntry, this.key(currentEntry), value);
    }

    void clearEntry(long pos, long prevEntry) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL);
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    public long remove(long posToRemove) {
        long entryToShift;
        long entryToRemove = this.readEntry(posToRemove);
        long posToShift = posToRemove;
        while (!this.empty(entryToShift = this.readEntry(posToShift = this.step(posToShift)))) {
            boolean cond2;
            long insertPos = this.hlPos(this.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.writeEntry(posToRemove, entryToRemove, entryToShift);
            posToRemove = posToShift;
            entryToRemove = entryToShift;
        }
        this.clearEntry(posToRemove, entryToRemove);
        return posToRemove;
    }

    public long value(long entry) {
        return entry >>> this.keyBits() & this.valueMask();
    }

    void forEach(EntryConsumer action) {
        for (long pos = 0L; pos <= this.capacityMask2(); pos += (long)this.hashLookupEntrySize()) {
            long entry = this.readEntry(pos);
            if (this.empty(entry)) continue;
            action.accept(this.key(entry), this.value(entry));
        }
    }

    String hashLookupToString() {
        StringBuilder sb = new StringBuilder("{");
        this.forEach((key, value) -> sb.append(key).append('=').append(value).append(','));
        sb.append('}');
        return sb.toString();
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        VanillaChronicleHash h = this.h();
        long hashLookupOffset = h.segmentOffset(this.segmentIndex());
        long freeListOffset = hashLookupOffset + h.segmentHashLookupOuterSize;
        this.freeListBytes.storePositionAndSize(h.ms, freeListOffset, h.segmentFreeListInnerSize);
        this.freeList.reuse((Bytes)this.freeListBytes);
        this.entrySpaceOffset = freeListOffset + h.segmentFreeListOuterSize + (long)h.segmentEntrySpaceInnerOffset;
        this.closeSegmentDependants();
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public SingleThreadedDirectBitSet freeList() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.freeList;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeEntry();
    }

    public boolean entryInit() {
        return this.pos >= 0L;
    }

    public void initEntry(long pos) {
        this.initKeySizeOffset(pos);
        this.entryBytes.position(this.keySizeOffset);
        this.keySize = this.h().keySizeMarshaller.readSize(this.entryBytes);
        this.keyOffset = this.entryBytes.position();
        this.pos = pos;
        this.closeEntryDependants();
    }

    public void initEntry(long pos, Value<?, ?> key) {
        this.initKeySizeOffset(pos);
        this.entryBytes.position(this.keySizeOffset);
        this.keySize = key.size();
        this.h().keySizeMarshaller.writeSize(this.entryBytes, this.keySize);
        this.keyOffset = this.entryBytes.position();
        key.writeTo(this.entryBytesAccessor, this.entryBytes, this.keyOffset);
        this.pos = pos;
        this.closeEntryDependants();
    }

    public void initEntryCopying(long newPos, long bytesToCopy) {
        long oldKeySizeOffset = this.keySizeOffset;
        this.initKeySizeOffset(newPos);
        long oldKeyOffset = this.keyOffset;
        this.keyOffset = this.keySizeOffset + (oldKeyOffset - oldKeySizeOffset);
        Access.copy(this.entryBytesAccess, this.entryBytesAccessHandle, (long)this.entryBytesAccessOffset(oldKeySizeOffset), this.entryBytesAccess, this.entryBytesAccessHandle, (long)this.entryBytesAccessOffset(this.keySizeOffset), (long)bytesToCopy);
        this.pos = newPos;
        this.closeEntryDependants();
    }

    public long keyOffset() {
        assert (this.entryInit()) : "Entry should be init";
        return this.keyOffset;
    }

    public long keySize() {
        assert (this.entryInit()) : "Entry should be init";
        return this.keySize;
    }

    public long keySizeOffset() {
        assert (this.entryInit()) : "Entry should be init";
        return this.keySizeOffset;
    }

    @Override
    public long pos() {
        assert (this.entryInit()) : "Entry should be init";
        return this.pos;
    }

    public void closeEntry() {
        if (!this.entryInit()) {
            return;
        }
        this.closeEntryDependants();
        this.pos = -1L;
    }

    public void closeEntryDependants() {
        this.entryKey.closeEntryKeyBytesValueSizeDependants();
        this.closeReplicationUpdateDropChangeDependants();
        this.closeReplicationUpdateUpdateChangeDependants();
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
        this.entryKey.closeEntryKeyBytesValueInnerGetUsingDependants();
    }

    public void dropChange() {
        ((ReplicatedChronicleMap)this.m()).dropChange(this.segmentIndex(), this.pos());
    }

    public void closeReplicationUpdateDropChangeDependants() {
        this.closeReplicationUpdateUpdateChangeDependants();
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeReplicatedMapEntryStagesKeyEndDependants() {
        this.closeReplicatedMapEntryStagesCountValueSizeOffsetDependants();
        this.closeReplicationState();
        this.closeReplicatedMapEntryStagesEntryEndDependants();
    }

    private long _MapEntryStages_countValueSizeOffset() {
        return this.keyEnd();
    }

    long countValueSizeOffset() {
        return this._MapEntryStages_countValueSizeOffset() + 10L;
    }

    public void closeReplicatedMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValue();
    }

    public boolean replicationStateInit() {
        return this.replicationBytesOffset >= 0L;
    }

    void initReplicationState() {
        this.replicationBytesOffset = this.keyEnd();
    }

    void initReplicationState(long timestamp, byte identifier) {
        this.replicationBytesOffset = this.keyEnd();
        this.entryBytes.position(this.replicationBytesOffset);
        this.entryBytes.writeLong(timestamp);
        this.entryBytes.writeByte((int)identifier);
    }

    public long replicationBytesOffset() {
        if (!this.replicationStateInit()) {
            this.initReplicationState();
        }
        return this.replicationBytesOffset;
    }

    public void closeReplicationState() {
        if (!this.replicationStateInit()) {
            return;
        }
        this.replicationBytesOffset = -1L;
    }

    private long timestampOffset() {
        return this.replicationBytesOffset();
    }

    long timestamp() {
        return this.entryBytesAccess.readLong(this.entryBytesAccessHandle, this.timestampOffset());
    }

    @Override
    public long originTimestamp() {
        this.checkOnEachPublicOperation();
        return this.timestamp();
    }

    private long entryDeletedOffset() {
        return this.replicationBytesOffset() + 9L;
    }

    public boolean entryDeleted() {
        return this.entryBytesAccess.readBoolean(this.entryBytesAccessHandle, this.entryDeletedOffset());
    }

    public void writeEntryDeleted() {
        this.entryBytesAccess.writeBoolean(this.entryBytesAccessHandle, this.entryDeletedOffset(), true);
    }

    public void writeEntryPresent() {
        this.entryBytesAccess.writeBoolean(this.entryBytesAccessHandle, this.entryDeletedOffset(), false);
    }

    private long identifierOffset() {
        return this.replicationBytesOffset() + 8L;
    }

    byte identifier() {
        return this.entryBytesAccess.readByte(this.entryBytesAccessHandle, this.identifierOffset());
    }

    @Override
    public byte originIdentifier() {
        this.checkOnEachPublicOperation();
        return this.identifier();
    }

    public boolean segHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegHeader() {
        this.segmentHeaderAddress = this.h().ms.address() + this.h().segmentHeaderOffset(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        this.closeSegHeaderDependants();
    }

    public long segmentHeaderAddress() {
        if (!this.segHeaderInit()) {
            this.initSegHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segHeaderInit()) {
            this.initSegHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegHeader() {
        if (!this.segHeaderInit()) {
            return;
        }
        this.closeSegHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegHeaderDependants() {
        this.closeSegmentStagesTryFindInitLocksOfThisSegmentDependants();
        this.closeLocks();
    }

    long nextPosToSearchFrom() {
        return this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress());
    }

    boolean tryFindInitLocksOfThisSegment(Object thisContext, int index) {
        CompiledReplicatedMapIterationContext c = (CompiledReplicatedMapIterationContext)this.contextAtIndexInChain(index);
        if (c.segmentHeader() != null && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.rootContextOnThisSegment() != null) {
            throw new IllegalStateException("Nested context not implemented yet");
        }
        return false;
    }

    public void closeSegmentStagesTryFindInitLocksOfThisSegmentDependants() {
        this.closeLocks();
    }

    public long entries() {
        return this.segmentHeader().size(this.segmentHeaderAddress());
    }

    public void deleted(long deleted) {
        this.segmentHeader().deleted(this.segmentHeaderAddress(), deleted);
    }

    public void entries(long size) {
        this.segmentHeader().size(this.segmentHeaderAddress(), size);
    }

    public long deleted() {
        return this.segmentHeader().deleted(this.segmentHeaderAddress());
    }

    @Override
    public long size() {
        return this.entries() - this.deleted();
    }

    public void nextPosToSearchFrom(long nextPosToSearchFrom) {
        this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress(), nextPosToSearchFrom);
    }

    public void updateNextPosToSearchFrom(long allocated, int chunks) {
        long nextPosToSearchFrom = allocated + (long)chunks;
        if (nextPosToSearchFrom >= this.h().actualChunksPerSegment) {
            nextPosToSearchFrom = 0L;
        }
        this.nextPosToSearchFrom(nextPosToSearchFrom);
    }

    public long alloc(int chunks) {
        VanillaChronicleHash h = this.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " entry size chucks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long ret = this.freeList().setNextNContinuousClearBits(this.nextPosToSearchFrom(), chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
            if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                this.freeList().clear(ret, h.actualChunksPerSegment);
            }
            if ((ret = this.freeList().setNextNContinuousClearBits(0L, chunks)) == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
                if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                    this.freeList().clear(ret, h.actualChunksPerSegment);
                }
                if (chunks == 1) {
                    throw new IllegalStateException("Segment is full, no free entries found");
                }
                throw new IllegalStateException("Segment is full or has no ranges of " + chunks + " continuous free chunks");
            }
            this.updateNextPosToSearchFrom(ret, chunks);
        } else if (chunks == 1 || this.freeList().isSet(this.nextPosToSearchFrom())) {
            this.updateNextPosToSearchFrom(ret, chunks);
        }
        return ret;
    }

    public void free(long fromPos, int chunks) {
        this.freeList().clear(fromPos, fromPos + (long)chunks);
        if (fromPos < this.nextPosToSearchFrom()) {
            this.nextPosToSearchFrom(fromPos);
        }
    }

    public boolean locksInit() {
        return this.rootContextOnThisSegment != null;
    }

    void initLocks() {
        int i;
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(this, i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(this, i)) continue;
            return;
        }
        this.rootContextOnThisSegment = this;
        this.concurrentSameThreadContexts = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.nextNode = null;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    public CompiledReplicatedMapIterationContext rootContextOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        if (this.rootContextOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.localLockState = null;
        this.rootContextOnThisSegment = null;
    }

    public void clearSegment() {
        this.innerWriteLock.lock();
        this.clearHashLookup();
        this.freeList().clear();
        this.nextPosToSearchFrom(0L);
        this.entries(0L);
    }

    public void clear() {
        this.clearSegment();
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!this.allocatedChunksInit()) {
            return;
        }
        this.allocatedChunks = 0;
    }

    public void initEntryAndKeyCopying(long entrySize, long bytesToCopy) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.initEntryCopying(this.alloc(this.allocatedChunks()), bytesToCopy);
        this.incrementSegmentEntriesIfNeeded();
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos >= 0L;
    }

    public void initHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public long hashLookupPos() {
        assert (this.hashLookupPosInit()) : "HashLookupPos should be init";
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.hashLookupPos = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forEachRemoving(Predicate<? super MapEntry<K, V>> action) {
        this.innerUpdateLock.lock();
        long size = this.size();
        if (size == 0L) {
            return true;
        }
        try {
            boolean interrupted = false;
            long startPos = 0L;
            while (!this.empty(this.readEntry(startPos))) {
                startPos = this.step(startPos);
            }
            this.initHashLookupPos(startPos);
            do {
                this.setHashLookupPosGuarded(this.step(this.hashLookupPos()));
                long entry = this.readEntry(this.hashLookupPos());
                if (this.empty(entry)) continue;
                this.initEntry(this.value(entry));
                if (!this.entryIsPresent()) continue;
                this.initEntryRemovedOnThisIteration(false);
                if (!action.test(this)) {
                    interrupted = true;
                    break;
                }
                if (--size == 0L) break;
            } while (this.hashLookupPos() != startPos);
            boolean bl = !interrupted;
            return bl;
        }
        finally {
            this.innerReadLock.unlock();
            this.initEntryRemovedOnThisIteration(false);
        }
    }

    public boolean replicationUpdateInit() {
        return this.newIdentifier != 0;
    }

    public void initReplicationUpdate() {
        this.newTimestamp = ((ReplicatedChronicleMap)this.m()).timeProvider.currentTime();
        this.newIdentifier = ((ReplicatedChronicleMap)this.m()).identifier();
        this.closeReplicationUpdateDependants();
    }

    public void initReplicationUpdate(long timestamp, byte identifier) {
        this.newTimestamp = timestamp;
        if (identifier == 0) {
            throw new IllegalStateException("identifier can't be 0");
        }
        this.newIdentifier = identifier;
        this.closeReplicationUpdateDependants();
    }

    public void initReplicationUpdateIncrement(long timestamp) {
        assert (this.replicationUpdateInit());
        this.newTimestamp = timestamp + 1L;
        this.closeReplicationUpdateDependants();
    }

    public byte newIdentifier() {
        if (!this.replicationUpdateInit()) {
            this.initReplicationUpdate();
        }
        return this.newIdentifier;
    }

    public long newTimestamp() {
        if (!this.replicationUpdateInit()) {
            this.initReplicationUpdate();
        }
        return this.newTimestamp;
    }

    public void closeReplicationUpdate() {
        if (!this.replicationUpdateInit()) {
            return;
        }
        this.closeReplicationUpdateDependants();
        this.newIdentifier = 0;
    }

    public void closeReplicationUpdateDependants() {
        this.closeReplicationUpdateRemoteUpdateDependants();
        this.closeUpdatedReplicationState();
    }

    @Override
    public byte remoteIdentifier() {
        this.checkOnEachPublicOperation();
        return this.newIdentifier();
    }

    public boolean remoteUpdate() {
        return this.newIdentifier() != ((ReplicatedChronicleMap)this.m()).identifier();
    }

    public void closeReplicationUpdateRemoteUpdateDependants() {
        this.closeReplicationUpdateUpdateChangeDependants();
    }

    public void updateChange() {
        if (this.remoteUpdate()) {
            this.dropChange();
        } else {
            ((ReplicatedChronicleMap)this.m()).raiseChange(this.segmentIndex(), this.pos());
        }
    }

    public void closeReplicationUpdateUpdateChangeDependants() {
        this.closeValue();
    }

    boolean valueInit() {
        return this.valueOffset >= 0L;
    }

    void initValue() {
        this.valueSizeOffset = this.countValueSizeOffset();
        this.entryBytes.position(this.valueSizeOffset);
        this.valueSize = this.m().readValueSize(this.entryBytes);
        ((ReplicatedChronicleMap)this.m()).alignment.alignPositionAddr(this.entryBytes);
        this.valueOffset = this.entryBytes.position();
        this.closeValueDependants();
    }

    public void initValue(Value<?, ?> value) {
        this.valueSizeOffset = this.countValueSizeOffset();
        this.innerInitValue(value);
        this.closeValueDependants();
    }

    public void initValueAgain(Value<?, ?> value) {
        assert (this.valueInit());
        this.innerInitValue(value);
        this.closeValueDependants();
    }

    public void initValueWithoutSize(Value<?, ?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        this.valueSizeOffset = this.countValueSizeOffset();
        assert (oldValueSize == value.size());
        this.valueSize = oldValueSize;
        this.valueOffset = this.valueSizeOffset + (oldValueOffset - oldValueSizeOffset);
        this.writeValue(value);
        this.closeValueDependants();
    }

    public long valueOffset() {
        if (!this.valueInit()) {
            this.initValue();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valueInit()) {
            this.initValue();
        }
        return this.valueSize;
    }

    public long valueSizeOffset() {
        if (!this.valueInit()) {
            this.initValue();
        }
        return this.valueSizeOffset;
    }

    public void closeValue() {
        if (!this.valueInit()) {
            return;
        }
        this.closeValueDependants();
        this.valueOffset = -1L;
    }

    public void closeValueDependants() {
        this.entryValue.closeEntryValueBytesValueSizeDependants();
        this.entryValue.closeEntryValueBytesValueInnerGetUsingDependants();
        this.closeReplicatedMapEntryStagesEntryEndDependants();
    }

    public long newSizeOfEverythingBeforeValue(Value<V, ?> newValue) {
        return this.valueSizeOffset() + (long)((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.sizeEncodingSize(newValue.size()) - this.keySizeOffset();
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    protected long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeReplicatedMapEntryStagesEntryEndDependants() {
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
    }

    long entrySize() {
        return this.entryEnd() - this.keySizeOffset();
    }

    public void closeReplicatedMapEntryStagesEntrySizeDependants() {
        this.closeTheEntrySizeInChunks();
    }

    public boolean theEntrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initTheEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initTheEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.theEntrySizeInChunksInit()) {
            this.initTheEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeTheEntrySizeInChunks() {
        if (!this.theEntrySizeInChunksInit()) {
            return;
        }
        this.entrySizeInChunks = 0;
    }

    public final void freeExtraAllocatedChunks() {
        if (!((ReplicatedChronicleMap)this.m()).constantlySizedEntry && ((ReplicatedChronicleMap)this.m()).couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.free(this.pos() + (long)this.entrySizeInChunks(), this.allocatedChunks() - this.entrySizeInChunks());
        } else {
            this.initTheEntrySizeInChunks(this.allocatedChunks());
        }
    }

    private void _MapEntryStages_putValueDeletedEntry(Value<V, ?> newValue) {
        int newSizeInChunks;
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        long entryStartOffset = this.keySizeOffset();
        long newSizeOfEverythingBeforeValue = -1L;
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long newValueOffset = ((ReplicatedChronicleMap)this.m()).alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue);
            long newEntrySize = newValueOffset + newValue.size() - entryStartOffset;
            newSizeInChunks = this.m().inChunks(newEntrySize);
        } else {
            newSizeInChunks = this.entrySizeInChunks();
        }
        if (this.pos() + (long)newSizeInChunks < this.freeList().size() && this.freeList().allClear(this.pos(), this.pos() + (long)newSizeInChunks)) {
            this.freeList().set(this.pos(), this.pos() + (long)newSizeInChunks);
            this.innerWriteLock.lock();
            this.incrementSegmentEntriesIfNeeded();
            if (newValueSizeIsDifferent) {
                this.initValueAgain(newValue);
            } else {
                this.writeValueGuarded(newValue);
            }
        } else {
            if (newValueSizeIsDifferent) {
                assert (newSizeOfEverythingBeforeValue >= 0L);
            } else {
                newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            }
            long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
            if (newValueSizeIsDifferent) {
                this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - entryStartOffset);
                this.initValue(newValue);
            } else {
                long oldValueSizeOffset = this.valueSizeOffset();
                long oldValueSize = this.valueSize();
                long oldValueOffset = this.valueOffset();
                this.initEntryAndKeyCopying(entrySize, this.valueOffset() - entryStartOffset);
                this.initValueWithoutSize(newValue, oldValueSizeOffset, oldValueSize, oldValueOffset);
            }
            this.freeExtraAllocatedChunks();
        }
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    public void putValueDeletedEntry(Value<V, ?> newValue) {
        throw new AssertionError((Object)"Replicated Map doesn't remove entries truly, yet");
    }

    public void writeValueAndPutPos(Value<V, ?> value) {
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    private void _MapEntryStages_relocation(Value<V, ?> newValue, long newSizeOfEverythingBeforeValue) {
        this.free(this.pos(), this.entrySizeInChunks());
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - this.keySizeOffset());
        this.writeValueAndPutPos(newValue);
    }

    protected void relocation(Value<V, ?> newValue, long newSizeOfEverythingBeforeValue) {
        this.dropChange();
        this._MapEntryStages_relocation(newValue, newSizeOfEverythingBeforeValue);
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.free(this.pos(), this.entrySizeInChunks());
        this.entries(this.entries() - 1L);
        this.incrementModCountGuarded();
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        this.initEntryRemovedOnThisIteration(true);
        this.innerWriteLock.lock();
        try {
            if (this.remove(this.hashLookupPos()) != this.hashLookupPos()) {
                this.setHashLookupPosGuarded(this.stepBack(this.hashLookupPos()));
            }
            this.innerRemoveEntryExceptHashLookupUpdate();
        }
        finally {
            this.innerWriteLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void innerDefaultReplaceValue(Value<V, ?> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap m = this.m();
            int newSizeInChunks = m.inChunks(newEntrySize = (newValueOffset = m.alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue)) + newValue.size() - entryStartOffset);
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.freeList().allClear(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
                this.freeList().set(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks);
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeList().clear(this.pos() + (long)newSizeInChunks, this.pos() + (long)this.entrySizeInChunks());
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValueAgain(newValue);
        } else {
            this.writeValueGuarded(newValue);
        }
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    @Override
    public void doReplaceValue(Value<V, ?> newValue) {
        this.checkOnEachPublicOperation();
        try {
            this.innerDefaultReplaceValue(newValue);
        }
        finally {
            this.innerWriteLock.unlock();
        }
    }

    @Override
    public long remoteTimestamp() {
        this.checkOnEachPublicOperation();
        return this.newTimestamp();
    }

    public boolean updatedReplicationStateInit() {
        return this.updatedReplicationState;
    }

    public void initUpdatedReplicationState() {
        this.initReplicationState(this.newTimestamp(), this.newIdentifier());
        this.updatedReplicationState = true;
    }

    public void closeUpdatedReplicationState() {
        if (!this.updatedReplicationStateInit()) {
            return;
        }
        this.updatedReplicationState = false;
    }

    private boolean testTimeStampInSensibleRange() {
        if (((ReplicatedChronicleMap)this.m()).timeProvider == TimeProvider.SYSTEM) {
            long currentTime = TimeProvider.SYSTEM.currentTime();
            assert (Math.abs(currentTime - this.timestamp()) <= 100000000L) : "unrealistic timestamp: " + this.timestamp();
            assert (Math.abs(currentTime - this.newTimestamp()) <= 100000000L) : "unrealistic newTimestamp: " + this.newTimestamp();
        }
        return true;
    }

    public class DeprecatedMapKeyContextOnIteration
    implements MapKeyContext<K, V> {
        @Override
        public void close() {
            throw new UnsupportedOperationException("close() is not supported during iteration");
        }

        @Override
        @NotNull
        public K key() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.key().get();
        }

        @Override
        public boolean containsKey() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return true;
        }

        @Override
        public boolean valueEqualTo(V value) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return Value.bytesEquivalent(CompiledReplicatedMapIterationContext.this.entryValue, CompiledReplicatedMapIterationContext.this.context().wrapValueAsValue(value));
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.value().getUsing(usingValue);
        }

        @Override
        public V get() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.value().get();
        }

        @Override
        public boolean put(V newValue) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            CompiledReplicatedMapIterationContext.this.replaceValue(CompiledReplicatedMapIterationContext.this, CompiledReplicatedMapIterationContext.this.context().wrapValueAsValue(newValue));
            return true;
        }

        @Override
        public boolean remove() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            CompiledReplicatedMapIterationContext.this.remove(CompiledReplicatedMapIterationContext.this);
            return true;
        }

        @Override
        @NotNull
        public Bytes entry() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.entryBytes;
        }

        @NotNull
        private UnsupportedOperationException unsupportedLocks() {
            return new UnsupportedOperationException("Lock operations are not supported (and not needed!) during iteration");
        }

        @Override
        @NotNull
        public InterProcessLock readLock() {
            throw this.unsupportedLocks();
        }

        @Override
        @NotNull
        public InterProcessLock updateLock() {
            throw this.unsupportedLocks();
        }

        @Override
        @NotNull
        public InterProcessLock writeLock() {
            throw this.unsupportedLocks();
        }

        @Override
        public long keyOffset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.keyOffset();
        }

        @Override
        public long keySize() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.keySize();
        }

        @Override
        public long valueSize() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.valueSize();
        }

        @Override
        public long valueOffset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.valueOffset();
        }
    }

    public class WrappedValueInstanceValue
    extends CopyingInstanceValue<V, T> {
        private WrappedValueInstanceValue next;
        private V value;
        private boolean marshalled = false;
        private DirectBytes buf;

        public WrappedValueInstanceValue getUnusedWrappedValueGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValue();
        }

        public WrappedValueInstanceValue getUnusedWrappedValue() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceValue();
            }
            return this.next.getUnusedWrappedValue();
        }

        boolean nextInit() {
            return true;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            CompiledReplicatedMapIterationContext.this.m().checkValue(value);
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next != null) {
                this.next.closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mvi = CompiledReplicatedMapIterationContext.this.valueMetaInterop(this.value());
            long size = mvi.size(CompiledReplicatedMapIterationContext.this.valueInterop, this.value());
            this.buf = CopyingInstanceValue.getBuffer(this.buf, size);
            mvi.write(CompiledReplicatedMapIterationContext.this.valueInterop, (Bytes)this.buf, this.value());
            this.buf.flip();
            this.marshalled = true;
        }

        public DirectBytes buf() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buf;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public DirectBytes buffer() {
            return this.buf();
        }

        @Override
        public V getUsing(V usingValue) {
            this.buf().position(0L);
            return CompiledReplicatedMapIterationContext.this.valueReader.read((Bytes)this.buf(), this.buf().limit(), usingValue);
        }

        @Override
        public V instance() {
            return this.value();
        }
    }

    public class EntryValueBytesValue
    extends AbstractValue<V, T> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead = false;

        @Override
        public T handle() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.entryBytesAccessHandle;
        }

        @Override
        public ReadAccess<T> access() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.entryBytesAccess;
        }

        @Override
        public long offset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.entryBytesAccessOffset(CompiledReplicatedMapIterationContext.this.valueOffset());
        }

        @Override
        public long size() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.valueSize();
        }

        public void closeEntryValueBytesValueSizeDependants() {
            this.closeEntryValueBytesValueInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            CompiledReplicatedMapIterationContext.this.entryBytes.position(CompiledReplicatedMapIterationContext.this.valueOffset());
            return CompiledReplicatedMapIterationContext.this.valueReader.read(CompiledReplicatedMapIterationContext.this.entryBytes, this.size(), usingValue);
        }

        public void closeEntryValueBytesValueInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingValue);
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapIterationContext.this.localLockState().read;
        }

        @Override
        public void lock() {
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                CompiledReplicatedMapIterationContext.this.segmentHeader().readLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public void unlock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    return;
                }
                case READ_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().readUnlock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    break;
                }
                case UPDATE_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().updateUnlock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().writeUnlock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                }
            }
            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
            CompiledReplicatedMapIterationContext.this.closeHashLookupPos();
            CompiledReplicatedMapIterationContext.this.closeEntry();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean tryLock() {
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                CompiledReplicatedMapIterationContext.this.segmentHeader().readLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @Override
        public boolean tryLock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                        CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void lock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().updateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().updateLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapIterationContext.this.localLockState().update;
        }

        @Override
        public void unlock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeWriteToReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                }
            }
            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }
    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @Override
        public boolean tryLock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                        CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                        CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void unlock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                }
            }
            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapIterationContext.this.localLockState().write;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().writeLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void lock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().writeLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }
    }

    public class EntryKeyBytesValue
    extends AbstractValue<K, T> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        @Override
        public T handle() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.entryBytesAccessHandle;
        }

        @Override
        public ReadAccess<T> access() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.entryBytesAccess;
        }

        @Override
        public long size() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.keySize();
        }

        public void closeEntryKeyBytesValueSizeDependants() {
            this.closeEntryKeyBytesValueInnerGetUsingDependants();
        }

        @Override
        public long offset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.entryBytesAccessOffset(CompiledReplicatedMapIterationContext.this.keyOffset());
        }

        private K innerGetUsing(K usingKey) {
            CompiledReplicatedMapIterationContext.this.entryBytes.position(CompiledReplicatedMapIterationContext.this.keyOffset());
            return CompiledReplicatedMapIterationContext.this.keyReader.read(CompiledReplicatedMapIterationContext.this.entryBytes, this.size(), usingKey);
        }

        public void closeEntryKeyBytesValueInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        @Override
        public K getUsing(K usingKey) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingKey);
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                return;
            }
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }
    }
}

