/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.function.BiFunction;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.Value;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapMethodsSupport;
import net.openhft.chronicle.map.MapQueryContext;
import net.openhft.chronicle.map.ReturnValue;

public interface MapMethods<K, V, R> {
    default public boolean containsKey(MapQueryContext<K, V, R> q) {
        return q.entry() != null;
    }

    default public void get(MapQueryContext<K, V, R> q, ReturnValue<V> returnValue) {
        MapMethodsSupport.returnCurrentValueIfPresent(q, returnValue);
    }

    default public void put(MapQueryContext<K, V, R> q, Value<V, ?> value, ReturnValue<V> returnValue) {
        q.updateLock().lock();
        HashEntry entry = q.entry();
        if (entry != null) {
            returnValue.returnValue(entry.value());
            q.replaceValue((MapEntry<K, V>)entry, value);
        } else {
            q.insert((MapAbsentEntry<K, V>)q.absentEntry(), value);
        }
    }

    default public void putIfAbsent(MapQueryContext<K, V, R> q, Value<V, ?> value, ReturnValue<V> returnValue) {
        if (MapMethodsSupport.tryReturnCurrentValueIfPresent(q, returnValue)) {
            return;
        }
        q.insert((MapAbsentEntry<K, V>)q.absentEntry(), value);
    }

    default public void acquireUsing(MapQueryContext<K, V, R> q, ReturnValue<V> returnValue) {
        if (MapMethodsSupport.tryReturnCurrentValueIfPresent(q, returnValue)) {
            return;
        }
        q.insert(q.absentEntry(), q.defaultValue(q.absentEntry()));
        returnValue.returnValue(q.entry().value());
    }

    default public void remove(MapQueryContext<K, V, R> q, ReturnValue<V> returnValue) {
        q.updateLock().lock();
        HashEntry entry = q.entry();
        if (entry != null) {
            returnValue.returnValue(entry.value());
            q.remove((MapEntry<K, V>)entry);
        }
    }

    default public boolean remove(MapQueryContext<K, V, R> q, Value<V, ?> value) {
        q.updateLock().lock();
        HashEntry entry = q.entry();
        if (entry != null && Value.bytesEquivalent(entry.value(), value)) {
            q.remove((MapEntry<K, V>)entry);
            return true;
        }
        return false;
    }

    default public void replace(MapQueryContext<K, V, R> q, Value<V, ?> value, ReturnValue<V> returnValue) {
        q.updateLock().lock();
        HashEntry entry = q.entry();
        if (entry != null) {
            returnValue.returnValue(entry.value());
            q.replaceValue((MapEntry<K, V>)entry, value);
        }
    }

    default public boolean replace(MapQueryContext<K, V, R> q, Value<V, ?> oldValue, Value<V, ?> newValue) {
        q.updateLock().lock();
        HashEntry entry = q.entry();
        if (entry != null && Value.bytesEquivalent(entry.value(), oldValue)) {
            q.replaceValue((MapEntry<K, V>)entry, newValue);
            return true;
        }
        return false;
    }

    default public void compute(MapQueryContext<K, V, R> q, BiFunction<? super K, ? super V, ? extends V> remappingFunction, ReturnValue<V> returnValue) {
        q.updateLock().lock();
        HashEntry entry = q.entry();
        Object oldValue = entry != null ? (Object)entry.value().get() : null;
        V newValue = remappingFunction.apply(q.queriedKey().get(), oldValue);
        if (newValue != null) {
            Value<V, ?> newValueValue = q.wrapValueAsValue(newValue);
            if (entry != null) {
                q.replaceValue((MapEntry<K, V>)entry, newValueValue);
            } else {
                q.insert((MapAbsentEntry<K, V>)q.absentEntry(), newValueValue);
            }
            returnValue.returnValue(newValueValue);
        } else if (entry != null) {
            q.remove((MapEntry<K, V>)entry);
        }
    }

    default public void merge(MapQueryContext<K, V, R> q, Value<V, ?> value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, ReturnValue<V> returnValue) {
        Value<V, ?> newValueValue;
        q.updateLock().lock();
        HashEntry entry = q.entry();
        if (entry != null) {
            Object oldValue = entry.value().get();
            V newValue = remappingFunction.apply(oldValue, value.get());
            if (newValue == null) {
                q.remove((MapEntry<K, V>)entry);
                return;
            }
            newValueValue = q.wrapValueAsValue(newValue);
            q.replaceValue((MapEntry<K, V>)entry, newValueValue);
        } else {
            newValueValue = value;
            q.insert((MapAbsentEntry<K, V>)q.absentEntry(), newValueValue);
        }
        returnValue.returnValue(newValueValue);
    }
}

