/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.map.FPMEvent;
import net.openhft.chronicle.map.FileRecord;
import org.jetbrains.annotations.NotNull;

public class FilePerKeyMap
implements Map<String, String>,
Closeable {
    private final Path dirPath;
    private final Map<File, FileRecord> lastFile = new ConcurrentHashMap<File, FileRecord>();
    private final List<Consumer<FPMEvent>> listeners = new ArrayList<Consumer<FPMEvent>>();
    private final Thread fileFpmWatcher;
    private volatile boolean closed = false;
    private boolean putReturnsNull;
    private boolean snappyValues;
    private ThrowingFunction<InputStream, InputStream, IOException> reading = i -> i;
    private ThrowingFunction<OutputStream, OutputStream, IOException> writing = o -> o;

    public FilePerKeyMap(String dir) throws IOException {
        this.dirPath = Paths.get(dir, new String[0]);
        Files.createDirectories(this.dirPath, new FileAttribute[0]);
        WatchService watcher = FileSystems.getDefault().newWatchService();
        this.dirPath.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
        this.fileFpmWatcher = new Thread((Runnable)new FPMWatcher(watcher), dir + "-watcher");
        this.fileFpmWatcher.start();
    }

    public void registerForEvents(Consumer<FPMEvent> listener) {
        this.listeners.add(listener);
    }

    public void unregisterForEvents(Consumer<FPMEvent> listener) {
        this.listeners.remove(listener);
    }

    public void valueMarshaller(ThrowingFunction<InputStream, InputStream, IOException> reading, ThrowingFunction<OutputStream, OutputStream, IOException> writing) {
        this.reading = reading;
        this.writing = writing;
    }

    private void fireEvent(FPMEvent event) {
        for (Consumer<FPMEvent> listener : this.listeners) {
            listener.accept(event);
        }
    }

    @Override
    public int size() {
        return (int)this.getFiles().count();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getFiles().anyMatch(p -> p.getFileName().toString().equals(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getFiles().anyMatch(p -> this.getFileContents((Path)p).equals(value));
    }

    @Override
    public String get(Object key) {
        Path path = this.dirPath.resolve((String)key);
        return this.getFileContents(path);
    }

    @Override
    public String put(String key, String value) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Path path = this.dirPath.resolve(key);
        String existingValue = this.putReturnsNull ? null : this.getFileContents(path);
        this.writeToFile(path, value);
        return existingValue;
    }

    @Override
    public String remove(Object key) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        String existing = this.get(key);
        if (existing != null) {
            this.deleteFile(this.dirPath.resolve((String)key));
        }
        return existing;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        m.entrySet().stream().forEach((? super T e) -> this.put((String)e.getKey(), (String)e.getValue()));
    }

    @Override
    public void clear() {
        this.getFiles().forEach(this::deleteFile);
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.getFiles().map(p -> p.getFileName().toString()).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<String> values() {
        return this.getFiles().map(p -> this.getFileContents((Path)p)).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, String>> entrySet() {
        return this.getFiles().map(p -> new FPMEntry<String>(p.getFileName().toString(), this.getFileContents((Path)p))).collect(Collectors.toSet());
    }

    private Stream<Path> getFiles() {
        try {
            return Files.walk(this.dirPath, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String getFileContents(Path path) {
        try {
            File file = path.toFile();
            FileRecord last = this.lastFile.get(file);
            if (last != null && file.lastModified() == last.timestamp) {
                return last.contents;
            }
            return this.getFileContents0(path);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    String getFileContents0(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        File file = path.toFile();
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)file.length());
        byte[] bytes = new byte[1024];
        try (InputStream fis = (InputStream)this.reading.apply((Object)new FileInputStream(file));){
            int len;
            while ((len = fis.read(bytes)) > 0) {
                baos.write(bytes, 0, len);
            }
        }
        return baos.toString();
    }

    private void writeToFile(Path path, String value) {
        File file = path.toFile();
        File tmpFile = new File(file.getParentFile(), "." + file.getName());
        try (PrintWriter pw = new PrintWriter(new BufferedOutputStream((OutputStream)this.writing.apply((Object)new FileOutputStream(tmpFile))));){
            pw.write(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        tmpFile.renameTo(file);
    }

    private void deleteFile(Path path) {
        File key = path.toFile();
        key.delete();
    }

    @Override
    public void close() {
        this.closed = true;
        this.fileFpmWatcher.interrupt();
    }

    public void putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
    }

    public void snappyValues(boolean snappyValues) {
        this.snappyValues = snappyValues;
    }

    private class FPMWatcher
    implements Runnable {
        private final WatchService watcher;

        public FPMWatcher(WatchService watcher) {
            this.watcher = watcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                block10: while (true) {
                    WatchKey key = null;
                    try {
                        key = this.watcher.take();
                        Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                        while (true) {
                            String mapVal2;
                            Path p;
                            WatchEvent<?> ev;
                            Path fileName;
                            String mapKey;
                            if (!iterator.hasNext()) continue block10;
                            WatchEvent<?> event = iterator.next();
                            WatchEvent.Kind<?> kind = event.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW || (mapKey = (fileName = (Path)(ev = event).context()).toString()).startsWith(".")) continue;
                            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                                p = FilePerKeyMap.this.dirPath.resolve(fileName);
                                try {
                                    mapVal2 = FilePerKeyMap.this.getFileContents0(p);
                                    FilePerKeyMap.this.lastFile.put(p.toFile(), new FileRecord(p.toFile().lastModified(), mapVal2));
                                    FilePerKeyMap.this.fireEvent(new FPMEvent(FPMEvent.EventType.NEW, mapKey, null, mapVal2));
                                }
                                catch (FileNotFoundException mapVal2) {}
                                continue;
                            }
                            if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                                p = FilePerKeyMap.this.dirPath.resolve(fileName);
                                FileRecord lastVal = (FileRecord)FilePerKeyMap.this.lastFile.remove(p.toFile());
                                String lastContent = lastVal == null ? null : lastVal.contents;
                                FilePerKeyMap.this.fireEvent(new FPMEvent(FPMEvent.EventType.DELETE, mapKey, lastContent, null));
                                continue;
                            }
                            if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                            try {
                                FileRecord rec;
                                p = FilePerKeyMap.this.dirPath.resolve(fileName);
                                mapVal2 = FilePerKeyMap.this.getFileContents0(p);
                                String lastVal = null;
                                if (mapVal2 != null && (rec = FilePerKeyMap.this.lastFile.put(p.toFile(), new FileRecord(p.toFile().lastModified(), mapVal2))) != null) {
                                    lastVal = rec.contents;
                                }
                                if (lastVal != null && lastVal.equals(mapVal2)) continue;
                                FilePerKeyMap.this.fireEvent(new FPMEvent(FPMEvent.EventType.UPDATE, mapKey, lastVal, mapVal2));
                            }
                            catch (FileNotFoundException fileNotFoundException) {}
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    finally {
                        if (key == null) continue;
                        key.reset();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                if (!FilePerKeyMap.this.closed) {
                    e.printStackTrace();
                }
                return;
            }
        }
    }

    private static class FPMEntry<String>
    implements Map.Entry<String, String> {
        private String key;
        private String value;

        public FPMEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            String lastValue = this.value;
            this.value = value;
            return lastValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FPMEntry fpmEntry = (FPMEntry)o;
            if (this.key != null ? !this.key.equals(fpmEntry.key) : fpmEntry.key != null) {
                return false;
            }
            return !(this.value == null ? fpmEntry.value != null : !this.value.equals(fpmEntry.value));
        }

        @Override
        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

