/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.locks.IllegalInterProcessLockStateException;
import net.openhft.lang.io.NativeBytes;

public final class BigSegmentHeader
implements SegmentHeader {
    public static final BigSegmentHeader INSTANCE = new BigSegmentHeader();
    static final long LOCK_OFFSET = 0L;
    static final long COUNT_WORD_OFFSET = 0L;
    static final long WAIT_WORD_OFFSET = 4L;
    static final int COUNT_WORD_SHIFT = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 0 : 32;
    static final int WAIT_WORD_SHIFT = 32 - COUNT_WORD_SHIFT;
    static final int READ_BITS = 30;
    static final int MAX_READ = 0x3FFFFFFF;
    static final int READ_MASK = 0x3FFFFFFF;
    static final int READ_PARTY = 1;
    static final int UPDATE_BIT = 0x40000000;
    static final int UPDATE_PARTY = 0x40000001;
    static final int WRITE_BIT = Integer.MIN_VALUE;
    static final int WRITE_LOCKED_COUNT_WORD = -1073741823;
    static final int MAX_WAIT = Integer.MAX_VALUE;
    static final int WAIT_PARTY = 1;
    static final long SIZE_OFFSET = 8L;
    static final long NEXT_POS_TO_SEARCH_FROM_OFFSET = 12L;
    static final long EXCLUSIVE_LOCK_HOLDER_THREAD_ID_OFFSET = 16L;
    static final long DELETED_OFFSET = 24L;

    private BigSegmentHeader() {
    }

    @Override
    public long size(long address) {
        return (long)NativeBytes.UNSAFE.getInt(address + 8L) & 0xFFFFFFFFL;
    }

    @Override
    public void size(long address, long size) {
        NativeBytes.UNSAFE.putInt(address + 8L, (int)size);
    }

    @Override
    public long deleted(long address) {
        return (long)NativeBytes.UNSAFE.getInt(address + 24L) & 0xFFFFFFFFL;
    }

    @Override
    public void deleted(long address, long deleted) {
        NativeBytes.UNSAFE.putInt(address + 24L, (int)deleted);
    }

    @Override
    public long nextPosToSearchFrom(long address) {
        return (long)NativeBytes.UNSAFE.getInt(address + 12L) & 0xFFFFFFFFL;
    }

    @Override
    public void nextPosToSearchFrom(long address, long nextPosToSearchFrom) {
        NativeBytes.UNSAFE.putInt(address + 12L, (int)nextPosToSearchFrom);
    }

    private static long getLockWord(long address) {
        return NativeBytes.UNSAFE.getLongVolatile(null, address + 0L);
    }

    private static boolean casLockWord(long address, long expected, long x) {
        return NativeBytes.UNSAFE.compareAndSwapLong(null, address + 0L, expected, x);
    }

    private static int countWord(long lockWord) {
        return (int)(lockWord >> COUNT_WORD_SHIFT);
    }

    private static int waitWord(long lockWord) {
        return (int)(lockWord >> WAIT_WORD_SHIFT);
    }

    private static long lockWord(int countWord, int waitWord) {
        return ((long)countWord & 0xFFFFFFFFL) << COUNT_WORD_SHIFT | ((long)waitWord & 0xFFFFFFFFL) << WAIT_WORD_SHIFT;
    }

    private static int getCountWord(long address) {
        return NativeBytes.UNSAFE.getIntVolatile(null, address + 0L);
    }

    private static boolean casCountWord(long address, int expected, int x) {
        return NativeBytes.UNSAFE.compareAndSwapInt(null, address + 0L, expected, x);
    }

    private static void putCountWord(long address, int countWord) {
        NativeBytes.UNSAFE.putOrderedInt(null, address + 0L, countWord);
    }

    private static boolean writeLocked(int countWord) {
        return countWord == -1073741823;
    }

    private static void checkWriteLocked(int countWord) {
        if (countWord != -1073741823) {
            throw new IllegalInterProcessLockStateException("Expected write lock");
        }
    }

    private static boolean updateLocked(int countWord) {
        return (countWord & 0x40000000) != 0;
    }

    private static void checkUpdateLocked(int countWord) {
        if (countWord < 0x40000001) {
            throw new IllegalInterProcessLockStateException("Expected update lock");
        }
    }

    private static int readCount(int countWord) {
        return countWord & 0x3FFFFFFF;
    }

    private static void checkReadLocked(int countWord) {
        if (countWord <= 0) {
            throw new IllegalInterProcessLockStateException("Expected read lock");
        }
    }

    private static void checkReadCountForIncrement(int countWord) {
        if (BigSegmentHeader.readCount(countWord) == 0x3FFFFFFF) {
            throw new IllegalInterProcessLockStateException("Lock count reached the limit of 1073741823");
        }
    }

    private static int getWaitWord(long address) {
        return NativeBytes.UNSAFE.getIntVolatile(null, address + 4L);
    }

    private static boolean casWaitWord(long address, int expected, int x) {
        return NativeBytes.UNSAFE.compareAndSwapInt(null, address + 4L, expected, x);
    }

    private static void checkWaitWordForIncrement(int waitWord) {
        if (waitWord == Integer.MAX_VALUE) {
            throw new IllegalInterProcessLockStateException("Wait count reached the limit of 2147483647");
        }
    }

    private static void checkWaitWordForDecrement(int waitWord) {
        if (waitWord == 0) {
            throw new IllegalInterProcessLockStateException("Wait count underflowed");
        }
    }

    private static void writeExclusiveLockHolder(long address) {
        NativeBytes.UNSAFE.putLong(address + 16L, Thread.currentThread().getId());
    }

    private static void clearExclusiveLockHolder(long address) {
        NativeBytes.UNSAFE.putLong(address + 16L, 0L);
    }

    static Thread exclusiveLockHolder(long address) {
        long holderId = NativeBytes.UNSAFE.getLong(address + 16L);
        if (holderId == 0L) {
            return null;
        }
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        for (Thread thread : threads) {
            if (thread.getId() != holderId) continue;
            return thread;
        }
        return null;
    }

    @Override
    public void readLock(long address) {
        if (!this.tryReadLock(address, 2L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Dead lock");
        }
    }

    @Override
    public void readLockInterruptibly(long address) {
        this.readLock(address);
    }

    @Override
    public boolean tryReadLock(long address) {
        long lockWord = BigSegmentHeader.getLockWord(address);
        int countWord = BigSegmentHeader.countWord(lockWord);
        if (!BigSegmentHeader.writeLocked(countWord) && BigSegmentHeader.waitWord(lockWord) == 0) {
            BigSegmentHeader.checkReadCountForIncrement(countWord);
            if (BigSegmentHeader.casCountWord(address, countWord, countWord + 1)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean tryReadLock(long address, long time, TimeUnit unit) {
        return this.tryReadLock(address) || this.tryReadLock0(address, time, unit);
    }

    private boolean tryReadLock0(long address, long time, TimeUnit unit) {
        long timeInNanos = unit.toNanos(time);
        if (timeInNanos < 2000000L) {
            return this.tryReadLockNanos(address, timeInNanos);
        }
        return this.tryReadLockMillis(address, (timeInNanos + 900000L) / 1000000L);
    }

    private boolean tryReadLockNanos(long address, long timeInNanos) {
        long end = System.nanoTime() + timeInNanos;
        do {
            if (!this.tryReadLock(address)) continue;
            return true;
        } while (System.nanoTime() <= end);
        return false;
    }

    private boolean tryReadLockMillis(long address, long timeInMillis) {
        long lastTime = System.currentTimeMillis();
        do {
            if (this.tryReadLock(address)) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now == lastTime) continue;
            lastTime = now;
            --timeInMillis;
        } while (timeInMillis >= 0L);
        return false;
    }

    @Override
    public boolean tryUpgradeReadToUpdateLock(long address) {
        int countWord = BigSegmentHeader.getCountWord(address);
        BigSegmentHeader.checkReadLocked(countWord);
        return !BigSegmentHeader.updateLocked(countWord) && BigSegmentHeader.casCountWord(address, countWord, countWord - 1 + 0x40000001);
    }

    @Override
    public boolean tryUpgradeReadToWriteLock(long address) {
        int countWord = BigSegmentHeader.getCountWord(address);
        BigSegmentHeader.checkReadLocked(countWord);
        return countWord == 1 && BigSegmentHeader.casCountWord(address, 1, -1073741823);
    }

    @Override
    public void updateLock(long address) {
        if (!this.tryUpdateLock(address, 2L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Dead lock");
        }
    }

    @Override
    public void updateLockInterruptibly(long address) {
        this.updateLock(address);
    }

    @Override
    public boolean tryUpdateLock(long address) {
        long lockWord = BigSegmentHeader.getLockWord(address);
        int countWord = BigSegmentHeader.countWord(lockWord);
        if (!BigSegmentHeader.updateLocked(countWord) && BigSegmentHeader.waitWord(lockWord) == 0) {
            BigSegmentHeader.checkReadCountForIncrement(countWord);
            if (BigSegmentHeader.casCountWord(address, countWord, countWord + 0x40000001)) {
                BigSegmentHeader.writeExclusiveLockHolder(address);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean tryUpdateLock(long address, long time, TimeUnit unit) {
        return this.tryUpdateLock(address) || this.tryUpdateLock0(address, time, unit);
    }

    private boolean tryUpdateLock0(long address, long time, TimeUnit unit) {
        long timeInNanos = unit.toNanos(time);
        if (timeInNanos < 2000000L) {
            return this.tryUpdateLockNanos(address, timeInNanos);
        }
        return this.tryUpdateLockMillis(address, (timeInNanos + 900000L) / 1000000L);
    }

    private boolean tryUpdateLockNanos(long address, long timeInNanos) {
        long end = System.nanoTime() + timeInNanos;
        do {
            if (!this.tryUpdateLock(address)) continue;
            return true;
        } while (System.nanoTime() <= end);
        return false;
    }

    private boolean tryUpdateLockMillis(long address, long timeInMillis) {
        long lastTime = System.currentTimeMillis();
        do {
            if (this.tryUpdateLock(address)) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now == lastTime) continue;
            lastTime = now;
            --timeInMillis;
        } while (timeInMillis >= 0L);
        return false;
    }

    @Override
    public void writeLock(long address) {
        if (!this.tryWriteLock(address, 2L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Dead lock");
        }
    }

    @Override
    public void writeLockInterruptibly(long address) {
        this.writeLock(address);
    }

    @Override
    public boolean tryWriteLock(long address) {
        if (BigSegmentHeader.getCountWord(address) == 0 && BigSegmentHeader.casCountWord(address, 0, -1073741823)) {
            BigSegmentHeader.writeExclusiveLockHolder(address);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryWriteLock(long address, long time, TimeUnit unit) {
        return this.tryWriteLock(address) || this.tryWriteLock0(address, time, unit);
    }

    private boolean tryWriteLock0(long address, long time, TimeUnit unit) {
        long end = System.nanoTime() + unit.toNanos(time);
        BigSegmentHeader.registerWait(address);
        do {
            long lockWord;
            int countWord;
            if ((countWord = BigSegmentHeader.countWord(lockWord = BigSegmentHeader.getLockWord(address))) != 0) continue;
            int waitWord = BigSegmentHeader.waitWord(lockWord);
            BigSegmentHeader.checkWaitWordForDecrement(waitWord);
            if (!BigSegmentHeader.casLockWord(address, lockWord, BigSegmentHeader.lockWord(-1073741823, waitWord - 1))) continue;
            BigSegmentHeader.writeExclusiveLockHolder(address);
            return true;
        } while (System.nanoTime() <= end);
        BigSegmentHeader.deregisterWait(address);
        return false;
    }

    private static void registerWait(long address) {
        int waitWord;
        do {
            waitWord = BigSegmentHeader.getWaitWord(address);
            BigSegmentHeader.checkWaitWordForIncrement(waitWord);
        } while (!BigSegmentHeader.casWaitWord(address, waitWord, waitWord + 1));
    }

    private static void deregisterWait(long address) {
        int waitWord;
        do {
            waitWord = BigSegmentHeader.getWaitWord(address);
            BigSegmentHeader.checkWaitWordForDecrement(waitWord);
        } while (!BigSegmentHeader.casWaitWord(address, waitWord, waitWord - 1));
    }

    @Override
    public void upgradeUpdateToWriteLock(long address) {
        if (!this.tryUpgradeUpdateToWriteLock(address, 2L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Dead lock");
        }
    }

    @Override
    public void upgradeUpdateToWriteLockInterruptibly(long address) {
        this.upgradeUpdateToWriteLock(address);
    }

    @Override
    public boolean tryUpgradeUpdateToWriteLock(long address) {
        int countWord = BigSegmentHeader.getCountWord(address);
        return BigSegmentHeader.checkExclusiveUpdateLocked(countWord) && BigSegmentHeader.casCountWord(address, countWord, -1073741823);
    }

    private static boolean checkExclusiveUpdateLocked(int countWord) {
        BigSegmentHeader.checkUpdateLocked(countWord);
        return countWord == 0x40000001;
    }

    @Override
    public boolean tryUpgradeUpdateToWriteLock(long address, long time, TimeUnit unit) {
        return this.tryUpgradeUpdateToWriteLock(address) || this.tryUpgradeUpdateToWriteLock0(address, time, unit);
    }

    private boolean tryUpgradeUpdateToWriteLock0(long address, long time, TimeUnit unit) {
        long end = System.nanoTime() + unit.toNanos(time);
        BigSegmentHeader.registerWait(address);
        do {
            long lockWord;
            int countWord;
            if (!BigSegmentHeader.checkExclusiveUpdateLocked(countWord = BigSegmentHeader.countWord(lockWord = BigSegmentHeader.getLockWord(address)))) continue;
            int waitWord = BigSegmentHeader.waitWord(lockWord);
            BigSegmentHeader.checkWaitWordForDecrement(waitWord);
            if (!BigSegmentHeader.casLockWord(address, lockWord, BigSegmentHeader.lockWord(-1073741823, waitWord - 1))) continue;
            return true;
        } while (System.nanoTime() <= end);
        BigSegmentHeader.deregisterWait(address);
        return false;
    }

    @Override
    public void readUnlock(long address) {
        int countWord;
        do {
            countWord = BigSegmentHeader.getCountWord(address);
            BigSegmentHeader.checkReadLocked(countWord);
        } while (!BigSegmentHeader.casCountWord(address, countWord, countWord - 1));
    }

    @Override
    public void updateUnlock(long address) {
        int countWord;
        do {
            countWord = BigSegmentHeader.getCountWord(address);
            BigSegmentHeader.checkUpdateLocked(countWord);
        } while (!BigSegmentHeader.casCountWord(address, countWord, countWord - 0x40000001));
        BigSegmentHeader.clearExclusiveLockHolder(address);
    }

    @Override
    public void downgradeUpdateToReadLock(long address) {
        int countWord;
        do {
            countWord = BigSegmentHeader.getCountWord(address);
            BigSegmentHeader.checkUpdateLocked(countWord);
        } while (!BigSegmentHeader.casCountWord(address, countWord, countWord ^ 0x40000000));
        BigSegmentHeader.clearExclusiveLockHolder(address);
    }

    @Override
    public void writeUnlock(long address) {
        BigSegmentHeader.checkWriteLocked(BigSegmentHeader.getCountWord(address));
        BigSegmentHeader.clearExclusiveLockHolder(address);
        BigSegmentHeader.putCountWord(address, 0);
    }

    @Override
    public void downgradeWriteToUpdateLock(long address) {
        BigSegmentHeader.checkWriteLocked(BigSegmentHeader.getCountWord(address));
        BigSegmentHeader.putCountWord(address, 0x40000001);
    }

    @Override
    public void downgradeWriteToReadLock(long address) {
        BigSegmentHeader.checkWriteLocked(BigSegmentHeader.getCountWord(address));
        BigSegmentHeader.clearExclusiveLockHolder(address);
        BigSegmentHeader.putCountWord(address, 1);
    }
}

